/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.batchprocess.LoadVSSCDataResult;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.AbstractCombatEpisode;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.CombatEpisode;
import gov.va.med.esr.common.model.ee.CombatService;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.lookup.CombatPayType;
import gov.va.med.esr.common.model.lookup.CombatServiceSource;
import gov.va.med.esr.common.model.lookup.ConflictLocation;
import gov.va.med.esr.common.model.lookup.DischargeType;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.Indicator;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.MsdsCountry;
import gov.va.med.esr.common.model.lookup.OEFOIFSource;
import gov.va.med.esr.common.model.lookup.PHDocumentType;
import gov.va.med.esr.common.model.lookup.ServiceBranch;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.MilitaryServiceInput;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.rule.data.MilitaryServiceInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.util.ActivationComparator;
import gov.va.med.esr.common.util.CombatEpisodeComparator;
import gov.va.med.esr.common.util.CombatServiceComparator;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.common.util.MilitaryServiceEpisodeComparator;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateComparator;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class MilitaryServiceInputParameter
extends BaseParameter
implements MilitaryServiceInput {
    private static final long serialVersionUID = -1361096143377416462L;
    private Boolean prisonerOfWarIndicator = null;
    private Boolean veteranPrisonerOfWarIndicator = null;
    private MilitaryServiceEpisode militaryServiceEpisode = null;
    private FilipinoVeteranProof filipinoVeteranProof = null;
    private Boolean mseOverLap = null;
    private Boolean hasHECMSERecords = null;
    private Boolean hasHECMSERecordsOnFile = null;
    private Boolean hasVAMCMSERecords = null;
    private Boolean hasVAMCMSERecordsOnFile = null;
    private Date mostRecentSSD = null;
    private Date mostRecentCombatEpisodeEndDt = null;
    private String periodOfService = null;
    private boolean isOEFOIFCombatDataInconsitant = false;
    private boolean triggerZ07 = false;
    private static Date NDAADatePlus3YearsMinus1Day = null;
    private static Date NDAA_DATE = null;

    public Date getNDAADate(String ndaaDate) {
        if (NDAA_DATE == null && ndaaDate != null) {
            this.setNDAARelatedDate(ndaaDate);
        }
        return NDAA_DATE;
    }

    @Override
    public Date getNDAADatePlus3YearsMinus1Day(String ndaaDate) {
        if (NDAADatePlus3YearsMinus1Day == null && ndaaDate != null) {
            this.setNDAARelatedDate(ndaaDate);
        }
        return NDAADatePlus3YearsMinus1Day;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNDAARelatedDate(String ndaaDate) {
        Calendar cal;
        String[] dates = ndaaDate.split("/");
        Calendar calendar = cal = Calendar.getInstance();
        synchronized (calendar) {
            cal.clear();
            cal.set(Integer.parseInt(dates[2]), Integer.parseInt(dates[0]) - 1, Integer.parseInt(dates[1]));
            NDAA_DATE = cal.getTime();
            cal.add(1, 3);
            cal.add(5, -1);
            NDAADatePlus3YearsMinus1Day = cal.getTime();
        }
    }

    @Override
    public Date getCombatVeteranEligibilityEndDate() {
        return this.getCombatVeteranEligibilityEndDate(this.getIncomingPerson());
    }

    @Override
    public Date getOnFileCVEligibilityEndDate() {
        return this.getCombatVeteranEligibilityEndDate(this.getPristinePerson());
    }

    @Override
    public boolean isConflictDateInRange(Date startDate, Date endDate) {
        MilitaryServiceSiteRecord hecSite;
        if (startDate == null || endDate == null) {
            return false;
        }
        AbstractCombatEpisode ce = this.getCE();
        MilitaryServiceSiteRecord militaryServiceSiteRecord = hecSite = ce instanceof ConflictExperience ? ((ConflictExperience)ce).getMilitaryServiceSiteRecord() : ((CombatEpisode)ce).getMilitaryService().getHECMilitaryServiceSiteRecord();
        if (hecSite != null) {
            Set episodes = hecSite.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode episode : episodes) {
                Date upper_range;
                Date lower_range = episode.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()) : null;
                if (!this.isInRange(startDate, endDate, lower_range, upper_range = episode.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getPrisonerOfWarIndicator() {
        if (this.prisonerOfWarIndicator == null) {
            this.prisonerOfWarIndicator = this.getWasPrisonerOfWar(this.getIncomingPerson());
        }
        return this.prisonerOfWarIndicator != null ? this.prisonerOfWarIndicator : false;
    }

    @Override
    public boolean getVeteranPrisonerOfWarIndicator() {
        if (this.veteranPrisonerOfWarIndicator == null) {
            this.veteranPrisonerOfWarIndicator = this.getWasPrisonerOfWar(this.getPristinePerson());
        }
        return this.veteranPrisonerOfWarIndicator != null ? this.veteranPrisonerOfWarIndicator : false;
    }

    @Override
    public String getCurrentPeriodOfService() {
        ServicePeriod period = this.getHelperService().getCurrentServicePeriod(this.getPristinePerson().getMilitaryService());
        return period != null ? period.getCode() : null;
    }

    @Override
    public String getPeriodOfService() {
        MilitaryServiceSiteRecord record;
        MilitaryService incomingMilitaryService;
        if (this.periodOfService == null && (incomingMilitaryService = this.getIncomingPerson().getMilitaryService()) != null && (record = incomingMilitaryService.getHECMilitaryServiceSiteRecord()) != null) {
            ServicePeriod period = record.getServicePeriod();
            this.periodOfService = period != null ? period.getCode() : null;
        }
        return this.periodOfService;
    }

    @Override
    public boolean hasAtLeastOnePeriodOfService() {
        boolean result = false;
        MilitaryService ms = this.getIncomingPerson().getMilitaryService();
        Set siteRecs = ms.getMilitaryServiceSiteRecords();
        Iterator itr = siteRecs != null ? siteRecs.iterator() : null;
        MilitaryServiceSiteRecord siteRec = null;
        while (itr != null && itr.hasNext()) {
            siteRec = (MilitaryServiceSiteRecord)((Object)itr.next());
            if (siteRec.getServicePeriod() == null) continue;
            result = true;
            break;
        }
        return result;
    }

    @Override
    public String getMedalOfHonorIndicator(Person person) throws ServiceException {
        MedalOfHonor mh = person.getMedalOfHonor();
        Boolean indicator = mh != null ? mh.getMhIndicator() : null;
        String flag = null;
        if (indicator != null) {
            flag = Boolean.TRUE.equals(indicator) ? "Y" : "N";
        }
        return flag;
    }

    @Override
    public void setMHDataSource(String dataSource) throws ServiceException {
        Person person;
        MedalOfHonor mh;
        if (dataSource != null && (mh = (person = this.getIncomingPerson()).getMedalOfHonor()) != null) {
            mh.setDataSource(this.getLookupService().getMHDataSourceByCode(dataSource));
        }
    }

    @Override
    public void setMHDecorationStatus(String status) throws ServiceException {
        Person person;
        MedalOfHonor mh;
        if (status != null && (mh = (person = this.getIncomingPerson()).getMedalOfHonor()) != null) {
            mh.setStatus(this.getLookupService().getDecorationStatusByCode(status));
        }
    }

    @Override
    public void setMHDocumentReceiptDate(Date receiptDate) {
        Person person = this.getIncomingPerson();
        MedalOfHonor mh = person.getMedalOfHonor();
        if (mh != null) {
            mh.setDocumentReceiptDate(receiptDate);
        }
    }

    @Override
    public void setMHDocumentType(String documentType) throws ServiceException {
        Person person;
        MedalOfHonor mh;
        if (documentType != null && (mh = (person = this.getIncomingPerson()).getMedalOfHonor()) != null) {
            mh.setDocumentType((PHDocumentType)this.getLookupService().getByCode(PHDocumentType.class, documentType));
        }
    }

    @Override
    public void setMHIndicator(String indicator) throws ServiceException {
        Person person;
        MedalOfHonor mh;
        if (indicator != null && (mh = (person = this.getIncomingPerson()).getMedalOfHonor()) != null) {
            mh.setMhIndicator("Y".equals(indicator) ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void setMHLastEditedDate(Date lastEditDate) {
        Person person = this.getIncomingPerson();
        MedalOfHonor mh = person.getMedalOfHonor();
        if (mh != null) {
            mh.setDateLastEdited(lastEditDate);
        }
    }

    @Override
    public void setMHStatusUpdateDate(Date statusUpdateDate) {
        Person person = this.getIncomingPerson();
        MedalOfHonor mh = person.getMedalOfHonor();
        if (mh != null) {
            mh.setStatusLastUpdateDate(statusUpdateDate);
        }
    }

    @Override
    public boolean isCVEndDateImproved(Person incoming, Person onFile) {
        MilitaryService onfileMS = onFile != null ? onFile.getMilitaryService() : null;
        MilitaryService incomingMS = incoming != null ? incoming.getMilitaryService() : null;
        Date date1 = incomingMS != null ? incomingMS.getCombatVeteranEligibilityEndDate() : null;
        Date date2 = onfileMS != null ? onfileMS.getCombatVeteranEligibilityEndDate() : null;
        return DateUtils.isAfterIgnoreTime((Date)date1, (Date)date2);
    }

    @Override
    public void acceptMHFromMSDS() throws ServiceException {
        MedalOfHonor incoming = this.getIncomingPerson().getMedalOfHonor();
        MedalOfHonor result = this.getResultPerson().getMedalOfHonor();
        if (incoming != null) {
            if (result == null) {
                result = new MedalOfHonor();
                this.getResultPerson().setMedalOfHonor(result);
            }
            this.getMergeRuleService().mergeMedalOfHonor(incoming, result);
        }
    }

    @Override
    public boolean isImprovedByMSDS() {
        if (this.getMilitaryServiceInputData() != null) {
            return this.getMilitaryServiceInputData().isImprovedByMSDS();
        }
        return false;
    }

    @Override
    public boolean isProcessQMSEflow() {
        if (this.getMilitaryServiceInputData() != null) {
            return this.getMilitaryServiceInputData().isProcessQMSEflow();
        }
        return false;
    }

    @Override
    public void acceptOrDeleteMH() throws ServiceException {
        if (this.getIncomingPerson().getMedalOfHonor() == null) {
            if (this.getResultPerson().getMedalOfHonor() != null) {
                this.getResultPerson().setMedalOfHonor(null);
            }
        } else {
            this.acceptMHFromMSDS();
        }
    }

    @Override
    public Date getServiceOfficialEndDate(String code) throws ServiceException {
        block3: {
            if (StringUtils.isNotEmpty((String)code)) {
                try {
                    ServicePeriod period = this.getLookupService().getServicePeriodByCode(code);
                    return period.getEndDate();
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)("Failed to get a service period by code " + code), (Throwable)e);
                    throw new ServiceException("Failed to get a service period by code " + code, (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public Date getServiceOfficialStartDate(String code) throws ServiceException {
        block3: {
            if (StringUtils.isNotEmpty((String)code)) {
                try {
                    ServicePeriod period = this.getLookupService().getServicePeriodByCode(code);
                    return period.getStartDate();
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) break block3;
                    this.logger.debug((Object)("Failed to get a service period by code " + code), (Throwable)e);
                    throw new ServiceException("Failed to get a service period by code " + code, (Throwable)e);
                }
            }
        }
        return null;
    }

    @Override
    public Date getCEStartDate() {
        return ImpreciseDateUtils.getDateWithDefault(this.getCE() != null ? this.getCE().getStartDate() : null);
    }

    @Override
    public Date getCombatPayStartDate() {
        CombatService cs = this.getMilitaryServiceInputData() != null ? this.getMilitaryServiceInputData().getCombatService() : null;
        return ImpreciseDateUtils.getDateWithDefault(cs != null ? cs.getPayStartDate() : null);
    }

    @Override
    public Date getCEEndDate() {
        return ImpreciseDateUtils.getDateWithDefault(this.getCE() != null ? this.getCE().getEndDate() : null);
    }

    @Override
    public ConflictLocation getCombatLocation() {
        return this.getCE() != null ? this.getCE().getConflictLocation() : null;
    }

    @Override
    public String getCombatLocationCode() {
        return this.getCombatLocation() != null ? this.getCombatLocation().getCode() : null;
    }

    @Override
    public MsdsCountry getMsdsCountryCode() {
        CombatService cs = this.getMilitaryServiceInputData() != null ? this.getMilitaryServiceInputData().getCombatService() : null;
        return cs != null ? cs.getMsdsCountry() : null;
    }

    @Override
    public String getOEFOIFSource() {
        CombatEpisode ce = this.getCE() instanceof CombatEpisode ? (CombatEpisode)this.getCE() : null;
        return ce != null && ce.getOEFOIFSource() != null ? ce.getOEFOIFSource().getCode() : null;
    }

    @Override
    public ServiceBranch getServiceBranch() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        return mse != null ? mse.getServiceBranch() : null;
    }

    @Override
    public String getServiceComponent() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        return mse != null && mse.getMilitaryServiceComponent() != null ? mse.getMilitaryServiceComponent().getCode() : null;
    }

    @Override
    public Date getServiceEntryDate() {
        return ImpreciseDateUtils.getDateWithDefault(this.getMilitaryServiceEpisode() != null ? this.getMilitaryServiceEpisode().getStartDate() : null);
    }

    @Override
    public Date getServiceSeparationDate() {
        return ImpreciseDateUtils.getDateWithDefault(this.getMilitaryServiceEpisode() != null ? this.getMilitaryServiceEpisode().getEndDate() : null);
    }

    @Override
    public boolean isSEDPrecise() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        return this.isDatePrecise(mse != null ? mse.getEndDate() : null);
    }

    @Override
    public boolean isSSDPrecise() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        return this.isDatePrecise(mse != null ? mse.getStartDate() : null);
    }

    @Override
    public boolean isCEEndDatePrecise() {
        AbstractCombatEpisode ce = this.getCE();
        return this.isDatePrecise(ce != null ? ce.getEndDate() : null);
    }

    @Override
    public boolean isCEStartDatePrecise() {
        AbstractCombatEpisode ce = this.getCE();
        return this.isDatePrecise(ce != null ? ce.getStartDate() : null);
    }

    @Override
    public boolean isOverlappingMSE() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        if (mse != null && this.mseOverLap == null) {
            MilitaryServiceSiteRecord mssr = mse.getMilitaryServiceSiteRecord();
            Set episodes = mssr.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode episode : episodes) {
                if (episode == mse) continue;
                Date lower_range = episode.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()) : null;
                Date upper_range = episode.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
                boolean overlapped = false;
                overlapped = this.isOverlapped(this.getServiceEntryDate(), this.getServiceSeparationDate(), lower_range, upper_range);
                if (!overlapped) continue;
                this.mseOverLap = overlapped;
                break;
            }
        }
        return this.mseOverLap == null ? false : this.mseOverLap;
    }

    @Override
    public boolean hasPeriodOfService(String period) {
        return this.containsServicePeriod(period, this.getIncomingPerson());
    }

    @Override
    public Date getConflictOfficialEndDate(ConflictLocation conflictLocation) {
        return conflictLocation != null ? conflictLocation.getEndDate() : null;
    }

    @Override
    public Date getConflictOfficialStartDate(ConflictLocation conflictLocation) {
        return conflictLocation != null ? conflictLocation.getStartDate() : null;
    }

    @Override
    public FilipinoVeteranProof getFilipinoVeteranProof() {
        if (this.filipinoVeteranProof == null) {
            this.filipinoVeteranProof = this.getMilitaryServiceEpisode().getMilitaryServiceSiteRecord().getFilipinoVeteranProof();
        }
        return this.filipinoVeteranProof;
    }

    @Override
    public DischargeType getServiceDischargeType() {
        DischargeType type = null;
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        if (mse != null) {
            type = mse.getDischargeType();
        }
        return type;
    }

    @Override
    public boolean hasMilitaryServiceEpisodes() {
        boolean hasMSE = false;
        Person incoming = this.getIncomingPerson();
        MilitaryService ms = incoming.getMilitaryService();
        Set records = ms.getMilitaryServiceSiteRecords();
        for (MilitaryServiceSiteRecord record : records) {
            if (record.getMilitaryServiceEpisodes().isEmpty()) continue;
            hasMSE = true;
            break;
        }
        return hasMSE;
    }

    @Override
    public boolean isOverlappingCombatEpisode() {
        AbstractCombatEpisode ce = this.getCE();
        if (ce instanceof CombatEpisode) {
            Set ces = ((CombatEpisode)ce).getMilitaryService().getCombatEpisodes();
            return this.isOverlappingCE(ce, ces);
        }
        return false;
    }

    @Override
    public boolean hasCombatEpisodeWithOverlap(CombatEpisode ce) {
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        return ms != null ? this.isOverlappingCE(ce, ms.getCombatEpisodes()) : false;
    }

    @Override
    public boolean hasCombatEpisodeWithStartDateOnlyOverlap(CombatEpisode ce) {
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        this.setMatchedCombatEpisode(null);
        if (ce != null && ms != null && ms.getCombatEpisodes().size() > 0 && ce.getStartDate() != null && ce.getEndDate() != null) {
            Date startDate = ImpreciseDateUtils.getDateWithDefault(ce.getStartDate());
            Date endDate = ImpreciseDateUtils.getDateWithDefault(ce.getEndDate());
            for (CombatEpisode episode : ms.getCombatEpisodes()) {
                Date upper_range;
                Date lower_range = episode.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()) : null;
                if (!this.isDateBetween(startDate, lower_range, upper_range = episode.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null) || this.isDateBetween(endDate, lower_range, upper_range) || !this.isAfterIgnoreTime(endDate, lower_range) || !this.isAfterIgnoreTime(endDate, upper_range)) continue;
                this.setMatchedCombatEpisode(episode);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOverlappingConflictExperience() {
        AbstractCombatEpisode ce = this.getCE();
        if (ce instanceof ConflictExperience) {
            Set ces = ((ConflictExperience)ce).getMilitaryServiceSiteRecord().getConflictExperiences();
            return this.isOverlappingCE(ce, ces);
        }
        return false;
    }

    private List getOverlappingEpisodes(AbstractCombatEpisode ce, Set combatEpisodes) {
        ArrayList<AbstractCombatEpisode> overLapList = new ArrayList<AbstractCombatEpisode>();
        if (ce == null) {
            return overLapList;
        }
        for (AbstractCombatEpisode episode : combatEpisodes) {
            Date endDate;
            if (episode == ce) continue;
            Date lower_range = episode.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()) : null;
            Date upper_range = episode.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
            Date startDate = ce.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(ce.getStartDate()) : null;
            if (!this.isOverlapped(startDate, endDate = ce.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(ce.getEndDate()) : null, lower_range, upper_range)) continue;
            overLapList.add(episode);
        }
        return overLapList;
    }

    private boolean isOverlappingCE(AbstractCombatEpisode ce, Set combatEpisodes) {
        Boolean ceOverlap = null;
        if (ce != null) {
            Date ceStartDate = ce.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(ce.getStartDate()) : null;
            Date ceEndDate = ce.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(ce.getEndDate()) : null;
            for (AbstractCombatEpisode episode : combatEpisodes) {
                if (episode == ce) continue;
                Date lower_range = episode.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()) : null;
                Date upper_range = episode.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
                boolean overlapped = false;
                overlapped = this.isOverlapped(ceStartDate, ceEndDate, lower_range, upper_range);
                if (!overlapped) continue;
                ceOverlap = overlapped;
                break;
            }
        }
        return ceOverlap == null ? false : ceOverlap;
    }

    @Override
    public Date getCurrentCVEligEndDate() {
        Date date = null;
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryInfo = onFile.getMilitaryService();
        if (currentMilitaryInfo != null) {
            date = currentMilitaryInfo.getCombatVeteranEligibilityEndDate();
        }
        return date;
    }

    @Override
    public Boolean getDischargeDueToDisability() {
        return this.getDischargeDueToDisability(this.getIncomingPerson());
    }

    @Override
    public Boolean getDischargeDueToDisability(Person person) {
        MilitaryService ms = person != null ? person.getMilitaryService() : null;
        return ms != null ? ms.getDischargeDueToDisability() : null;
    }

    @Override
    public Boolean getMilitaryDisabilityRetirement() {
        return this.getMilitaryDisabilityRetirement(this.getIncomingPerson());
    }

    @Override
    public Boolean getMilitaryDisabilityRetirement(Person person) {
        MilitaryService ms = person != null ? person.getMilitaryService() : null;
        return ms != null ? ms.getDisabilityRetirementIndicator() : null;
    }

    @Override
    public Date getMostRecentReceivedSSD() {
        MilitaryService ms;
        if (this.mostRecentSSD == null && (ms = this.getResultPerson().getMilitaryService()) != null) {
            Iterator i;
            HashSet episodes = new HashSet();
            Set records = ms.getMilitaryServiceSiteRecords();
            Iterator iterator = i = records != null ? records.iterator() : null;
            while (i != null && i.hasNext()) {
                MilitaryServiceSiteRecord site_record = (MilitaryServiceSiteRecord)((Object)i.next());
                Set site_episodes = site_record != null ? site_record.getMilitaryServiceEpisodes() : null;
                if (site_episodes == null || site_episodes.isEmpty()) continue;
                episodes.addAll(site_episodes);
            }
            MilitaryServiceEpisodeComparator comparator = new MilitaryServiceEpisodeComparator();
            if (!episodes.isEmpty()) {
                MilitaryServiceEpisode episode = (MilitaryServiceEpisode)((Object)Collections.max(episodes, comparator));
                this.mostRecentSSD = episode != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
            }
        }
        return this.mostRecentSSD;
    }

    @Override
    public Date getMostRecentReceivedCombatEpisodeEndDate() {
        if (this.mostRecentCombatEpisodeEndDt == null) {
            Set ces;
            MilitaryService ms = this.getResultPerson().getMilitaryService();
            Set set = ces = ms != null ? ms.getCombatEpisodes() : null;
            if (ces != null && !ces.isEmpty()) {
                CombatEpisode episode = (CombatEpisode)((Object)Collections.max(ces, new CombatEpisodeComparator()));
                this.mostRecentCombatEpisodeEndDt = episode != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
            }
        }
        return this.mostRecentCombatEpisodeEndDt;
    }

    @Override
    public Date getMostRecentSSDPlus2Years() {
        return this.getDatePlus2YearsMinus1Day(this.getMostRecentReceivedSSD());
    }

    @Override
    public Date getMostRecentCombatEpisodeEndDatePlus2Years() {
        return this.getDatePlus2YearsMinus1Day(this.getMostRecentReceivedCombatEpisodeEndDate());
    }

    @Override
    public LoadVSSCDataResult getLoadVSSCDataResult() {
        return this.getMilitaryServiceInputData().getLoadVSSCDataResult();
    }

    @Override
    public boolean isDataFromVSSC() {
        return this.getMilitaryServiceInputData().isDataFromVSSC();
    }

    private Date getDatePlus2YearsMinus1Day(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            calendar.add(1, 2);
            calendar.add(5, -1);
            return calendar.getTime();
        }
        return null;
    }

    @Override
    public boolean isMostRecentConflictToDateAfterForLocation(Date date, String code) {
        if (date == null) {
            return false;
        }
        boolean mostRecent = false;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms != null) {
            ConflictExperience conflict;
            Iterator i;
            HashSet conflicts = new HashSet();
            Set records = ms.getMilitaryServiceSiteRecords();
            Iterator iterator = i = records != null ? records.iterator() : null;
            while (i != null && i.hasNext()) {
                MilitaryServiceSiteRecord site_record = (MilitaryServiceSiteRecord)((Object)i.next());
                Set site_conflicts = site_record != null ? site_record.getConflictExperiences() : null;
                if (site_conflicts == null || site_conflicts.isEmpty()) continue;
                conflicts.addAll(site_conflicts);
            }
            CombatEpisodeComparator comparator = new CombatEpisodeComparator();
            if (!conflicts.isEmpty() && (conflict = (ConflictExperience)((Object)Collections.max(conflicts, comparator))) != null) {
                ConflictLocation location = conflict.getConflictLocation();
                Date toDate = ImpreciseDateUtils.getDateWithDefault(conflict.getEndDate());
                if (location != null && toDate != null && location.getCode().equals(code) && toDate.after(date)) {
                    mostRecent = true;
                }
            }
        }
        return mostRecent;
    }

    @Override
    public String getMostRecentCombatLocation() {
        Set CEs;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms != null && !(CEs = ms.getCombatEpisodes()).isEmpty()) {
            CombatEpisode CE2 = (CombatEpisode)((Object)Collections.max(CEs, new CombatEpisodeComparator()));
            return CE2 != null && CE2.getConflictLocation() != null ? CE2.getConflictLocation().getCode() : null;
        }
        return null;
    }

    @Override
    public String getMostRecentCombatLocation(Person person) {
        Set CEs;
        if (person == null) {
            return null;
        }
        MilitaryService ms = person.getMilitaryService();
        if (ms != null && !(CEs = ms.getCombatEpisodes()).isEmpty()) {
            CombatEpisode CE2 = (CombatEpisode)((Object)Collections.max(CEs, new CombatEpisodeComparator()));
            return CE2 != null && CE2.getConflictLocation() != null ? CE2.getConflictLocation().getCode() : null;
        }
        return null;
    }

    @Override
    public void updateCombatEpisodes() {
        this.isOEFOIFCombatDataInconsitant = false;
        Person onFile = this.getResultPerson();
        MilitaryService onFileMS = onFile.getMilitaryService() != null ? onFile.getMilitaryService() : new MilitaryService();
        MilitaryService incomingMS = this.getMilitaryServiceInputData().getMilitaryService();
        if (incomingMS != null) {
            if (this.isUpdateFromGUI()) {
                this.updateCombatEpisodesFromGUI(incomingMS, onFileMS);
            } else if (this.isDataFromVSSC()) {
                this.updateCombatEpisodesFromVSSC(incomingMS, onFileMS);
            } else {
                this.updateCombatEpisodesFromMessage(incomingMS, onFileMS);
            }
        }
    }

    @Override
    public boolean isOEFOIFCombatDataInconsitant() {
        return this.isOEFOIFCombatDataInconsitant;
    }

    private void updateCombatEpisodesFromMessage(MilitaryService incomingMS, MilitaryService onFileMS) {
        HashSet onFileCEs = new HashSet(onFileMS.getCombatEpisodes());
        Set incomingCEs = incomingMS.getCombatEpisodes();
        for (CombatEpisode incomingCE : incomingCEs) {
            CombatEpisode onFileCE = this.getMatchingCombatEpisode(incomingCE, onFileCEs);
            if (onFileCE != null) {
                String onFileComLoc;
                String string = onFileComLoc = onFileCE.getConflictLocation() != null ? onFileCE.getConflictLocation().getCode() : null;
                if (this.isEqual(onFileComLoc, ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode())) {
                    this.getMergeRuleService().mergeCombatEpisode(incomingCE, onFileCE);
                    continue;
                }
                if (this.isEqual((Object)incomingCE.getConflictLocation(), (Object)onFileCE.getConflictLocation())) continue;
                this.isOEFOIFCombatDataInconsitant = true;
                continue;
            }
            if (!this.isOverlappingCE(incomingCE, onFileMS.getCombatEpisodes())) {
                onFileCE = new CombatEpisode();
                this.getMergeRuleService().mergeCombatEpisode(incomingCE, onFileCE);
                onFileMS.addCombatEpisode(onFileCE);
                continue;
            }
            this.isOEFOIFCombatDataInconsitant = true;
        }
    }

    private void updateCombatEpisodesFromGUI(MilitaryService incomingMS, MilitaryService onFileMS) {
        Set incomingCEs = incomingMS.getCombatEpisodes();
        HashSet<CombatEpisode> toAddCEs = new HashSet<CombatEpisode>();
        for (CombatEpisode incomingCE : incomingCEs) {
            if (incomingCE.getEntityKey() == null) {
                CombatEpisode newCE = new CombatEpisode();
                this.getMergeRuleService().mergeCombatEpisode(incomingCE, newCE);
                onFileMS.addCombatEpisode(newCE);
                toAddCEs.add(newCE);
                continue;
            }
            CombatEpisode onFileCE = onFileMS.getCombatEpisodeByEntityKey(incomingCE.getEntityKey());
            this.getMergeRuleService().mergeCombatEpisode(incomingCE, onFileCE);
            toAddCEs.add(onFileCE);
        }
        onFileMS.removeAllCombatEpisodes();
        if (!toAddCEs.isEmpty()) {
            onFileMS.addAllCombatEpisodes(toAddCEs);
        }
    }

    private void updateCombatEpisodesFromVSSC(MilitaryService incomingMS, MilitaryService onFileMS) {
        LoadVSSCDataResult result = this.getLoadVSSCDataResult();
        Set incomingCEs = incomingMS.getCombatEpisodes();
        for (CombatEpisode incomingCE : incomingCEs) {
            CombatEpisode onFileCE = this.getExactMatchingCombatEpisode(incomingCE, onFileMS.getCombatEpisodes());
            if (onFileCE != null) {
                result.incrementRejected(incomingCE);
                continue;
            }
            List overLappingEpisodes = this.getOverlappingEpisodes(incomingCE, onFileMS.getCombatEpisodes());
            if (overLappingEpisodes.size() > 1) {
                result.incrementRejected(incomingCE);
                continue;
            }
            if (overLappingEpisodes.size() == 0) {
                onFileCE = new CombatEpisode();
                this.getMergeRuleService().mergeCombatEpisode(incomingCE, onFileCE);
                onFileMS.addCombatEpisode(onFileCE);
                result.incrementAccepted(incomingCE);
                continue;
            }
            onFileCE = (CombatEpisode)((Object)overLappingEpisodes.get(0));
            if (this.isEqual(incomingCE.getStartDate(), onFileCE.getStartDate()) && this.isAfter(incomingCE.getEndDate().getCalendar().getTime(), onFileCE.getEndDate().getCalendar().getTime())) {
                onFileCE.setEndDate(incomingCE.getEndDate());
                onFileCE.setOEFOIFSource(incomingCE.getOEFOIFSource());
                onFileCE.setCombatPayType(incomingCE.getCombatPayType());
                if ((ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(onFileCE.getConflictLocation().getCode()) || ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(onFileCE.getConflictLocation().getCode())) && (ConflictLocation.CODE_OEF.getCode().equals(incomingCE.getConflictLocation().getCode()) || ConflictLocation.CODE_OIF.getCode().equals(incomingCE.getConflictLocation().getCode()))) {
                    onFileCE.setConflictLocation(incomingCE.getConflictLocation());
                }
                result.incrementAccepted(incomingCE);
                continue;
            }
            if (onFileCE.getOEFOIFStationNumber() != null || onFileCE.getOEFOIFSource() != null && OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode().equals(onFileCE.getOEFOIFSource().getCode())) {
                Calendar onFileStart = onFileCE.getStartDate().getCalendar();
                Calendar incomingStart = incomingCE.getStartDate().getCalendar();
                if (onFileStart.get(1) == incomingStart.get(1) && onFileStart.get(2) == incomingStart.get(2) && onFileStart.get(5) > 1 && this.isAfter(incomingCE.getEndDate().getCalendar().getTime(), onFileCE.getEndDate().getCalendar().getTime())) {
                    onFileCE.setEndDate(incomingCE.getEndDate());
                    if (onFileCE.getOEFOIFSource() == null || !OEFOIFSource.CODE_CENTRALIZED_ELIGIBILITY_VERIFICATION.getCode().equals(onFileCE.getOEFOIFSource().getCode())) {
                        onFileCE.setOEFOIFSource(incomingCE.getOEFOIFSource());
                    }
                    onFileCE.setCombatPayType(incomingCE.getCombatPayType());
                    if ((ConflictLocation.CODE_CONFLICT_UNSPECIFIED.getCode().equals(onFileCE.getConflictLocation().getCode()) || ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode().equals(onFileCE.getConflictLocation().getCode())) && (ConflictLocation.CODE_OEF.getCode().equals(incomingCE.getConflictLocation().getCode()) || ConflictLocation.CODE_OIF.getCode().equals(incomingCE.getConflictLocation().getCode()))) {
                        onFileCE.setConflictLocation(incomingCE.getConflictLocation());
                    }
                    result.incrementAccepted(incomingCE);
                    continue;
                }
            }
            result.incrementRejected(incomingCE);
        }
    }

    private CombatEpisode getMatchingCombatEpisode(CombatEpisode incomingCE, Set onFileCEs) {
        for (CombatEpisode onFileCE : onFileCEs) {
            if (!this.isEqual(incomingCE.getStartDate(), onFileCE.getStartDate()) || !this.isEqual(incomingCE.getEndDate(), onFileCE.getEndDate())) continue;
            return onFileCE;
        }
        return null;
    }

    private CombatEpisode getExactMatchingCombatEpisode(CombatEpisode incomingCE, Set onFileCEs) {
        for (CombatEpisode onFileCE : onFileCEs) {
            if (!this.isEqual((Object)incomingCE.getConflictLocation(), (Object)onFileCE.getConflictLocation()) || !this.isEqual(incomingCE.getStartDate(), onFileCE.getStartDate()) || !this.isEqual(incomingCE.getEndDate(), onFileCE.getEndDate()) || !this.isEqual((Object)incomingCE.getCombatPayType(), (Object)onFileCE.getCombatPayType()) || !this.isEqual((Object)incomingCE.getOEFOIFSource(), (Object)onFileCE.getOEFOIFSource()) || !this.isEqual((Object)incomingCE.getOEFOIFStationNumber(), (Object)onFileCE.getOEFOIFStationNumber())) continue;
            return onFileCE;
        }
        return null;
    }

    @Override
    public void setMilitaryServiceInfoBySiteToReceived() {
        MilitaryService incomingMilitaryService;
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService == null) {
            currentMilitaryService = new MilitaryService();
            onFile.setMilitaryService(currentMilitaryService);
        }
        if ((incomingMilitaryService = this.getMilitaryServiceInputData().getMilitaryService()) != null) {
            if (this.isUpdateFromGUI()) {
                MilitaryServiceSiteRecord incomingHECSiteRecord = incomingMilitaryService.getHECMilitaryServiceSiteRecord();
                if (incomingHECSiteRecord != null) {
                    MilitaryServiceSiteRecord currentHECSiteRecord = currentMilitaryService.getHECMilitaryServiceSiteRecord();
                    if (currentHECSiteRecord == null) {
                        currentHECSiteRecord = new MilitaryServiceSiteRecord();
                        this.getMergeRuleService().mergeMilitaryServiceSiteRecord(incomingHECSiteRecord, currentHECSiteRecord);
                        currentMilitaryService.addMilitaryServiceSiteRecord(currentHECSiteRecord);
                    } else {
                        this.getMergeRuleService().mergeMilitaryServiceSiteRecord(incomingHECSiteRecord, currentHECSiteRecord);
                    }
                }
            } else {
                Set incomingSiteRecords = incomingMilitaryService.getMilitaryServiceSiteRecords();
                for (MilitaryServiceSiteRecord incomingSiteRecord : incomingSiteRecords) {
                    if (incomingSiteRecord == null) continue;
                    MilitaryServiceSiteRecord currentSiteRecord = currentMilitaryService.getMilitaryServiceSiteRecordsBySite(incomingSiteRecord.getSite());
                    if (currentSiteRecord == null) {
                        currentSiteRecord = new MilitaryServiceSiteRecord();
                        this.getMergeRuleService().mergeMilitaryServiceSiteRecord(incomingSiteRecord, currentSiteRecord);
                        currentMilitaryService.addMilitaryServiceSiteRecord(currentSiteRecord);
                        continue;
                    }
                    this.getMergeRuleService().mergeMilitaryServiceSiteRecord(incomingSiteRecord, currentSiteRecord);
                }
            }
        }
    }

    @Override
    public void setCVEligibilityEndDate(Date date) {
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryInfo = onFile.getMilitaryService();
        if (currentMilitaryInfo == null) {
            currentMilitaryInfo = new MilitaryService();
            onFile.setMilitaryService(currentMilitaryInfo);
        }
        currentMilitaryInfo.setCombatVeteranEligibilityEndDate(date);
    }

    @Override
    public void setDischargeDueToDisability(Boolean flag) {
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryInfo = onFile.getMilitaryService();
        if (currentMilitaryInfo == null) {
            currentMilitaryInfo = new MilitaryService();
            onFile.setMilitaryService(currentMilitaryInfo);
        }
        currentMilitaryInfo.setDischargeDueToDisability(flag);
    }

    @Override
    public void setMilitaryDisabilityRetirement(Boolean flag) {
        Person onFile = this.getResultPerson();
        MilitaryService ms = onFile.getMilitaryService();
        if (ms == null) {
            ms = new MilitaryService();
            onFile.setMilitaryService(ms);
        }
        ms.setDisabilityRetirementIndicator(flag);
    }

    @Override
    public SHAD getShad() {
        return this.getShad(this.getIncomingPerson());
    }

    @Override
    public String getShadIndicator() throws ServiceException {
        SHAD shad = this.getShad();
        return shad != null && shad.getShadIndicator() != null ? shad.getShadIndicator().getCode() : null;
    }

    @Override
    public String getPristineShadIndicator() throws ServiceException {
        SHAD shad = this.getShad(this.getPristinePerson());
        return shad != null && shad.getShadIndicator() != null ? shad.getShadIndicator().getCode() : null;
    }

    @Override
    public void setShadIndicator(String indicator) throws ServiceException {
        SHAD shad = this.getShad(this.getResultPerson());
        if (shad == null) {
            shad = new SHAD();
            this.getResultPerson().setShad(shad);
        }
        Indicator ind = (Indicator)this.getLookupService().getByCode(Indicator.class, Indicator.NO.getCode());
        shad.setShadIndicator(ind);
    }

    @Override
    public void setShad(SHAD shad) throws ServiceException {
        Person onFile = this.getResultPerson();
        if (shad != null) {
            SHAD onFileShad = this.getShad(onFile);
            if (onFileShad == null) {
                onFileShad = new SHAD();
                onFile.setShad(onFileShad);
            }
            onFileShad.setShadIndicator(shad.getShadIndicator());
        } else {
            onFile.setShad(null);
        }
    }

    @Override
    public boolean hasAMSEWithinDateRange(boolean useHECEnteredMSEDate, Date fromDate, Date toDate) throws ServiceException {
        boolean found;
        block1: {
            MilitaryServiceSiteRecord mssr;
            VAFacility facility;
            Iterator i;
            MilitaryService ms;
            block2: {
                found = false;
                MilitaryServiceInputData data = this.getMilitaryServiceInputData();
                MilitaryService militaryService = ms = data != null ? data.getMilitaryService() : this.getIncomingPerson().getMilitaryService();
                if (ms == null) break block1;
                if (!useHECEnteredMSEDate) break block2;
                MilitaryServiceSiteRecord hecRecord = ms.getHECMilitaryServiceSiteRecord();
                if (hecRecord == null) break block1;
                found = this.isOverlapped(hecRecord.getMilitaryServiceEpisodes(), fromDate, toDate);
                break block1;
            }
            Set records = ms.getMilitaryServiceSiteRecords();
            Iterator iterator = i = records != null ? records.iterator() : null;
            while (i != null && i.hasNext() && ((facility = (mssr = (MilitaryServiceSiteRecord)((Object)i.next())).getSite()) == null || facility.getCode().equals((Object)VAFacility.CODE_HEC) || !(found = this.isOverlapped(mssr.getMilitaryServiceEpisodes(), fromDate, toDate)))) {
            }
        }
        return found;
    }

    @Override
    public boolean hasHECMSEwithinDateRange(Person person, Date fromDate, Date toDate) throws ServiceException {
        Set msEpisodes = this.getHECMSEs(person.getMilitaryService());
        return msEpisodes != null && !msEpisodes.isEmpty() ? this.isOverlapped(msEpisodes, fromDate, toDate) : false;
    }

    @Override
    public boolean hasAMSEWithinDateRange(Date fromDate, Date toDate) throws ServiceException {
        MilitaryServiceInputData data;
        MilitaryService ms = null;
        ms = this.isUpdateFromGUI() || this.isMessageFromVOA() ? ((data = this.getMilitaryServiceInputData()) != null ? data.getMilitaryService() : this.getIncomingPerson().getMilitaryService()) : this.getResultPerson().getMilitaryService();
        Set msEpisodes = this.getHECMSEs(ms);
        msEpisodes = msEpisodes == null || msEpisodes.isEmpty() ? this.getSiteMSEs(ms) : msEpisodes;
        return this.isOverlapped(msEpisodes, fromDate, toDate);
    }

    @Override
    public void setHECPeriodOfService(String pos) throws ServiceException {
        this.updatePeriodOfService(this.getResultPerson(), pos);
        this.updatePeriodOfService(this.getIncomingPerson(), pos);
    }

    @Override
    public void setVOAPeriodOfService(String pos) throws ServiceException {
        this.updateVOAPeriodOfService(this.getResultPerson(), pos);
    }

    @Override
    public boolean hasHECEnteredMilitaryServiceEpisodes() throws ServiceException {
        MilitaryServiceInputData data;
        MilitaryService ms;
        Set msEpisodes;
        if (this.hasHECMSERecords == null && (msEpisodes = this.getHECMSEs(ms = (data = this.getMilitaryServiceInputData()) != null ? data.getMilitaryService() : this.getIncomingPerson().getMilitaryService())) != null && !msEpisodes.isEmpty()) {
            this.hasHECMSERecords = Boolean.TRUE;
        }
        return this.hasHECMSERecords != null ? this.hasHECMSERecords : false;
    }

    @Override
    public boolean hasHECEnteredMilitaryServiceEpisodesOnFile() throws ServiceException {
        Set msEpisodes;
        if (this.hasHECMSERecordsOnFile == null && (msEpisodes = this.getHECMSEs(this.getResultPerson().getMilitaryService())) != null && !msEpisodes.isEmpty()) {
            this.hasHECMSERecordsOnFile = Boolean.TRUE;
        }
        return this.hasHECMSERecordsOnFile != null ? this.hasHECMSERecordsOnFile : false;
    }

    @Override
    public boolean hasVAMCEnteredMilitaryServiceEpisodes() throws ServiceException {
        MilitaryServiceInputData data;
        MilitaryService ms;
        Set msEpisodes;
        if (this.hasVAMCMSERecords == null && (msEpisodes = this.getSiteMSEs(ms = (data = this.getMilitaryServiceInputData()) != null ? data.getMilitaryService() : this.getIncomingPerson().getMilitaryService())) != null && !msEpisodes.isEmpty()) {
            this.hasVAMCMSERecords = Boolean.TRUE;
        }
        return this.hasVAMCMSERecords != null ? this.hasVAMCMSERecords : false;
    }

    @Override
    public boolean hasVAMCEnteredMilitaryServiceEpisodesOnFile() throws ServiceException {
        Set msEpisodes;
        if (this.hasVAMCMSERecordsOnFile == null && (msEpisodes = this.getSiteMSEs(this.getResultPerson().getMilitaryService())) != null && !msEpisodes.isEmpty()) {
            this.hasVAMCMSERecordsOnFile = Boolean.TRUE;
        }
        return this.hasVAMCMSERecordsOnFile != null ? this.hasVAMCMSERecordsOnFile : false;
    }

    private Set getHECMSEs(MilitaryService ms) throws ServiceException {
        if (ms != null) {
            MilitaryServiceSiteRecord mssRecord = ms.getHECMilitaryServiceSiteRecord();
            return mssRecord != null ? mssRecord.getMilitaryServiceEpisodes() : null;
        }
        return null;
    }

    @Override
    public boolean hasNoEnrollRecordPriorNDAA(String ndaaDate) throws ServiceException {
        try {
            return !this.getEligibilityEnrollmentService().hasAnyEnrollmentRecordBeforeDate(this.getIncomingPerson().getEntityKey(), this.getNDAADate(ndaaDate));
        }
        catch (RuleException ex) {
            throw new ServiceException("Error getting enrollment record before NDAA", (Throwable)ex);
        }
    }

    @Override
    public Date getMostRecentSSDOrCombatToDate() {
        Date ssdDt = this.getMostRecentReceivedSSD();
        Date ceEndDt = this.getMostRecentReceivedCombatEpisodeEndDate();
        if (ssdDt == null) {
            return ceEndDt;
        }
        if (ceEndDt == null) {
            return ssdDt;
        }
        return ssdDt.after(ceEndDt) ? ssdDt : ceEndDt;
    }

    @Override
    public Date getMostRecentSSDOrCombatEndDatePlus5YearsMinus1Day() {
        return this.getDatePlus5YearsMinus1Day(this.getMostRecentSSDOrCombatToDate());
    }

    private Date getDatePlus5YearsMinus1Day(Date date) {
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.clear();
            calendar.setTime(date);
            calendar.add(1, 5);
            calendar.add(5, -1);
            return calendar.getTime();
        }
        return null;
    }

    @Override
    public boolean isMostRecentConflictToDateAfter(Date date) {
        if (date == null) {
            return false;
        }
        boolean mostRecent = false;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms != null) {
            Date toDate;
            ConflictExperience conflict;
            Iterator i;
            HashSet conflicts = new HashSet();
            Set records = ms.getMilitaryServiceSiteRecords();
            Iterator iterator = i = records != null ? records.iterator() : null;
            while (i != null && i.hasNext()) {
                MilitaryServiceSiteRecord site_record = (MilitaryServiceSiteRecord)((Object)i.next());
                Set site_conflicts = site_record != null ? site_record.getConflictExperiences() : null;
                if (site_conflicts == null || site_conflicts.isEmpty()) continue;
                conflicts.addAll(site_conflicts);
            }
            CombatEpisodeComparator comparator = new CombatEpisodeComparator();
            if (!conflicts.isEmpty() && (conflict = (ConflictExperience)((Object)Collections.max(conflicts, comparator))) != null && (toDate = ImpreciseDateUtils.getDateWithDefault(conflict.getEndDate())) != null && toDate.after(date)) {
                mostRecent = true;
            }
        }
        return mostRecent;
    }

    private Set getSiteMSEs(MilitaryService ms) throws ServiceException {
        Set records;
        HashSet mses = new HashSet();
        MilitaryServiceSiteRecord hecMSSRecord = ms.getHECMilitaryServiceSiteRecord();
        Set set = records = ms != null ? ms.getMilitaryServiceSiteRecords() : null;
        if (records != null) {
            for (MilitaryServiceSiteRecord siteMSSRecord : records) {
                if (hecMSSRecord != null && hecMSSRecord.equals((Object)siteMSSRecord)) continue;
                mses.addAll(siteMSSRecord.getMilitaryServiceEpisodes());
            }
        }
        return mses;
    }

    private SHAD getShad(Person person) {
        return person != null ? person.getShad() : null;
    }

    private AbstractCombatEpisode getCE() {
        return this.getMilitaryServiceInputData() != null ? this.getMilitaryServiceInputData().getIncomingConflictExperience() : null;
    }

    private MilitaryServiceEpisode getMilitaryServiceEpisode() {
        this.militaryServiceEpisode = this.getMilitaryServiceInputData() != null ? this.getMilitaryServiceInputData().getIncomingMilitaryServiceEpisode() : null;
        return this.militaryServiceEpisode;
    }

    private Boolean getWasPrisonerOfWar(Person person) {
        PrisonerOfWar pow;
        if (person != null && (pow = person.getPrisonerOfWar()) != null && pow.getPowIndicator() != null) {
            return pow.getPowIndicator().toBoolean();
        }
        return null;
    }

    @Override
    public Date getCombatVeteranEligibilityEndDate(Person person) {
        MilitaryService militaryService = person != null ? person.getMilitaryService() : null;
        return militaryService != null ? militaryService.getCombatVeteranEligibilityEndDate() : null;
    }

    private boolean isOverlapped(Set episodes, Date fromDate, Date toDate) {
        boolean found = false;
        if (episodes != null) {
            for (MilitaryServiceEpisode episode : episodes) {
                if (!this.isOverlapped(ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()), ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()), fromDate, toDate)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private boolean isInRange(Date startDate, Date endDate, Date lower_range, Date upper_range) {
        return !(startDate == null || endDate == null || lower_range == null || upper_range == null || !startDate.equals(endDate) && !startDate.before(endDate) || !lower_range.equals(upper_range) && !lower_range.before(upper_range) || !startDate.equals(lower_range) && !startDate.after(lower_range) || !startDate.equals(upper_range) && !startDate.before(upper_range) || !endDate.equals(lower_range) && !endDate.after(lower_range) || !endDate.equals(upper_range) && !endDate.before(upper_range));
    }

    private boolean isOverlapped(Date startDate, Date endDate, Date lower_range, Date upper_range) {
        boolean overlapped = false;
        if (startDate != null && endDate != null && lower_range != null && upper_range != null) {
            if (startDate.equals(lower_range) || startDate.equals(upper_range) || endDate.equals(lower_range) || endDate.equals(upper_range)) {
                overlapped = true;
            } else if (startDate.before(lower_range) && lower_range.before(upper_range) && upper_range.before(endDate)) {
                overlapped = true;
            } else if (startDate.before(lower_range) && lower_range.before(endDate) && endDate.before(upper_range)) {
                overlapped = true;
            } else if (lower_range.before(startDate) && startDate.before(upper_range) && upper_range.before(endDate)) {
                overlapped = true;
            } else if (lower_range.before(startDate) && startDate.before(endDate) && endDate.before(upper_range)) {
                overlapped = true;
            }
        }
        return overlapped;
    }

    private boolean containsServicePeriod(String servicePeriod, Person person) {
        Set militaryServiceSiteRecords;
        boolean found = false;
        MilitaryService militaryService = person != null ? person.getMilitaryService() : null;
        Set set = militaryServiceSiteRecords = militaryService != null ? militaryService.getMilitaryServiceSiteRecords() : null;
        if (militaryServiceSiteRecords != null && militaryServiceSiteRecords.size() > 0) {
            for (MilitaryServiceSiteRecord militaryServiceSiteRecord : militaryServiceSiteRecords) {
                if (militaryServiceSiteRecord.getServicePeriod() == null || !militaryServiceSiteRecord.getServicePeriod().getCode().equals(servicePeriod)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private MilitaryServiceInputData getMilitaryServiceInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof MilitaryServiceInputData) {
            return (MilitaryServiceInputData)ruleDataAware;
        }
        return null;
    }

    private void updatePeriodOfService(Person person, String pos) throws ServiceException {
        MilitaryServiceSiteRecord record;
        Validate.notNull((Object)((Object)person), (String)"A person to update period of service must not be NULL");
        LookupService lookupService = this.getLookupService();
        ServicePeriod period = StringUtils.isNotEmpty((String)pos) ? lookupService.getServicePeriodByCode(pos) : null;
        MilitaryService ms = person.getMilitaryService();
        MilitaryServiceSiteRecord militaryServiceSiteRecord = record = ms != null ? ms.getHECMilitaryServiceSiteRecord() : null;
        if (record != null) {
            record.setServicePeriod(period);
        } else if (period != null) {
            record = new MilitaryServiceSiteRecord();
            record.setSite(lookupService.getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
            if (ms == null) {
                ms = new MilitaryService();
                person.setMilitaryService(ms);
            }
            ms.addMilitaryServiceSiteRecord(record);
            record.setServicePeriod(period);
        }
    }

    private void updateVOAPeriodOfService(Person person, String pos) throws ServiceException {
        MilitaryServiceSiteRecord record;
        Validate.notNull((Object)((Object)person), (String)"A person to update period of service must not be NULL");
        if (this.getIncomingPerson() == null || this.getIncomingPerson().getMilitaryService() == null || this.getIncomingPerson().getPreferredFacility() == null) {
            return;
        }
        String stationNum = this.getIncomingPerson().getPreferredFacility().getCode();
        LookupService lookupService = this.getLookupService();
        ServicePeriod period = StringUtils.isNotEmpty((String)pos) ? lookupService.getServicePeriodByCode(pos) : null;
        MilitaryService ms = person.getMilitaryService();
        MilitaryServiceSiteRecord militaryServiceSiteRecord = record = ms != null ? ms.getMilitaryServiceSiteRecordsBySite(stationNum) : null;
        if (record != null) {
            record.setServicePeriod(period);
        } else if (period != null) {
            record = new MilitaryServiceSiteRecord();
            record.setSite(this.getIncomingPerson().getPreferredFacility());
            if (ms == null) {
                ms = new MilitaryService();
                person.setMilitaryService(ms);
            }
            ms.addMilitaryServiceSiteRecord(record);
            record.setServicePeriod(period);
        }
    }

    @Override
    public Date getCombatPayEndDate() {
        return this.getCombatService() != null && this.getCombatService().getPayEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(this.getCombatService().getPayEndDate()) : null;
    }

    @Override
    public Date getMostRecentCombatPayEndDate() {
        Set combatPays;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        Date endDate = null;
        Set set = combatPays = ms != null ? ms.getCombatServices() : new HashSet();
        if (!combatPays.isEmpty()) {
            CombatService cs = (CombatService)((Object)Collections.max(combatPays, new CombatServiceComparator()));
            endDate = cs != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate()) : null;
        }
        return endDate;
    }

    @Override
    public Date getCombatPayEndDateADR() {
        CombatService cs = this.getMatchedCombatPay();
        return cs != null && cs.getPayEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate()) : null;
    }

    @Override
    public boolean isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual(String code) throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfo(this.getResultPerson());
        MilitaryServiceEpisode mse = info.getLastMSE();
        String cd = mse != null && mse.getDischargeType() != null ? mse.getDischargeType().getCode() : null;
        return code != null ? code.equals(cd) : false;
    }

    @Override
    public boolean isCharacterOfDischargeOfLastNonbreakServiceEpisodeEqual(String code, Set episodes) throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfoFromSet(episodes);
        MilitaryServiceEpisode mse = info.getLastMSE();
        String cd = mse != null && mse.getDischargeType() != null ? mse.getDischargeType().getCode() : null;
        return code != null ? code.equals(cd) : false;
    }

    @Override
    public void setHasQmse(boolean value) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setHasQmse(value);
        }
    }

    @Override
    public boolean hasQmse() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).hasQmse();
        }
        return false;
    }

    @Override
    public String getMseCreatedBy() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        return mse != null && mse.getCreatedBy() != null ? mse.getCreatedBy().getName() : null;
    }

    @Override
    public String getActivationTerminationReasonCode() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        if (mse == null) {
            return null;
        }
        Activation act = this.getActivationForServicePeriod(mse.getStartDate(), mse.getEndDate());
        return act != null && act.getTerminationReason() != null ? act.getTerminationReason().getCode() : null;
    }

    private Activation getActivationForServicePeriod(ImpreciseDate begin, ImpreciseDate end) {
        Set activations = this.getActivations(this.getResultPerson());
        if (begin != null && end != null && activations != null && activations.size() > 0) {
            Date startDate = ImpreciseDateUtils.getDateWithDefault(begin);
            Date endDate = ImpreciseDateUtils.getDateWithDefault(end);
            Iterator itr = activations.iterator();
            while (itr != null && itr.hasNext()) {
                Activation activation = (Activation)((Object)itr.next());
                if (!this.isOverlapped(activation.getActivationBeginDate(), activation.getActivationEndDate(), startDate, endDate)) continue;
                return activation;
            }
        }
        return null;
    }

    @Override
    public boolean hasMultNonbreakServiceEpisodeEQorGT24ContinuousMonths() throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfo(this.getResultPerson());
        return info.getCount() > 1 && info.meets24MonthCriteria();
    }

    private NonBreakingEpisodesInfo determineNonbreakServiceEpisodeInfoFromSet(Set episodes) {
        NonBreakingEpisodesInfo info = new NonBreakingEpisodesInfo();
        if (episodes == null) {
            return info;
        }
        Set msEpisodes = episodes;
        int numberOfEpisodes = 1;
        if (msEpisodes != null && msEpisodes.size() > 0) {
            Date start = null;
            Date end = null;
            List list = this.sortMilitaryServiceEpisodes(msEpisodes);
            for (MilitaryServiceEpisode mse : list) {
                Date startTmp = ImpreciseDateUtils.getDateWithDefault(mse.getStartDate());
                Date endTmp = ImpreciseDateUtils.getDateWithDefault(mse.getEndDate());
                if (startTmp == null || endTmp == null) continue;
                if (start == null) {
                    start = startTmp;
                    end = endTmp;
                    info.setFirstMSE(mse);
                }
                if (end != null && end.before(startTmp) && startTmp.before(endTmp)) {
                    if (end.equals(this.getDateMinusOneDay(startTmp))) {
                        end = endTmp;
                        ++numberOfEpisodes;
                        info.setLastMSE(mse);
                    } else {
                        start = startTmp;
                        end = endTmp;
                    }
                }
                Date minDate = this.get24MonthDate(start);
                if (end == null || !end.equals(minDate) && !end.after(minDate)) continue;
                info.setMeets24MonthCriteria(true);
            }
            info.setCount(numberOfEpisodes);
        }
        return info;
    }

    private NonBreakingEpisodesInfo determineNonbreakServiceEpisodeInfo(Person person) throws ServiceException {
        if (person == null) {
            return new NonBreakingEpisodesInfo();
        }
        Set msEpisodes = this.getHECMSEs(person.getMilitaryService());
        return this.determineNonbreakServiceEpisodeInfoFromSet(msEpisodes);
    }

    private Date getDateMinusOneDay(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        calendar.add(5, -1);
        return calendar.getTime();
    }

    private Date get24MonthDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTime(date);
        int month = calendar.get(2);
        calendar.set(2, month += 24);
        return calendar.getTime();
    }

    private List sortMilitaryServiceEpisodes(Set mses) {
        MilitaryServiceEpisodeComparator comparator = new MilitaryServiceEpisodeComparator();
        if (mses == null || mses.isEmpty()) {
            return new ArrayList();
        }
        ArrayList list = new ArrayList(mses);
        Collections.sort(list, comparator);
        return list;
    }

    @Override
    public boolean isCharacterOfDischargeOfFirstNonbreakServiceEpisodeEqual(String code) throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfo(this.getResultPerson());
        MilitaryServiceEpisode mse = info.getFirstMSE();
        String cd = mse != null && mse.getDischargeType() != null ? mse.getDischargeType().getCode() : null;
        return code != null ? code.equals(cd) : false;
    }

    @Override
    public boolean hasMultNonbreakServiceEpisode() throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfo(this.getResultPerson());
        return info.getCount() > 1;
    }

    @Override
    public Date getEnteredOnDuty() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        if (mse != null && mse.getStartDate() != null) {
            return ImpreciseDateUtils.getDateWithDefault(mse.getStartDate());
        }
        return null;
    }

    @Override
    public boolean hasSingleServiceEpisodeEQorGT24ContinuousMonths() throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfo(this.getResultPerson());
        return info.getCount() == 1 && info.meets24MonthCriteria();
    }

    @Override
    public boolean isAnyMilitaryServiceEpisodeEQorGT24Months(Set episodes) throws ServiceException {
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfoFromSet(episodes);
        return info.meets24MonthCriteria();
    }

    @Override
    public boolean isMilitaryServiceEpisodeEQorGT24Months(MilitaryServiceEpisode mse) throws ServiceException {
        if (mse == null) {
            return false;
        }
        HashSet<MilitaryServiceEpisode> episodes = new HashSet<MilitaryServiceEpisode>();
        episodes.add(mse);
        NonBreakingEpisodesInfo info = this.determineNonbreakServiceEpisodeInfoFromSet(episodes);
        return info.getCount() == 1 && info.meets24MonthCriteria();
    }

    @Override
    public boolean isPeriodOfServiceAtLeastOneDay(MilitaryServiceEpisode mse) throws ServiceException {
        Date upper_range;
        if (mse == null) {
            return false;
        }
        Date lower_range = mse.getStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getStartDate()) : null;
        Date date = upper_range = mse.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getEndDate()) : null;
        if (lower_range == null || upper_range == null) {
            return false;
        }
        return this.isAfterIgnoreTime(upper_range, lower_range) || this.isSameDay(lower_range, upper_range);
    }

    @Override
    public CombatPayType getCombatPayType() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            CombatService cs = data.getCombatService();
            return cs != null ? cs.getCombatPayType() : null;
        }
        return null;
    }

    @Override
    public boolean hasCombatPayMatch(CombatPayType type, Date begin) {
        Set combatServices = this.getCombatServices(this.getResultPerson());
        this.setMatchedCombatPay(null);
        if (combatServices != null && combatServices.size() > 0 && type != null && begin != null) {
            Iterator iter;
            Iterator i = iter = combatServices.iterator();
            while (i.hasNext()) {
                CombatPayType payType;
                CombatService cs = (CombatService)((Object)i.next());
                Date beginDate = cs.getPayStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayStartDate()) : null;
                CombatPayType combatPayType = payType = cs.getCombatPayType() != null ? cs.getCombatPayType() : null;
                if (beginDate == null || payType == null || !beginDate.equals(begin) || !payType.getCode().equals(type.getCode())) continue;
                this.setMatchedCombatPay(cs);
                return true;
            }
        }
        return false;
    }

    @Override
    public Date getDeploymentEndDate() {
        Deployment dep = this.getDeployment();
        return dep != null ? dep.getDeploymentEndDate() : null;
    }

    @Override
    public Date getDeploymentEndDate(Person person) {
        Deployment dep = this.getDeployment();
        return dep != null ? dep.getDeploymentEndDate() : null;
    }

    @Override
    public boolean hasDeploymentExactMatch(Deployment deployment) {
        return this.hasDeploymentExactOrSimpleMatch(deployment, null);
    }

    @Override
    public String getCharacterOfServiceCode() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        return mse != null && mse.getDischargeType() != null ? mse.getDischargeType().getCode() : null;
    }

    @Override
    public String getMsdsServiceComponent() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        return mse != null && mse.getMilitaryServiceComponent() != null ? mse.getMilitaryServiceComponent().getCode() : null;
    }

    @Override
    public String getHECMostRecentServiceComponent() {
        MilitaryServiceEpisode mse = this.getHECMostRecentMSE(this.getResultPerson().getMilitaryService());
        return mse != null && mse.getMilitaryServiceComponent() != null ? mse.getMilitaryServiceComponent().getCode() : null;
    }

    @Override
    public String getMsdsWorkItem() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMsdsWorkItem() : null;
    }

    @Override
    public void setMsdsWorkItem(String item) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setMsdsWorkItem(item);
        }
    }

    @Override
    public boolean isCombayPayPeriodLessThanADR(Date start, Date end) {
        if (start == null || end == null) {
            return true;
        }
        Set combatServices = this.getCombatServices(this.getPristinePerson());
        if (combatServices != null && combatServices.size() > 0) {
            Date startDate;
            CombatService cs = (CombatService)((Object)Collections.max(combatServices, new CombatServiceComparator()));
            Date endDate = cs != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate()) : null;
            Date date = startDate = cs != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayStartDate()) : null;
            if (startDate != null && endDate != null && start.after(startDate) && start.before(endDate)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isCombatPayPeriodLessThan(Date start, Date end) {
        Set combatServices = this.getCombatServices(this.getPristinePerson());
        if (start != null && end != null && combatServices != null && combatServices.size() > 0) {
            Iterator iter;
            Iterator i = iter = combatServices.iterator();
            while (i.hasNext()) {
                Date upper_range;
                CombatService cs = (CombatService)((Object)i.next());
                Date lower_range = cs.getPayStartDate() != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayStartDate()) : null;
                Date date = upper_range = cs.getPayEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate()) : null;
                if (lower_range == null || upper_range == null || !start.after(lower_range) || !start.before(end)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasServiceEpisodeWithOverlap(MilitaryServiceEpisode mse) throws ServiceException {
        if (mse == null) {
            return false;
        }
        Date fromDate = ImpreciseDateUtils.getDateWithDefault(mse.getStartDate());
        Date toDate = ImpreciseDateUtils.getDateWithDefault(mse.getEndDate());
        Set msEpisodes = this.getHECMSEs(this.getResultPerson().getMilitaryService());
        return this.isOverlapped(msEpisodes, fromDate, toDate);
    }

    @Override
    public MilitaryServiceEpisode getMSEFromMSDS() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        MilitaryServiceEpisode mse = data != null ? data.getIncomingMilitaryServiceEpisode() : null;
        return mse;
    }

    @Override
    public Date getMostRecentHECrecordSSD() {
        MilitaryServiceEpisode mse = this.getMatchedMSE();
        return mse != null && mse.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getEndDate()) : null;
    }

    public MilitaryServiceEpisode getMostRecentMSE(Person person) {
        if (person == null) {
            return null;
        }
        MilitaryServiceEpisode mostRecentMSE = null;
        MilitaryService ms = person.getMilitaryService();
        if (ms != null) {
            Iterator i;
            HashSet episodes = new HashSet();
            Set records = ms.getMilitaryServiceSiteRecords();
            Iterator iterator = i = records != null ? records.iterator() : null;
            while (i != null && i.hasNext()) {
                MilitaryServiceSiteRecord site_record = (MilitaryServiceSiteRecord)((Object)i.next());
                Set site_episodes = site_record != null ? site_record.getMilitaryServiceEpisodes() : null;
                if (site_episodes == null || site_episodes.isEmpty()) continue;
                episodes.addAll(site_episodes);
            }
            MilitaryServiceEpisodeComparator comparator = new MilitaryServiceEpisodeComparator();
            if (!episodes.isEmpty()) {
                MilitaryServiceEpisode episode;
                mostRecentMSE = episode = (MilitaryServiceEpisode)((Object)Collections.max(episodes, comparator));
            }
        }
        return mostRecentMSE;
    }

    @Override
    public DischargeType getMatchedServiceDischargeType() {
        MilitaryServiceEpisode mse = this.getMatchedMSE();
        return mse != null ? mse.getDischargeType() : null;
    }

    @Override
    public String getMatchedServiceDischargeTypeCode() {
        DischargeType type = this.getMatchedServiceDischargeType();
        return type != null ? type.getCode() : null;
    }

    @Override
    public boolean hasDeployment(Person person) {
        Set activations = this.getActivations(person);
        if (activations != null && activations.size() > 0) {
            Iterator itr = activations.iterator();
            while (itr != null && itr.hasNext()) {
                Activation activation = (Activation)((Object)itr.next());
                if (activation.getDeployments() == null || activation.getDeployments().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Deployment getDeployment() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getDeployment() : null;
    }

    private Set getActivations(Person person) {
        return person != null && person.getMilitaryService() != null ? person.getMilitaryService().getActivations() : null;
    }

    @Override
    public CombatService getCombatService() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null && data.getCombatService() != null ? data.getCombatService() : null;
    }

    @Override
    public Activation getActivation() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getActivation() : null;
    }

    @Override
    public boolean hasCombatService(Person person) {
        Set cServices = this.getCombatServices(person);
        return cServices != null && cServices.size() > 0;
    }

    public Set getCombatServices(Person person) {
        return person != null && person.getMilitaryService() != null ? person.getMilitaryService().getCombatServices() : null;
    }

    @Override
    public boolean hasCombatServiceWithOverlap(CombatService cs) {
        Set cServices = this.getCombatServices(this.getResultPerson());
        boolean found = false;
        if (cServices != null && cs != null) {
            Date start = ImpreciseDateUtils.getDateWithDefault(cs.getPayStartDate());
            Date end = ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate());
            for (CombatService combatService : cServices) {
                if (!this.isOverlapped(ImpreciseDateUtils.getDateWithDefault(combatService.getPayStartDate()), ImpreciseDateUtils.getDateWithDefault(combatService.getPayEndDate()), start, end)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public String getNameContingencyCode() {
        Activation activation = this.getActivation();
        return activation != null && activation.getNamedContingency() != null ? activation.getNamedContingency().getCode() : null;
    }

    @Override
    public String getSpecialOperationCode() {
        Deployment dep = this.getDeployment();
        return dep != null && dep.getSpecialOperation() != null ? dep.getSpecialOperation().getCode() : null;
    }

    @Override
    public String getTerminationReasonCode() {
        Deployment deployment = this.getDeployment();
        return deployment != null && deployment.getTerminationReason() != null ? deployment.getTerminationReason().getCode() : null;
    }

    @Override
    public Date getActivationEndDate() {
        Activation activation = this.getActivation();
        return activation != null ? activation.getActivationEndDate() : null;
    }

    @Override
    public Date getMostRecentActivationEndDate() {
        Set activations;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        Date endDate = null;
        Set set = activations = ms != null ? ms.getActivations() : new HashSet();
        if (!activations.isEmpty()) {
            Activation activation = (Activation)((Object)Collections.max(activations, new ActivationComparator()));
            endDate = activation != null ? activation.getActivationEndDate() : null;
        }
        return endDate;
    }

    @Override
    public Date getActivationEndDate(Person person) {
        return null;
    }

    @Override
    public Date getMatchedRADDate() {
        MilitaryServiceEpisode mse = this.getMatchedMSE();
        return mse != null && mse.getEndDate() != null ? ImpreciseDateUtils.getDateWithDefault(mse.getEndDate()) : null;
    }

    @Override
    public Date getRADDate() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        return mse != null ? ImpreciseDateUtils.getDateWithDefault(mse.getEndDate()) : null;
    }

    @Override
    public MsdsCountry getDeploymentCountry() {
        Deployment deployment = this.getDeployment();
        return deployment != null ? deployment.getCountry() : null;
    }

    @Override
    public Date getDeploymentBeginDate() {
        Deployment deployment = this.getDeployment();
        return deployment != null ? deployment.getDeploymentBeginDate() : null;
    }

    @Override
    public String getCombatServiceSourceCode() {
        CombatService cs = this.getCombatService();
        return cs != null && cs.getCombatServiceSource() != null ? cs.getCombatServiceSource().getCode() : null;
    }

    @Override
    public DischargeType getServiceDischargeType(Person person) {
        DischargeType type = null;
        MilitaryServiceEpisode mse = this.getMostRecentMSE(person);
        if (mse != null) {
            type = mse.getDischargeType();
        }
        return type;
    }

    @Override
    public void acceptCombatEpisodesFromVadir() {
        CombatEpisode ce = this.getCombatEpisode();
        CombatEpisode matched = this.getMatchedCombatEpisode();
        if (ce != null) {
            MilitaryService currentMilitaryService = this.getResultPerson().getMilitaryService();
            if (currentMilitaryService == null) {
                currentMilitaryService = new MilitaryService();
                this.getResultPerson().setMilitaryService(currentMilitaryService);
            }
            if (matched == null) {
                matched = new CombatEpisode();
                this.getResultPerson().getMilitaryService().addCombatEpisode(matched);
            }
            this.getMergeRuleService().mergeCombatEpisode(ce, matched);
        }
    }

    @Override
    public void updateCombatPayData() {
        CombatService cs = this.getCombatService();
        CombatService matched = this.getMatchedCombatPay();
        if (cs != null && this.getResultPerson().getMilitaryService() != null) {
            if (matched == null) {
                matched = new CombatService();
                this.getResultPerson().getMilitaryService().addCombatService(matched);
            }
            this.getMergeRuleService().mergeCombatService(cs, matched);
        }
    }

    @Override
    public void updateActivation() throws ServiceException {
        Activation act = this.getActivation();
        if (act == null) {
            return;
        }
        Activation matched = this.getMatchedActivationFromResult(act);
        if (matched == null) {
            matched = new Activation();
            MilitaryService currentMilitaryService = this.getResultPerson().getMilitaryService();
            if (currentMilitaryService == null) {
                currentMilitaryService = new MilitaryService();
                this.getResultPerson().setMilitaryService(currentMilitaryService);
            }
            this.getResultPerson().getMilitaryService().addActivation(matched);
        }
        this.getMergeRuleService().mergeActivation(act, matched);
    }

    private Activation getMatchedActivationFromResult(Activation incoming) {
        Set activations = this.getActivations(this.getResultPerson());
        if (incoming != null && activations != null && activations.size() > 0) {
            for (Activation activation : activations) {
                Date begin = activation.getActivationBeginDate();
                Date incomingBegin = incoming.getActivationBeginDate();
                if (begin == null || incomingBegin == null || !begin.equals(incomingBegin)) continue;
                return activation;
            }
        }
        return null;
    }

    @Override
    public void updateCombatPayEndDate() {
        CombatService cs = this.getMatchedCombatPay();
        CombatService incoming = this.getCombatService();
        if (cs != null && incoming != null) {
            cs.setPayEndDate(incoming.getPayEndDate());
        }
    }

    @Override
    public void updateDeploymentData() throws ServiceException {
        Deployment matched;
        Deployment deployment = this.getDeployment();
        Activation incomingActivation = this.getActivation();
        if (deployment == null || incomingActivation == null) {
            return;
        }
        Activation matchedActivationFromResult = this.getMatchedActivationFromResult(incomingActivation);
        if (matchedActivationFromResult == null) {
            matchedActivationFromResult = new Activation();
            this.getMergeRuleService().mergeActivation(incomingActivation, matchedActivationFromResult);
            Person resultPerson = this.getResultPerson();
            MilitaryService currentMilitaryService = resultPerson.getMilitaryService();
            if (currentMilitaryService == null) {
                currentMilitaryService = new MilitaryService();
                resultPerson.setMilitaryService(currentMilitaryService);
            }
            resultPerson.getMilitaryService().addActivation(matchedActivationFromResult);
        }
        if ((matched = this.getMatchedDeployment()) == null) {
            matched = new Deployment();
            matchedActivationFromResult.addDeployment(matched);
        }
        this.getMergeRuleService().mergeDeployment(deployment, matched);
    }

    @Override
    public void updateDeploymentEndDate() {
        Deployment dep = this.getMatchedDeployment();
        Deployment incoming = this.getDeployment();
        if (dep != null && incoming != null) {
            dep.setDeploymentEndDate(incoming.getDeploymentEndDate());
        }
    }

    @Override
    public MHDataSource getDeploymentSourceOfData() {
        Deployment deployment = this.getDeployment();
        return deployment != null ? deployment.getDataSource() : null;
    }

    @Override
    public boolean hasCombatPayExactMatch(CombatService cp) {
        Set combatServices = this.getCombatServices(this.getResultPerson());
        CombatService csExactMatch = null;
        this.setMatchedCombatPay(null);
        if (cp != null && combatServices != null && (csExactMatch = (CombatService)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)cp, combatServices)) != null) {
            this.setMatchedCombatPay(csExactMatch);
        }
        return csExactMatch != null;
    }

    @Override
    public void setDeploymentDateLastUpdated() {
        Deployment dep = this.getMatchedDeployment();
        Deployment incoming = this.getDeployment();
        if (dep != null && incoming != null) {
            dep.setModifiedOn(incoming.getModifiedOn());
        }
    }

    @Override
    public void setDeploymentSourceOfData(MHDataSource source) {
        Deployment dep = this.getMatchedDeployment();
        Deployment incoming = this.getDeployment();
        if (dep != null && incoming != null) {
            dep.setDataSource(incoming.getDataSource());
        }
    }

    @Override
    public void setMsdsMessageDate() {
        MilitaryServiceInputData data;
        Date date;
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        Date date2 = date = mse != null ? mse.getCreatedOn() : this.getCurrentDate();
        if (date != null && (data = this.getMilitaryServiceInputData()) != null) {
            data.setMsdsMessageDate(ImpreciseDateUtils.createImpreciseDateWithoutTime(date));
        }
    }

    @Override
    public void setServiceEndDate() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        MilitaryServiceEpisode matched = this.getMatchedMSE();
        if (matched != null && mse != null) {
            matched.setEndDate(mse.getEndDate());
        }
    }

    @Override
    public void setServiceEpisodeDateLastUpdated() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        MilitaryServiceEpisode matched = this.getMatchedMSE();
        if (matched != null && mse != null) {
            matched.setModifiedOn(mse.getModifiedOn());
        }
    }

    @Override
    public void acceptServiceEpisodeFromMSDS() throws ServiceException {
        if (this.getMilitaryServiceInputData() != null) {
            MilitaryServiceSiteRecord incomingHECSiteRecord;
            MilitaryServiceSiteRecord militaryServiceSiteRecord = incomingHECSiteRecord = this.getMilitaryServiceInputData().getMilitaryService() != null ? this.getMilitaryServiceInputData().getMilitaryService().getHECMilitaryServiceSiteRecord() : null;
            if (incomingHECSiteRecord != null) {
                MilitaryServiceEpisode toAdd;
                MilitaryServiceSiteRecord currentHECSiteRecord;
                Person onFile = this.getResultPerson();
                MilitaryService currentMilitaryService = onFile.getMilitaryService();
                if (currentMilitaryService == null) {
                    currentMilitaryService = new MilitaryService();
                    onFile.setMilitaryService(currentMilitaryService);
                }
                if ((currentHECSiteRecord = currentMilitaryService.getHECMilitaryServiceSiteRecord()) == null) {
                    currentHECSiteRecord = new MilitaryServiceSiteRecord();
                    this.getMergeRuleService().mergeMilitaryServiceSiteRecord(incomingHECSiteRecord, currentHECSiteRecord);
                    currentMilitaryService.addMilitaryServiceSiteRecord(currentHECSiteRecord);
                }
                if ((toAdd = this.getMilitaryServiceInputData().getIncomingMilitaryServiceEpisode()) != null) {
                    MilitaryServiceEpisode mse = null;
                    if (toAdd.getEntityKey() != null) {
                        mse = currentHECSiteRecord.getMilitaryServiceEpisodeByEntityKey(toAdd.getEntityKey());
                    }
                    if (mse == null) {
                        Set episodes = currentHECSiteRecord.getMilitaryServiceEpisodes();
                        for (AbstractEntity obj : episodes) {
                            if (!this.getMergeRuleService().getMatchRuleService().match(obj, (AbstractEntity)toAdd)) continue;
                            mse = (MilitaryServiceEpisode)obj;
                            break;
                        }
                        if (mse == null) {
                            mse = new MilitaryServiceEpisode();
                            currentHECSiteRecord.addMilitaryServiceEpisode(mse);
                        }
                    }
                    this.getMergeRuleService().mergeMilitaryServiceEpisode(toAdd, mse);
                }
            }
        }
    }

    @Override
    public void setServiceEpisodeSourceOfData() {
        MilitaryServiceEpisode mse = this.getMilitaryServiceEpisode();
        MilitaryServiceEpisode matched = this.getMatchedMSE();
        if (matched == null || mse != null) {
            // empty if block
        }
    }

    public MilitaryServiceEpisode getMatchedMSE() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMatchedMSE() : null;
    }

    public Activation getMatchedActivation() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMatchedActivation() : null;
    }

    @Override
    public void setMatchedActivation(Activation matchedActivation) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setMatchedActivation(matchedActivation);
        }
    }

    @Override
    public boolean hasServiceEpisodeExactMatch() throws ServiceException {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        Set mses = this.getHECMSEs(this.getResultPerson().getMilitaryService());
        this.setMatchedMSE(null);
        MilitaryServiceEpisode mseExactMatch = null;
        if (mse != null && mses != null) {
            mseExactMatch = (MilitaryServiceEpisode)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)mse, mses);
            this.setMatchedMSE(mseExactMatch);
        }
        return mseExactMatch != null;
    }

    @Override
    public String getMSDSdataSource() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMsdsDataSource() : null;
    }

    @Override
    public void setCharacterOfDischarge(DischargeType type) {
        MilitaryServiceEpisode mse = this.getMatchedMSE();
        if (mse != null & type != null) {
            mse.setDischargeType(type);
        }
    }

    @Override
    public void setCombatPayDateLastUpdated() {
        CombatService cs = this.getMatchedCombatPay();
        CombatService incoming = this.getCombatService();
        if (cs != null && incoming != null) {
            cs.setModifiedOn(incoming.getModifiedOn());
        }
    }

    @Override
    public CombatServiceSource getCombatPaySourceOfData() {
        CombatService cs = this.getCombatService();
        return cs != null && cs.getCombatServiceSource() != null ? cs.getCombatServiceSource() : null;
    }

    @Override
    public void setCombatPaySourceOfData(CombatServiceSource source) {
        CombatService cs = this.getMatchedCombatPay();
        CombatService incoming = this.getCombatService();
        if (cs != null && incoming != null) {
            cs.setCombatServiceSource(source);
        }
    }

    @Override
    public void adjustMSDSImpreciseDates() {
        CombatService cs = this.getCombatService();
        if (cs != null && cs.getPayEndDate() != null && cs.getPayStartDate() != null) {
            if (!cs.getPayStartDate().isDayPrecise()) {
                ImpreciseDate adjustedStart = ImpreciseDateUtils.createImpreciseDateWithoutTime(ImpreciseDateUtils.getDateWithDefault(cs.getPayStartDate(), 5, 1));
                cs.setPayStartDate(adjustedStart);
            }
            if (!cs.getPayEndDate().isDayPrecise()) {
                Date tmpEnd = ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate());
                Calendar calendar = Calendar.getInstance();
                calendar.clear();
                calendar.setTime(tmpEnd);
                int lastDate = calendar.getActualMaximum(5);
                calendar.set(5, lastDate);
                int lastDay = calendar.get(5);
                ImpreciseDate adjustedEnd = ImpreciseDateUtils.createImpreciseDateWithoutTime(ImpreciseDateUtils.getDateWithDefault(cs.getPayEndDate(), 5, lastDay));
                cs.setPayEndDate(adjustedEnd);
            }
        }
    }

    @Override
    public void setRAD(Date rad) {
        MilitaryServiceEpisode mse = this.getMatchedMSE();
        if (mse != null && rad != null) {
            mse.setEndDate(ImpreciseDateUtils.createImpreciseDateWithoutTime(rad));
        }
    }

    @Override
    public boolean hasMatchingBOSandBegDateOfServiceInADR(ServiceBranch branch, Date begin) throws ServiceException {
        Set mses = this.getHECMSEs(this.getResultPerson().getMilitaryService());
        this.setMatchedMSE(null);
        if (mses != null && branch != null && begin != null) {
            for (MilitaryServiceEpisode mse : mses) {
                if (mse.getServiceBranch() == null || mse.getStartDate() == null || !branch.getCode().equals(mse.getServiceBranch().getCode()) || !begin.equals(ImpreciseDateUtils.getDateWithDefault(mse.getStartDate()))) continue;
                this.setMatchedMSE(mse);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasDeploymentMatch(Date begin) {
        return this.hasDeploymentExactOrSimpleMatch(null, begin);
    }

    private boolean hasDeploymentExactOrSimpleMatch(Deployment incoming, Date begin) {
        Set activations = this.getActivations(this.getResultPerson());
        if (activations != null && activations.size() > 0) {
            for (Activation activation : activations) {
                Set deployments = activation.getDeployments();
                if (deployments == null || deployments.size() <= 0) continue;
                for (Deployment deployment : deployments) {
                    boolean match;
                    if (begin != null && incoming == null) {
                        if (begin.compareTo(deployment.getDeploymentBeginDate()) != 0) continue;
                        this.setMatchedDeployment(deployment);
                        this.setMatchedActivation(activation);
                        return true;
                    }
                    if (begin != null || incoming == null || !(match = this.getMergeRuleService().getMatchRuleService().match((AbstractEntity)incoming, (AbstractEntity)deployment))) continue;
                    this.setMatchedDeployment(deployment);
                    this.setMatchedActivation(activation);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public Date getHECMostRecentReceivedSSD() {
        MilitaryService ms;
        if (this.mostRecentSSD == null && (ms = this.getResultPerson().getMilitaryService()) != null) {
            Set site_episodes;
            HashSet episodes = new HashSet();
            MilitaryServiceSiteRecord record = ms.getHECMilitaryServiceSiteRecord();
            Set set = site_episodes = record != null ? record.getMilitaryServiceEpisodes() : null;
            if (site_episodes != null && !site_episodes.isEmpty()) {
                episodes.addAll(site_episodes);
            }
            MilitaryServiceEpisodeComparator comparator = new MilitaryServiceEpisodeComparator();
            if (!episodes.isEmpty()) {
                MilitaryServiceEpisode episode = (MilitaryServiceEpisode)((Object)Collections.max(episodes, comparator));
                this.mostRecentSSD = episode != null ? ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()) : null;
            }
        }
        return this.mostRecentSSD;
    }

    private MilitaryServiceEpisode getHECMostRecentMSE(MilitaryService ms) {
        if (ms != null) {
            Set site_episodes;
            HashSet episodes = new HashSet();
            MilitaryServiceSiteRecord record = ms.getHECMilitaryServiceSiteRecord();
            Set set = site_episodes = record != null ? record.getMilitaryServiceEpisodes() : null;
            if (site_episodes != null && !site_episodes.isEmpty()) {
                episodes.addAll(site_episodes);
            }
            MilitaryServiceEpisodeComparator comparator = new MilitaryServiceEpisodeComparator();
            if (!episodes.isEmpty()) {
                return (MilitaryServiceEpisode)((Object)Collections.max(episodes, comparator));
            }
        }
        return null;
    }

    @Override
    public Date getHECMostRecentDtSsdCombatEpisodeActivationCombatPay() {
        Date ssdDt = this.getHECMostRecentReceivedSSD();
        Date ceEndDt = this.getMostRecentReceivedCombatEpisodeEndDate();
        Date actDt = this.getMostRecentActivationEndDate();
        Date payDt = this.getMostRecentCombatPayEndDate();
        HashSet<Date> dates = new HashSet<Date>();
        if (ssdDt != null) {
            dates.add(ssdDt);
        }
        if (ceEndDt != null) {
            dates.add(ceEndDt);
        }
        if (actDt != null) {
            dates.add(actDt);
        }
        if (payDt != null) {
            dates.add(payDt);
        }
        DateComparator dc = new DateComparator();
        if (!dates.isEmpty()) {
            return (Date)Collections.max(dates, dc);
        }
        return null;
    }

    @Override
    public Date getHECMostRecentSSDOrCombatToDate() {
        Date ssdDt = this.getHECMostRecentReceivedSSD();
        Date ceEndDt = this.getMostRecentReceivedCombatEpisodeEndDate();
        if (ssdDt == null) {
            return ceEndDt;
        }
        if (ceEndDt == null) {
            return ssdDt;
        }
        return ssdDt.after(ceEndDt) ? ssdDt : ceEndDt;
    }

    @Override
    public Date getHECMostRecentSSDOrCombatEndDatePlus5YearsMinus1Day() {
        return this.getDatePlus5YearsMinus1Day(this.getHECMostRecentSSDOrCombatToDate());
    }

    @Override
    public boolean isHECMostRecentConflictToDateAfterForLocation(Date date, String code) {
        if (date == null) {
            return false;
        }
        boolean mostRecent = false;
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms != null) {
            ConflictExperience conflict;
            Set site_conflicts;
            HashSet conflicts = new HashSet();
            MilitaryServiceSiteRecord site_record = ms.getHECMilitaryServiceSiteRecord();
            Set set = site_conflicts = site_record != null ? site_record.getConflictExperiences() : null;
            if (site_conflicts != null && !site_conflicts.isEmpty()) {
                conflicts.addAll(site_conflicts);
            }
            CombatEpisodeComparator comparator = new CombatEpisodeComparator();
            if (!conflicts.isEmpty() && (conflict = (ConflictExperience)((Object)Collections.max(conflicts, comparator))) != null) {
                ConflictLocation location = conflict.getConflictLocation();
                Date toDate = ImpreciseDateUtils.getDateWithDefault(conflict.getEndDate());
                if (location != null && toDate != null && location.getCode().equals(code) && toDate.after(date)) {
                    mostRecent = true;
                }
            }
        }
        return mostRecent;
    }

    @Override
    public String getMsdsQueryStatusCode(Person person) {
        MilitaryService ms = person.getMilitaryService();
        return ms != null && ms.getMilitaryServiceQueryStatus() != null ? ms.getMilitaryServiceQueryStatus().getCode() : null;
    }

    @Override
    public void setMsdsQueryStatus(String status) throws ServiceException {
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms == null) {
            ms = new MilitaryService();
            this.getResultPerson().setMilitaryService(ms);
        }
        ms.setMilitaryServiceQueryStatus(this.getLookupService().getMilitaryServiceQueryStatusByCode(status));
    }

    @Override
    public String getMsdsReceiveStatus() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).getMsdsReceiveStatus();
        }
        return null;
    }

    @Override
    public String getMsdsBirlsStatus() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).getMsdsBirlsStatus();
        }
        return null;
    }

    @Override
    public String getMsdsVadirStatus() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).getMsdsVadirStatus();
        }
        return null;
    }

    @Override
    public String getMsdsOefOifIndicator() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).getMsdsOefOifIndicator();
        }
        return null;
    }

    @Override
    public DischargeType getMsdsServiceDischargeType() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        return mse != null ? mse.getDischargeType() : null;
    }

    @Override
    public ServiceBranch getMsdsServiceBranch() {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        return mse != null ? mse.getServiceBranch() : null;
    }

    @Override
    public void setOefOifIndicatorOfMostRecent(String ind) throws ServiceException {
        MilitaryService ms = this.getResultPerson().getMilitaryService();
        if (ms != null && ind != null) {
            Set CEs = ms.getCombatEpisodes();
            CombatEpisode mostRecent = null;
            if (!CEs.isEmpty() && (mostRecent = (CombatEpisode)((Object)Collections.max(CEs, new CombatEpisodeComparator()))) != null) {
                mostRecent.setConflictLocation(this.getLookupService().getConflictByCode(ind));
            }
        }
    }

    @Override
    public boolean hasDeploymentWithOverlap(Deployment deployment) {
        Set activations = this.getActivations(this.getPristinePerson());
        if (deployment != null && activations != null && !activations.isEmpty()) {
            Date start = deployment.getDeploymentBeginDate();
            Date end = deployment.getDeploymentEndDate();
            for (Activation activation : activations) {
                Set deployments = activation.getDeployments();
                if (deployments == null || deployments.isEmpty()) continue;
                for (Deployment temp : deployments) {
                    if (!this.isOverlapped(temp.getDeploymentBeginDate(), temp.getDeploymentEndDate(), start, end)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean hasNewMilitaryServiceEpisode() {
        HashSet<MilitaryServiceEpisode> overlapMSEList = new HashSet<MilitaryServiceEpisode>();
        HashSet<MilitaryServiceEpisode> newMSEList = new HashSet<MilitaryServiceEpisode>();
        Set incomingMSE = new HashSet();
        Set hecMSE = new HashSet();
        if (this.getPristinePerson().getMilitaryService() != null && this.getPristinePerson().getMilitaryService().getHECMilitaryServiceSiteRecord() != null) {
            hecMSE = this.getPristinePerson().getMilitaryService().getHECMilitaryServiceSiteRecord().getMilitaryServiceEpisodes();
        }
        if (this.getRuleDataAware() instanceof EventInputData && this.getIncomingPerson().getMilitaryService() != null && this.getIncomingPerson().getMilitaryService().getMilitaryServiceSiteRecordsBySite(((EventInputData)this.getRuleDataAware()).getVerificationInfo().getSiteNumber()) != null) {
            incomingMSE = this.getIncomingPerson().getMilitaryService().getMilitaryServiceSiteRecordsBySite(((EventInputData)this.getRuleDataAware()).getVerificationInfo().getSiteNumber()).getMilitaryServiceEpisodes();
        }
        if (incomingMSE != null && !incomingMSE.isEmpty()) {
            for (MilitaryServiceEpisode incoming : incomingMSE) {
                boolean overlap = this.isOverlapped(hecMSE, ImpreciseDateUtils.getDateWithDefault(incoming.getStartDate()), ImpreciseDateUtils.getDateWithDefault(incoming.getEndDate()));
                if (overlap) {
                    overlapMSEList.add(incoming);
                    continue;
                }
                newMSEList.add(incoming);
            }
        }
        return !newMSEList.isEmpty();
    }

    @Override
    public boolean hasNewOEFOIFdata() {
        Set pristineCE = new HashSet();
        Set resultCE = new HashSet();
        HashSet<CombatEpisode> overlapCEList = new HashSet<CombatEpisode>();
        HashSet<CombatEpisode> newCEList = new HashSet<CombatEpisode>();
        if (this.getPristinePerson().getMilitaryService() != null) {
            pristineCE = this.getPristinePerson().getMilitaryService().getCombatEpisodes();
        }
        if (this.getResultPerson().getMilitaryService() != null) {
            resultCE = this.getResultPerson().getMilitaryService().getCombatEpisodes();
        }
        if (resultCE != null && !resultCE.isEmpty()) {
            for (CombatEpisode incoming : resultCE) {
                boolean overlap = this.hasMatchingCombatEpisode(incoming, pristineCE);
                if (overlap) {
                    overlapCEList.add(incoming);
                    continue;
                }
                newCEList.add(incoming);
            }
        }
        return !newCEList.isEmpty();
    }

    private boolean hasMatchingCombatEpisode(CombatEpisode incomingCE, Set onFileCEs) {
        if (onFileCEs != null) {
            for (CombatEpisode onFileCE : onFileCEs) {
                if (!this.isEqual(incomingCE.getStartDate(), onFileCE.getStartDate()) || !this.isEqual(incomingCE.getEndDate(), onFileCE.getEndDate())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasNoMSDSdata() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).isNoMSDSdata();
        }
        return false;
    }

    @Override
    public boolean isMsdsRetryCountGreaterThanLimit() throws ServiceException {
        return super.getLogMessagingService().findCountCompletion(this.getResultPerson().getEntityKey());
    }

    @Override
    public Set getActivations() {
        return this.getActivations(this.getIncomingPerson());
    }

    @Override
    public Set getCombatEpisodes() {
        return this.getIncomingPerson().getMilitaryService() != null ? this.getIncomingPerson().getMilitaryService().getCombatEpisodes() : new HashSet();
    }

    @Override
    public Set getCombatPays() {
        return this.getCombatServices(this.getIncomingPerson());
    }

    @Override
    public Set getHECMilitaryServiceEpisodes() throws ServiceException {
        return this.getHECMSEs(this.getIncomingPerson().getMilitaryService());
    }

    @Override
    public Set getHECMilitaryServiceEpisodesResult() throws ServiceException {
        return this.getHECMSEs(this.getResultPerson().getMilitaryService());
    }

    @Override
    public void addFilteredMse(MilitaryServiceEpisode mse) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).addFilteredMseEntry(mse);
        }
    }

    @Override
    public Set getFilteredMseSet() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).getFilteredMseSet();
        }
        return null;
    }

    @Override
    public void removeAllFilteredMse() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).removeAllFilteredMseEntries();
        }
    }

    @Override
    public void setActivation(Activation activation) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setActivation(activation);
        }
    }

    @Override
    public CombatEpisode getCombatEpisode() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getCombatEpisode() : null;
    }

    @Override
    public void setCombatEpisode(CombatEpisode combatEpisode) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setCombatEpisode(combatEpisode);
        }
    }

    @Override
    public void setMatchedCombatEpisodeEndDate() {
        CombatEpisode matched = this.getMatchedCombatEpisode();
        CombatEpisode incoming = this.getCombatEpisode();
        if (matched != null && incoming != null) {
            matched.setEndDate(incoming.getEndDate());
        }
    }

    @Override
    public void setCombatPay(CombatService combatPay) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setCombatService(combatPay);
        }
    }

    @Override
    public void setDeployment(Deployment deployment) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setDeployment(deployment);
        }
    }

    @Override
    public void setMilitaryServiceEpisode(MilitaryServiceEpisode mse) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setIncomingMilitaryServiceEpisode(mse);
        }
    }

    @Override
    public void setMSDSdataSource(String source) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setMsdsDataSource(source);
        }
    }

    @Override
    public void terminateRuleFlow(boolean flag) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setTerminateRuleFlow(flag);
        }
    }

    @Override
    public boolean getSeedingIndicator() {
        return this.getMilitaryServiceInputData().getIsSeeding();
    }

    @Override
    public void updateSeedingCombatEpisodes() throws ServiceException {
        this.setSeedingCombatEpisode();
    }

    @Override
    public boolean updateSeedingCVEndDate() {
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService != null && this.getOnFileCVEligibilityEndDate() != null && this.getOnFileCVEligibilityEndDate().before(this.getCombatVeteranEligibilityEndDate())) {
            this.triggerZ07 = true;
        }
        return this.triggerZ07;
    }

    public CombatService getMatchedCombatPay() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMatchedCombatPay() : null;
    }

    public void setMatchedCombatPay(CombatService matchedCombatPay) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setMatchedCombatPay(matchedCombatPay);
        }
    }

    public void setMatchedMSE(MilitaryServiceEpisode matchedMSE) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setMatchedMSE(matchedMSE);
        }
    }

    public Deployment getMatchedDeployment() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMatchedDeployment() : null;
    }

    public void setMatchedDeployment(Deployment matchedDeployment) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setMatchedDeployment(matchedDeployment);
        }
    }

    @Override
    public void setSeedingMilitaryServiceSiteInformation() throws ServiceException {
        MilitaryService incomingMilitaryService;
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService == null) {
            currentMilitaryService = new MilitaryService();
            onFile.setMilitaryService(currentMilitaryService);
        }
        Set incomingSitesMSE = new HashSet();
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        MilitaryService militaryService = incomingMilitaryService = data != null ? data.getMilitaryService() : this.getIncomingPerson().getMilitaryService();
        if (incomingMilitaryService != null) {
            incomingSitesMSE = this.populateIncomingSitesMSE(incomingMilitaryService);
        }
        MilitaryServiceSiteRecord currentSiteRecord = currentMilitaryService.getHECMilitaryServiceSiteRecord();
        if (!incomingSitesMSE.isEmpty()) {
            if (currentSiteRecord == null) {
                currentSiteRecord = new MilitaryServiceSiteRecord();
                this.updateHECSeedingEpisode(incomingSitesMSE, currentSiteRecord);
                this.createHECMSSR(currentMilitaryService, currentSiteRecord);
            } else {
                this.updateHECSeedingEpisode(incomingSitesMSE, currentSiteRecord);
            }
        }
    }

    private Set populateIncomingSitesMSE(MilitaryService incomingMilitaryService) {
        HashSet<MilitaryServiceEpisode> incomingSitesMSE = new HashSet<MilitaryServiceEpisode>();
        Set incomingSiteRecords = incomingMilitaryService.getMilitaryServiceSiteRecords();
        if (incomingSiteRecords != null && !incomingSiteRecords.isEmpty()) {
            for (MilitaryServiceSiteRecord incomingSiteRecord : incomingSiteRecords) {
                if (incomingSiteRecord.getSite() == null || incomingSiteRecord.getSite().getCode().equals(VAFacility.CODE_HEC.getName()) || incomingSiteRecord.getMilitaryServiceEpisodes().isEmpty()) continue;
                for (MilitaryServiceEpisode incomingEpisode : incomingSiteRecord.getMilitaryServiceEpisodes()) {
                    if (incomingEpisode.getEndDate() == null || incomingEpisode.getStartDate() == null) continue;
                    incomingSitesMSE.add(incomingEpisode);
                }
            }
        }
        return incomingSitesMSE;
    }

    private void updateHECSeedingEpisode(Set incomingSitesMSE, MilitaryServiceSiteRecord currentSiteRecord) throws ServiceException {
        for (MilitaryServiceEpisode incomingEpisode : this.sortServiceSeparationDateRecentToOld(incomingSitesMSE)) {
            if (currentSiteRecord.getMilitaryServiceEpisodes().isEmpty()) {
                this.mergeMilitaryServiceEpisode(incomingEpisode, null, currentSiteRecord);
                continue;
            }
            Set hecMSE = this.getHecMilitaryServiceEpisode(currentSiteRecord.getMilitaryServiceEpisodes());
            if (hecMSE.isEmpty()) {
                this.mergeMilitaryServiceEpisode(incomingEpisode, null, currentSiteRecord);
                continue;
            }
            boolean hasOverlap = this.hasAMSEWithinDateRange(hecMSE, ImpreciseDateUtils.getDateWithDefault(incomingEpisode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(incomingEpisode.getEndDate()));
            if (hasOverlap) {
                MilitaryServiceEpisode overlappedEpisode = this.getOverlappedMSE(hecMSE, ImpreciseDateUtils.getDateWithDefault(incomingEpisode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(incomingEpisode.getEndDate()));
                if (overlappedEpisode == null) continue;
                this.seedingRule(overlappedEpisode, incomingEpisode, hecMSE, currentSiteRecord);
                continue;
            }
            this.mergeMilitaryServiceEpisode(incomingEpisode, null, currentSiteRecord);
        }
    }

    private void createHECMSSR(MilitaryService currentMilitaryService, MilitaryServiceSiteRecord currentSiteRecord) throws ServiceException {
        currentSiteRecord.setSite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
        currentMilitaryService.addMilitaryServiceSiteRecord(currentSiteRecord);
    }

    private List sortServiceSeparationDateRecentToOld(Collection incomingMSEs) {
        ArrayList sortedIncomingMSEs = new ArrayList();
        if (incomingMSEs != null && !incomingMSEs.isEmpty()) {
            sortedIncomingMSEs.addAll(incomingMSEs);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof MilitaryServiceEpisode ? ImpreciseDateUtils.getReconcilitationDateWithDefault(((MilitaryServiceEpisode)((Object)pObject1)).getEndDate()) : null;
                    Date date2 = pObject2 instanceof MilitaryServiceEpisode ? ImpreciseDateUtils.getReconcilitationDateWithDefault(((MilitaryServiceEpisode)((Object)pObject2)).getEndDate()) : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(sortedIncomingMSEs, comparator);
        }
        return sortedIncomingMSEs;
    }

    private void mergeMilitaryServiceEpisode(MilitaryServiceEpisode incomingEpisode, MilitaryServiceEpisode overlappedEpisode, MilitaryServiceSiteRecord currentSiteRecord) {
        this.getMergeRuleService().mergeSeedingMilitaryServiceEpisode(incomingEpisode, overlappedEpisode, currentSiteRecord);
    }

    private Set getHecMilitaryServiceEpisode(Set hecMilitaryServiceEpisodes) {
        HashSet<MilitaryServiceEpisode> hecMSE = new HashSet<MilitaryServiceEpisode>();
        for (MilitaryServiceEpisode hecEpisode : hecMilitaryServiceEpisodes) {
            if (hecEpisode.getEndDate() == null || hecEpisode.getStartDate() == null) continue;
            hecMSE.add(hecEpisode);
        }
        return hecMSE;
    }

    public boolean hasAMSEWithinDateRange(Set episodes, Date fromDate, Date toDate) throws ServiceException {
        List orderedOnFileEpisodes = this.sortServiceSeparationDateRecentToOld(episodes);
        boolean found = false;
        found = this.isOverlapped(orderedOnFileEpisodes, fromDate, toDate);
        return found;
    }

    private void seedingRule(MilitaryServiceEpisode overlappedEpisode, MilitaryServiceEpisode incomingEpisode, Set hecMSEByType, MilitaryServiceSiteRecord currentSiteRecord) {
        Date overlappedStartDate = ImpreciseDateUtils.getDateWithDefault(overlappedEpisode.getStartDate());
        Date overlappedEndDate = ImpreciseDateUtils.getReconcilitationDateWithDefault(overlappedEpisode.getEndDate());
        Date incomingEpisodeStartDate = ImpreciseDateUtils.getDateWithDefault(incomingEpisode.getStartDate());
        Date incomingEpisodeEndDate = ImpreciseDateUtils.getReconcilitationDateWithDefault(incomingEpisode.getEndDate());
        if (overlappedStartDate.equals(incomingEpisodeStartDate)) {
            if (overlappedEndDate.equals(incomingEpisodeEndDate)) {
                if (overlappedEpisode.getServiceBranch() == null && incomingEpisode.getServiceBranch() != null) {
                    overlappedEpisode.setServiceBranch(incomingEpisode.getServiceBranch());
                }
                if (overlappedEpisode.getMilitaryServiceComponent() == null && incomingEpisode.getMilitaryServiceComponent() != null) {
                    overlappedEpisode.setMilitaryServiceComponent(incomingEpisode.getMilitaryServiceComponent());
                }
                if (overlappedEpisode.getServiceNumber() == null && incomingEpisode.getServiceNumber() != null) {
                    overlappedEpisode.setServiceNumber(incomingEpisode.getServiceNumber());
                }
                if (overlappedEpisode.getDischargeType() == null && incomingEpisode.getDischargeType() != null) {
                    overlappedEpisode.setDischargeType(incomingEpisode.getDischargeType());
                }
            } else if (overlappedEndDate.before(incomingEpisodeEndDate)) {
                if (hecMSEByType.size() > 1) {
                    Set tempOnFileEpisodes = hecMSEByType;
                    MilitaryServiceEpisode tempOnfileOverlap = this.checkUpdateOverlap(tempOnFileEpisodes, overlappedEpisode, incomingEpisodeStartDate, incomingEpisodeEndDate);
                    if (tempOnfileOverlap == null) {
                        this.mergeMilitaryServiceEpisode(incomingEpisode, overlappedEpisode, currentSiteRecord);
                    }
                } else {
                    this.mergeMilitaryServiceEpisode(incomingEpisode, overlappedEpisode, currentSiteRecord);
                }
            }
        } else if (overlappedEndDate.equals(incomingEpisodeEndDate) && overlappedStartDate.after(incomingEpisodeStartDate)) {
            if (hecMSEByType.size() > 1) {
                Set tempOnFileEpisodes = hecMSEByType;
                MilitaryServiceEpisode tempOnfileOverlap = this.checkUpdateOverlap(tempOnFileEpisodes, overlappedEpisode, incomingEpisodeStartDate, incomingEpisodeEndDate);
                if (tempOnfileOverlap == null) {
                    this.mergeMilitaryServiceEpisode(incomingEpisode, overlappedEpisode, currentSiteRecord);
                }
            } else {
                this.mergeMilitaryServiceEpisode(incomingEpisode, overlappedEpisode, currentSiteRecord);
            }
        }
    }

    private boolean isOverlapped(List episodes, Date fromDate, Date toDate) {
        boolean found = false;
        if (episodes != null) {
            for (MilitaryServiceEpisode episode : episodes) {
                if (!this.isOverlapped(ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()), ImpreciseDateUtils.getDateWithDefault(episode.getEndDate()), fromDate, toDate)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private MilitaryServiceEpisode getOverlappedMSE(Set episodes, Date fromDate, Date toDate) {
        List orderedOnFileEpisodes = this.sortServiceSeparationDateRecentToOld(episodes);
        MilitaryServiceEpisode overlappingEpisode = null;
        if (episodes != null && !episodes.isEmpty()) {
            for (MilitaryServiceEpisode episode : orderedOnFileEpisodes) {
                if (!this.isOverlapped(ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(episode.getEndDate()), fromDate, toDate)) continue;
                overlappingEpisode = episode;
                break;
            }
        }
        return overlappingEpisode;
    }

    private MilitaryServiceEpisode checkUpdateOverlap(Set tempOnfileEpisodes, MilitaryServiceEpisode overlappedEpisode, Date incomingEpisodeStartDate, Date incomingEpisodeEndDate) {
        MilitaryServiceEpisode tempOnfileOverlap = null;
        tempOnfileEpisodes.remove((Object)overlappedEpisode);
        tempOnfileOverlap = this.getOverlappedMSE(tempOnfileEpisodes, incomingEpisodeStartDate, incomingEpisodeEndDate);
        return tempOnfileOverlap;
    }

    private void setSeedingCombatEpisode() throws ServiceException {
        MilitaryService incomingMilitaryService;
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService == null) {
            currentMilitaryService = new MilitaryService();
            onFile.setMilitaryService(currentMilitaryService);
        }
        Set incomingCEs = new HashSet();
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        MilitaryService militaryService = incomingMilitaryService = data != null ? data.getMilitaryService() : this.getIncomingPerson().getMilitaryService();
        if (incomingMilitaryService != null) {
            incomingCEs = this.populateIncomingSitesCE(incomingMilitaryService);
        }
        if (!incomingCEs.isEmpty()) {
            this.updateCESeedingEpisode(incomingCEs, currentMilitaryService);
        }
    }

    private Set populateIncomingSitesCE(MilitaryService incomingMilitaryService) {
        HashSet<CombatEpisode> incomingSitesCE = new HashSet<CombatEpisode>();
        Set allCEs = incomingMilitaryService.getCombatEpisodes();
        if (allCEs != null && !allCEs.isEmpty()) {
            for (CombatEpisode incomingCE : allCEs) {
                if (incomingCE.getConflictLocation() == null) continue;
                String incomingConflictLocation = incomingCE.getConflictLocation().getCode();
                if (incomingCE.getOEFOIFStationNumber() != null && incomingCE.getOEFOIFStationNumber().getCode().equals(VAFacility.CODE_HEC.getName()) || !incomingConflictLocation.equals(ConflictLocation.CODE_UNKNOWN_OEF_OIF.getCode()) && !incomingConflictLocation.equals(ConflictLocation.CODE_OEF.getCode()) && !incomingConflictLocation.equals(ConflictLocation.CODE_OIF.getCode()) || incomingCE.getEndDate() == null || incomingCE.getStartDate() == null) continue;
                incomingSitesCE.add(incomingCE);
            }
        }
        return incomingSitesCE;
    }

    private void updateCESeedingEpisode(Set incomingSitesCE, MilitaryService currentMilitaryService) throws ServiceException {
        for (CombatEpisode incomingEpisode : this.sortCEServiceSeparationDateRecentToOld(incomingSitesCE)) {
            boolean removeIncoming = false;
            Set hecCEs = this.buildHecCEs(currentMilitaryService.getCombatEpisodes());
            if (hecCEs.isEmpty()) {
                this.updateCE(currentMilitaryService, incomingEpisode);
            } else {
                Set hecCEByConfLoc = this.getHecCEByConflictLoc(hecCEs, incomingEpisode.getConflictLocation());
                if (hecCEByConfLoc.isEmpty()) {
                    this.updateCE(currentMilitaryService, incomingEpisode);
                } else {
                    boolean hasOverlap = this.hasACEWithinDateRange(hecCEByConfLoc, ImpreciseDateUtils.getDateWithDefault(incomingEpisode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(incomingEpisode.getEndDate()));
                    if (hasOverlap) {
                        CombatEpisode overlappedEpisode = this.getOverlappedCE(hecCEByConfLoc, ImpreciseDateUtils.getDateWithDefault(incomingEpisode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(incomingEpisode.getEndDate()));
                        if (overlappedEpisode != null) {
                            this.seedingCERule(overlappedEpisode, incomingEpisode, hecCEByConfLoc, currentMilitaryService);
                            removeIncoming = true;
                        }
                    } else {
                        this.updateCE(currentMilitaryService, incomingEpisode);
                    }
                }
            }
            if (!removeIncoming) continue;
            incomingEpisode.getEntityKey();
            CombatEpisode onFileCE = currentMilitaryService.getCombatEpisodeByEntityKey(incomingEpisode.getEntityKey());
            currentMilitaryService.removeCombatEpisode(onFileCE);
        }
    }

    private List sortCEServiceSeparationDateRecentToOld(Collection incomingCEs) {
        ArrayList sortedIncomingCEs = new ArrayList();
        if (incomingCEs != null && !incomingCEs.isEmpty()) {
            sortedIncomingCEs.addAll(incomingCEs);
            Comparator comparator = new Comparator(){

                public int compare(Object pObject1, Object pObject2) {
                    Date date1 = pObject1 instanceof CombatEpisode ? ImpreciseDateUtils.getReconcilitationDateWithDefault(((CombatEpisode)((Object)pObject1)).getEndDate()) : null;
                    Date date2 = pObject2 instanceof CombatEpisode ? ImpreciseDateUtils.getReconcilitationDateWithDefault(((CombatEpisode)((Object)pObject2)).getEndDate()) : null;
                    return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                }
            };
            Collections.sort(sortedIncomingCEs, comparator);
        }
        return sortedIncomingCEs;
    }

    private Set buildHecCEs(Set onFileCEs) {
        HashSet<CombatEpisode> hecCEs = new HashSet<CombatEpisode>();
        if (onFileCEs != null && !onFileCEs.isEmpty()) {
            for (CombatEpisode hecCE : onFileCEs) {
                if (hecCE.getOEFOIFStationNumber() == null || !hecCE.getOEFOIFStationNumber().getCode().equals(VAFacility.CODE_HEC.getName()) || hecCE.getEndDate() == null || hecCE.getStartDate() == null) continue;
                hecCEs.add(hecCE);
            }
        }
        return hecCEs;
    }

    private void updateCE(MilitaryService currentMilitaryService, CombatEpisode incomingEpisode) throws ServiceException {
        incomingEpisode.getEntityKey();
        CombatEpisode onFileCE = currentMilitaryService.getCombatEpisodeByEntityKey(incomingEpisode.getEntityKey());
        onFileCE.setOEFOIFStationNumber(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
    }

    private Set getHecCEByConflictLoc(Set hecCEs, ConflictLocation conflictLoc) {
        HashSet<CombatEpisode> hecCEByconfLoc = new HashSet<CombatEpisode>();
        for (CombatEpisode hecCE : hecCEs) {
            if (hecCE.getConflictLocation() == null || !this.isEqual((Object)hecCE.getConflictLocation(), (Object)conflictLoc)) continue;
            hecCEByconfLoc.add(hecCE);
        }
        return hecCEByconfLoc;
    }

    public boolean hasACEWithinDateRange(Set episodes, Date fromDate, Date toDate) {
        List orderedOnFileEpisodes = this.sortCEServiceSeparationDateRecentToOld(episodes);
        boolean found = false;
        found = this.isCEOverlapped(orderedOnFileEpisodes, fromDate, toDate);
        return found;
    }

    private CombatEpisode getOverlappedCE(Set episodes, Date fromDate, Date toDate) {
        List orderedOnFileEpisodes = this.sortCEServiceSeparationDateRecentToOld(episodes);
        CombatEpisode overlappingEpisode = null;
        if (episodes != null && !episodes.isEmpty()) {
            for (CombatEpisode episode : orderedOnFileEpisodes) {
                if (!this.isOverlapped(ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(episode.getEndDate()), fromDate, toDate)) continue;
                overlappingEpisode = episode;
                break;
            }
        }
        return overlappingEpisode;
    }

    private void seedingCERule(CombatEpisode overlappedEpisode, CombatEpisode incomingEpisode, Set hecCEByConfLoc, MilitaryService onFile) throws ServiceException {
        Date overlappedStartDate = ImpreciseDateUtils.getDateWithDefault(overlappedEpisode.getStartDate());
        Date overlappedEndDate = ImpreciseDateUtils.getReconcilitationDateWithDefault(overlappedEpisode.getEndDate());
        Date incomingEpisodeStartDate = ImpreciseDateUtils.getDateWithDefault(incomingEpisode.getStartDate());
        Date incomingEpisodeEndDate = ImpreciseDateUtils.getReconcilitationDateWithDefault(incomingEpisode.getEndDate());
        if (overlappedStartDate.equals(incomingEpisodeStartDate)) {
            if (overlappedEndDate.equals(incomingEpisodeEndDate)) {
                if (overlappedEpisode.getOEFOIFSource() == null && incomingEpisode.getOEFOIFSource() != null) {
                    overlappedEpisode.setOEFOIFSource(incomingEpisode.getOEFOIFSource());
                }
                if (overlappedEpisode.getCombatPayType() == null && incomingEpisode.getCombatPayType() != null) {
                    overlappedEpisode.setCombatPayType(incomingEpisode.getCombatPayType());
                }
                overlappedEpisode.setOEFOIFStationNumber(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
            } else if (overlappedEndDate.before(incomingEpisodeEndDate)) {
                if (hecCEByConfLoc.size() > 1) {
                    Set tempOnFileEpisodes = hecCEByConfLoc;
                    CombatEpisode tempOnfileOverlap = this.checkCEUpdateOverlap(tempOnFileEpisodes, overlappedEpisode, incomingEpisodeStartDate, incomingEpisodeEndDate);
                    if (tempOnfileOverlap == null) {
                        this.mergeCombatEpisode(incomingEpisode, overlappedEpisode);
                    }
                } else {
                    this.mergeCombatEpisode(incomingEpisode, overlappedEpisode);
                }
            }
        } else if (overlappedEndDate.equals(incomingEpisodeEndDate) && overlappedStartDate.after(incomingEpisodeStartDate)) {
            if (hecCEByConfLoc.size() > 1) {
                Set tempOnFileEpisodes = hecCEByConfLoc;
                CombatEpisode tempOnfileOverlap = this.checkCEUpdateOverlap(tempOnFileEpisodes, overlappedEpisode, incomingEpisodeStartDate, incomingEpisodeEndDate);
                if (tempOnfileOverlap == null) {
                    this.mergeCombatEpisode(incomingEpisode, overlappedEpisode);
                }
            } else {
                this.mergeCombatEpisode(incomingEpisode, overlappedEpisode);
            }
        }
    }

    private boolean isCEOverlapped(List episodes, Date fromDate, Date toDate) {
        boolean found = false;
        if (episodes != null && !episodes.isEmpty()) {
            for (CombatEpisode episode : episodes) {
                if (!this.isOverlapped(ImpreciseDateUtils.getDateWithDefault(episode.getStartDate()), ImpreciseDateUtils.getReconcilitationDateWithDefault(episode.getEndDate()), fromDate, toDate)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    private CombatEpisode checkCEUpdateOverlap(Set tempOnfileEpisodes, CombatEpisode overlappedEpisode, Date incomingEpisodeStartDate, Date incomingEpisodeEndDate) {
        CombatEpisode tempOnfileOverlap = null;
        tempOnfileEpisodes.remove((Object)overlappedEpisode);
        tempOnfileOverlap = this.getOverlappedCE(tempOnfileEpisodes, incomingEpisodeStartDate, incomingEpisodeEndDate);
        return tempOnfileOverlap;
    }

    private void mergeCombatEpisode(CombatEpisode incomingEpisode, CombatEpisode overlappedEpisode) throws ServiceException {
        this.getMergeRuleService().mergeCombatEpisode(incomingEpisode, overlappedEpisode);
        overlappedEpisode.setOEFOIFStationNumber(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
    }

    @Override
    public boolean getServiceIndicator() throws ServiceException {
        return super.getSystemParameterService().getMSDSServiceIndicator();
    }

    @Override
    public void createHECFromIncoming() throws ServiceException {
        Set incomingSiteRecords;
        MilitaryService incomingMilitaryService;
        Person onFile = this.getResultPerson();
        MilitaryService currentMilitaryService = onFile.getMilitaryService();
        if (currentMilitaryService == null) {
            currentMilitaryService = new MilitaryService();
            onFile.setMilitaryService(currentMilitaryService);
        }
        if ((incomingMilitaryService = this.getMilitaryServiceInputData().getMilitaryService()) != null && !(incomingSiteRecords = incomingMilitaryService.getMilitaryServiceSiteRecords()).isEmpty()) {
            for (MilitaryServiceSiteRecord incomingSiteRecord : incomingSiteRecords) {
                MilitaryServiceSiteRecord hecSiteRecord;
                if (incomingSiteRecord == null || (hecSiteRecord = currentMilitaryService.getHECMilitaryServiceSiteRecord()) != null) continue;
                hecSiteRecord = new MilitaryServiceSiteRecord();
                this.getMergeRuleService().mergeIncomingMSEToHEC(incomingSiteRecord, hecSiteRecord);
                hecSiteRecord.setSite(this.getLookupService().getVaFacilityByCode(VAFacility.CODE_HEC.getName()));
                currentMilitaryService.addMilitaryServiceSiteRecord(hecSiteRecord);
            }
        }
    }

    @Override
    public boolean isHecTransfer() {
        return this.getMilitaryServiceInputData().isTransferToHec();
    }

    @Override
    public boolean hasMatchingImpreciseDate() throws ServiceException {
        MilitaryServiceEpisode mse = this.getMSEFromMSDS();
        Set mses = this.getHECMSEs(this.getResultPerson().getMilitaryService());
        this.setMatchedMSE(null);
        if (mse != null && mse.getStartDate() != null && mse.getEndDate() != null && mses != null && !mses.isEmpty()) {
            for (MilitaryServiceEpisode hecmse : mses) {
                if (!hecmse.getStartDate().isImprecise() && !hecmse.getEndDate().isImprecise() || !this.impreciseDateMatch(hecmse.getStartDate(), hecmse.getEndDate(), mse)) continue;
                this.setMatchedMSE(hecmse);
                return true;
            }
        }
        return false;
    }

    private boolean impreciseDateMatch(ImpreciseDate hecStartDate, ImpreciseDate hecEndDate, MilitaryServiceEpisode incomingMSE) {
        if (hecStartDate.isImprecise()) {
            return this.impreciseMatchCheck(hecStartDate, incomingMSE.getStartDate());
        }
        if (hecEndDate.isImprecise()) {
            return this.impreciseMatchCheck(hecEndDate, incomingMSE.getEndDate());
        }
        return false;
    }

    private boolean impreciseMatchCheck(ImpreciseDate hecDate, ImpreciseDate incomingDate) {
        return !hecDate.isDayPrecise() && !hecDate.isMonthPrecise() ? hecDate.getYear().equals(incomingDate.getYear()) : !hecDate.isDayPrecise() && hecDate.getYear().equals(incomingDate.getYear()) && hecDate.getMonth().equals(incomingDate.getMonth());
    }

    @Override
    public void acceptPreciseServiceEpisodeFromMSDS() throws ServiceException {
        MilitaryServiceEpisode mse = this.getMatchedMSE();
        MilitaryServiceEpisode incomingMse = this.getMSEFromMSDS();
        if (mse != null && incomingMse != null) {
            this.getMergeRuleService().mergeMilitaryServiceEpisode(incomingMse, mse);
        }
    }

    @Override
    public boolean hasImpreciseData() {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            return ((MilitaryServiceInputData)this.getRuleDataAware()).isImpreciseData();
        }
        return false;
    }

    @Override
    public void setImpreciseData(boolean isImprecise) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setImpreciseDateDetected(isImprecise);
        }
    }

    @Override
    public boolean isDischargeDueToDisabilityChanged() {
        Boolean incomingDisability = this.getDischargeDueToDisability();
        Boolean PristineDisability = this.getDischargeDueToDisability(this.getPristinePerson());
        if (incomingDisability != null && PristineDisability != null) {
            return !this.isEqual(incomingDisability, PristineDisability);
        }
        if (incomingDisability == null && PristineDisability == null) {
            return false;
        }
        return incomingDisability == null && PristineDisability != null && PristineDisability != false || incomingDisability != null && PristineDisability == null && incomingDisability != false;
    }

    public CombatEpisode getMatchedCombatEpisode() {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        return data != null ? data.getMatchedCombatEpisode() : null;
    }

    public void setMatchedCombatEpisode(CombatEpisode matchedCombatEpisode) {
        MilitaryServiceInputData data = this.getMilitaryServiceInputData();
        if (data != null) {
            data.setMatchedCombatEpisode(matchedCombatEpisode);
        }
    }

    @Override
    public boolean isResultCLVeligible() {
        return this.calculateCLVeligibilitybyMSE(this.getResultPerson());
    }

    @Override
    public boolean isResultCLVeligibleForNoHEC() {
        return this.calculateCLVeligibilitybyMSEForNoHEC(this.getResultPerson());
    }

    @Override
    public boolean isResultVeteran() {
        return this.getResultPerson() != null && this.getResultPerson().isVeteran() != false;
    }

    @Override
    public boolean isResultCLVeligibleForNoHECNoVeteran() {
        return this.calculateCLVeligibilitybyMSEForNoHECNoVeteran(this.getResultPerson());
    }

    @Override
    public boolean isResultCLVeligibleNoVeteran() {
        return this.calculateCLVeligibilitybyMSENoVeteran(this.getResultPerson());
    }

    @Override
    public boolean isPristineCLVeligibile() {
        return this.calculateCLVeligibilitybyMSE(this.getPristinePerson());
    }

    @Override
    public boolean isIncomingCLVeligibile() {
        return this.calculateCLVeligibilitybyMSE(this.getIncomingPerson());
    }

    @Override
    public boolean isCLVEligibleSamePOn() {
        return this.isResultCLVeligible() == this.isPristineCLVeligibile();
    }

    @Override
    public boolean isCLVEligibleNoToYesPOn() {
        if (!this.isPristineCLVeligibile() && this.isResultCLVeligible()) {
            return true;
        }
        return this.isCLVEligibleSamePOn();
    }

    @Override
    public boolean calculateCLVeligibilitybyMSE(Person person) {
        long totalServiceDays = 0L;
        ImpreciseDate startday = new ImpreciseDate("19530801");
        ImpreciseDate endday = new ImpreciseDate("19871231");
        Set mssrs = person.getMilitaryService().getMilitaryServiceSiteRecords();
        VAFacility site = null;
        for (MilitaryServiceSiteRecord mssr : mssrs) {
            site = mssr.getSite();
            if (site == null || !site.getStationNumber().equals(VAFacility.CODE_HEC.getName())) continue;
            Set mses = mssr.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : mses) {
                if (mse.getDischargeType() == null || mse.getDischargeType().getCode().equals(DischargeType.CODE_BAD_CONDUCT.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_OTHER_THAN_HONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE_VA.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_UNDESIRABLE.getCode()) || !person.isVeteran().booleanValue()) continue;
                if ((CommonDateUtils.isDateAfter(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), startday) || startday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, endday).longValue();
                    continue;
                }
                if (!CommonDateUtils.isDateBefore(mse.getStartDate(), endday) && !endday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getStartDate(), startday) && !startday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getEndDate(), endday) && !endday.equals((Object)mse.getEndDate())) continue;
                totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), endday).longValue();
            }
        }
        return totalServiceDays >= 30L;
    }

    public boolean calculateCLVeligibilitybyMSEForNoHEC(Person person) {
        long totalServiceDays = 0L;
        ImpreciseDate startday = new ImpreciseDate("19530801");
        ImpreciseDate endday = new ImpreciseDate("19871231");
        Set mssrs = person.getMilitaryService().getMilitaryServiceSiteRecords();
        VAFacility site = null;
        for (MilitaryServiceSiteRecord mssr : mssrs) {
            site = mssr.getSite();
            if (site == null || site.getStationNumber().equals(VAFacility.CODE_HEC.getName())) continue;
            Set mses = mssr.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : mses) {
                if (mse.getDischargeType() == null || mse.getDischargeType().getCode().equals(DischargeType.CODE_BAD_CONDUCT.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_OTHER_THAN_HONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE_VA.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_UNDESIRABLE.getCode()) || !person.isVeteran().booleanValue()) continue;
                if ((CommonDateUtils.isDateAfter(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), startday) || startday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, endday).longValue();
                    continue;
                }
                if (!CommonDateUtils.isDateBefore(mse.getStartDate(), endday) && !endday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getStartDate(), startday) && !startday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getEndDate(), endday) && !endday.equals((Object)mse.getEndDate())) continue;
                totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), endday).longValue();
            }
        }
        return totalServiceDays >= 30L;
    }

    @Override
    public boolean calculateCLVeligibilitybyMSENoVeteran(Person person) {
        long totalServiceDays = 0L;
        ImpreciseDate startday = new ImpreciseDate("19530801");
        ImpreciseDate endday = new ImpreciseDate("19871231");
        Set mssrs = person.getMilitaryService().getMilitaryServiceSiteRecords();
        VAFacility site = null;
        for (MilitaryServiceSiteRecord mssr : mssrs) {
            site = mssr.getSite();
            if (site == null || !site.getStationNumber().equals(VAFacility.CODE_HEC.getName())) continue;
            Set mses = mssr.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : mses) {
                if (mse.getDischargeType() == null || mse.getDischargeType().getCode().equals(DischargeType.CODE_BAD_CONDUCT.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_OTHER_THAN_HONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE_VA.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_UNDESIRABLE.getCode())) continue;
                if ((CommonDateUtils.isDateAfter(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), startday) || startday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, endday).longValue();
                    continue;
                }
                if (!CommonDateUtils.isDateBefore(mse.getStartDate(), endday) && !endday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getStartDate(), startday) && !startday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getEndDate(), endday) && !endday.equals((Object)mse.getEndDate())) continue;
                totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), endday).longValue();
            }
        }
        return totalServiceDays >= 30L;
    }

    public boolean calculateCLVeligibilitybyMSEForNoHECNoVeteran(Person person) {
        long totalServiceDays = 0L;
        ImpreciseDate startday = new ImpreciseDate("19530801");
        ImpreciseDate endday = new ImpreciseDate("19871231");
        Set mssrs = person.getMilitaryService().getMilitaryServiceSiteRecords();
        VAFacility site = null;
        for (MilitaryServiceSiteRecord mssr : mssrs) {
            site = mssr.getSite();
            if (site == null || site.getStationNumber().equals(VAFacility.CODE_HEC.getName())) continue;
            Set mses = mssr.getMilitaryServiceEpisodes();
            for (MilitaryServiceEpisode mse : mses) {
                if (mse.getDischargeType() == null || mse.getDischargeType().getCode().equals(DischargeType.CODE_BAD_CONDUCT.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_OTHER_THAN_HONORABLE.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_DISHONORABLE_VA.getCode()) || mse.getDischargeType().getCode().equals(DischargeType.CODE_UNDESIRABLE.getCode())) continue;
                if ((CommonDateUtils.isDateAfter(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), startday) || startday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate())) && (CommonDateUtils.isDateBefore(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, mse.getEndDate()).longValue();
                    continue;
                }
                if ((CommonDateUtils.isDateAfter(mse.getEndDate(), endday) || endday.equals((Object)mse.getEndDate())) && (CommonDateUtils.isDateBefore(mse.getStartDate(), startday) || startday.equals((Object)mse.getStartDate()))) {
                    totalServiceDays += CommonDateUtils.getDays(startday, endday).longValue();
                    continue;
                }
                if (!CommonDateUtils.isDateBefore(mse.getStartDate(), endday) && !endday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getStartDate(), startday) && !startday.equals((Object)mse.getStartDate()) || !CommonDateUtils.isDateAfter(mse.getEndDate(), endday) && !endday.equals((Object)mse.getEndDate())) continue;
                totalServiceDays += CommonDateUtils.getDays(mse.getStartDate(), endday).longValue();
            }
        }
        return totalServiceDays >= 30L;
    }

    private class NonBreakingEpisodesInfo {
        private int count = 0;
        private MilitaryServiceEpisode firstMSE = null;
        private MilitaryServiceEpisode lastMSE = null;
        private boolean meets24MonthCriteria = false;

        private NonBreakingEpisodesInfo() {
        }

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public MilitaryServiceEpisode getFirstMSE() {
            return this.firstMSE;
        }

        public void setFirstMSE(MilitaryServiceEpisode firstMSE) {
            this.firstMSE = firstMSE;
        }

        public MilitaryServiceEpisode getLastMSE() {
            return this.lastMSE;
        }

        public void setLastMSE(MilitaryServiceEpisode lastMSE) {
            this.lastMSE = lastMSE;
        }

        public boolean meets24MonthCriteria() {
            return this.meets24MonthCriteria;
        }

        public void setMeets24MonthCriteria(boolean meets24MonthCriteria) {
            this.meets24MonthCriteria = meets24MonthCriteria;
        }
    }
}

