/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.IneligibleInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;

public class IneligibleInputParameter
extends BaseParameter
implements IneligibleInput {
    private static final long serialVersionUID = -1069379818694573999L;
    private Date ineligibilityDate = null;
    private String ineligibilityReason = null;

    @Override
    public Date getIneligibilityDate() throws RuleException {
        if (this.ineligibilityDate == null) {
            this.ineligibilityDate = this.getIneligibilityDate(this.getIncomingPerson());
        }
        return this.ineligibilityDate;
    }

    @Override
    public Date getIneligibilityDate(Person person) throws RuleException {
        IneligibilityFactor ief = this.getIneligibilityFactor(person);
        return ief != null ? ief.getIneligibleDate() : null;
    }

    @Override
    public IneligibilityFactor getIneligibilityFactor() throws RuleException {
        return this.getIneligibilityFactor(this.getIncomingPerson());
    }

    @Override
    public IneligibilityFactor getIneligibilityFactor(Person person) throws RuleException {
        return person != null ? person.getIneligibilityFactor() : null;
    }

    @Override
    public String getIneligibilityReason() throws RuleException {
        if (this.ineligibilityReason == null) {
            this.ineligibilityReason = this.getIneligibilityReason(this.getIncomingPerson());
        }
        return this.ineligibilityReason;
    }

    @Override
    public String getIneligibilityReason(Person person) throws RuleException {
        IneligibilityFactor ief = this.getIneligibilityFactor(person);
        return ief != null ? ief.getReason() : null;
    }

    @Override
    public boolean isUpdateFromSiteViaZ07() throws RuleException {
        IneligibilityFactor ineligibilityFactor = this.getIneligibilityFactor(this.getIncomingPerson());
        return ineligibilityFactor != null && ineligibilityFactor.getFacilityReceived() != null && !ineligibilityFactor.getFacilityReceived().getStationNumber().equals(VAFacility.CODE_HEC.getName());
    }

    @Override
    public void updateIneligibility() throws RuleException {
        this.setIneligible(this.getIneligibilityFactor(this.getIncomingPerson()));
    }

    @Override
    public void removeIneligibility() {
        if (this.getResultPerson().getIneligibilityFactor() != null) {
            this.getResultPerson().setIneligibilityFactor(null);
        }
    }

    @Override
    public String getIneligibleDateReceivedFrom() throws RuleException {
        IneligibilityFactor ineligibilityFactor = this.getIneligibilityFactor(this.getIncomingPerson());
        String stationNumber = ineligibilityFactor != null && ineligibilityFactor.getFacilityReceived() != null ? ineligibilityFactor.getFacilityReceived().getStationNumber() : null;
        return stationNumber;
    }

    @Override
    public boolean isIneligibleDateUpdatedByVAMC() throws RuleException {
        String stationNumber;
        IneligibilityFactor ineligibilityFactor = this.getIneligibilityFactor(this.getIncomingPerson());
        String string = stationNumber = ineligibilityFactor != null && ineligibilityFactor.getFacilityReceived() != null ? ineligibilityFactor.getFacilityReceived().getStationNumber() : null;
        return stationNumber != null ? !stationNumber.equals(VAFacility.CODE_HEC.getName()) : false;
    }

    @Override
    public void setIneligible(IneligibilityFactor incoming) throws RuleException {
        block2: {
            try {
                this.getMergeRuleService().mergeIneligibilityFactor(incoming, this.getResultPerson());
            }
            catch (ServiceException e) {
                if (!this.logger.isDebugEnabled()) break block2;
                this.logger.debug((Object)"Failed to copy ineligibility factor", (Throwable)e);
            }
        }
    }

    @Override
    public void setIneligibilityDate(Date date) throws RuleException {
        IneligibilityFactor ief = this.getIneligibilityFactor(this.getResultPerson());
        if (ief == null) {
            ief = new IneligibilityFactor();
            this.getResultPerson().setIneligibilityFactor(ief);
        }
        ief.setIneligibleDate(date);
    }

    @Override
    public void setIneligibilityReason(String reason) throws RuleException {
        IneligibilityFactor ief = this.getIneligibilityFactor(this.getResultPerson());
        if (ief == null) {
            ief = new IneligibilityFactor();
            this.getResultPerson().setIneligibilityFactor(ief);
        }
        ief.setReason(reason);
    }

    @Override
    public String getIneligibilityVARODecision() throws RuleException {
        return this.getIneligibilityVARODecision(this.getIncomingPerson());
    }

    @Override
    public String getIneligibilityVARODecision(Person person) throws RuleException {
        IneligibilityFactor ief = this.getIneligibilityFactor(person);
        return ief != null ? ief.getVaroDecision() : null;
    }

    @Override
    public void setIneligibilityVARODecision(String decision) throws RuleException {
        IneligibilityFactor ief = this.getIneligibilityFactor(this.getResultPerson());
        if (ief == null) {
            ief = new IneligibilityFactor();
            this.getResultPerson().setIneligibilityFactor(ief);
        }
        ief.setVaroDecision(decision);
    }
}

