/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.DependentFinancials;
import gov.va.med.esr.common.model.financials.Expense;
import gov.va.med.esr.common.model.financials.FinancialInformation;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.GMTThreshold;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.InProcessFinancialInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.financials.IncomeThreshold;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.financials.RelaxationPercentage;
import gov.va.med.esr.common.model.financials.SpouseFinancials;
import gov.va.med.esr.common.model.lookup.AssetType;
import gov.va.med.esr.common.model.lookup.ExpenseType;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.IncomeType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Dependent;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.Spouse;
import gov.va.med.esr.common.rule.FinancialInput;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.FinancialInputData;
import gov.va.med.esr.common.rule.parameter.AbstractFinancialInputParameter;
import gov.va.med.esr.common.ui.form.FinancialDetailsForm;
import gov.va.med.esr.common.util.CommonDateUtils;
import gov.va.med.esr.service.IVMFinancialInfo;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.conversion.ConversionService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.ObjectUtils;
import gov.va.med.fw.util.SerializationUtils;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.Validate;
import sun.misc.BASE64Encoder;

public class FinancialInputParameter
extends AbstractFinancialInputParameter
implements FinancialInput {
    private static final long serialVersionUID = 901893310343112107L;
    private static Integer YEAR_2008 = new Integer("2008");
    public static final String[] incompleteMTStatuses = new String[]{MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName(), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName(), MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName()};
    public static final String[] incompleteCopayTestStatuses = new String[]{MeansTestStatus.MT_STATUS_NON_EXEMPT.getName(), MeansTestStatus.MT_STATUS_EXEMPT.getName()};
    public static final String MESSAGING_SERVICE_BEAN_NAME = "messagingService";
    private MessagingService messagingSevice = null;
    private boolean isDataFromZ07 = false;
    private Boolean determinedPrimaryFlag = null;
    private Integer calculatedGMTThreshold = null;
    private Address calculatedGMTAddress = null;
    private Boolean meansTestPermitted = null;
    private Boolean subjectToMeansTest = null;
    private Boolean primaryCopayApplicable = null;
    private BigDecimal calculatedMTThreshold = null;
    private String calculatedMeansTestStatusCode = null;
    private String calculatedRxCopayStatusCode = null;
    private boolean financialStatementCopied = false;
    private boolean incomeTestCopied = false;
    private BigDecimal calculatedNetworthThreshold = null;
    private IncomeThreshold incomeThresholdForComms = null;
    private IncomeTest priorIncomeTest = null;
    private IncomeTest conversionBaseTest = null;
    private ConversionService conversionService;

    protected boolean isIncomeYearLaterThan2008() {
        Integer incomeYear = this.getIncomingIncomeYear();
        return CommonDateUtils.isIncomeYear2009OrLatter(incomeYear);
    }

    @Override
    public Integer getCurrentIncomeTestYear(Person person) throws ServiceException {
        return this.getCurrentIncomeTest() != null ? this.getCurrentIncomeTest().getIncomeYear() : null;
    }

    @Override
    public float getRelaxPercentage(Integer incomeYear) throws ServiceException {
        Validate.notNull((Object)incomeYear, (String)"incomeYear cannot be null");
        RelaxationPercentage relaxationPercentage = this.getRelaxationPercentageService().getRelaxationPercentageByIncomeYear(incomeYear);
        return relaxationPercentage.getValue().floatValue();
    }

    @Override
    public float getRelaxPercentage() throws ServiceException {
        return this.getRelaxPercentage(this.getIncomingIncomeYear());
    }

    @Override
    public IncomeTest getCurrentIncomeTest() throws ServiceException {
        return this.getCurrentIncomeTest(this.getPristinePerson());
    }

    @Override
    public IncomeTest getCurrentIncomeTest(Person person) throws ServiceException {
        return this.getHelperService().getCurrentIncomeTest(person);
    }

    @Override
    public IncomeTest getCurrentIncomeTestForEE(Person person) throws ServiceException {
        return this.getHelperService().getCurrentIncomeTestForEE(person);
    }

    @Override
    public IncomeTest getMostRecentIncomeTest() throws ServiceException {
        return this.getCurrentIncomeTest();
    }

    @Override
    public BigDecimal getAssetAmount(AssetType.Code assetType) {
        BigDecimal amount = this.getAssetAmount(this.getIncomingFinancialStatement(), assetType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getIncomeAmount(IncomeType.Code incomeType) {
        BigDecimal amount = this.getIncomeAmount(this.getIncomingFinancialStatement(), incomeType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public BigDecimal getTotalIncomeAmount(IncomeType.Code incomeType) throws ServiceException {
        BigDecimal amount = this.getTotalIncome(this.getIncomingFinancialStatement(), incomeType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getExpenseAmount(ExpenseType.Code expenseType) {
        BigDecimal amount = this.getExpenseAmount(this.getIncomingFinancialStatement(), expenseType);
        return amount == null ? new BigDecimal(0.0) : amount;
    }

    @Override
    public BigDecimal getDebtAmount() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        return stmt != null && stmt.getDebt() != null ? stmt.getDebt().getAmount() : new BigDecimal(0.0);
    }

    @Override
    public boolean isIncomeInRange(double lower, double upper) {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null && stmt.getIncome() != null) {
            return this.isIncomeInRange(stmt.getIncome().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isExpenseInRange(double lower, double upper) {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null && stmt.getExpenses() != null) {
            return this.isExpenseInRange(stmt.getExpenses().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isAssetInRange(double lower, double upper) {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null && stmt.getAssets() != null) {
            return this.isAssetInRange(stmt.getAssets().values(), lower, upper);
        }
        return true;
    }

    @Override
    public boolean isDebtInRange(double lower, double upper) {
        return this.isInRange(this.getDebtAmount(), lower, upper);
    }

    @Override
    public void setIncomeTestType(String typeCode) throws UnknownLookupTypeException, UnknownLookupCodeException {
        this.setIncomeTestType(this.getResultIncomeTest(), typeCode);
    }

    @Override
    public void setIncomeTestType(IncomeTest test, String typeCode) throws UnknownLookupTypeException, UnknownLookupCodeException {
        IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(typeCode);
        test.setType(type);
    }

    @Override
    public void setSiteConductingTest(VAFacility facility) {
        this.getResultIncomeTest().setSiteConductingTest(facility);
    }

    private void setMeansTestStatus(IncomeTest incomeTest, String status) throws UnknownLookupTypeException, UnknownLookupCodeException {
        MeansTestStatus mtStatus = this.getLookupService().getMeansTestStatusByCode(status);
        IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getName());
        if (incomeTest != null && type != null && mtStatus != null) {
            incomeTest.setIncomeTestStatus(type, mtStatus);
        }
    }

    @Override
    public void setMeansTestStatus(String status) throws UnknownLookupTypeException, UnknownLookupCodeException {
        if (this.getRuleDataAware() instanceof EEInputData) {
            IncomeTest it = this.getHelperService().getCurrentIncomeTest(this.getResultPerson());
            this.setMeansTestStatus(it, status);
        } else {
            this.setMeansTestStatus(this.getOrCreateIncomeTest(), status);
        }
    }

    @Override
    public void setMeansTestStatus(String mtStatusCode, String determinedStatusCode) throws UnknownLookupTypeException, UnknownLookupCodeException {
        this.setMeansTestStatus(this.getResultIncomeTest(), mtStatusCode, determinedStatusCode);
    }

    @Override
    public void setMeansTestStatus(IncomeTest test, String mtStatusCode, String determinedStatusCode) throws UnknownLookupTypeException, UnknownLookupCodeException {
        IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getName());
        MeansTestStatus mtStatus = this.getLookupService().getMeansTestStatusByCode(mtStatusCode);
        MeansTestStatus determinedStatus = this.getLookupService().getMeansTestStatusByCode(determinedStatusCode);
        test.setIncomeTestStatus(type, mtStatus, determinedStatus);
    }

    @Override
    public void setPharmacyTestStatus(String status) throws UnknownLookupTypeException, UnknownLookupCodeException {
        MeansTestStatus mtStatus = this.getLookupService().getMeansTestStatusByCode(status);
        IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName());
        if (this.getRuleDataAware() instanceof EEInputData) {
            IncomeTest it = this.getHelperService().getCurrentIncomeTest(this.getResultPerson());
            if (it != null && type != null && mtStatus != null) {
                it.setIncomeTestStatus(type, mtStatus);
            }
        } else {
            this.getResultIncomeTest().setIncomeTestStatus(type, mtStatus);
        }
    }

    @Override
    public void setPharmacyTestStatus(String mtStatusCode, String determinedStatusCode) throws UnknownLookupTypeException, UnknownLookupCodeException {
        this.setPharmacyTestStatus(this.getResultIncomeTest(), mtStatusCode, determinedStatusCode);
    }

    @Override
    public void setPharmacyTestStatus(IncomeTest test, String mtStatusCode, String determinedStatusCode) throws UnknownLookupTypeException, UnknownLookupCodeException {
        IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName());
        MeansTestStatus mtStatus = this.getLookupService().getMeansTestStatusByCode(mtStatusCode);
        MeansTestStatus determinedStatus = this.getLookupService().getMeansTestStatusByCode(determinedStatusCode);
        test.setIncomeTestStatus(type, mtStatus, determinedStatus);
    }

    @Override
    public BigDecimal getCalculatedMTThreshold() throws ServiceException {
        if (this.calculatedMTThreshold == null) {
            IncomeTest test = this.getIncomingIncomeTest();
            this.calculatedMTThreshold = this.determineMTThreshold(test.getIncomeYear(), this.getCalculatedNumberOfDependents());
        }
        this.logger.debug((Object)this.calculatedMTThreshold);
        return this.calculatedMTThreshold;
    }

    private BigDecimal determineMTThreshold(Integer incomeYear, Integer dependentCount) throws ServiceException {
        BigDecimal mtThreshold = new BigDecimal(0);
        if (incomeYear == null) {
            return mtThreshold;
        }
        IncomeThreshold it = this.getLookupService().getIncomeThreshold(incomeYear);
        if (it != null && dependentCount != null) {
            int count = dependentCount;
            if (count == 0) {
                mtThreshold = this.getNotNull(it.getExemptAmount());
            } else if (count > 0) {
                mtThreshold = this.getNotNull(it.getDependent());
            }
            for (int i = 1; i < count; ++i) {
                mtThreshold = mtThreshold.add(this.getNotNull(it.getAddDependentThreshold()));
            }
        }
        return mtThreshold;
    }

    private BigDecimal determineNetworthThreshold(Integer incomeYear) throws ServiceException {
        BigDecimal propertyThreshold = new BigDecimal(0);
        if (incomeYear == null) {
            return propertyThreshold;
        }
        IncomeThreshold it = this.getLookupService().getIncomeThreshold(incomeYear);
        if (it != null) {
            propertyThreshold = this.getNotNull(it.getPropertyThreshold());
        }
        return propertyThreshold;
    }

    private void determineGMTInformation() throws ServiceException {
        if (this.isUpdateFromGUI() || this.isMessageFromVOA()) {
            this.manageGMTThreshold(this.getCalculatedNumberOfDependents());
        } else {
            this.processGMTThreshold(this.getIncomeTest().getTotalNumberOfDependents());
        }
    }

    private void processGMTThreshold(Integer totalNumberOfDependents) throws ServiceException {
        Integer incomeTestGMTThreshold = this.getGMTThreshold(this.getIncomingIncomeTest());
        if (incomeTestGMTThreshold != null) {
            this.calculatedGMTThreshold = incomeTestGMTThreshold;
        }
        if (this.calculatedGMTAddress == null) {
            Address pristineGmtAddress = this.getGMTAddress(this.getPristineIncomeTest());
            this.calculatedGMTAddress = pristineGmtAddress != null ? pristineGmtAddress : this.processGMTAddress(totalNumberOfDependents, incomeTestGMTThreshold);
        }
    }

    private Address processGMTAddress(Integer totalNumberOfDependents, Integer incomeTestGMTThreshold) throws ServiceException {
        Address permAddress = this.getIncomingPerson().getPermanentAddress();
        Integer newGMTThreshold = this.calculateGMTThresholdAmount(permAddress, totalNumberOfDependents);
        if (this.isEqual(incomeTestGMTThreshold, newGMTThreshold)) {
            if (permAddress != null) {
                Address gmtAddress = new Address();
                gmtAddress.setLine1(permAddress.getLine1());
                gmtAddress.setLine2(permAddress.getLine2());
                gmtAddress.setLine3(permAddress.getLine3());
                gmtAddress.setCity(permAddress.getCity());
                gmtAddress.setState(permAddress.getState());
                gmtAddress.setZipCode(permAddress.getZipCode());
                return gmtAddress;
            }
        } else {
            VAFacility.VAFacilityAddress sendingFacilityAddr = this.getSourceFacility().getStreetAddress();
            if (sendingFacilityAddr != null) {
                Address gmtAddress = new Address();
                gmtAddress.setLine1(sendingFacilityAddr.getLine1());
                gmtAddress.setLine2(sendingFacilityAddr.getLine2());
                gmtAddress.setLine3(sendingFacilityAddr.getLine3());
                gmtAddress.setCity(sendingFacilityAddr.getCity());
                gmtAddress.setState(sendingFacilityAddr.getState() == null ? null : sendingFacilityAddr.getState().getCode());
                gmtAddress.setZipCode(sendingFacilityAddr.getZipCode());
                return gmtAddress;
            }
        }
        return null;
    }

    @Override
    public void setGMTAddress(Address address) {
        this.getResultIncomeTest().setGmtAddress(address);
    }

    @Override
    public Address getGMTAddress(IncomeTest test) {
        if (test == null) {
            return null;
        }
        return test.getGmtAddress();
    }

    @Override
    public Integer getCalculatedGMTThreshold() throws ServiceException {
        if (this.calculatedGMTThreshold == null) {
            this.determineGMTInformation();
        }
        this.logger.debug((Object)this.calculatedGMTThreshold);
        return this.calculatedGMTThreshold;
    }

    @Override
    public BigDecimal getCalculatedGMTThresholdAsBigDecimal() throws ServiceException {
        Integer gmtThreshold = this.getCalculatedGMTThreshold();
        BigDecimal gmtThresBD = null;
        if (gmtThreshold != null) {
            gmtThresBD = new BigDecimal(gmtThreshold.doubleValue());
        }
        return gmtThresBD;
    }

    @Override
    public Address getCalculatedGMTAddress() throws ServiceException {
        if (this.calculatedGMTAddress == null) {
            this.determineGMTInformation();
        }
        return this.calculatedGMTAddress;
    }

    @Override
    public void setGMTThreshold(Integer threshold) {
        BigDecimal th = threshold != null ? new BigDecimal(threshold) : null;
        this.getResultIncomeTest().setGmtThresholdAmount(th);
    }

    @Override
    public void setMTThreshold(BigDecimal threshold) {
        this.getResultIncomeTest().setThresholdA(threshold);
    }

    @Override
    public void saveInProcessInfo(Person person, Integer incomeYear) throws RuleException, ServiceException {
        this.getFinancialsService().validateFinancialsUpdate(incomeYear, this.getPristinePerson());
        FinancialDetailsForm detailsForm = new FinancialDetailsForm();
        detailsForm.setIncomeYear(incomeYear.toString());
        this.conversionService.convert((Object)person, (Object)detailsForm);
        Person resultPerson = this.getResultPerson();
        byte[] data = SerializationUtils.serialize((Serializable)detailsForm.getFinancialsData());
        InProcessFinancialInfo inProcessFinancial = resultPerson.getInProcessFinancial(incomeYear);
        if (inProcessFinancial == null) {
            inProcessFinancial = new InProcessFinancialInfo();
            inProcessFinancial.setIncomeYear(incomeYear);
            resultPerson.setInProcessFinancial(incomeYear, inProcessFinancial);
        }
        inProcessFinancial.setInProcessData(new BASE64Encoder().encode(data));
    }

    public Integer calculateGMTThresholdAmount(Address address, Integer totalNumberOfDependents) throws ServiceException {
        Integer thresholdAmount = null;
        if (address == null) {
            return thresholdAmount;
        }
        String zipCode = address.getZipCode();
        if (zipCode == null) {
            return thresholdAmount;
        }
        String fipsCode = null;
        try {
            fipsCode = this.getLookupService().getFipsCode(zipCode);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (fipsCode == null) {
            return thresholdAmount;
        }
        String msaCode = null;
        try {
            msaCode = this.getLookupService().getMsaCode(zipCode);
            if (msaCode != null && msaCode.equals("0")) {
                msaCode = "9999";
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        Integer incomeYear = this.getIncomingIncomeYear();
        List gmtThresholds = null;
        gmtThresholds = StringUtils.isEmpty((String)msaCode) ? this.getLookupService().getGMTThreshold(incomeYear, fipsCode) : this.getLookupService().getGMTThreshold(incomeYear, fipsCode, msaCode);
        if (gmtThresholds != null && gmtThresholds.size() > 0) {
            GMTThreshold gmtThreshold = (GMTThreshold)((Object)gmtThresholds.get(0));
            int dependents = totalNumberOfDependents == null ? 0 : totalNumberOfDependents;
            return this.calculateThresholdAmount(gmtThreshold, dependents);
        }
        return thresholdAmount;
    }

    private void manageGMTThreshold(Integer totalNumberOfDependents) throws ServiceException {
        Address siteAddress;
        IncomeTest test = this.getResultIncomeTest();
        if (test != null && test.getGmtAddress() != null) {
            this.calculatedGMTAddress = test.getGmtAddress();
            this.calculatedGMTThreshold = this.getGMTThreshold(test);
            return;
        }
        Address permAddress = this.getIncomingPerson().getPermanentAddress();
        this.calculatedGMTThreshold = this.calculateGMTThresholdAmount(permAddress, totalNumberOfDependents);
        if (this.calculatedGMTThreshold != null && this.calculatedGMTThreshold > 0) {
            this.calculatedGMTAddress = permAddress;
            return;
        }
        IncomeTest mostRecentTest = this.getCurrentIncomeTest();
        if (mostRecentTest != null && IncomeTestType.CODE_MEANS_TEST.getName().equals(this.getIncomeTestTypeCode(mostRecentTest)) && mostRecentTest.getSource() != null && IncomeTestSource.CODE_VAMC.getCode().equals(mostRecentTest.getSource().getCode()) && this.isNoOfDaysBetweenDates(mostRecentTest.getEffectiveDate(), this.getCurrentDate(), 365)) {
            siteAddress = this.getFacilityAddress(mostRecentTest.getSiteConductingTest());
            this.calculatedGMTThreshold = this.calculateGMTThresholdAmount(siteAddress, totalNumberOfDependents);
            if (this.calculatedGMTThreshold != null && this.calculatedGMTThreshold > 0) {
                this.calculatedGMTAddress = siteAddress;
                return;
            }
        }
        siteAddress = this.getFacilityAddress(this.getRecentMsgTransmittedFacility());
        this.calculatedGMTThreshold = this.calculateGMTThresholdAmount(siteAddress, totalNumberOfDependents);
        if (this.calculatedGMTThreshold != null && this.calculatedGMTThreshold > 0) {
            this.calculatedGMTAddress = siteAddress;
            return;
        }
    }

    private boolean isNoOfDaysBetweenDates(Date date1, Date date2, int noOfDays) {
        GregorianCalendar newDate1 = null;
        if (date1 != null) {
            newDate1 = new GregorianCalendar();
            newDate1.setTime(date1);
            newDate1.add(5, noOfDays);
        }
        return newDate1 != null && newDate1.getTime().getTime() > date2.getTime();
    }

    private Integer calculateThresholdAmount(GMTThreshold gmtThreshold, int totalDependents) {
        BigDecimal totalAmount = null;
        if (totalDependents > 7) {
            BigDecimal amountFor4 = gmtThreshold.getThresholdValue(3);
            BigDecimal amountFor8 = gmtThreshold.getThresholdValue(7);
            double excessAmount = (double)(totalDependents - 7) * amountFor4.doubleValue() * 0.08;
            totalAmount = amountFor8.add(new BigDecimal(excessAmount));
        } else {
            totalAmount = gmtThreshold.getThresholdValue(totalDependents);
        }
        double thresholdAmount = totalAmount.doubleValue();
        int lowerTotalAmont = (int)thresholdAmount / 50 * 50;
        return new Integer(thresholdAmount - (double)lowerTotalAmont > 0.0 ? lowerTotalAmont + 50 : lowerTotalAmont);
    }

    @Override
    public void setNumberOfDependentChildren(Integer numberOfDependentChildren) {
        FinancialStatement resultStmt = this.getResultFinancialStatement();
        resultStmt.setNumberOfDependentChildren(numberOfDependentChildren);
    }

    @Override
    public void setNumberOfDependents(Integer totalNumberOfDependents) {
        IncomeTest resultTest = this.getResultIncomeTest();
        resultTest.setTotalNumberOfDependents(totalNumberOfDependents);
    }

    @Override
    public void setValidDependent(FinancialStatement stmt) {
        if (stmt == null) {
            return;
        }
        Set dfSet = stmt.getDependentFinancials();
        for (DependentFinancials df : dfSet) {
            if (this.isDependentValidDependent(df)) {
                df.setValidDependent(Boolean.TRUE);
                continue;
            }
            df.setValidDependent(Boolean.FALSE);
        }
        for (SpouseFinancials sf : stmt.getSpouseFinancials()) {
            if (this.isSpouseValidDependent(sf)) {
                sf.setValidDependent(Boolean.TRUE);
                continue;
            }
            sf.setValidDependent(Boolean.FALSE);
        }
    }

    @Override
    public void setNetworth(BigDecimal networth) {
        this.getResultIncomeTest().setNetWorth(networth);
    }

    @Override
    public void setTotalIncome(BigDecimal income) throws ServiceException {
        this.getResultIncomeTest().setTotalIncome(income);
    }

    @Override
    public void setNetIncome(BigDecimal income) throws ServiceException {
        this.getResultIncomeTest().setNetIncome(income);
    }

    @Override
    public void setPensionThreshold(BigDecimal threshold) {
        this.getResultIncomeTest().setPensionThreshold(threshold);
    }

    @Override
    public BigDecimal getCalculatedNetworthThreshold() throws ServiceException {
        if (this.calculatedNetworthThreshold == null) {
            this.calculatedNetworthThreshold = this.determineNetworthThreshold(this.getIncomingIncomeYear());
        }
        return this.calculatedNetworthThreshold;
    }

    @Override
    public void setNetworthThreshold(BigDecimal threshold) {
        this.getResultIncomeTest().setNetworthThreshold(threshold);
    }

    @Override
    public void setIncomeExclusionThreshold(BigDecimal threshold) {
        this.getResultIncomeTest().setChildIncomeExclusionThreshold(threshold);
    }

    @Override
    public void setDeductibleExpense(BigDecimal expense) {
        this.getResultIncomeTest().setDeductibleExpenses(expense);
    }

    @Override
    public void setAdjustableMedicalExpense(BigDecimal expense) {
        this.setExpenseAmount((FinancialInformation)this.getResultFinancialStatement(), ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL, expense);
    }

    @Override
    public void setNonReimbursedMedicalExpense(BigDecimal expense) {
        this.setExpenseAmount((FinancialInformation)this.getResultFinancialStatement(), ExpenseType.EXPENSE_TYPE_NON_REIMBURSED_MEDICAL, expense);
    }

    @Override
    public void deletePrimaryIncomeTest() {
        this.getResultPerson().setIncomeTest(this.getIncomingIncomeYear(), null);
    }

    @Override
    public boolean isIncomeTestDeleted() {
        return this.getIncomingIncomeTest() == null && this.getPristineIncomeTest() != null;
    }

    @Override
    public Date getLastEditDate(IncomeTest test) {
        return test == null ? null : test.getLastEditedDate();
    }

    @Override
    public Date getIncomeTestLastEditedDate() {
        return this.getLastEditDate(this.getIncomeTest());
    }

    @Override
    public Date getPristineIncomeTestLastEditedDate() {
        return this.getLastEditDate(this.getPristineIncomeTest());
    }

    @Override
    public void setLastEditDate(Date date) {
        if (this.getRuleDataAware() instanceof EEInputData) {
            IncomeTest incomeTest = this.getHelperService().getCurrentIncomeTest(this.getResultPerson());
            if (incomeTest != null) {
                this.setLastEditDate(incomeTest, this.getCurrentDate());
            }
        } else {
            this.setLastEditDate(this.getOrCreateIncomeTest(), date);
        }
    }

    public void setLastEditDate(IncomeTest incomeTest, Date date) {
        incomeTest.setLastEditedDate(date);
    }

    @Override
    public Date getCompletedDate(IncomeTest test) {
        return test == null ? new Date() : test.getCompletedDate();
    }

    @Override
    public Date getCompletedDate() {
        return this.getCompletedDate(this.getIncomeTest());
    }

    @Override
    public void setCompletedDate(Date date) {
        this.setCompletedDate(this.getOrCreateIncomeTest(), date);
    }

    @Override
    public void setCompletedDate(IncomeTest incomeTest, Date date) {
        incomeTest.setCompletedDate(date);
    }

    @Override
    public Date determineCompletedDate() {
        IncomeTest onFile = this.getPristineIncomeTest();
        IncomeTest incoming = this.getIncomeTest();
        String onFileSiteCode = this.getSiteConductingTestFacilityCode(onFile);
        String incomingSiteCode = this.getSiteConductingTestFacilityCode(incoming);
        if (this.isPrimary(onFile) && this.isTestTypeMeansTest(onFile) && this.isTestTypeMeansTest(incoming) && StringUtils.equals((String)incomingSiteCode, (String)onFileSiteCode) && !this.isCADAdjusted(onFile)) {
            return this.getEarliest(onFile.getCompletedDate(), incoming.getCompletedDate());
        }
        String[] statuses = new String[]{MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName(), MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName()};
        if (this.isPrimary(onFile) && this.isTestTypeMeansTest(onFile) && StringUtils.contains((String[])statuses, (String)this.getDeterminedStatus(onFile)) && !this.isCADAdjusted(onFile) && StringUtils.contains((String[])statuses, (String)this.getDeterminedStatus(incoming)) && Boolean.TRUE.equals(this.getAgreeToPayIndicator(incoming))) {
            return this.getEarliest(onFile.getCompletedDate(), incoming.getCompletedDate());
        }
        if (this.isTestTypeMeansTest(incoming) && this.getDeterminedPrimaryFlag()) {
            return this.getCompletedDate(incoming);
        }
        if (this.isPrimary(onFile) && this.isTestTypePharmacyCopayTest(onFile) && this.isCADAdjusted(onFile) && this.getCompletedDate(incoming).after(this.getCompletedDate(onFile))) {
            return this.getCompletedDate(incoming);
        }
        if (this.isPrimary(onFile) && this.isTestTypePharmacyCopayTest(onFile) && !this.isCADAdjusted(onFile)) {
            return this.getCompletedDate(incoming);
        }
        if (this.isTestTypePharmacyCopayTest(incoming) && this.getDeterminedPrimaryFlag()) {
            return this.getCompletedDate(incoming);
        }
        return this.getCompletedDate(onFile);
    }

    @Override
    public Date getEffectiveTestDate() {
        return this.getEffectiveTestDate(this.getIncomingIncomeTest());
    }

    @Override
    public Date determineEffectiveDate() {
        IncomeTest onFile = this.getPristineIncomeTest();
        IncomeTest incoming = this.getIncomeTest();
        if (this.isPrimary(onFile) && !this.isIncomingTestDeterminedPrimary() && this.isEarlier(this.getEffectiveTestDate(incoming), this.getEffectiveTestDate(onFile))) {
            return this.getEffectiveTestDate(incoming);
        }
        return this.getEffectiveTestDate(onFile);
    }

    @Override
    public void setEffectiveTestDate(Date date) {
        Date testEffectiveDate = date;
        if (date != null) {
            Calendar calendar = DateUtils.createCalendar((Date)date);
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            calendar.clear();
            calendar.set(year, month, day);
            testEffectiveDate = calendar.getTime();
        }
        this.setEffectiveTestDate(this.getOrCreateIncomeTest(), testEffectiveDate);
    }

    public void setEffectiveTestDate(IncomeTest incomeTest, Date date) {
        incomeTest.setEffectiveDate(date);
        this.checkSetFutureTestFlag(incomeTest, date);
    }

    @Override
    public void setCADAdjusted(Boolean cadAdjusted) {
        this.getOrCreateIncomeTest().setCadAdjusted(cadAdjusted);
    }

    @Override
    public Boolean getCADAdjusted(IncomeTest test) {
        if (test == null) {
            return null;
        }
        return test.getCadAdjusted();
    }

    @Override
    public void setAgreeToPayIndicator(Boolean atpd) {
        this.getOrCreateIncomeTest().setAgreesToPayDeductible(atpd);
    }

    @Override
    public String getDisclosure() {
        Boolean disclosure = this.getDisclosure(this.getIncomeTest());
        if (disclosure != null) {
            return disclosure != false ? "Y" : "N";
        }
        return null;
    }

    @Override
    public void setDisclosure(Boolean disclosure) {
        this.getOrCreateIncomeTest().setDiscloseFinancialInformation(disclosure);
    }

    @Override
    public String getDeductibleStatus() {
        Boolean deductible = this.getAgreeToPayIndicator(this.getIncomeTest());
        if (deductible != null) {
            return deductible != false ? "Y" : "N";
        }
        return null;
    }

    @Override
    public Integer getGMTThreshold() {
        return this.getGMTThreshold(this.getIncomingIncomeTest());
    }

    @Override
    public Integer getMTThreshold() {
        return this.getMTThreshold(this.getIncomingIncomeTest());
    }

    @Override
    public String getMeansTestStatusCode() {
        return this.getMeansTestStatusCode(this.getIncomingIncomeTest());
    }

    @Override
    public String getPharmacyCopayStatusCode() {
        IncomeTest incomeTest = this.getIncomingIncomeTest();
        if (incomeTest != null) {
            return this.getPharmacyCopayStatusCode(this.getIncomingIncomeTest());
        }
        return null;
    }

    @Override
    public String getMeansTestStatusCode(IncomeTest incomeTest) {
        return this.getMeansTestStatusCode(incomeTest, IncomeTestType.CODE_MEANS_TEST);
    }

    @Override
    public String getPharmacyCopayStatusCode(IncomeTest incomeTest) {
        return this.getMeansTestStatusCode(incomeTest, IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
    }

    @Override
    public String getMeansTestDeterminedStatusCode(IncomeTest incomeTest) {
        return this.getDeterminedStatusCode(incomeTest, IncomeTestType.CODE_MEANS_TEST);
    }

    @Override
    public String getPharmacyCopayDeterminedStatusCode(IncomeTest incomeTest) {
        return this.getDeterminedStatusCode(incomeTest, IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
    }

    @Override
    public IncomeTest getIncomeTest() {
        return this.getIncomingIncomeTest();
    }

    @Override
    public IncomeTest getResultIncomeTest() {
        Integer incomeYear = this.getIncomingIncomeYear();
        return this.getResultPerson().getIncomeTest(incomeYear);
    }

    public FinancialStatement getResultFinancialStatement() {
        Integer incomeYear = this.getIncomingIncomeYear();
        return this.getResultPerson().getFinancialStatement(incomeYear);
    }

    public IncomeTestStatus getResultIncomeTestStatus() {
        return this.getOrCreateIncomeTestStatus();
    }

    protected IncomeTestStatus getOrCreateIncomeTestStatus() {
        IncomeTestStatus rStatus = this.getOrCreateIncomeTest().getIncomeTestStatus();
        if (rStatus == null) {
            rStatus = new IncomeTestStatus();
        }
        return rStatus;
    }

    @Override
    public String getSiteConductingTestFacilityCode(IncomeTest iTest) {
        VAFacility site = this.getSiteConductingTest(iTest);
        return site == null ? null : site.getCode();
    }

    @Override
    public VAFacility getSiteConductingTest(IncomeTest iTest) {
        if (iTest == null) {
            return null;
        }
        return iTest.getSiteConductingTest();
    }

    @Override
    public String getReceivingFacilityCode() {
        return this.getLookupCode((Lookup)this.getSourceFacility());
    }

    @Override
    public VAFacility getReceivingFacility() {
        return this.getSourceFacility();
    }

    @Override
    public BigDecimal getSpousalSupportAmount() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null) {
            return stmt.getContributionToSpouse();
        }
        return null;
    }

    @Override
    public Boolean hasMarriedLastCalendarYear() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null) {
            return stmt.getMarriedLastCalendarYear();
        }
        return null;
    }

    @Override
    public void setLivedWithPatient(Boolean flag) {
        SpouseFinancials sf;
        FinancialStatement fstmt = this.getResultFinancialStatement();
        if (fstmt != null && (sf = fstmt.getRecentSpouseFinancials()) != null) {
            sf.setLivedWithPatient(flag);
        }
    }

    public Boolean spouseLivesWithVeteran() {
        SpouseFinancials sf;
        FinancialStatement fstmt = this.getIncomingFinancialStatement();
        if (fstmt != null && (sf = fstmt.getRecentSpouseFinancials()) != null) {
            return sf.getLivedWithPatient();
        }
        return null;
    }

    @Override
    public void setIncomeTest(IncomeTest incomeTest) throws ServiceException {
        if (incomeTest == null) {
            this.getResultPerson().setIncomeTest(this.getIncomingIncomeYear(), null);
        } else {
            boolean isFuture;
            IncomeTest rsTest = this.getOrCreateIncomeTest();
            Date effDate = null;
            boolean bl = isFuture = rsTest.isFutureTest() != null ? rsTest.isFutureTest() : false;
            if (isFuture) {
                effDate = rsTest.getEffectiveDate();
            }
            this.getMergeRuleService().mergeIncomeTest(incomeTest, rsTest);
            if (isFuture) {
                rsTest.setEffectiveDate(effDate);
            }
            this.checkSetFutureTestFlag(rsTest, rsTest.getEffectiveDate());
            this.incomeTestCopied = true;
        }
    }

    @Override
    public void processIVMIncomeTest() throws ServiceException {
        IncomeTest incomingTest = this.getIncomeTest();
        String source = this.getIncomeTestSourceCode(incomingTest);
        if (IncomeTestSource.CODE_IVM.getCode().equals(source)) {
            IncomeTest resultTest = this.getOrCreateIncomeTest();
            Address gmtAddress = resultTest.getGmtAddress();
            this.getMergeRuleService().mergeFullIncomeTest(incomingTest, resultTest);
            resultTest.setGmtAddress(gmtAddress);
            this.checkSetFutureTestFlag(resultTest, resultTest.getEffectiveDate());
            resultTest.setPrimaryIncomeTest(Boolean.TRUE);
            this.incomeTestCopied = true;
        }
    }

    private void checkSetFutureTestFlag(IncomeTest test, Date effectiveDate) {
        if (effectiveDate != null) {
            if (this.isAfterIgnoreTime(effectiveDate, this.getCurrentDate())) {
                test.setFutureTest(Boolean.TRUE);
            } else {
                test.setFutureTest(Boolean.FALSE);
            }
        }
    }

    @Override
    public String getMTStatus() {
        return this.getMeansTestStatusCode(this.getIncomingIncomeTest(), IncomeTestType.CODE_MEANS_TEST);
    }

    @Override
    public String getIVMActionCode() {
        FinancialInputData data = this.getFinancialInputData();
        if (data != null && data.getIvmFinancialInfo() != null) {
            return data.getIvmFinancialInfo().getIvmActionCode();
        }
        return null;
    }

    @Override
    public boolean hasIVMTestOnFileForIncomingIY() throws ServiceException {
        Integer incomeYear = this.getIncomingIncomeYear();
        if (incomeYear == null) {
            return false;
        }
        IncomeTest onFile = this.getResultPerson().getIncomeTest(incomeYear);
        String source = this.getIncomeTestSourceCode(onFile);
        return IncomeTestSource.CODE_IVM.getCode().equals(source);
    }

    public IncomeTest getPreviousPrimaryTest(Integer conversionIncomeYear, Person person) throws ServiceException {
        if (conversionIncomeYear == null) {
            return null;
        }
        Map incomeTests = person.getIncomeTests();
        ArrayList incomeYears = new ArrayList(incomeTests.keySet());
        if (incomeYears == null || incomeYears.isEmpty()) {
            return null;
        }
        Collections.sort(incomeYears);
        for (int i = incomeYears.size() - 1; i >= 0; --i) {
            Integer incomeYear = (Integer)incomeYears.get(i);
            if (conversionIncomeYear.compareTo(incomeYear) <= 0) continue;
            IncomeTest incomeTest = (IncomeTest)((Object)incomeTests.get(incomeYear));
            boolean future = false;
            if (incomeTest.isFutureTest() != null) {
                future = incomeTest.isFutureTest();
            }
            if (future) continue;
            return incomeTest;
        }
        return null;
    }

    @Override
    public void createCloneIncomeTest() throws ServiceException {
        IncomeTest previousPrimaryTest = this.getPreviousPrimaryTest(this.getIncomingIncomeYear(), this.getResultPerson());
        if (previousPrimaryTest != null && this.getIncomingIncomeYear() != null) {
            FinancialStatement onfileFs;
            PatientVisitSummary resultVisitSummary;
            Person resultPerson = this.getResultPerson();
            Integer conversionIncomeYear = this.getIncomingIncomeYear();
            IncomeTest clonedTest = (IncomeTest)((Object)previousPrimaryTest.clone());
            clonedTest.setIncomeYear(conversionIncomeYear);
            IncomeTest conversion = new IncomeTest();
            this.getMergeRuleService().mergeFullIncomeTest(clonedTest, conversion);
            resultPerson.setIncomeTest(conversionIncomeYear, conversion);
            VAFacility facility = previousPrimaryTest.getSiteConductingTest();
            Integer currentIncomeYear = previousPrimaryTest.getIncomeYear();
            if (facility != null && currentIncomeYear != null && (resultVisitSummary = this.getResultPerson().getPatientVisitSummary(conversionIncomeYear, facility)) == null && (resultVisitSummary = resultPerson.getPatientVisitSummary(currentIncomeYear, facility)) != null) {
                PatientVisitSummary clonedPatientVisitSummary = new PatientVisitSummary();
                this.getMergeRuleService().mergePatientVisitSummary(resultVisitSummary, clonedPatientVisitSummary);
                clonedPatientVisitSummary.setIncomeYear(conversionIncomeYear);
                resultPerson.setPatientVisitSummary(conversionIncomeYear, facility, clonedPatientVisitSummary);
            }
            if ((onfileFs = resultPerson.getFinancialStatement(currentIncomeYear)) != null) {
                FinancialStatement clonedFs = (FinancialStatement)((Object)onfileFs.clone());
                clonedFs.setIncomeYear(conversionIncomeYear);
                FinancialStatement conversionFs = new FinancialStatement();
                this.getMergeRuleService().mergeFinancialStatement(clonedFs, conversionFs);
                resultPerson.setFinancialStatement(conversionIncomeYear, conversionFs);
            }
        } else {
            throw new ServiceException("Unable to clone a test for IVM conversion process: veteran has no income test");
        }
    }

    public void partialMergeIVMConversionData(IncomeTest ivmData, IncomeTest esrIncomeTest) throws ServiceException {
        String mtStatusCode;
        if (ivmData == null || esrIncomeTest == null) {
            return;
        }
        if (ivmData.getType() == null) {
            throw new ServiceException("IVM Conversion data does not contain Means Test Type for person id:" + esrIncomeTest.getPerson().getPersonEntityKey().getKeyValueAsString());
        }
        esrIncomeTest.setType(ivmData.getType());
        esrIncomeTest.setPrimaryIncomeTest(Boolean.TRUE);
        esrIncomeTest.setTotalNumberOfDependents(ivmData.getTotalNumberOfDependents());
        IncomeTestStatus mtIncomeTestStatusESR = esrIncomeTest.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST);
        IncomeTestStatus mtIncomeTestStatusIncoming = ivmData.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST);
        MeansTestStatus mtTestDeterminedStatus = mtIncomeTestStatusESR != null ? mtIncomeTestStatusESR.getDeterminedStatus() : null;
        IncomeTestStatus rxIncomeTestStatusESR = esrIncomeTest.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
        IncomeTestStatus rxIncomeTestStatusIncoming = ivmData.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
        MeansTestStatus rxTestDeterminedStatus = rxIncomeTestStatusESR != null ? rxIncomeTestStatusESR.getDeterminedStatus() : null;
        boolean mtStatusAlreadyMerged = false;
        boolean rxStatusAlreadyMerged = false;
        if (mtIncomeTestStatusESR == null && mtIncomeTestStatusIncoming != null) {
            mtIncomeTestStatusESR = new IncomeTestStatus();
            this.getMergeRuleService().mergeIncomeTestStatus(mtIncomeTestStatusIncoming, mtIncomeTestStatusESR);
            esrIncomeTest.addIncomeTestStatus(mtIncomeTestStatusESR);
            mtStatusAlreadyMerged = true;
        }
        if (rxIncomeTestStatusESR == null && rxIncomeTestStatusIncoming != null) {
            rxIncomeTestStatusESR = new IncomeTestStatus();
            this.getMergeRuleService().mergeIncomeTestStatus(rxIncomeTestStatusIncoming, rxIncomeTestStatusESR);
            esrIncomeTest.addIncomeTestStatus(rxIncomeTestStatusESR);
            rxStatusAlreadyMerged = true;
        }
        if (!mtStatusAlreadyMerged && mtIncomeTestStatusESR != null && mtIncomeTestStatusIncoming != null) {
            this.getMergeRuleService().mergeIncomeTestStatus(mtIncomeTestStatusIncoming, mtIncomeTestStatusESR);
        }
        if (!rxStatusAlreadyMerged && rxIncomeTestStatusESR != null && rxIncomeTestStatusIncoming != null) {
            this.getMergeRuleService().mergeIncomeTestStatus(rxIncomeTestStatusIncoming, rxIncomeTestStatusESR);
        }
        if (mtIncomeTestStatusIncoming != null || mtIncomeTestStatusESR != null) {
            // empty if block
        }
        if (rxIncomeTestStatusIncoming != null || rxIncomeTestStatusESR != null) {
            // empty if block
        }
        if (mtIncomeTestStatusESR != null && mtTestDeterminedStatus != null) {
            mtIncomeTestStatusESR.setDeterminedStatus(mtTestDeterminedStatus);
        }
        if (rxIncomeTestStatusESR != null && rxTestDeterminedStatus != null) {
            rxIncomeTestStatusESR.setDeterminedStatus(rxTestDeterminedStatus);
        }
        esrIncomeTest.setEffectiveDate(ivmData.getEffectiveDate());
        esrIncomeTest.setIVMTestCompletionDate(ivmData.getIVMTestCompletionDate());
        if (mtIncomeTestStatusESR != null && mtIncomeTestStatusIncoming != null && mtIncomeTestStatusIncoming.getCompletedDate() != null) {
            esrIncomeTest.setCompletedDate(mtIncomeTestStatusIncoming.getCompletedDate());
        } else if (rxIncomeTestStatusESR != null && rxIncomeTestStatusIncoming != null && rxIncomeTestStatusIncoming.getCompletedDate() != null) {
            esrIncomeTest.setCompletedDate(rxIncomeTestStatusIncoming.getCompletedDate());
        }
        esrIncomeTest.setIvmConversionDate(ivmData.getIvmConversionDate());
        esrIncomeTest.setSource(ivmData.getSource());
        esrIncomeTest.setThresholdA(ivmData.getThresholdA());
        String string = mtStatusCode = mtIncomeTestStatusESR != null && mtIncomeTestStatusESR.getStatus() != null ? mtIncomeTestStatusESR.getStatus().getCode() : null;
        if (MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(mtStatusCode) || MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(mtStatusCode)) {
            esrIncomeTest.setAgreesToPayDeductible(Boolean.TRUE);
        } else {
            esrIncomeTest.setAgreesToPayDeductible(null);
        }
        esrIncomeTest.setPg8RelaxationIndicator(ivmData.getPg8RelaxationIndicator());
        esrIncomeTest.setWorkflowCaseStatus(ivmData.getWorkflowCaseStatus());
    }

    @Override
    public void createOrUpdateTestFromIVMConversionData(boolean testExists) throws ServiceException {
        IncomeTest incomingTest = this.getIncomeTest();
        IncomeTest resultTest = this.getOrCreateIncomeTest();
        if (incomingTest == null || resultTest == null) {
            return;
        }
        IncomeTest pristineTest = (IncomeTest)((Object)resultTest.clone());
        Person resultPerson = this.getResultPerson();
        Integer incomingIncomeYear = this.getIncomingIncomeYear();
        this.partialMergeIVMConversionData(incomingTest, resultTest);
        resultTest.setPrimaryIncomeTest(Boolean.TRUE);
        resultTest.setNetWorth(null);
        resultTest.setTotalIncome(null);
        resultTest.setNetIncome(null);
        resultTest.setDeductibleExpenses(null);
        if (!testExists) {
            VAFacility siteConductingTest;
            BeneficiaryTravel travel;
            Expense adjMedical;
            FinancialStatement financialStatement;
            Hardship hardship;
            resultTest.setDiscloseFinancialInformation(Boolean.TRUE);
            resultTest.setType(this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getCode()));
            resultTest.setCadAdjusted(Boolean.FALSE);
            resultTest.setAdjudicationDate(null);
            IncomeTestStatus ltc1 = resultTest.getIncomeTestStatus(IncomeTestType.CODE_LTC_CO_PAY_TEST);
            IncomeTestStatus ltc2 = resultTest.getIncomeTestStatus(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST);
            if (ltc1 != null) {
                resultTest.removeIncomeTestStatus(ltc1);
            }
            if (ltc2 != null) {
                resultTest.removeIncomeTestStatus(ltc2);
            }
            if ((hardship = resultTest.getHardship()) != null) {
                hardship.setHardshipGranted(Boolean.FALSE);
                hardship.setReason(null);
                hardship.setSiteGrantingHardship(null);
                hardship.setEffectiveDate(null);
                hardship.setReviewDate(null);
            }
            if ((financialStatement = resultPerson.getFinancialStatement(incomingIncomeYear)) != null && (adjMedical = financialStatement.getExpense(ExpenseType.EXPENSE_TYPE_ADJUSTED_MEDICAL)) != null && adjMedical.getAmount() != null && adjMedical.getAmount().compareTo(new BigDecimal(0)) > 0) {
                adjMedical.setAmount(new BigDecimal(0));
            }
            resultTest.setIncomeVerificationStatus(null);
            resultTest.setIncomeVerificationStatusDate(null);
            if (resultTest.getThresholdA() == null) {
                resultTest.setThresholdA(this.getCalculatedMTThreshold());
            }
            if (resultTest.getGmtThresholdAmount() == null && pristineTest != null) {
                resultTest.setGmtThresholdAmount(pristineTest.getGmtThresholdAmount());
            }
            if (resultTest.getNetworthThreshold() == null) {
                resultTest.setNetworthThreshold(this.getCalculatedNetworthThreshold());
            }
            if (resultTest.getPensionThreshold() == null) {
                resultTest.setPensionThreshold(this.getCalculatedPensionThreshold());
            }
            if (resultTest.getChildIncomeExclusionThreshold() == null) {
                resultTest.setChildIncomeExclusionThreshold(this.getCalculatedIncomeExclusionThreshold());
            }
            BeneficiaryTravel beneficiaryTravel = travel = (siteConductingTest = resultTest.getSiteConductingTest()) != null ? resultPerson.getBeneficiaryTravel(incomingIncomeYear, siteConductingTest) : null;
            if (travel != null) {
                resultPerson.setBeneficiaryTravel(resultTest.getIncomeYear(), siteConductingTest, null);
            }
        }
        resultTest.setLastEditedDate(this.getCurrentDate());
        FinancialInputData data = this.getFinancialInputData();
        if (data != null && data.getIvmFinancialInfo() != null) {
            resultTest.setBtFinancialInd(data.getIvmFinancialInfo().getBtFinancialInd());
            this.updateIVMEventData(data.getIvmFinancialInfo().getIncomeYear(), resultTest, pristineTest, data.getIvmFinancialInfo().getIvmActionCode());
        }
    }

    private Date getEffectiveDateForIVMIncomeYear(Integer incomeYear) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, incomeYear);
        calendar.add(1, 1);
        calendar.add(2, 0);
        calendar.add(5, 0);
        return calendar.getTime();
    }

    @Override
    public void reverseDoesNotExistMeansTest() throws ServiceException {
        FinancialInputData data;
        if (this.getIncomingIncomeYear() == null) {
            return;
        }
        Person result = this.getResultPerson();
        result.setIncomeTest(this.getIncomingIncomeYear(), null);
        if (result.getFinancialStatement(this.getIncomingIncomeYear()) != null) {
            result.setFinancialStatement(this.getIncomingIncomeYear(), null);
        }
        if ((data = this.getFinancialInputData()) != null && data.getIvmFinancialInfo() != null) {
            IncomeTest pristineTest = this.getPristinePerson().getIncomeTest(this.getIncomingIncomeYear());
            this.updateIVMEventData(this.getIncomingIncomeYear(), null, pristineTest, data.getIvmFinancialInfo().getIvmActionCode());
            IncomeTest current = this.getHelperService().getCurrentIncomeTest(result);
            if (current != null) {
                data.getIvmFinancialInfo().setCurrentIncomeYear(current.getIncomeYear());
            }
        }
    }

    @Override
    public void reverseExistingMeansTest() throws ServiceException {
        IncomeTest onFileTest;
        Integer incomeYear = this.getIncomingIncomeYear();
        if (incomeYear == null) {
            return;
        }
        IncomeTest existingBase = this.getConversionBaseTest(incomeYear);
        if (existingBase != null && (onFileTest = this.getResultPerson().getIncomeTest(incomeYear)) != null) {
            List statuses = null;
            try {
                statuses = this.getFinancialsService().getIncomeTestStatusesForIVMReversal(existingBase.getHistoryId());
            }
            catch (RuleException e) {
                throw new ServiceException((Throwable)e);
            }
            IncomeTest conversionTest = (IncomeTest)((Object)onFileTest.clone());
            IncomeTestStatus mtIncomeTestStatus = onFileTest.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST);
            IncomeTestStatus rxIncomeTestStatus = onFileTest.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
            this.getMergeRuleService().mergeFullIncomeTest(existingBase, onFileTest);
            onFileTest.setBtFinancialInd(existingBase.getBtFinancialInd());
            if (statuses != null && !statuses.isEmpty()) {
                Iterator iter;
                onFileTest.removeAllStatuses();
                Iterator i = iter = statuses.iterator();
                while (i.hasNext()) {
                    IncomeTestStatus status = (IncomeTestStatus)((Object)i.next());
                    IncomeTestStatus temp = onFileTest.getIncomeTestStatus(status.getType());
                    if (temp != null) continue;
                    if (mtIncomeTestStatus != null && status.getType().getCode().equals(mtIncomeTestStatus.getType().getCode())) {
                        onFileTest.addIncomeTestStatus(mtIncomeTestStatus);
                        this.getMergeRuleService().mergeIncomeTestStatus(status, mtIncomeTestStatus);
                        continue;
                    }
                    if (rxIncomeTestStatus != null && status.getType().getCode().equals(rxIncomeTestStatus.getType().getCode())) {
                        onFileTest.addIncomeTestStatus(rxIncomeTestStatus);
                        this.getMergeRuleService().mergeIncomeTestStatus(status, rxIncomeTestStatus);
                        continue;
                    }
                    IncomeTestStatus newStatus = new IncomeTestStatus();
                    onFileTest.addIncomeTestStatus(newStatus);
                    this.getMergeRuleService().mergeIncomeTestStatus(status, newStatus);
                }
            } else {
                throw new ServiceException("Failed to find IncomeTestStatus during IVM reversal: income test id: " + onFileTest.getEntityKey().getKeyValueAsString());
            }
            FinancialInputData data = this.getFinancialInputData();
            if (data != null && data.getIvmFinancialInfo() != null) {
                this.updateIVMEventData(incomeYear, onFileTest, conversionTest, data.getIvmFinancialInfo().getIvmActionCode());
            }
        }
    }

    @Override
    public void updateBTFinancialInd() {
        Integer iy = this.getIncomingIncomeYear();
        if (iy != null) {
            IVMFinancialInfo info;
            IncomeTest result = this.getResultIncomeTest();
            FinancialInputData data = this.getFinancialInputData();
            IVMFinancialInfo iVMFinancialInfo = info = data != null ? data.getIvmFinancialInfo() : null;
            if (result != null && info != null) {
                result.setBtFinancialInd(info.getBtFinancialInd());
            }
        }
    }

    public void updateIVMEventData(Integer iy, IncomeTest resultTest, IncomeTest existingTest, String action) {
        FinancialInputData data = this.getFinancialInputData();
        if (data != null) {
            MeansTestStatus rxStatusExisting;
            IncomeTestStatus mtIncomeTestStatus = resultTest != null ? resultTest.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST) : null;
            IncomeTestStatus mtIncomeTestStatusExisting = existingTest != null ? existingTest.getIncomeTestStatus(IncomeTestType.CODE_MEANS_TEST) : null;
            IncomeTestStatus rxIncomeTestStatus = resultTest != null ? resultTest.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST) : null;
            IncomeTestStatus rxIncomeTestStatusExisting = existingTest != null ? existingTest.getIncomeTestStatus(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST) : null;
            MeansTestStatus mtStatus = mtIncomeTestStatus != null ? mtIncomeTestStatus.getStatus() : null;
            MeansTestStatus mtStatusExisting = mtIncomeTestStatusExisting != null ? mtIncomeTestStatusExisting.getStatus() : null;
            MeansTestStatus rxStatus = rxIncomeTestStatus != null ? rxIncomeTestStatus.getStatus() : null;
            MeansTestStatus meansTestStatus = rxStatusExisting = rxIncomeTestStatusExisting != null ? rxIncomeTestStatusExisting.getStatus() : null;
            if (mtStatus != null) {
                if ("C".equals(action)) {
                    data.setMTConversion(true);
                }
                if ("R".equals(action)) {
                    data.setMTReversal(true);
                }
            }
            if (rxStatus != null) {
                if ("C".equals(action)) {
                    data.setRXConversion(true);
                }
                if ("R".equals(action)) {
                    data.setRXReversal(true);
                }
            }
            if (resultTest == null && "R".equals(action)) {
                if (mtStatusExisting != null) {
                    data.setMTReversal(true);
                }
                if (rxStatusExisting != null) {
                    data.setRXReversal(true);
                }
            }
        }
    }

    @Override
    public boolean wasConversionToExistingMeansTest(Integer incomeYear) throws ServiceException {
        IncomeTest baseTest = this.getConversionBaseTest(incomeYear);
        return baseTest != null;
    }

    private IncomeTest getConversionBaseTest(Integer incomeYear) throws ServiceException {
        if (this.conversionBaseTest == null) {
            if (incomeYear == null) {
                return null;
            }
            Person result = this.getResultPerson();
            IncomeTest resultIncomeTest = result != null ? result.getIncomeTest(incomeYear) : null;
            try {
                this.conversionBaseTest = this.getFinancialsService().findConversionBaseTest(resultIncomeTest);
            }
            catch (RuleException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return this.conversionBaseTest;
    }

    @Override
    public boolean getPg8RelaxationIndicator(IncomeTest test) {
        if (test != null && test.getPg8RelaxationIndicator() != null) {
            return test.getPg8RelaxationIndicator();
        }
        return false;
    }

    @Override
    public boolean hasNoPriorIYTestOrAllPriorTestsMTCopayRequired() throws ServiceException {
        if (this.getResultPerson() == null) {
            return false;
        }
        if (this.getResultPerson().getIncomeTests() != null && this.getResultPerson().getIncomeTests().isEmpty()) {
            return true;
        }
        Map incomeTestMap = this.getResultPerson().getIncomeTests();
        Collection incomeTests = incomeTestMap.values();
        for (IncomeTest incomeTest : incomeTests) {
            String code = this.getMeansTestStatusCode(incomeTest);
            if (MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(code)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Integer getGMTThreshold(IncomeTest incomeTest) {
        if (incomeTest != null && incomeTest.getGmtThresholdAmount() != null) {
            return new Integer(incomeTest.getGmtThresholdAmount().intValue());
        }
        return null;
    }

    @Override
    public Integer getMTThreshold(IncomeTest incomeTest) {
        if (incomeTest != null && incomeTest.getThresholdA() != null) {
            return new Integer(incomeTest.getThresholdA().intValue());
        }
        return null;
    }

    @Override
    public Date getHardshipEffectiveDate() {
        return this.getHardshipEffectiveDate(this.getIncomeTest());
    }

    @Override
    public Date getHardshipEffectiveDate(IncomeTest incomeTest) {
        Hardship hardship = this.getHardship(incomeTest);
        return hardship != null ? hardship.getEffectiveDate() : null;
    }

    @Override
    public Hardship getHardship(IncomeTest incomeTest) {
        return incomeTest != null ? incomeTest.getHardship() : null;
    }

    @Override
    public void setHardship(Hardship sourceHardship) throws ServiceException {
        IncomeTest test = this.getResultIncomeTest();
        IncomeTest srcTest = this.getIncomingIncomeTest();
        Hardship targetHardship = test.getHardship();
        if (targetHardship == null && sourceHardship != null) {
            targetHardship = new Hardship();
            test.setHardship(targetHardship);
            this.getMergeRuleService().mergeHardship(sourceHardship, targetHardship);
        } else if (targetHardship != null && sourceHardship == null) {
            test.setHardship(null);
            IncomeTestStatus status = test.getIncomeTestStatusOfType(IncomeTestType.CODE_MEANS_TEST);
            if (status != null) {
                status.setStatus(status.getDeterminedStatus());
            }
        } else if (sourceHardship != null) {
            this.getMergeRuleService().mergeHardship(sourceHardship, targetHardship);
        }
        if (sourceHardship != null && srcTest != null && srcTest.getType().getCode().equals(test.getType().getCode())) {
            test.setIncomeTestStatus(test.getType(), srcTest.getStatus());
        }
    }

    @Override
    public String getSiteGrantingHardship(IncomeTest incomeTest) {
        Hardship hardship = this.getHardship(incomeTest);
        VAFacility site = hardship != null ? hardship.getSiteGrantingHardship() : null;
        return this.getLookupCode((Lookup)site);
    }

    public Date getHardshipReviewDate(IncomeTest incomeTest) {
        Hardship hardship = this.getHardship(incomeTest);
        return hardship == null ? null : hardship.getReviewDate();
    }

    @Override
    public boolean isIncomeTestDeleted(String source) {
        return this.getIncomingIncomeTest() == null;
    }

    public String getMeansTestStatus() {
        return this.getMeansTestStatusCode(this.getIncomingIncomeTest(), IncomeTestType.CODE_MEANS_TEST);
    }

    @Override
    public String getPristineMeansTestStatus() {
        return this.getMeansTestStatusCode(this.getPristineIncomeTest(), IncomeTestType.CODE_MEANS_TEST);
    }

    @Override
    public boolean isMTCopyStatusChanged() throws ServiceException {
        try {
            String incomingMeansTestStatus = this.getMeansTestStatus();
            IncomeTest pristineIncomeTest = this.getCurrentIncomeTest(this.getPristinePerson());
            String pristineMeansTestStatus = "";
            if (pristineIncomeTest != null) {
                pristineMeansTestStatus = this.getMeansTestStatusCode(pristineIncomeTest, IncomeTestType.CODE_MEANS_TEST);
            }
            if (incomingMeansTestStatus != null && pristineMeansTestStatus != null && !pristineMeansTestStatus.equals("") && pristineMeansTestStatus.equals(incomingMeansTestStatus)) {
                return false;
            }
            if (incomingMeansTestStatus != null && pristineMeansTestStatus != null && !pristineMeansTestStatus.equals("") && !pristineMeansTestStatus.equals(incomingMeansTestStatus)) {
                return true;
            }
            return incomingMeansTestStatus != null && (pristineMeansTestStatus == null || !pristineMeansTestStatus.equals("")) || incomingMeansTestStatus == null && pristineMeansTestStatus != null && !pristineMeansTestStatus.equals("");
        }
        catch (ServiceException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public boolean isPrimary(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return false;
        }
        return Boolean.TRUE.equals(incomeTest.isPrimaryIncomeTest());
    }

    @Override
    public void setPrimaryInd(IncomeTest test, Boolean primary) {
        if (test != null) {
            test.setPrimaryIncomeTest(primary);
        }
    }

    @Override
    public boolean isCADAdjusted() {
        return this.isCADAdjusted(this.getIncomeTest());
    }

    @Override
    public boolean isCADAdjusted(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return false;
        }
        Boolean cadAdjust = incomeTest.getCadAdjusted();
        return cadAdjust != null && cadAdjust != false;
    }

    @Override
    public boolean isAgreetoPayCoPay() {
        return this.isAgreetoPayCoPay(this.getIncomeTest());
    }

    @Override
    public boolean isAgreetoPayCoPay(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return false;
        }
        Boolean payDeductible = incomeTest.getAgreesToPayDeductible();
        return payDeductible != null && payDeductible != false;
    }

    @Override
    public IncomeTestSource getIncomeTestSource(IncomeTest incomeTest) {
        return incomeTest == null ? null : incomeTest.getSource();
    }

    @Override
    public String getIncomeTestSourceCode(IncomeTest incomeTest) {
        IncomeTestSource testSrc = this.getIncomeTestSource(incomeTest);
        return testSrc == null ? null : testSrc.getCode();
    }

    @Override
    public boolean isTestTypeMeansTest() {
        return this.isTestTypeMeansTest(this.getIncomeTest());
    }

    @Override
    public boolean isTestTypeMeansTest(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return false;
        }
        return IncomeTestType.CODE_MEANS_TEST.getName().equals(this.getIncomeTestTypeCode(incomeTest));
    }

    @Override
    public String getIncomeTestTypeCode(IncomeTest incomeTest) {
        IncomeTestType type = incomeTest == null ? null : incomeTest.getType();
        return type == null ? null : type.getCode();
    }

    public boolean isTestTypePharmacyCopayTest(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return false;
        }
        return IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName().equals(this.getIncomeTestTypeCode(incomeTest));
    }

    @Override
    public String getDeterminedStatus(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return null;
        }
        MeansTestStatus mtStatus = incomeTest.getDeterminedStatus();
        return mtStatus == null ? null : mtStatus.getCode();
    }

    @Override
    public String getDeterminedStatus() {
        return this.getDeterminedStatus(this.getIncomeTest());
    }

    public String getIncomeTestStatus(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return null;
        }
        MeansTestStatus status = incomeTest.getStatus();
        return status == null ? null : status.getCode();
    }

    @Override
    public boolean isDuplicateIncomeTest() {
        return this.isIncomeTestDuplicate(this.getIncomingIncomeTest(), this.getPristineIncomeTest());
    }

    @Override
    public boolean hasTestonfileForIncomingIncomeYear() throws ServiceException {
        Integer year = this.getIncomingIncomeYear();
        IncomeTest test = year != null ? this.getPristinePerson().getIncomeTest(year) : null;
        return test != null;
    }

    @Override
    public boolean checkForPresenceOfIncomeTestMeetingP8RecheckCriteria() throws ServiceException {
        if (this.getResultPerson() == null) {
            return false;
        }
        Map incomeTestMap = this.getResultPerson().getIncomeTests();
        Collection incomeTests = incomeTestMap.values();
        for (IncomeTest incomeTest : incomeTests) {
            if (incomeTest == null || !this.meetsP8FinancialCriteria(incomeTest)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkForPresenceOfIVMIncomeTestMeetingP8RecheckCriteria() throws ServiceException {
        if (this.getResultPerson() == null) {
            return false;
        }
        Map incomeTestMap = this.getResultPerson().getIncomeTests();
        Collection incomeTests = incomeTestMap.values();
        for (IncomeTest incomeTest : incomeTests) {
            if (incomeTest == null || !this.meetsIVMP8FinancialCriteria(incomeTest)) continue;
            return true;
        }
        return false;
    }

    private boolean meetsP8FinancialCriteria(IncomeTest incomeTest) throws ServiceException {
        MeansTestStatus mts;
        if (incomeTest == null) {
            return false;
        }
        Integer incomeYear = this.getIncomeYear(incomeTest);
        if (incomeYear != null && incomeYear.compareTo(YEAR_2008) >= 0 && (mts = incomeTest.getStatus()) != null && (MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(mts.getCode()) || MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(mts.getCode()))) {
            BigDecimal gmtThreshold = incomeTest.getGmtThresholdAmount();
            BigDecimal mtThreshold = incomeTest.getThresholdA();
            String source = this.getIncomeTestSourceCode(incomeTest);
            if (gmtThreshold != null && mtThreshold != null && Boolean.TRUE.equals(incomeTest.getDiscloseFinancialInformation()) && source != null && !IncomeTestSource.CODE_IVM.getCode().equals(source)) {
                float relaxPercentage = this.getRelaxPercentage(incomeYear);
                if (gmtThreshold.compareTo(mtThreshold) >= 0 && !this.isIncomeGreaterThanGMTplusRelaxPercentForCE(relaxPercentage, incomeTest) || mtThreshold.compareTo(gmtThreshold) >= 0 && !this.isIncomeGreaterThanMTTplusRelaxPercentForCE(relaxPercentage, incomeTest)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void addIncomeTestDeletedEvent() {
        Integer incomeYear = this.getIncomingIncomeYear();
        if (incomeYear == null) {
            return;
        }
        this.getResultPerson().setChangeEvent("INCOMETEST_DELETED", incomeYear.toString());
    }

    @Override
    public void postProcessIVMEvents() {
        Integer incomeYear = this.getIncomingIncomeYear();
        if (incomeYear == null) {
            return;
        }
        FinancialStatement fsResult = this.getResultPerson().getFinancialStatement(incomeYear);
        FinancialStatement fsPristine = this.getPristinePerson().getFinancialStatement(incomeYear);
        if (fsResult != null && fsPristine == null || fsResult == null && fsPristine != null) {
            this.getResultPerson().setChangeEvent("FIN_DEPENDENT_CHANGE", incomeYear.toString());
            return;
        }
        if (fsResult != null && fsPristine != null) {
            Set updatedDepFins = fsResult.getDependentFinancials();
            Set pristineDepFins = fsPristine.getDependentFinancials();
            if (updatedDepFins.size() != pristineDepFins.size()) {
                this.getResultPerson().setChangeEvent("FIN_DEPENDENT_CHANGE", incomeYear.toString());
                return;
            }
            if (updatedDepFins.size() == pristineDepFins.size()) {
                Iterator updatedIter = updatedDepFins.iterator();
                Iterator pristineIter = pristineDepFins.iterator();
                while (updatedIter.hasNext()) {
                    DependentFinancials dep = (DependentFinancials)((Object)updatedIter.next());
                    DependentFinancials matched = (DependentFinancials)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)dep, pristineDepFins);
                    if (matched == null) continue;
                    if (ObjectUtils.didObjectChange((Object)matched.getIncapableOfSelfSupport(), (Object)dep.getIncapableOfSelfSupport()) || ObjectUtils.didObjectChange((Object)matched.getContributedToSupport(), (Object)dep.getContributedToSupport()) || ObjectUtils.didObjectChange((Object)matched.getHasIncome(), (Object)dep.getHasIncome()) || ObjectUtils.didObjectChange((Object)matched.getAmountContributedToSupport(), (Object)dep.getAmountContributedToSupport()) || ObjectUtils.didObjectChange((Object)matched.getIncomeAvailableToPatient(), (Object)dep.getIncomeAvailableToPatient())) {
                        this.getResultPerson().setChangeEvent("FIN_DEPENDENT_CHANGE", incomeYear.toString());
                        return;
                    }
                    Dependent depU = dep.getReportedOn();
                    Dependent depP = matched.getReportedOn();
                    if (!ObjectUtils.didObjectChange((Object)((Object)depP.getOfficialSsn()), (Object)((Object)depU.getOfficialSsn())) && !ObjectUtils.didObjectChange((Object)depP.getName(), (Object)depU.getName()) && !ObjectUtils.didObjectChange((Object)depP.getDob(), (Object)depU.getDob()) && !ObjectUtils.didObjectChange((Object)((Object)depP.getGender()), (Object)((Object)depU.getGender())) && !ObjectUtils.didObjectChange((Object)((Object)depP.getRelationship()), (Object)((Object)depU.getRelationship())) && !ObjectUtils.didObjectChange((Object)depP.getStartDate(), (Object)depU.getStartDate())) continue;
                    this.getResultPerson().setChangeEvent("FIN_DEPENDENT_CHANGE", incomeYear.toString());
                    return;
                }
            }
        }
        IncomeTest resultTest = this.getResultPerson().getIncomeTest(this.getIncomingIncomeYear());
        IncomeTest pristineTest = this.getPristinePerson().getIncomeTest(this.getIncomingIncomeYear());
        if (resultTest != null && pristineTest == null || resultTest == null && pristineTest != null) {
            this.getResultPerson().setChangeEvent("FIN_INCOMETEST_CHANGE", incomeYear.toString());
            return;
        }
        if (resultTest != null && pristineTest != null) {
            if (this.compareIncomeStatusesForIVM(resultTest.getStatuses(), pristineTest.getStatuses())) {
                this.getResultPerson().setChangeEvent("FIN_INCTSTSTATUS_CHANGE", incomeYear.toString());
                return;
            }
            if (!resultTest.matchesDomainValues((Object)pristineTest)) {
                this.getResultPerson().setChangeEvent("FIN_INCOMETEST_CHANGE", incomeYear.toString());
            }
        }
    }

    private boolean compareIncomeStatusesForIVM(Set resultSet, Set oldSet) {
        if (resultSet == null && oldSet != null) {
            return true;
        }
        if (resultSet != null && oldSet == null) {
            return true;
        }
        if (resultSet != null && oldSet != null) {
            if (resultSet.size() != oldSet.size()) {
                return true;
            }
            for (IncomeTestStatus resultStatus : resultSet) {
                IncomeTestStatus matched = (IncomeTestStatus)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)resultStatus, oldSet);
                if (matched != null) {
                    if (!ObjectUtils.didObjectChange((Object)((Object)matched.getDeterminedStatus()), (Object)((Object)resultStatus.getDeterminedStatus())) && !ObjectUtils.didObjectChange((Object)((Object)matched.getStatus()), (Object)((Object)resultStatus.getStatus())) && !ObjectUtils.didObjectChange((Object)((Object)matched.getType()), (Object)((Object)resultStatus.getType()))) continue;
                    return true;
                }
                return true;
            }
        }
        return false;
    }

    private boolean meetsIVMP8FinancialCriteria(IncomeTest incomeTest) throws ServiceException {
        MeansTestStatus mts;
        if (incomeTest == null) {
            return false;
        }
        Integer incomeYear = this.getIncomeYear(incomeTest);
        if (incomeYear != null && incomeYear.compareTo(YEAR_2008) >= 0 && (mts = incomeTest.getStatus()) != null && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(mts.getCode())) {
            String source = this.getIncomeTestSourceCode(incomeTest);
            if (Boolean.TRUE.equals(incomeTest.getDiscloseFinancialInformation()) && source != null && IncomeTestSource.CODE_IVM.getCode().equals(source) && incomeTest.getPg8RelaxationIndicator() != null && incomeTest.getPg8RelaxationIndicator().booleanValue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasVerifiedEnrollmentAndP8Eligible() throws ServiceException {
        List incomeYears = this.getIncomeYearsFromVerifiedEnrollmentDueToP8();
        if (incomeYears != null) {
            for (int i = 0; i < incomeYears.size(); ++i) {
                Integer incomeYear = (Integer)incomeYears.get(i);
                IncomeTest it = this.getResultPerson().getIncomeTest(incomeYear);
                if (it == null || !this.meetsP8FinancialCriteria(it)) continue;
                return true;
            }
        }
        return false;
    }

    private List getIncomeYearsFromVerifiedEnrollmentDueToP8() throws ServiceException {
        List incomeYears = null;
        try {
            incomeYears = this.getEligibilityEnrollmentService().getIncomeYearsFromVerifiedEnrollmentDueToP8(this.getIncomingPerson().getEntityKey());
        }
        catch (RuleException e) {
            throw new ServiceException((Throwable)e);
        }
        return incomeYears;
    }

    private boolean isIncomeTestDuplicate(IncomeTest test1, IncomeTest test2) {
        String test1FacilityCode = this.getSiteConductingTestFacilityCode(test1);
        String test2FacilityCode = this.getSiteConductingTestFacilityCode(test2);
        return StringUtils.equals((String)this.getIncomeTestSourceCode(test1), (String)this.getIncomeTestSourceCode(test2)) && StringUtils.equals((String)test1FacilityCode, (String)test2FacilityCode) && StringUtils.equals((String)this.getIncomeTestTypeCode(test1), (String)this.getIncomeTestTypeCode(test2)) && this.isEquals(this.getLastEditDate(test1), this.getLastEditDate(test2));
    }

    @Override
    public boolean isIncompleteIncomeTest() {
        return this.isIncompleteIncomeTest(this.getIncomeTest());
    }

    @Override
    public boolean isIncompleteIncomeTest(IncomeTest incomeTest) {
        if (incomeTest == null) {
            return true;
        }
        String detTestStatus = this.getDeterminedStatus(incomeTest);
        return IncomeTestType.CODE_MEANS_TEST.getName().equals(this.getIncomeTestTypeCode(incomeTest)) ? !StringUtils.contains((String[])incompleteMTStatuses, (String)detTestStatus) || this.getCompletedDate() == null : IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName().equals(this.getIncomeTestTypeCode(incomeTest)) && (!StringUtils.contains((String[])incompleteCopayTestStatuses, (String)detTestStatus) || this.getCompletedDate() == null);
    }

    @Override
    public boolean isIncomingTestDeterminedPrimary() {
        if (this.determinedPrimaryFlag == null) {
            this.determinedPrimaryFlag = this.isDeterminedPrimary(this.getIncomeTest(), this.getPristineIncomeTest());
        }
        return this.determinedPrimaryFlag;
    }

    private boolean isDeterminedPrimary(IncomeTest incomeTest, IncomeTest pristineIncomeTest) {
        IncomeTestStatus onFileStatus;
        String type = this.getIncomeTestTypeCode(incomeTest);
        if (type == null) {
            return false;
        }
        if (this.isNonPrimaryType(type)) {
            return false;
        }
        if (this.isTestNonPrimary(pristineIncomeTest)) {
            return true;
        }
        if (IncomeTestType.CODE_MEANS_TEST.getName().equals(incomeTest.getType().getCode())) {
            if (!this.isEquals(this.getAgreeToPayIndicator(incomeTest), this.getAgreeToPayIndicator(pristineIncomeTest)) || !this.isEquals(this.getDisclosure(incomeTest), this.getDisclosure(pristineIncomeTest))) {
                return true;
            }
            String pristineIncomeTestType = this.getIncomeTestTypeCode(pristineIncomeTest);
            if (IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName().equals(pristineIncomeTestType)) {
                return true;
            }
        }
        if (IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST.getName().equals(incomeTest.getType().getCode()) && IncomeTestType.CODE_MEANS_TEST.getName().equals(pristineIncomeTest.getType().getCode()) && (onFileStatus = pristineIncomeTest.getIncomeTestStatus()) != null && onFileStatus.getStatus() != null && MeansTestStatus.MT_STATUS_NO_LONGER_REQUIRED.getName().equals(onFileStatus.getStatus().getCode())) {
            return true;
        }
        if (StringUtils.equals((String)this.getIncomeTestTypeCode(incomeTest), (String)this.getIncomeTestTypeCode(pristineIncomeTest))) {
            boolean incomingIsBefore;
            Date effectiveDate;
            if (StringUtils.equals((String)this.getSiteConductingTestFacilityCode(incomeTest), (String)this.getSiteConductingTestFacilityCode(pristineIncomeTest)) && (effectiveDate = this.getEffectiveTestDate(incomeTest)) != null && !effectiveDate.after(this.getCurrentDate())) {
                return true;
            }
            if (IncomeTestSource.CODE_HEC.getName().equals(this.getIncomeTestSourceCode(incomeTest))) {
                return true;
            }
            if (!StringUtils.equals((String)this.getIncomeTestSourceCode(incomeTest), (String)this.getIncomeTestSourceCode(pristineIncomeTest)) && IncomeTestSource.CODE_VAMC.getName().equals(this.getIncomeTestSourceCode(incomeTest)) && IncomeTestSource.CODE_HEC.getName().equals(this.getIncomeTestSourceCode(pristineIncomeTest)) && !this.isPreferred(pristineIncomeTest, incomeTest)) {
                return true;
            }
            if (StringUtils.equals((String)this.getIncomeTestSourceCode(incomeTest), (String)this.getIncomeTestSourceCode(pristineIncomeTest)) && ((incomingIsBefore = this.isBefore(this.getEffectiveTestDate(incomeTest), this.getEffectiveTestDate(pristineIncomeTest))) || !incomingIsBefore && !this.isPreferred(pristineIncomeTest, incomeTest)) && this.isPreferred(incomeTest, pristineIncomeTest)) {
                return true;
            }
        }
        return false;
    }

    public boolean isNonPrimaryType(String type) {
        return IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getName().equals(type) || IncomeTestType.CODE_LTC_CO_PAY_TEST.getName().equals(type);
    }

    public boolean isTestNonPrimary(IncomeTest test) {
        return test == null || test.getType() == null || test.getType().getCode() == null || this.isNonPrimaryType(test.getType().getCode());
    }

    public boolean isPreferred(IncomeTest test1, IncomeTest test2) {
        return !MeansTestStatus.MT_STATUS_REQUIRED.getName().equals(this.getIncomeTestStatus(test1)) && (!this.isTestTypePharmacyCopayTest(test1) || !MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY.getName().equals(this.getIncomeTestStatus(test1)));
    }

    @Override
    public void mergeIncomeTestStatus(IncomeTestType.Code typeCode) throws ServiceException {
        IncomeTestStatus incomingStatus;
        IncomeTest incomingTest = this.getIncomingIncomeTest();
        IncomeTest resultTest = this.getResultIncomeTest();
        IncomeTestStatus resultStatus = resultTest != null ? resultTest.getIncomeTestStatus(typeCode) : null;
        IncomeTestStatus incomeTestStatus = incomingStatus = incomingTest != null ? incomingTest.getIncomeTestStatus(typeCode) : null;
        if (incomingStatus == null && resultStatus != null) {
            resultTest.removeStatus(resultStatus);
        } else if (incomingStatus != null && resultStatus == null) {
            resultStatus = new IncomeTestStatus();
            resultTest.addStatus(resultStatus);
            this.getMergeRuleService().mergeIncomeTestStatus(incomingStatus, resultStatus);
        } else if (incomingStatus != null && resultStatus != null) {
            this.getMergeRuleService().mergeIncomeTestStatus(incomingStatus, resultStatus);
        }
    }

    @Override
    public void processFinancialStatement() throws ServiceException {
        try {
            FinancialStatement inStmt = this.getIncomingFinancialStatement();
            FinancialStatement pristineStmt = this.getPristineFinancialStatement();
            if (inStmt == null && pristineStmt != null) {
                this.setFinancialStatement(null);
            } else if (inStmt != null) {
                FinancialStatement rsStmt = this.getOrCreateFinancialStatement();
                this.getMergeRuleService().mergeFinancialStatement(inStmt, rsStmt, this.isDataFromZ07);
                this.getFinancialsHelperService().processSsn(rsStmt);
                this.getFinancialsHelperService().updatePseudoSsnClock(this.getResultPerson(), rsStmt);
                this.financialStatementCopied = true;
            }
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)e);
            }
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void setFinancialStatement(FinancialStatement stmt) throws ServiceException {
        this.getResultPerson().setFinancialStatement(this.getIncomingIncomeYear(), stmt);
        this.getFinancialsHelperService().updatePseudoSsnClock(this.getResultPerson(), stmt);
    }

    @Override
    public void setPatientVisitSummary(PatientVisitSummary visitSummary) {
        this.getResultPerson().setPatientVisitSummary(this.getIncomingIncomeYear(), this.getSourceFacility(), visitSummary);
    }

    @Override
    public void processPatientVisitSummary() throws ServiceException {
        PatientVisitSummary incomingVisitSummary = this.getPatientVisitSummary(this.getIncomingPerson());
        PatientVisitSummary pristineVisitSummary = this.getPatientVisitSummary(this.getPristinePerson());
        if (incomingVisitSummary == null && pristineVisitSummary != null) {
            this.setPatientVisitSummary(null);
        } else if (incomingVisitSummary != null) {
            this.getMergeRuleService().mergePatientVisitSummary(incomingVisitSummary, this.getOrCreatePatientVisitSummary());
        }
    }

    @Override
    public Date getDateOfLastVisit() {
        IncomeTest incomeTest;
        PatientVisitSummary visitSummary = null;
        if (this.getFinancialInputData() != null) {
            visitSummary = this.getPatientVisitSummary(this.getIncomingPerson());
        } else if (this.getEEInputData() != null && (incomeTest = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson())) != null) {
            Integer year = incomeTest.getIncomeYear();
            VAFacility facility = incomeTest.getSiteConductingTest();
            if (year != null && facility != null) {
                visitSummary = this.getIncomingPerson().getPatientVisitSummary(year, facility);
            }
        }
        return visitSummary != null ? visitSummary.getLastVisitDate() : null;
    }

    @Override
    public PatientVisitSummary getPatientVisitSummary(Person person) {
        VAFacility facility = this.getSourceFacility();
        Integer incomeYear = this.getIncomingIncomeYear();
        if (person != null && facility != null && incomeYear != null) {
            return person.getPatientVisitSummary(incomeYear, facility);
        }
        return null;
    }

    private PatientVisitSummary getOrCreatePatientVisitSummary() {
        VAFacility facility = this.getSourceFacility();
        Integer incomeYear = this.getIncomingIncomeYear();
        PatientVisitSummary visitSummary = this.getResultPerson().getPatientVisitSummary(incomeYear, facility);
        if (visitSummary == null) {
            visitSummary = new PatientVisitSummary();
            visitSummary.setFacilityVisited(facility);
            visitSummary.setIncomeYear(incomeYear);
            this.getResultPerson().setPatientVisitSummary(incomeYear, facility, visitSummary);
        }
        return visitSummary;
    }

    @Override
    public BeneficiaryTravel getBeneficiaryTravel(Person person) {
        VAFacility facility = this.getSourceFacility();
        Integer incomeYear = this.getIncomingIncomeYear();
        if (person != null && facility != null && incomeYear != null) {
            return person.getBeneficiaryTravel(incomeYear, facility);
        }
        return null;
    }

    private BeneficiaryTravel getOrCreateBeneficiaryTravel() {
        VAFacility facility = this.getSourceFacility();
        Integer incomeYear = this.getIncomingIncomeYear();
        BeneficiaryTravel bt = this.getResultPerson().getBeneficiaryTravel(incomeYear, facility);
        if (bt == null) {
            bt = new BeneficiaryTravel();
            bt.setFacilityVisited(facility);
            bt.setYear(incomeYear);
            this.getResultPerson().setBeneficiaryTravel(incomeYear, facility, bt);
        }
        return bt;
    }

    @Override
    public void setBeneficiaryTravel(BeneficiaryTravel travel) {
        this.getResultPerson().setBeneficiaryTravel(this.getIncomingIncomeYear(), this.getSourceFacility(), travel);
    }

    @Override
    public void processBeneficiaryTravel() throws ServiceException {
        BeneficiaryTravel incomingBTravel = this.getBeneficiaryTravel(this.getIncomingPerson());
        BeneficiaryTravel pristineBTravel = this.getBeneficiaryTravel(this.getPristinePerson());
        boolean btChanged = false;
        BeneficiaryTravel btOnFile = null;
        if (incomingBTravel == null && pristineBTravel != null) {
            this.setBeneficiaryTravel(null);
        } else if (incomingBTravel != null && incomingBTravel.getClaimDate() == null) {
            this.setBeneficiaryTravel(null);
        } else if (incomingBTravel != null) {
            btOnFile = this.getOrCreateBeneficiaryTravel();
            Boolean btIndIncoming = incomingBTravel.isEligible() != null ? Boolean.valueOf(incomingBTravel.isEligible()) : null;
            Boolean btIndOnFile = btOnFile.isEligible() != null ? Boolean.valueOf(btOnFile.isEligible()) : null;
            this.getMergeRuleService().mergeBeneficiaryTravel(incomingBTravel, btOnFile);
            if (btIndOnFile == null && btIndIncoming != null) {
                btChanged = true;
            } else if (btIndOnFile != null && btIndIncoming != null) {
                boolean bl = btChanged = !btIndOnFile.equals(btIndIncoming);
            }
        }
        if (btChanged && btOnFile != null) {
            String year;
            String incomingYear = this.getIncomingIncomeYear() != null ? this.getIncomingIncomeYear().toString() : null;
            String string = year = btOnFile.getYear() != null ? btOnFile.getYear().toString() : incomingYear;
            if (year != null) {
                this.getResultPerson().setChangeEvent("BT_IND_CHANGE", year);
            }
        }
    }

    private boolean areCodeValuesEqual(AbstractLookup a, AbstractLookup b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null && b != null || b == null && a != null) {
            return false;
        }
        return this.isEqual(a.getCode(), b.getCode());
    }

    @Override
    public boolean processEffectiveImmediately() throws ServiceException {
        IncomeTest currentTest = this.getCurrentIncomeTest();
        IncomeTest incomingIncomeTest = this.getIncomingIncomeTest();
        if (currentTest == null) {
            return true;
        }
        if (this.isTestTypeMeansTest(currentTest) && this.isTestTypeMeansTest(incomingIncomeTest)) {
            String incomingStatus = this.getMeansTestStatusCode(incomingIncomeTest);
            Integer currentYear = currentTest.getIncomeYear();
            Integer incomingYear = incomingIncomeTest.getIncomeYear();
            boolean yearIsLater = currentYear != null && incomingYear != null ? incomingYear.compareTo(currentYear) > 0 : false;
            String[] rul1Statuses = new String[]{MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getName(), MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName(), MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName(), MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName()};
            if (yearIsLater && StringUtils.contains((String[])rul1Statuses, (String)incomingStatus)) {
                return true;
            }
        } else if (this.isTestTypePharmacyCopayTest(incomingIncomeTest)) {
            boolean yearIsLater;
            String incomingStatus = this.getPharmacyCopayStatusCode(incomingIncomeTest);
            Integer currentYear = currentTest.getIncomeYear();
            Integer incomingYear = incomingIncomeTest.getIncomeYear();
            boolean bl = currentYear != null && incomingYear != null ? incomingYear.compareTo(currentYear) > 0 : (yearIsLater = false);
            if (yearIsLater && (MeansTestStatus.MT_STATUS_NON_EXEMPT.getName().equals(incomingStatus) || MeansTestStatus.MT_STATUS_EXEMPT.getName().equals(incomingStatus))) {
                return true;
            }
        }
        return false;
    }

    public boolean isExpired(IncomeTest incomeTest) {
        if (incomeTest != null) {
            Date expDate;
            Date today = this.getCurrentDate();
            Date effDate = this.getEffectiveTestDate(incomeTest);
            Date date = expDate = effDate == null ? null : this.addDaysToDate(effDate, 365);
            if (expDate != null && expDate.before(today)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void processHardship() throws ServiceException {
        Date incomingEffectiveDate;
        Hardship currentHardship = this.getHardship(this.getPristineIncomeTest());
        Hardship incomingHardship = this.getHardship(this.getIncomeTest());
        Date currentEffectiveDate = currentHardship == null ? null : currentHardship.getEffectiveDate();
        Date date = incomingEffectiveDate = incomingHardship == null ? null : incomingHardship.getEffectiveDate();
        if (incomingEffectiveDate != null) {
            if (currentEffectiveDate == null && !this.isEarlier(incomingEffectiveDate, this.getEffectiveTestDate(this.getResultIncomeTest()))) {
                this.setHardship(incomingHardship);
            }
            if (!(currentEffectiveDate == null || !this.isSiteGrantingHardshipSameAsSiteTransmittingData(currentHardship) || this.isEquals(currentEffectiveDate, incomingEffectiveDate) && this.isEquals(currentHardship.getReviewDate(), incomingHardship.getReviewDate()))) {
                this.setHardship(incomingHardship);
            }
        } else if (incomingEffectiveDate == null && currentEffectiveDate != null && this.isSiteGrantingHardshipSameAsSiteTransmittingData(currentHardship)) {
            this.setHardship(null);
        }
    }

    private boolean isSiteGrantingHardshipSameAsSiteTransmittingData(Hardship currentHardship) {
        return this.isEqual(this.getLookupCode((Lookup)currentHardship.getSiteGrantingHardship()), this.getReceivingFacilityCode());
    }

    @Override
    public Date addYearToDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        if (calendar.get(2) == 1 && calendar.get(5) == 29) {
            calendar.set(5, 28);
        }
        return calendar.getTime();
    }

    public Date addDaysToDate(Date date, int days) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, days);
        return calendar.getTime();
    }

    private Address getFacilityAddress(VAFacility facility) {
        if (facility != null && facility.getStreetAddress() != null) {
            VAFacility.VAFacilityAddress facilityAddr = facility.getStreetAddress();
            Address siteAddress = new Address();
            siteAddress.setLine1(facilityAddr.getLine1());
            siteAddress.setLine2(facilityAddr.getLine2());
            siteAddress.setLine3(facilityAddr.getLine3());
            siteAddress.setCity(facilityAddr.getCity());
            siteAddress.setState(facilityAddr.getState() == null ? null : facilityAddr.getState().getCode());
            siteAddress.setZipCode(facilityAddr.getZipCode());
            return siteAddress;
        }
        return null;
    }

    private VAFacility getRecentMsgTransmittedFacility() throws ServiceException {
        return this.getMessagingSevice().findSiteLastTransmittedMsg(this.getResultPerson().getEntityKey());
    }

    @Override
    public boolean getDeterminedPrimaryFlag() {
        return this.isIncomingTestDeterminedPrimary();
    }

    @Override
    public void setDeterminedPrimaryFlag(boolean determinedPrimaryFlag) {
        this.determinedPrimaryFlag = determinedPrimaryFlag;
    }

    @Override
    public boolean isCurrentTestOlderThan365Days() throws ServiceException {
        return this.getCurrentIncomeTest() != null && this.isBefore(this.addYearToDate(this.getCurrentIncomeTest().getEffectiveDate()), new Date());
    }

    public boolean isHardShipGranted(IncomeTest incomeTest) {
        Hardship hardShip = this.getHardship(incomeTest);
        if (hardShip != null && hardShip.getHardshipGranted() != null) {
            return hardShip.getHardshipGranted();
        }
        return false;
    }

    @Override
    public boolean isIncomingIncomeTestYearGreaterThanCurrentYear() {
        Calendar calendar = Calendar.getInstance();
        return this.isGreaterThan(this.getIncomingIncomeYear(), calendar.get(1));
    }

    @Override
    public boolean isHardShipGranted() {
        return this.isHardShipGranted(this.getPristineIncomeTest());
    }

    @Override
    public boolean isIncomeTestCurrent() throws ServiceException {
        return this.getCurrentIncomeTest() != null;
    }

    @Override
    public boolean isMTPermitted() {
        if (this.meansTestPermitted == null) {
            this.meansTestPermitted = this.getFinancialsHelperService().isMeansTestPermitted(this.getResultPerson());
        }
        return this.meansTestPermitted;
    }

    @Override
    public void setMTPermitted(boolean value) {
        this.meansTestPermitted = value;
    }

    @Override
    public boolean isRXCopayApplicableForVeteran() {
        if (this.isMessageFromVOA()) {
            return true;
        }
        if (this.primaryCopayApplicable == null) {
            if (this.getRuleDataAware() instanceof EEInputData) {
                EEInputData eid = (EEInputData)this.getRuleDataAware();
                Person clonePerson = (Person)((Object)this.getResultPerson().clone());
                clonePerson.setEnrollmentDetermination(eid.getResultEnrollmentDetermination());
                this.primaryCopayApplicable = this.getFinancialsHelperService().isPhramacyCoPayApplicable(clonePerson);
            } else {
                this.primaryCopayApplicable = this.getFinancialsHelperService().isPhramacyCoPayApplicable(this.getResultPerson());
            }
        }
        return this.primaryCopayApplicable;
    }

    @Override
    public boolean isPersonFromVISTA() {
        EEInputData data = this.getEEInputData();
        if (data != null && data.getSendingFacility() != null) {
            return VAFacility.CODE_MHV.getCode().equals(data.getSendingFacility().getStationNumber());
        }
        return false;
    }

    @Override
    public void setRXCopayApplicableForVeteran(boolean copayApplicableForVeteran) {
        this.primaryCopayApplicable = copayApplicableForVeteran;
    }

    @Override
    public boolean isVeteranSubjectToMeansTesting() throws ServiceException {
        if (this.subjectToMeansTest == null) {
            if (this.getRuleDataAware() instanceof EEInputData) {
                EEInputData eid = (EEInputData)this.getRuleDataAware();
                Person clonePerson = (Person)((Object)this.getResultPerson().clone());
                clonePerson.setEnrollmentDetermination(eid.getResultEnrollmentDetermination());
                this.subjectToMeansTest = this.getFinancialsHelperService().isSubjectToMeansTest(clonePerson);
            } else {
                this.subjectToMeansTest = this.getFinancialsHelperService().isSubjectToMeansTest(this.getResultPerson());
            }
        }
        return this.subjectToMeansTest;
    }

    @Override
    public boolean isAllowedtoEditCurrentTest() throws ServiceException {
        return this.getFinancialsHelperService().isAllowedtoEditTest(this.getPristinePerson(), this.getIncomingIncomeYear());
    }

    @Override
    public boolean isAllowedtoAddMeansTest() throws ServiceException {
        return this.getFinancialsHelperService().isAllowedtoAddMeansTest(this.getPristinePerson(), this.getIncomingIncomeYear());
    }

    @Override
    public boolean isAllowedtoAddPharmacyCopayTest() throws ServiceException {
        return this.getFinancialsHelperService().isAllowedtoAddPharmacyCopayTest(this.getPristinePerson(), this.getIncomingIncomeYear());
    }

    @Override
    public boolean isAllowedtoAddTest() throws ServiceException {
        return this.getFinancialsHelperService().isAllowedtoAddTest(this.getPristinePerson(), this.getIncomingIncomeYear());
    }

    @Override
    public void setVeteranSubjectToMeansTesting(boolean veteranSubjectToMeansTesting) {
        this.subjectToMeansTest = veteranSubjectToMeansTesting;
    }

    public MessagingService getMessagingSevice() {
        if (this.messagingSevice == null) {
            this.setMessagingSevice((MessagingService)this.getApplicationContext().getBean(MESSAGING_SERVICE_BEAN_NAME));
        }
        return this.messagingSevice;
    }

    private boolean getSendCaseToAdjudication(IncomeTest incomeTest) throws AdjudicationResponseRequiredException {
        if (incomeTest != null && incomeTest.getSendForAdjudication() == null) {
            throw new AdjudicationResponseRequiredException("Send to Adjudication response is missing.");
        }
        return Boolean.TRUE.equals(incomeTest != null ? incomeTest.getSendForAdjudication() : null);
    }

    @Override
    public String getCalculatedMeansTestStatusCode() throws ServiceException {
        if (this.calculatedMeansTestStatusCode == null) {
            this.calculatedMeansTestStatusCode = this.determineMeansTestStatusCode();
        }
        return this.calculatedMeansTestStatusCode;
    }

    @Override
    public MeansTestStatus determineMeansTestStatus() throws ServiceException {
        String meansTestStatusCode = this.determineMeansTestStatusCode();
        return meansTestStatusCode == null ? null : this.getLookupService().getMeansTestStatusByCode(meansTestStatusCode);
    }

    @Override
    public boolean isAdjudicationResponseRequired() throws ServiceException {
        try {
            this.determineMeansTestStatusCode();
        }
        catch (AdjudicationResponseRequiredException ex) {
            return true;
        }
        return false;
    }

    @Override
    public void setSubjectToOrPermittedTrue() {
        this.subjectToMeansTest = Boolean.TRUE;
        this.meansTestPermitted = Boolean.TRUE;
    }

    public String determineMeansTestStatusCode() throws ServiceException {
        BigDecimal gmtThreshold = this.convert(this.getCalculatedGMTThreshold());
        BigDecimal mtThreshold = this.getCalculatedMTThreshold();
        BigDecimal netIncome = this.getCalculatedNetIncome();
        BigDecimal networth = this.getCalculatedNetworth();
        BigDecimal networthThreshold = this.getCalculatedNetworthThreshold();
        FinancialStatement finStmt = this.getIncomingFinancialStatement();
        Boolean isPost2005Format = finStmt != null ? finStmt.getIsPost2005Format() : FinancialStatement.DEFAULT_POST_2005_FORMAT;
        return this.determineMeansTestStatusCode(gmtThreshold, mtThreshold, netIncome, networth, networthThreshold, isPost2005Format);
    }

    private String determineMeansTestStatusCode(BigDecimal gmtThreshold, BigDecimal mtThreshold, BigDecimal netIncome, BigDecimal netWorth, BigDecimal netWorthThreshold, Boolean isPost2005Format) throws ServiceException, AdjudicationResponseRequiredException {
        BigDecimal otherIncome;
        String meansTestStatusCode = null;
        mtThreshold = this.getNotNull(mtThreshold);
        gmtThreshold = this.getNotNull(gmtThreshold);
        netIncome = this.getNotNull(netIncome);
        netWorth = this.getNotNull(netWorth);
        netWorthThreshold = this.getNotNull(netWorthThreshold);
        BigDecimal incomeAndNetworth = netIncome.add(netWorth);
        if (!this.isVeteranSubjectToMeansTesting() && !this.isMTPermitted()) {
            return meansTestStatusCode;
        }
        IncomeTest incomeTest = this.getIncomeTest();
        if (Boolean.FALSE.equals(this.getDisclosure(incomeTest))) {
            return MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) <= 0 && incomeAndNetworth.compareTo(netWorthThreshold) < 0) {
            return MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getName();
        }
        BigDecimal bigDecimal = otherIncome = isPost2005Format != false ? this.getTotalIncomeAmount(IncomeType.INCOME_TYPE_FARM_RANCH_PROPERTY_OR_BUSINESS_INCOME) : this.getTotalIncomeAmount(IncomeType.INCOME_TYPE_TOTAL_ALL_OTHER_INCOME);
        if (netIncome.compareTo(mtThreshold) > 0 && netIncome.compareTo(gmtThreshold) <= 0 && otherIncome.compareTo(ZERO_AMOUNT) > 0) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) > 0 && netIncome.compareTo(gmtThreshold) >= 0 && otherIncome.compareTo(ZERO_AMOUNT) > 0) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName();
        }
        if (incomeAndNetworth.compareTo(netWorthThreshold) > 0 && gmtThreshold.compareTo(mtThreshold) > 0 && otherIncome.compareTo(ZERO_AMOUNT) > 0) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) <= 0 && netIncome.compareTo(gmtThreshold) <= 0 && incomeAndNetworth.compareTo(netWorthThreshold) > 0 && gmtThreshold.compareTo(mtThreshold) < 0 && this.isIncomeYearLaterThan2008()) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName();
        }
        if (incomeAndNetworth.compareTo(netWorthThreshold) > 0 && gmtThreshold.compareTo(mtThreshold) < 0 && otherIncome.compareTo(ZERO_AMOUNT) > 0) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) <= 0 && incomeAndNetworth.compareTo(netWorthThreshold) >= 0 && gmtThreshold.compareTo(mtThreshold) > 0) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) <= 0 && incomeAndNetworth.compareTo(netWorthThreshold) >= 0 && gmtThreshold.compareTo(mtThreshold) < 0) {
            return this.getSendCaseToAdjudication(incomeTest) ? MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName() : MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) > 0 && netIncome.compareTo(gmtThreshold) <= 0) {
            return MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getName();
        }
        if (netIncome.compareTo(mtThreshold) > 0 && netIncome.compareTo(gmtThreshold) > 0) {
            return MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName();
        }
        return null;
    }

    @Override
    public String getCalculatedRxCopayStatusCode() throws ServiceException {
        if (this.calculatedRxCopayStatusCode == null) {
            this.calculatedRxCopayStatusCode = this.determineRxCopayStatusCode();
        }
        return this.calculatedRxCopayStatusCode;
    }

    @Override
    public void convertMTToRxCopayTest() throws RuleException {
        IncomeTest incomeTest = this.getHelperService().getCurrentIncomeTest(this.getResultPerson());
        if (incomeTest != null) {
            IncomeTestStatus rxStatus = incomeTest.getPharmacyCoPayStatus();
            Date completed = incomeTest.getCompletedDate();
            if (rxStatus != null) {
                rxStatus.setDeterminedStatus(rxStatus.getStatus());
                incomeTest.setType(rxStatus.getType());
                if (completed == null) {
                    completed = this.getCurrentDate();
                }
                rxStatus.setCompletedDate(completed);
                rxStatus.setLastEditedDate(this.getCurrentDate());
            }
        }
    }

    @Override
    public void convertToMT() throws RuleException {
        IncomeTest incomeTest = this.getHelperService().getCurrentIncomeTestForEE(this.getResultPerson());
        if (incomeTest != null) {
            try {
                IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getName());
                Date completed = incomeTest.getCompletedDate();
                IncomeTestStatus status = incomeTest.getIncomeTestStatusOfType(IncomeTestType.CODE_MEANS_TEST);
                if (status != null) {
                    status.setStatus(status.getDeterminedStatus());
                    incomeTest.setType(type);
                    if (completed == null) {
                        completed = this.getCurrentDate();
                    }
                    status.setCompletedDate(completed);
                    status.setLastEditedDate(this.getCurrentDate());
                }
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to convert income test to MT", (Throwable)e);
            }
        }
    }

    private String determineRxCopayStatusCode() throws ServiceException {
        if (this.isRXCopayApplicableForVeteran()) {
            BigDecimal totalIncome = this.getCalculatedNetIncome();
            BigDecimal pensionThreshold = this.getCalculatedPensionThreshold();
            if (Boolean.FALSE.equals(this.getDisclosure(this.getIncomeTest())) || totalIncome.compareTo(pensionThreshold) > 0) {
                return MeansTestStatus.MT_STATUS_NON_EXEMPT.getName();
            }
            return MeansTestStatus.MT_STATUS_EXEMPT.getName();
        }
        return null;
    }

    private void setMessagingSevice(MessagingService messagingSevice) {
        this.messagingSevice = messagingSevice;
    }

    @Override
    public boolean isFinancialStatementCopied() {
        return this.financialStatementCopied;
    }

    @Override
    public void setFinancialStatementCopied(boolean financialStatementCopied) {
        this.financialStatementCopied = financialStatementCopied;
    }

    @Override
    public boolean isIncomeTestCopied() {
        return this.incomeTestCopied;
    }

    @Override
    public void setIncomeTestCopied(boolean incomeTestCopied) {
        this.incomeTestCopied = incomeTestCopied;
    }

    @Override
    public BigDecimal getAdd90DayHospitalDeductible() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getAdd90DayHospitalDeductible() != null ? incomeThreshold.getAdd90DayHospitalDeductible() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getAdd90DayHospitalMedicareDeductible() throws RuleException {
        return new BigDecimal(0);
    }

    @Override
    public BigDecimal getOutpatientSpecialCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getOutpatientSpecialtyCopay() != null ? incomeThreshold.getOutpatientSpecialtyCopay() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getGMTInpatient90DayCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getGmtInpatient90DayCopay() != null ? incomeThreshold.getGmtInpatient90DayCopay() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getGMTInpatientAdd90DayCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getGmtInpatientAdd90DayCopay() != null ? incomeThreshold.getGmtInpatientAdd90DayCopay() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getGMTInpatientPerDiem() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getGmtInpatientPerDiem() != null ? incomeThreshold.getGmtInpatientPerDiem() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getMedicationCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getMedicationCopay() != null ? incomeThreshold.getMedicationCopay() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getNinetyDayHospitalCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getNinetyDayHospitalCopay() != null ? incomeThreshold.getNinetyDayHospitalCopay() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getOutpatientCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getOutpatientCopay() != null ? incomeThreshold.getOutpatientCopay() : new BigDecimal(0);
    }

    @Override
    public BigDecimal getOutpatientPreventiveCopay() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getOutpatientPreventiveCopay() != null ? incomeThreshold.getOutpatientPreventiveCopay() : new BigDecimal(0);
    }

    @Override
    public Integer getIncomeYear(IncomeTest incomeTest) {
        return incomeTest != null ? incomeTest.getIncomeYear() : null;
    }

    @Override
    public BigDecimal getInpatientPerDiem() throws RuleException {
        IncomeThreshold incomeThreshold = this.getIncomeThresholdForComms();
        return incomeThreshold != null && incomeThreshold.getInpatientPerDiem() != null ? incomeThreshold.getInpatientPerDiem() : new BigDecimal(0);
    }

    @Override
    public String getPriorMeansTestStatusCode() throws RuleException {
        IncomeTest incomeTest = this.getPriorIncomeTest();
        if (incomeTest != null) {
            return this.getMeansTestStatusCode(incomeTest);
        }
        return null;
    }

    @Override
    public String getPriorPharmacyCopayStatusCode() throws RuleException {
        IncomeTest incomeTest = this.getPriorIncomeTest();
        if (incomeTest != null) {
            return this.getPharmacyCopayStatusCode(incomeTest);
        }
        return null;
    }

    @Override
    public Date getDateRefusedCopay() throws RuleException {
        IncomeTest test = null;
        Date dateRefused = null;
        try {
            test = this.getCurrentIncomeTest(this.getResultPerson());
            dateRefused = test != null ? test.getEffectiveDate() : null;
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to calculate income threshold", (Throwable)e);
        }
        return dateRefused;
    }

    @Override
    public Boolean getSpouseLivesWithVeteran() {
        SpouseFinancials fianacial;
        FinancialStatement fstmt = this.getIncomingFinancialStatement();
        if (fstmt != null && (fianacial = fstmt.getRecentSpouseFinancials()) != null) {
            return fianacial.getLivedWithPatient();
        }
        return null;
    }

    @Override
    public void updateLTCStatuses() throws ServiceException {
        IncomeTest incomingTest = this.getIncomingIncomeTest();
        IncomeTest resultTest = this.getResultIncomeTest();
        IncomeTestStatus ltcCopayStatus = null;
        IncomeTestStatus ltcCopayExemtStatus = null;
        if (incomingTest != null && resultTest == null) {
            ltcCopayStatus = incomingTest.getIncomeTestStatus(IncomeTestType.CODE_LTC_CO_PAY_TEST);
            ltcCopayExemtStatus = incomingTest.getIncomeTestStatus(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST);
            if (ltcCopayStatus != null || ltcCopayExemtStatus != null) {
                String testTypeCode = IncomeTestType.CODE_LTC_CO_PAY_TEST.getCode();
                if (ltcCopayStatus == null) {
                    testTypeCode = IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST.getCode();
                }
                IncomeTestType type = this.getLookupService().getIncomeTestTypeByCode(testTypeCode);
                resultTest = new IncomeTest();
                resultTest.setIncomeYear(incomingTest.getIncomeYear());
                resultTest.setType(type);
                resultTest.setSource(incomingTest.getSource());
                resultTest.setSiteConductingTest(incomingTest.getSiteConductingTest());
                resultTest.setEffectiveDate(incomingTest.getEffectiveDate());
                resultTest.setPrimaryIncomeTest(Boolean.FALSE);
                resultTest.setFutureTest(null);
                this.getResultPerson().setIncomeTest(incomingTest.getIncomeYear(), resultTest);
            }
        }
        this.mergeIncomeTestStatus(IncomeTestType.CODE_LTC_CO_PAY_TEST);
        this.mergeIncomeTestStatus(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST);
    }

    @Override
    public IncomeTest getPristinePrimaryIncomeTest() {
        return super.getPristineIncomeTest();
    }

    private IncomeThreshold getIncomeThresholdForComms() throws RuleException {
        IncomeTest incomeTest;
        if (this.incomeThresholdForComms == null && (incomeTest = this.getIncomeTest()) != null) {
            Integer year = incomeTest.getIncomeYear();
            Integer total = incomeTest.getTotalNumberOfDependents() != null ? incomeTest.getTotalNumberOfDependents() : new Integer(0);
            try {
                if (year != null) {
                    this.incomeThresholdForComms = this.getFinancialsHelperService().calculateIncomeThresholds(year, total);
                }
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to calculate income threshold", (Throwable)e);
            }
        }
        return this.incomeThresholdForComms;
    }

    private IncomeTest getPriorIncomeTest() throws RuleException {
        if (this.priorIncomeTest == null) {
            this.priorIncomeTest = this.getPriorIncomeTest(this.getIncomingPerson());
        }
        return this.priorIncomeTest;
    }

    private IncomeTest getPriorIncomeTest(Person person) throws RuleException {
        Validate.notNull((Object)((Object)person), (String)"A person must not be null ");
        try {
            Person prior = this.getPriorEEPerson();
            return prior != null ? this.getCurrentIncomeTest(prior) : null;
        }
        catch (ServiceException ex) {
            throw new RuleException("Error retrieving prior income test", (Throwable)ex);
        }
    }

    @Override
    public boolean hasIncomingSpouse() {
        return this.getIncomingSpouse() != null;
    }

    public Spouse getIncomingSpouse() {
        SpouseFinancials spouseFinancials;
        SpouseFinancials spouseFinancials2 = spouseFinancials = this.getIncomingFinancialStatement() != null ? this.getIncomingFinancialStatement().getActiveSpouseFinancials() : null;
        if (spouseFinancials == null) {
            this.logger.info((Object)"spouseFinancial is null");
            return null;
        }
        return spouseFinancials.getReportedOn();
    }

    @Override
    public Employment getIncomingSpouseEmployment() {
        if (this.getIncomingSpouse() == null) {
            return null;
        }
        return this.getIncomingSpouse().getEmployment();
    }

    public Spouse getResultSpouse() {
        if (this.getResultFinancialStatement() != null && this.getResultFinancialStatement().getActiveSpouseFinancials() != null) {
            SpouseFinancials spouseFinancials = this.getResultFinancialStatement().getActiveSpouseFinancials();
            return spouseFinancials.getReportedOn();
        }
        return null;
    }

    @Override
    public Employment getResultSpouseEmployment() {
        return this.getResultSpouse() == null ? null : this.getResultSpouse().getEmployment();
    }

    @Override
    public boolean isIncomeGreaterThanGMTplusRelaxPercent(float relaxPercent) throws ServiceException {
        boolean flag = true;
        try {
            BigDecimal netIncome = this.getCalculatedNetIncome();
            BigDecimal gmtthresholdVal = new BigDecimal(this.getNotNull(this.getCalculatedGMTThreshold()));
            BigDecimal gmtthresholdRelaxVal = this.percentageOf(gmtthresholdVal, relaxPercent);
            BigDecimal adjustedIncome = this.add(gmtthresholdVal, gmtthresholdRelaxVal);
            flag = this.isGreaterThan(netIncome, adjustedIncome);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error((Object)e);
            }
            throw new ServiceException((Throwable)e);
        }
        return flag;
    }

    @Override
    public boolean isIncomeGreaterThanMTTplusRelaxPercent(float relaxPercent) throws ServiceException {
        boolean flag = true;
        BigDecimal netIncome = this.getCalculatedNetIncome();
        Integer mtthresholdValDecimal = this.isUpdateFromGUI() ? new Integer(this.getNotNull(this.getCalculatedMTThreshold()).intValue()) : this.getMTThreshold(this.getIncomingIncomeTest());
        BigDecimal mtthresholdVal = new BigDecimal(mtthresholdValDecimal);
        BigDecimal thresholdRelaxVal = this.percentageOf(mtthresholdVal, relaxPercent);
        BigDecimal adjustedIncome = this.add(mtthresholdVal, thresholdRelaxVal);
        flag = this.isGreaterThan(netIncome, adjustedIncome);
        return flag;
    }

    @Override
    public boolean isIncomeGreaterThanGMTplusRelaxPercentForCE(float relaxPercent) throws ServiceException {
        boolean flag = true;
        IncomeTest test = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
        if (test != null) {
            flag = this.determineIfNetIncomeGreaterThanThresholdPlusRelaxPercentForCE(relaxPercent, test.getGmtThresholdAmount(), test);
        }
        return flag;
    }

    @Override
    public boolean isIncomeGreaterThanMTTplusRelaxPercentForCE(float relaxPercent) throws ServiceException {
        boolean flag = true;
        IncomeTest test = this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
        if (test != null) {
            flag = this.determineIfNetIncomeGreaterThanThresholdPlusRelaxPercentForCE(relaxPercent, test.getThresholdA(), test);
        }
        return flag;
    }

    private boolean determineIfNetIncomeGreaterThanThresholdPlusRelaxPercentForCE(float relaxPercent, BigDecimal threshold, IncomeTest test) throws ServiceException {
        boolean flag = true;
        if (test != null && threshold != null) {
            BigDecimal netIncome = test.getNetIncome();
            if (netIncome == null && !IncomeTestSource.CODE_IVM.getCode().equals(test.getSource().getCode())) {
                netIncome = this.calculateNetIncomeForCE(test);
            }
            if (netIncome != null) {
                BigDecimal thresholdRelaxVal = this.percentageOf(threshold, relaxPercent);
                BigDecimal adjustedIncome = this.add(threshold, thresholdRelaxVal);
                flag = this.isGreaterThan(netIncome, adjustedIncome);
            }
        }
        return flag;
    }

    @Override
    public boolean isDataFromZ07() {
        return this.isDataFromZ07;
    }

    @Override
    public void setDataFromZ07(boolean isDataFromZ07) {
        this.isDataFromZ07 = isDataFromZ07;
    }

    private boolean isIncomeGreaterThanGMTplusRelaxPercentForCE(float relaxPercent, IncomeTest incomeTest) throws ServiceException {
        boolean flag = true;
        if (incomeTest != null) {
            flag = this.determineIfNetIncomeGreaterThanThresholdPlusRelaxPercentForCE(relaxPercent, incomeTest.getGmtThresholdAmount(), incomeTest);
        }
        return flag;
    }

    public boolean isIncomeGreaterThanMTTplusRelaxPercentForCE(float relaxPercent, IncomeTest incomeTest) throws ServiceException {
        boolean flag = true;
        if (incomeTest != null) {
            flag = this.determineIfNetIncomeGreaterThanThresholdPlusRelaxPercentForCE(relaxPercent, incomeTest.getThresholdA(), incomeTest);
        }
        return flag;
    }

    @Override
    public boolean ifConditionsMetMakeFutureTestEffectiveImmediately() throws ServiceException {
        boolean shouldFDTBeMadeEffectiveImmediately = false;
        IncomeTest resultTest = this.getResultIncomeTest();
        FinancialInputData data = this.getFinancialInputData();
        if (data == null) {
            return false;
        }
        Map incomeTestMap = this.getResultPerson().getIncomeTests();
        Collection incomeTests = incomeTestMap.values();
        Iterator incomeTestsIterator = incomeTests.iterator();
        IncomeTest futureIncomeTest = null;
        while (incomeTestsIterator.hasNext()) {
            IncomeTest incomeTest = (IncomeTest)((Object)incomeTestsIterator.next());
            if (incomeTest.isFutureTest() == null || !incomeTest.isFutureTest().booleanValue()) continue;
            futureIncomeTest = incomeTest;
            break;
        }
        if (futureIncomeTest != null) {
            boolean isResultTestMeansTest = this.isTestTypeMeansTest(resultTest);
            boolean isFutureTestMeansTest = this.isTestTypeMeansTest(futureIncomeTest);
            boolean isResultTestRxTest = this.isTestTypePharmacyCopayTest(resultTest);
            boolean isFutureTestRxTest = this.isTestTypePharmacyCopayTest(futureIncomeTest);
            String resultMeansTestStatus = this.getMeansTestStatusCode(resultTest);
            String futureMeansTestStatus = this.getMeansTestStatusCode(futureIncomeTest);
            String resultRxCopayStatus = this.getPharmacyCopayStatusCode(resultTest);
            String futureRxCopayStatus = this.getPharmacyCopayStatusCode(futureIncomeTest);
            Integer incomeYear = this.getIncomeYear(futureIncomeTest);
            float relaxPercentage = this.getRelaxPercentage(incomeYear);
            if (isResultTestMeansTest && !this.isExpired(resultTest) && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(resultMeansTestStatus) && isFutureTestMeansTest && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(futureMeansTestStatus) && (this.isLessThan(this.calculateNetIncomeForCE(futureIncomeTest), futureIncomeTest.getThresholdA()) || this.isLessThan(futureIncomeTest.getThresholdA(), futureIncomeTest.getGmtThresholdAmount()) && !this.isIncomeGreaterThanGMTplusRelaxPercentForCE(relaxPercentage, futureIncomeTest) || !this.isIncomeGreaterThanMTTplusRelaxPercentForCE(relaxPercentage, futureIncomeTest))) {
                shouldFDTBeMadeEffectiveImmediately = true;
            }
            if (isResultTestMeansTest && !this.isExpired(resultTest) && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(resultMeansTestStatus) && isFutureTestMeansTest && MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(futureMeansTestStatus) && this.isLessThan(futureIncomeTest.getGmtThresholdAmount(), futureIncomeTest.getThresholdA()) && !this.isIncomeGreaterThanMTTplusRelaxPercentForCE(relaxPercentage, futureIncomeTest)) {
                shouldFDTBeMadeEffectiveImmediately = true;
            } else if (isResultTestMeansTest && !this.isExpired(resultTest) && MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getCode().equals(resultMeansTestStatus) && isFutureTestMeansTest && (MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode().equals(futureMeansTestStatus) || MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(futureMeansTestStatus) || this.isLessThan(futureIncomeTest.getThresholdA(), futureIncomeTest.getGmtThresholdAmount()) && MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(futureMeansTestStatus))) {
                shouldFDTBeMadeEffectiveImmediately = true;
            } else if (isResultTestMeansTest && !this.isExpired(resultTest) && this.isEqual(resultMeansTestStatus, futureMeansTestStatus) && MeansTestStatus.MT_STATUS_NON_EXEMPT.getName().equals(resultRxCopayStatus) && isFutureTestMeansTest && MeansTestStatus.MT_STATUS_EXEMPT.getName().equals(futureRxCopayStatus)) {
                shouldFDTBeMadeEffectiveImmediately = true;
            } else if (isResultTestMeansTest && !this.isExpired(resultTest) && MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(resultMeansTestStatus) && isFutureTestMeansTest && MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode().equals(futureMeansTestStatus)) {
                shouldFDTBeMadeEffectiveImmediately = true;
            } else if (isResultTestMeansTest && !this.isExpired(resultTest) && this.isEqual(resultMeansTestStatus, futureMeansTestStatus) && MeansTestStatus.MT_STATUS_INCOMPLETE_RX_COPAY_ONLY.getName().equals(resultRxCopayStatus) && isFutureTestMeansTest && (MeansTestStatus.MT_STATUS_EXEMPT.getName().equals(futureRxCopayStatus) || MeansTestStatus.MT_STATUS_NON_EXEMPT.getName().equals(futureRxCopayStatus))) {
                shouldFDTBeMadeEffectiveImmediately = true;
            } else if (isResultTestRxTest && !this.isExpired(resultTest) && MeansTestStatus.MT_STATUS_NON_EXEMPT.getName().equals(resultRxCopayStatus) && isFutureTestRxTest && MeansTestStatus.MT_STATUS_EXEMPT.getName().equals(futureRxCopayStatus)) {
                shouldFDTBeMadeEffectiveImmediately = true;
            }
            data.setExistingFDTTest(futureIncomeTest);
        }
        return shouldFDTBeMadeEffectiveImmediately;
    }

    @Override
    public void makeExistingFDTEffectiveImmediately() throws ServiceException {
        Date now = this.getCurrentDate();
        IncomeTest fdt = this.getExistingFDT();
        if (fdt != null) {
            Date testEffectiveDate = null;
            Calendar calendar = DateUtils.createCalendar((Date)now);
            int year = calendar.get(1);
            int month = calendar.get(2);
            int day = calendar.get(5);
            calendar.clear();
            calendar.set(year, month, day);
            testEffectiveDate = calendar.getTime();
            fdt.setEffectiveDate(testEffectiveDate);
            fdt.setPrimaryIncomeTest(Boolean.TRUE);
            fdt.setCompletedDate(now);
            fdt.setLastEditedDate(now);
            fdt.setFutureTest(new Boolean(false));
        }
    }

    @Override
    public IncomeTest getExistingFDT() throws ServiceException {
        return this.getFinancialInputData() != null ? this.getFinancialInputData().getExistingFDTTest() : null;
    }

    @Override
    public boolean isSpouseAddressAfter() {
        if (this.getIncomingSpouse() == null) {
            return false;
        }
        Address incomingAddress = this.getIncomingSpouse().getAddress();
        if (incomingAddress == null) {
            return true;
        }
        if (this.getResultSpouse() == null) {
            return true;
        }
        Address onFileAddress = this.getResultSpouse().getAddress();
        if (onFileAddress == null) {
            return true;
        }
        Date incoming = incomingAddress.getChangeDate();
        Date current = onFileAddress.getChangeDate();
        return this.isAfter(incoming, current);
    }

    public void setResultSpouse(Spouse resultSpouse) {
        if (this.getResultFinancialStatement() != null) {
            SpouseFinancials spouseFinancials = this.getResultFinancialStatement().getActiveSpouseFinancials();
            spouseFinancials.setReportedOn(resultSpouse);
        }
    }

    @Override
    public void updateSpouseAddress() throws ServiceException {
        if (this.getIncomingSpouse() != null && this.getResultSpouse() != null) {
            this.getMergeRuleService().mergeSpouseAddress(this.getIncomingSpouse(), this.getResultSpouse());
        }
    }

    @Override
    public void setSpouseOccupation(Employment incoming, Employment result) {
        if (incoming != null && incoming != null) {
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                result.setOccupation(incoming.getOccupation());
            }
        }
    }

    @Override
    public void setSpouseDateOfRetirement(Employment incoming, Employment result) {
        if (incoming != null) {
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                result.setRetirementDate(incoming.getRetirementDate());
            }
        }
    }

    private Employment getOrCreateSpouseEmployment() {
        Spouse spouse = this.getResultSpouse();
        if (spouse != null) {
            Employment result = spouse.getEmployment();
            if (result == null) {
                result = new Employment();
                spouse.setEmployment(result);
            }
            return result;
        }
        return null;
    }

    @Override
    public void setSpouseEmployerAddressCity(Employment incoming, Employment result) {
        if (incoming != null && incoming.getEmployerAddress() != null) {
            Address incomingAddress = incoming.getEmployerAddress();
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                Address address = result.getEmployerAddress();
                if (address == null) {
                    address = new Address();
                    result.setEmployerAddress(address);
                }
                address.setCity(incomingAddress.getCity());
            }
        }
    }

    @Override
    public void setSpouseEmployerAddressLine1(Employment incoming, Employment result) {
        if (incoming != null && incoming.getEmployerAddress() != null) {
            Address incomingAddress = incoming.getEmployerAddress();
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                Address address = result.getEmployerAddress();
                if (address == null) {
                    address = new Address();
                    result.setEmployerAddress(address);
                }
                address.setLine1(incomingAddress.getLine1());
            }
        }
    }

    @Override
    public void setSpouseEmployerAddressLine2(Employment incoming, Employment result) {
        if (incoming != null && incoming.getEmployerAddress() != null) {
            Address incomingAddress = incoming.getEmployerAddress();
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                Address address = result.getEmployerAddress();
                if (address == null) {
                    address = new Address();
                    result.setEmployerAddress(address);
                }
                address.setLine2(incomingAddress.getLine2());
            }
        }
    }

    @Override
    public void setSpouseEmployerAddressLine3(Employment incoming, Employment result) {
        if (incoming != null && incoming.getEmployerAddress() != null) {
            Address incomingAddress = incoming.getEmployerAddress();
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                Address address = result.getEmployerAddress();
                if (address == null) {
                    address = new Address();
                    result.setEmployerAddress(address);
                }
                address.setLine3(incomingAddress.getLine3());
            }
        }
    }

    @Override
    public void setSpouseEmployerAddressState(Employment incoming, Employment result) {
        if (incoming != null && incoming.getEmployerAddress() != null) {
            Address incomingAddress = incoming.getEmployerAddress();
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                Address address = result.getEmployerAddress();
                if (address == null) {
                    address = new Address();
                    result.setEmployerAddress(address);
                }
                address.setState(incomingAddress.getState());
            }
        }
    }

    @Override
    public void setSpouseEmployerAddressZip(Employment incoming, Employment result) {
        if (incoming != null && incoming.getEmployerAddress() != null) {
            Address incomingAddress = incoming.getEmployerAddress();
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                Address address = result.getEmployerAddress();
                if (address == null) {
                    address = new Address();
                    result.setEmployerAddress(address);
                }
                address.setZipCode(incomingAddress.getZipCode());
            }
        }
    }

    @Override
    public void setSpouseEmployerName(Employment incoming, Employment result) {
        if (incoming != null) {
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                result.setEmployerName(incoming.getEmployerName());
            }
        }
    }

    @Override
    public void setSpouseEmployerPhoneNumber(Employment incoming, Employment result) {
        if (incoming != null) {
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                result.setEmployerPhone(incoming.getEmployerPhone());
            }
        }
    }

    @Override
    public void setSpouseEmploymentStatus(Employment incoming, Employment result) {
        if (incoming != null) {
            if (result == null) {
                result = this.getOrCreateSpouseEmployment();
            }
            if (result != null) {
                result.setEmploymentStatus(incoming.getEmploymentStatus());
            }
        }
    }

    @Override
    public boolean isSpouseHomePhoneAfter() {
        if (this.getIncomingSpouse() == null) {
            return false;
        }
        Phone incomingPhone = this.getIncomingSpouse().getHomePhone();
        if (incomingPhone == null) {
            return false;
        }
        if (this.getResultSpouse() == null) {
            return true;
        }
        Phone onFilePhone = this.getResultSpouse().getHomePhone();
        if (onFilePhone == null) {
            return true;
        }
        Date incoming = incomingPhone.getChangeDate();
        Date current = onFilePhone.getChangeDate();
        return this.isAfter(incoming, current);
    }

    @Override
    public Employment getPristineSpouseEmployment() {
        SpouseFinancials spouseFinancials;
        FinancialStatement pristineStatement = this.getFinancialStatement(this.getPristinePerson(), this.getIncomingIncomeYear());
        SpouseFinancials spouseFinancials2 = spouseFinancials = pristineStatement != null ? pristineStatement.getActiveSpouseFinancials() : null;
        if (spouseFinancials == null) {
            return null;
        }
        Spouse spouse = spouseFinancials.getReportedOn();
        if (spouse == null) {
            return null;
        }
        return spouse.getEmployment();
    }

    @Override
    public void updateSpouseHomePhone() throws ServiceException {
        if (this.getIncomingSpouse() != null && this.getResultSpouse() != null) {
            this.getMergeRuleService().mergeSpouseHomePhone(this.getIncomingSpouse(), this.getResultSpouse());
        }
    }

    @Override
    public boolean hasPrimaryMeansTest() {
        IncomeTest onFile = this.getPristineIncomeTest();
        return this.isPrimary(onFile) && this.isTestTypeMeansTest(onFile);
    }

    @Override
    public boolean isVoaDiscloseFinancialDataNo() throws UnknownLookupTypeException, UnknownLookupCodeException {
        Boolean disclosure = this.getDisclosure(this.getIncomeTest());
        if (Boolean.FALSE.equals(disclosure)) {
            this.setMeansTestStatus(MeansTestStatus.MT_STATUS_MT_COPAY_REQUIRED.getName());
            return true;
        }
        return false;
    }

    @Override
    public void preProcessVOAFinancialData() throws RuleException {
        this.preProcessIncomeTestDateAndSource();
        this.preProcessLivedWithPatientForSpouse();
        this.preProcessDependentFinancials();
    }

    private void preProcessLivedWithPatientForSpouse() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt != null && stmt.getSpouseFinancials() != null) {
            for (SpouseFinancials sf : stmt.getSpouseFinancials()) {
                if (sf == null) continue;
                if (Boolean.TRUE.equals(stmt.getContributedToSpouseInd()) || stmt.getContributionToSpouse() != null && stmt.getContributionToSpouse().longValue() > 0L) {
                    sf.setLivedWithPatient(Boolean.FALSE);
                    stmt.setContributedToSpouseInd(Boolean.TRUE);
                    continue;
                }
                sf.setLivedWithPatient(Boolean.TRUE);
                stmt.setContributedToSpouseInd(Boolean.FALSE);
            }
        }
    }

    private void preProcessDependentFinancials() {
        FinancialStatement stmt = this.getIncomingFinancialStatement();
        if (stmt == null) {
            return;
        }
        ArrayList<DependentFinancials> stList = new ArrayList<DependentFinancials>();
        Date dependentDOB = null;
        GregorianCalendar today = new GregorianCalendar();
        GregorianCalendar eighteenYearAgo = (GregorianCalendar)today.clone();
        eighteenYearAgo.set(1, today.get(1) - 18);
        eighteenYearAgo.set(6, today.get(5) - 1);
        GregorianCalendar twentyThreeYearAgo = (GregorianCalendar)today.clone();
        twentyThreeYearAgo.set(1, today.get(1) - 23);
        twentyThreeYearAgo.set(6, today.get(5) - 1);
        Set dfSet = stmt.getDependentFinancials();
        for (DependentFinancials df : dfSet) {
            dependentDOB = this.getRelationBirthDate(df.getReportedOn());
            if (!(dependentDOB != null && DateUtils.isBeforeIgnoreTime((Date)eighteenYearAgo.getTime(), (Date)dependentDOB) || df.getIncapableOfSelfSupport() != null && df.getIncapableOfSelfSupport() != false) && (df.getAttendedSchool() == null || !df.getAttendedSchool().booleanValue() || dependentDOB == null || !DateUtils.isDateBetween((Date)dependentDOB, (Date)eighteenYearAgo.getTime(), (Date)twentyThreeYearAgo.getTime()) || !df.isActive())) continue;
            stList.add(df);
            this.preProcessDependentFinancials(df);
        }
        stmt.removeAllDependentFinancials();
        Iterator iter = stList.iterator();
        while (iter.hasNext()) {
            stmt.addDependentFinancials((DependentFinancials)((Object)iter.next()));
        }
    }

    private void preProcessDependentFinancials(DependentFinancials df) {
        if (df != null) {
            if (df.getTotalEmploymentIncome() != null && df.getTotalEmploymentIncome().getAmount() != null && df.getTotalEmploymentIncome().getAmount().longValue() > 0L) {
                df.setHasIncome(Boolean.TRUE);
            } else {
                df.setHasIncome(Boolean.FALSE);
            }
            if (Boolean.TRUE.equals(df.getContributedToSupport()) || df.getAmountContributedToSupport() != null && df.getAmountContributedToSupport().longValue() > 0L) {
                df.setLivedWithPatient(Boolean.FALSE);
                df.setContributedToSupport(Boolean.TRUE);
            } else {
                df.setLivedWithPatient(Boolean.TRUE);
                df.setContributedToSupport(Boolean.FALSE);
            }
        }
    }

    private void preProcessIncomeTestDateAndSource() throws RuleException {
        IncomeTest it = this.getIncomeTest();
        IncomeTest currIncomeTest = null;
        if (it == null) {
            currIncomeTest = this.getResultPerson().getIncomeTest(new Integer(Calendar.getInstance().get(1) - 1));
        }
        if (it.getDiscloseFinancialInformation().equals(Boolean.FALSE) || currIncomeTest != null && currIncomeTest.getDiscloseFinancialInformation().equals(Boolean.FALSE)) {
            try {
                it.setSiteConductingTest(this.getLookupService().getVaFacilityByStationNumber(VAFacility.CODE_HEC.getCode()));
                it.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_HEC.getCode()));
                it.setType(this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getCode()));
                it.setIncomeYear(this.getIncomingIncomeYear());
                this.getIncomingPerson().setIncomeTest(this.getIncomingIncomeYear(), it);
            }
            catch (UnknownLookupTypeException e) {
                throw new RuleException("Can not set Income Test Source/Type of Test HEC", (Throwable)((Object)e));
            }
            catch (UnknownLookupCodeException ex) {
                throw new RuleException("Can not set Income Test Source/Type of Test HEC", (Throwable)((Object)ex));
            }
        }
        if (currIncomeTest == null) {
            it = new IncomeTest();
        }
        Date rightNow = Calendar.getInstance().getTime();
        it.setCompletedDate(rightNow);
        it.setEffectiveDate(rightNow);
        it.setSiteConductingTest(null);
        try {
            it.setSource(this.getLookupService().getIncomeTestSourceByCode(IncomeTestSource.CODE_VOA.getCode()));
            it.setType(this.getLookupService().getIncomeTestTypeByCode(IncomeTestType.CODE_MEANS_TEST.getCode()));
            it.setDiscloseFinancialInformation(Boolean.TRUE);
            it.setAgreesToPayDeductible(Boolean.TRUE);
        }
        catch (Exception ex) {
            throw new RuleException("Can not set Income Test Source/Type of Test VOA", (Throwable)ex);
        }
        it.setIncomeYear(this.getIncomingIncomeYear());
        this.getIncomingPerson().setIncomeTest(this.getIncomingIncomeYear(), it);
    }

    @Override
    public boolean isPharmacyCopayStatusChanged() throws ServiceException {
        String pristineCopayStatus = null;
        String resultCopayStatus = null;
        IncomeTest pIcomeTest = this.getCurrentIncomeTest(this.getPristinePerson());
        IncomeTest resultIcomeTest = this.getCurrentIncomeTest(this.getResultPerson());
        if (pIcomeTest != null) {
            pristineCopayStatus = this.getPharmacyCopayStatusCode(pIcomeTest);
        }
        if (resultIcomeTest != null) {
            resultCopayStatus = this.getPharmacyCopayStatusCode(resultIcomeTest);
        }
        if (pristineCopayStatus == null && resultCopayStatus == null) {
            return false;
        }
        if (pristineCopayStatus == null && resultCopayStatus != null) {
            return true;
        }
        if (pristineCopayStatus != null && resultCopayStatus == null) {
            return true;
        }
        return !pristineCopayStatus.equals(resultCopayStatus);
    }

    @Override
    public IncomeTest getIncomeTestFutureTestIncluded() {
        return this.getIncomingIncludingFutureIncomeTest();
    }

    private class AdjudicationResponseRequiredException
    extends ServiceException {
        private static final long serialVersionUID = -3676890144455555033L;

        public AdjudicationResponseRequiredException(String msg) {
            super(msg);
        }
    }
}

