/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.Eligibility;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.HealthBenefitPlan;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.AgentOrangeExposureLocation;
import gov.va.med.esr.common.model.lookup.DataChangeSource;
import gov.va.med.esr.common.model.lookup.EligibilityType;
import gov.va.med.esr.common.model.lookup.EnrollmentCategory;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.registry.Registry;
import gov.va.med.esr.common.rule.EnrollmentInput;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.util.EnrollmentDeterminationComparatorByEntityKeyValue;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.RegistrySearchCriteria;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.rule.RuleConfigurationException;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class EnrollmentInputParameter
extends BaseParameter
implements EnrollmentInput {
    private static final long serialVersionUID = -5776487792673041771L;
    private static final String TEN_PERCENT = "10";
    private static final int MAX_ALLOWED_RECORDS = 20;
    private EnrollmentDetermination resultEnrollmentDetermination = null;
    private EnrollmentDetermination incomingEnrollmentDetermination = null;
    private EnrollmentDetermination ceEnrollmentDetermination = null;
    private EnrollmentDetermination pristineEnrollmentDetermination = null;
    private String cancelDecline = null;
    private String calculatedPrimaryEligibilityCode = null;
    private String receivedPrimaryEligibilityCode = null;
    private String currentPrimaryEligibilityCode = null;
    private String mostRecentPriorityGroupOfVerifiedEnrollment = null;
    private String mostRecentPrioritySubGroupOfVerifiedEnrollment = null;
    private Date applicationDate = null;
    private Date earliestUnverifiedApplicationDate = null;
    private Date earliestEffDateForVerifiedUnlessCancelled = null;
    private Boolean hasEverHadVerifiedEnrollment = null;
    private Date cancelledDeclinedDate = null;
    private static final String VETERAN = "V";
    private static final String NONVETERAN = "N";
    private String priorEnrollmentPriority = null;
    private Date earliestEnrollmentEffectiveDate = null;
    private Date earliestVerifiedEnrollmentDate = null;
    private String mostRecentNonNullPriorityCode = null;
    private HealthBenefitProfile pristineHealthBenefitProfile = null;

    @Override
    public boolean getVeteranIndicator() {
        return this.getIncomingPerson().getVeteran() != null ? this.getIncomingPerson().getVeteran() : false;
    }

    @Override
    public boolean getResultVeteranIndicator() {
        return this.getResultPerson().getVeteran() != null ? this.getResultPerson().getVeteran() : false;
    }

    @Override
    public boolean getPristineVeteranIndicator() {
        return this.getPristinePerson().getVeteran() != null ? this.getPristinePerson().getVeteran() : false;
    }

    @Override
    public EnrollmentDetermination getCalculatedEnrollmentDetermination() throws RuleException {
        return this.getResultEnrollmentDetermination();
    }

    @Override
    public void setEnrollmentPriority(String value) throws RuleException {
        try {
            if (value == null) {
                this.getResultEnrollmentDetermination().setPriorityGroup(null);
            } else {
                this.getHelperService().setEnrollmentPriority(value, this.getResultEnrollmentDetermination());
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set enrollment priority", (Throwable)e);
        }
    }

    @Override
    public void setSubPriority(String code) throws RuleException {
        try {
            if (code == null) {
                this.getResultEnrollmentDetermination().setPrioritySubGroup(null);
            } else {
                this.getHelperService().setEnrollmentPrioritySubGroup(code, this.getResultEnrollmentDetermination());
            }
        }
        catch (ServiceException e) {
            throw new RuleException("failed to set sub priority", (Throwable)e);
        }
    }

    @Override
    public void addToOtherEligibilityList(String value) throws RuleException {
        try {
            Eligibility eligibility = this.getHelperService().createOtherEligibility(value);
            if (!this.containsEligibility(this.getResultEnrollmentDetermination().getOtherEligibilities(), eligibility)) {
                this.getResultEnrollmentDetermination().addOtherEligibility(eligibility);
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to add to other eligibility list", (Throwable)e);
        }
    }

    @Override
    public void addHBPToList(String hbpCodeStr) throws RuleException {
        try {
            HealthBenefitPlan newPlan = new HealthBenefitPlan();
            newPlan.setPlanType(this.getLookupService().getHealthBenefitPlanTypeByCode(hbpCodeStr));
            newPlan.setChangeDate(new Date());
            newPlan.setChangeSource((DataChangeSource)this.getLookupService().getByCode(DataChangeSource.class, DataChangeSource.CODE_ESR.getCode()));
            this.getIncomingPerson().getHealthBenefitProfile().addHealthBenefitPlan(newPlan);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to add to health benefit Plan list", (Throwable)e);
        }
    }

    @Override
    public void removeHBPFromList(String hbpCodeStr) throws RuleException {
        try {
            HealthBenefitPlanType planTypeByCodeStr = this.getLookupService().getHealthBenefitPlanTypeByCode(hbpCodeStr);
            if (planTypeByCodeStr != null) {
                this.getIncomingPerson().getHealthBenefitProfile().removeHealthBenefitPlanByType(planTypeByCodeStr);
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to remove from health benefit Plan list", (Throwable)e);
        }
    }

    @Override
    public void addToSecondaryEligibilityList(String value) throws RuleException {
        try {
            Eligibility eligibility = this.getHelperService().createEligibility(value);
            if (!this.containsEligibility(this.getResultEnrollmentDetermination().getSecondaryEligibilities(), eligibility)) {
                this.getResultEnrollmentDetermination().addSecondaryEligibility(eligibility);
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to add to secondary eligibility list", (Throwable)e);
        }
    }

    @Override
    public boolean hasReceivedEligibilityCodeEqualTo(String eligibilityCode) {
        Person incoming = this.getIncomingPerson();
        boolean found = this.containsReceivedEligibility(incoming.getReceivedSecondaryEligibilities(), eligibilityCode);
        if (!found) {
            ReceivedEligibility primary = incoming.getReceivedPrimaryEligibility();
            found = primary != null && primary.getType() != null && primary.getType().getCode().equals(eligibilityCode);
        }
        return found;
    }

    @Override
    public void setPrimaryEligilityCode(String value) throws RuleException {
        try {
            this.getResultEnrollmentDetermination().setPrimaryEligiblity(this.getHelperService().createEligibility(value));
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set primary eligibility code", (Throwable)e);
        }
    }

    @Override
    public String getCalculatedPrimaryEligibilityCode() throws RuleException {
        if (this.calculatedPrimaryEligibilityCode == null) {
            Eligibility eligibility = this.getResultEnrollmentDetermination().getPrimaryEligibility();
            this.calculatedPrimaryEligibilityCode = eligibility != null && eligibility.getType() != null ? eligibility.getType().getCode() : null;
        }
        return this.calculatedPrimaryEligibilityCode;
    }

    @Override
    public String getIncomingPrimaryEligibilityCode() throws RuleException {
        Eligibility eligibility = this.getIncomingEnrollmentDetermination().getPrimaryEligibility();
        String result = eligibility != null && eligibility.getType() != null ? eligibility.getType().getCode() : null;
        this.logger.debug((Object)result);
        return result;
    }

    @Override
    public String getReceivedPrimaryEligibilityCode() {
        if (this.receivedPrimaryEligibilityCode == null) {
            this.receivedPrimaryEligibilityCode = this.getReceivedPrimaryEligibilityCode(this.getIncomingPerson());
        }
        return this.receivedPrimaryEligibilityCode;
    }

    @Override
    public Date getApplicationDate() {
        if (this.applicationDate == null) {
            this.applicationDate = this.getIncomingPerson().getApplication() != null ? this.getIncomingPerson().getApplication().getApplicationDate() : null;
        }
        return this.applicationDate;
    }

    @Override
    public Date getReceivedEnrollmentDate() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEnrollmentDate() : null;
    }

    @Override
    public Date getReceivedEnrollmentEffectiveDate() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEnrollmentDate() : null;
    }

    @Override
    public String getReceivedEnrollmentStatus() throws RuleConfigurationException {
        EnrollmentStatus enrollmentStatus = this.getReceivedEnrollment(this.getIncomingPerson()) != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEnrollmentStatus() : null;
        return enrollmentStatus != null ? enrollmentStatus.getCode() : null;
    }

    @Override
    public String getCancelledDeclinedReason() {
        CancelDecline cd = this.getIncomingPerson().getCancelDecline();
        return cd != null && cd.getReason() != null ? cd.getReason().getCode() : null;
    }

    @Override
    public String getCancelledDeclined() {
        if (this.cancelDecline == null) {
            this.cancelDecline = this.getCancelDecline(this.getIncomingPerson());
        }
        return this.cancelDecline;
    }

    @Override
    public Date getCancelledDeclinedDate() {
        if (this.cancelledDeclinedDate == null) {
            this.cancelledDeclinedDate = this.getCancelledDeclinedDate(this.getIncomingPerson());
        }
        return this.cancelledDeclinedDate;
    }

    @Override
    public String getPrimaryEligibilityCodeFromSite() throws RuleException {
        return this.getReceivedPrimaryEligibilityCode();
    }

    @Override
    public Date getApplicationDateFromVAMC() {
        return this.getApplicationDate();
    }

    @Override
    public Date getEnrollmentDate() {
        return this.getIncomingEnrollmentDetermination() != null ? this.getIncomingEnrollmentDetermination().getEnrollmentDate() : null;
    }

    @Override
    public Date getEnrollmentDateFromVAMC() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEnrollmentDate() : null;
    }

    @Override
    public Date getEnrollmentEffectiveDate() {
        return this.getIncomingEnrollmentDetermination() != null ? this.getIncomingEnrollmentDetermination().getEffectiveDate() : null;
    }

    @Override
    public Date getEnrollmentEffectiveDateFromVAMC() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEffectiveDate() : null;
    }

    @Override
    public Date getEnrollmentEndDateFromVAMC() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEndDate() : null;
    }

    @Override
    public String getEnrollmentPriority() throws RuleException {
        return this.getResultEnrollmentDetermination() != null && this.getResultEnrollmentDetermination().getPriorityGroup() != null ? this.getResultEnrollmentDetermination().getPriorityGroup().getCode() : null;
    }

    @Override
    public String getCalculatedEnrollmentStatus() throws RuleException {
        return this.getResultEnrollmentDetermination() != null && this.getResultEnrollmentDetermination().getEnrollmentStatus() != null ? this.getResultEnrollmentDetermination().getEnrollmentStatus().getCode() : null;
    }

    @Override
    public String getEnrollmentPriority(Person person) throws RuleException {
        EnrollmentDetermination ed = person != null ? person.getEnrollmentDetermination() : null;
        return ed != null && ed.getPriorityGroup() != null ? ed.getPriorityGroup().getCode() : null;
    }

    @Override
    public String getEnrollmentPriorityFromVAMC() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null && this.getReceivedEnrollment(this.getIncomingPerson()).getPriorityGroup() != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getPriorityGroup().getCode() : null;
    }

    @Override
    public String getEnrollmentSourceFromMessage() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null && this.getReceivedEnrollment(this.getIncomingPerson()).getCalculationSource() != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getCalculationSource().getCode() : null;
    }

    @Override
    public String getEnrollmentStatus() throws RuleException {
        return this.getEnrollmentStatusCode(this.getIncomingPerson());
    }

    @Override
    public String getEnrollmentStatusFromVAMC() {
        String code = null;
        if (this.getReceivedEnrollment(this.getIncomingPerson()) != null && this.getReceivedEnrollment(this.getIncomingPerson()).getEntityKey() == null) {
            code = this.getReceivedEnrollment(this.getIncomingPerson()).getEnrollmentStatus() != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getEnrollmentStatus().getCode() : null;
        }
        return code;
    }

    @Override
    public String getEnrollmentSubPriority() throws RuleException {
        return this.getResultEnrollmentDetermination() != null && this.getResultEnrollmentDetermination().getPrioritySubGroup() != null ? this.getResultEnrollmentDetermination().getPrioritySubGroup().getCode() : null;
    }

    @Override
    public String getEnrollmentSubPriorityFromVAMC() {
        return this.getReceivedEnrollment(this.getIncomingPerson()) != null && this.getReceivedEnrollment(this.getIncomingPerson()).getPrioritySubGroup() != null ? this.getReceivedEnrollment(this.getIncomingPerson()).getPrioritySubGroup().getCode() : null;
    }

    @Override
    public Date getMostRecentUnverifiedApplicationDate() throws RuleException {
        if (this.earliestUnverifiedApplicationDate == null) {
            Date date = this.earliestUnverifiedApplicationDate = this.getIncomingPerson().getApplication() != null ? this.getIncomingPerson().getApplication().getApplicationDate() : null;
            if (this.earliestUnverifiedApplicationDate == null) {
                this.earliestUnverifiedApplicationDate = this.getEarliestUnverifiedEnrollmentApplicationDate();
            }
        }
        return this.earliestUnverifiedApplicationDate;
    }

    @Override
    public Date getPreviousEnrollmentDate() {
        Date previous;
        Date date = previous = this.getPristineEnrollmentDetermination() != null ? this.getPristineEnrollmentDetermination().getEnrollmentDate() : null;
        if (previous == null) {
            previous = new Date();
        }
        return previous;
    }

    @Override
    public String getPreviousEnrollmentPriority() {
        return this.getPristineEnrollmentDetermination() != null && this.getPristineEnrollmentDetermination().getPriorityGroup() != null ? this.getPristineEnrollmentDetermination().getPriorityGroup().getCode() : null;
    }

    @Override
    public String getEnrollmentPriorityBeforePH() throws RuleException {
        String priority = null;
        Person person = this.getIncomingPerson();
        if (person != null && person.getEntityKey() != null) {
            try {
                String[] priGrps = this.getEligibilityEnrollmentService().getEnrollmentPriorityBeforePH(person.getEntityKey());
                if (priGrps != null) {
                    priority = priGrps[0];
                }
            }
            catch (ServiceException serviceEx) {
                throw new RuleException("Error getting enrollment priority before PH was added", (Throwable)serviceEx);
            }
        }
        return priority;
    }

    @Override
    public String getPreviousEnrollmentStatus() throws RuleException {
        return this.getEnrollmentStatusCode(this.getPristinePerson());
    }

    @Override
    public String getPreviousEnrollmentSubPriority() {
        return this.getPristineEnrollmentDetermination() != null && this.getPristineEnrollmentDetermination().getPrioritySubGroup() != null ? this.getPristineEnrollmentDetermination().getPrioritySubGroup().getCode() : null;
    }

    @Override
    public boolean hasPreviousVerifiedEnrollmentStatus() throws RuleException {
        return this.getEnrollmentStatusCode(this.getPristinePerson()) != null && this.getEnrollmentStatusCode(this.getPristinePerson()).equals(EnrollmentStatus.CODE_VERIFIED.getName());
    }

    @Override
    public boolean hasPriorVerifiedEnrollmentStatus() throws RuleException {
        return this.hasEverHadVerifiedEnrollment();
    }

    @Override
    public void setApplicationDate(Date applicationDate) {
        Application application = this.getResultPerson().getApplication();
        if (application != null || applicationDate != null) {
            if (application == null) {
                application = new Application();
                this.getResultPerson().setApplication(application);
            }
            application.setApplicationDate(applicationDate);
        }
    }

    @Override
    public void setEnrollmentCategory(String category) throws RuleException {
        try {
            this.getHelperService().setEnrollmentCategory(category, this.getResultEnrollmentDetermination());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set enrollment category", (Throwable)e);
        }
    }

    @Override
    public void setEnrollmentDate(Date enrollmentDate) throws RuleException {
        this.getResultEnrollmentDetermination().setEnrollmentDate(enrollmentDate);
    }

    @Override
    public void setEnrollmentEffectiveDate(Date effectiveDate) throws RuleException {
        this.getResultEnrollmentDetermination().setEffectiveDate(effectiveDate);
    }

    @Override
    public void setEnrollmentEndDate(Date enrollmentEndDate) throws RuleException {
        this.getResultEnrollmentDetermination().setEndDate(enrollmentEndDate);
    }

    @Override
    public void setEnrollmentSource(String source) throws RuleException {
        try {
            this.getHelperService().setEnrollmentSource(source, this.getResultEnrollmentDetermination());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set enrollment source", (Throwable)e);
        }
    }

    @Override
    public void setEnrollmentStatus(String status) throws RuleException {
        try {
            this.getHelperService().setEnrollmentStatus(status, this.getResultEnrollmentDetermination());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set enrollment status", (Throwable)e);
        }
    }

    public void setFacilityReceivedFrom(VAFacility.Code facility) throws RuleException {
        Validate.notNull((Object)((Object)facility), (String)"A facility must not be null");
        this.setFacilityReceivedFrom(facility.getName());
    }

    @Override
    public void setFacilityReceivedFrom(String facility) throws RuleException {
        try {
            this.getHelperService().setFacilityReceivedFrom(facility, this.getResultEnrollmentDetermination());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set facility received", (Throwable)e);
        }
    }

    @Override
    public void setFacilityReceivedToHEC() throws RuleException {
        this.setFacilityReceivedFrom(VAFacility.CODE_HEC);
    }

    @Override
    public void removeVeteranReceivedEligibilityCodes() {
        HashSet<ReceivedEligibility> toRemove = new HashSet<ReceivedEligibility>();
        Set onFiles = this.getResultPerson().getReceivedSecondaryEligibilities();
        for (ReceivedEligibility re : onFiles) {
            boolean found = false;
            for (ReceivedEligibility incoming : this.getIncomingPerson().getReceivedSecondaryEligibilities()) {
                if (!this.getMergeRuleService().getMatchRuleService().match((AbstractEntity)re, (AbstractEntity)incoming)) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(re);
        }
        for (ReceivedEligibility remove : toRemove) {
            this.getResultPerson().removeReceivedSecondaryEligibility(remove);
        }
    }

    @Override
    public void updateVeteranReceivedEligibilityCodes() throws RuleException {
        Person incoming = this.getIncomingPerson();
        Person onFile = this.getResultPerson();
        try {
            this.getMergeRuleService().mergeReceivedEligibility(incoming, onFile);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to merge received eligibilities", (Throwable)e);
        }
    }

    @Override
    public boolean isContainedReceivedEligibilityCode(String codes) {
        Set eligs = this.getReceivedEligibilities(this.getIncomingPerson());
        return this.codesAreValid(eligs, codes);
    }

    @Override
    public boolean isContainedVeteranReceivedEligibilityCode(String codes) {
        boolean result = false;
        Set eligs = this.getReceivedEligibilities(this.getResultPerson());
        boolean valid = this.codesAreValid(eligs, codes);
        if (valid) {
            result = this.matchReceivedEligibilities(this.getIncomingPerson(), this.getResultPerson());
        }
        return result;
    }

    public EnrollmentDetermination getEnrollmentDetermination(Person person) {
        return this.getHelperService().getEnrollmentDetermination(person);
    }

    @Override
    public Date getCurrentApplicationDateOnFile() {
        Application application = this.getApplication(this.getPristinePerson());
        return application != null ? application.getApplicationDate() : null;
    }

    @Override
    public Date getCurrentEffDateOnFile() {
        EnrollmentDetermination ed = this.getEnrollmentDetermination(this.getPristinePerson());
        return ed != null ? ed.getEffectiveDate() : null;
    }

    @Override
    public String getCurrentEnrollmentStatusOnFile() throws RuleException {
        return this.getEnrollmentStatusCode(this.getPristinePerson());
    }

    @Override
    public Date getEarliestEnrollmentEffectiveDate() throws RuleException {
        if (this.earliestEnrollmentEffectiveDate == null) {
            try {
                EligibilityEnrollmentService enrollmentService = this.getEligibilityEnrollmentService();
                Person person = this.getIncomingPerson();
                if (person != null && person.getEntityKey() != null) {
                    this.earliestEnrollmentEffectiveDate = enrollmentService.getFirstNotNullEffDate(this.getIncomingPerson().getEntityKey());
                }
            }
            catch (ServiceException serviceEx) {
                throw new RuleException("Error getting earliest enrollment effective date", (Throwable)serviceEx);
            }
        }
        return this.earliestEnrollmentEffectiveDate;
    }

    @Override
    public Date getEffectiveDateForEarliestVerifiedUnlessCancelled() throws RuleException {
        Date earliestEnrollEffectiveDate = null;
        try {
            EligibilityEnrollmentService enrollmentService = this.getEligibilityEnrollmentService();
            Person person = this.getIncomingPerson();
            if (person != null && person.getEntityKey() != null) {
                earliestEnrollEffectiveDate = enrollmentService.getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(this.getIncomingPerson().getEntityKey());
            }
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting earliest enrollment effective date", (Throwable)serviceEx);
        }
        return earliestEnrollEffectiveDate;
    }

    @Override
    public Date getEarliestVerifiedEnrollmentDate() throws RuleException {
        if (this.earliestVerifiedEnrollmentDate == null) {
            try {
                EligibilityEnrollmentService enrollmentService = this.getEligibilityEnrollmentService();
                Person person = this.getIncomingPerson();
                if (person != null && person.getEntityKey() != null) {
                    this.earliestVerifiedEnrollmentDate = enrollmentService.getEnrollmentDateForEarliestVerifiedUnlessCancelled(person.getEntityKey());
                }
            }
            catch (ServiceException serviceEx) {
                throw new RuleException("Error getting earliest verified enrollment date", (Throwable)serviceEx);
            }
        }
        return this.earliestVerifiedEnrollmentDate;
    }

    @Override
    public boolean hasEverHadVerifiedEnrollment() throws RuleException {
        if (this.hasEverHadVerifiedEnrollment == null) {
            try {
                boolean tmp = this.getEligibilityEnrollmentService().isVerifiedEnrollmentExists(this.getIncomingPerson().getEntityKey());
                this.hasEverHadVerifiedEnrollment = new Boolean(tmp);
            }
            catch (ServiceException ex) {
                throw new RuleException("Error getting verified enrollment", (Throwable)ex);
            }
        }
        return this.hasEverHadVerifiedEnrollment != null ? this.hasEverHadVerifiedEnrollment : false;
    }

    @Override
    public Boolean getEnrollmentOverridenOnFile() {
        EnrollmentOverride eo = this.getEnrollmentOverride(this.getPristinePerson());
        return eo != null ? eo.getOverride() : Boolean.FALSE;
    }

    @Override
    public void setEnrollmentOverriden(boolean b) throws RuleException {
        EnrollmentOverride resultEo;
        this.getResultEnrollmentDetermination().setOverridden(new Boolean(b));
        if (!b && (resultEo = this.getEnrollmentOverride(this.getResultPerson())) != null) {
            resultEo.setOverride(Boolean.FALSE);
            resultEo.setOverrideReason(null);
            resultEo.setOverrideComment(null);
        }
    }

    @Override
    public String getCurrentPrimaryEligibilityCode() {
        Eligibility primary;
        EnrollmentDetermination enrollment;
        if (this.currentPrimaryEligibilityCode == null && (enrollment = this.getPristineEnrollmentDetermination()) != null && (primary = enrollment.getPrimaryEligibility()) != null) {
            EligibilityType type = primary.getType();
            this.currentPrimaryEligibilityCode = type != null ? type.getCode() : null;
        }
        return this.currentPrimaryEligibilityCode;
    }

    @Override
    public Boolean getEnrollmentOverride() {
        EnrollmentOverride eo = this.getEnrollmentOverride(this.getIncomingPerson());
        return eo != null ? eo.getOverride() : Boolean.FALSE;
    }

    @Override
    public Boolean getProcessOverrideFromEnrollmentOverride() {
        EnrollmentOverride eo = this.getEnrollmentOverride(this.getIncomingPerson());
        return eo != null ? eo.getProcessOverride() : null;
    }

    @Override
    public Boolean getSiteVerifiedEnrollment() throws RuleException {
        Person siteData = this.getVerifiedSiteData();
        Boolean hasSiteData = Boolean.FALSE;
        if (siteData != null) {
            hasSiteData = this.getEnrollmentDetermination(siteData) != null ? Boolean.TRUE : Boolean.FALSE;
        }
        return hasSiteData;
    }

    @Override
    public String getPrimaryEligibilityCodeOfVerifiedSite() throws RuleException {
        String code = null;
        Person siteData = this.getVerifiedSiteData();
        if (siteData != null) {
            EnrollmentDetermination enrollment = this.getEnrollmentDetermination(siteData);
            Eligibility primary = null;
            if (enrollment != null && (primary = enrollment.getPrimaryEligibility()) != null) {
                EligibilityType type = primary.getType();
                code = type != null ? type.getCode() : null;
            }
        }
        return code;
    }

    @Override
    public void setProcessOverride(boolean b) {
        EnrollmentOverride eo = this.getResultPerson().getEnrollmentOverride();
        if (eo != null) {
            eo.setProcessOverride(new Boolean(b));
        }
    }

    @Override
    public boolean isTypeOfPrimaryEligibilityCodeEqualTo(String eligibilityType) throws RuleException {
        boolean equal = false;
        if (NONVETERAN.equals(eligibilityType) && this.isNonVeteranPrimaryEligibility(this.getCalculatedPrimaryEligibilityCode())) {
            equal = true;
        } else if (VETERAN.equals(eligibilityType) && !this.isNonVeteranPrimaryEligibility(this.getCalculatedPrimaryEligibilityCode())) {
            equal = true;
        }
        return equal;
    }

    @Override
    public boolean isTypeOfReceivedPrimaryEligibilityCodeEqualTo(String eligibilityType) throws RuleException {
        boolean equal = false;
        if (NONVETERAN.equals(eligibilityType) && this.isNonVeteranPrimaryEligibility(this.getReceivedPrimaryEligibilityCode())) {
            equal = true;
        } else if (VETERAN.equals(eligibilityType) && !this.isNonVeteranPrimaryEligibility(this.getReceivedPrimaryEligibilityCode())) {
            equal = true;
        }
        return equal;
    }

    @Override
    public boolean isTypeOfSiteRecordEligibilityCodeEqual(Person person, String vetType) throws RuleException {
        EnrollmentDetermination ed = person != null ? person.getEnrollmentDetermination() : null;
        Eligibility e = ed != null ? ed.getPrimaryEligibility() : null;
        EligibilityType type = e != null ? e.getType() : null;
        boolean equal = false;
        if (NONVETERAN.equals(vetType) && this.isNonVeteranPrimaryEligibility(type != null ? type.getCode() : null)) {
            equal = true;
        } else if (VETERAN.equals(vetType) && !this.isNonVeteranPrimaryEligibility(type != null ? type.getCode() : null)) {
            equal = true;
        }
        return equal;
    }

    @Override
    public boolean doesCalculatedSecondaryEligibilityCodeContain(String eligibilityCode) throws RuleException {
        EnrollmentDetermination ed = this.getResultEnrollmentDetermination();
        if (ed != null && ed.getSecondaryEligibilities().size() > 0) {
            Iterator itr;
            Set eligs = ed.getSecondaryEligibilities();
            Iterator iterator = itr = eligs != null ? eligs.iterator() : null;
            while (itr != null && itr.hasNext()) {
                Eligibility elig = (Eligibility)itr.next();
                if (!this.isEligibilityOfType(elig, eligibilityCode)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean doesCalculatedPrimaryOrSecondaryEligibilitiesContain(String eligTypeCode) throws RuleException {
        boolean result = false;
        EnrollmentDetermination ed = null;
        ed = this.getResultPerson() != null ? this.getResultEnrollmentDetermination() : this.getIncomingEnrollmentDetermination();
        if (ed != null) {
            Eligibility elig = ed.getPrimaryEligibility();
            if (this.isEligibilityOfType(elig, eligTypeCode)) {
                result = true;
            } else {
                Iterator itr;
                Set eligs = ed.getSecondaryEligibilities();
                Iterator iterator = itr = eligs != null ? eligs.iterator() : null;
                while (itr != null && itr.hasNext()) {
                    elig = (Eligibility)itr.next();
                    if (!this.isEligibilityOfType(elig, eligTypeCode)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    private boolean isEligibilityOfType(Eligibility elig, String eligTypeCode) {
        return elig != null && elig.getType() != null && elig.getType().getCode().equals(eligTypeCode);
    }

    @Override
    public String getCurrentEnrollmentPrioirity() throws RuleException {
        return this.getEnrollmentPriority();
    }

    @Override
    public String getPriorEnrollmentPriority() throws RuleException {
        if (this.priorEnrollmentPriority == null) {
            EnrollmentDetermination enrollmentDetermination = this.getPriorEnrollment();
            EnrollmentPriorityGroup enrollmentPriorityGroup = enrollmentDetermination != null ? enrollmentDetermination.getPriorityGroup() : null;
            this.priorEnrollmentPriority = enrollmentPriorityGroup != null ? enrollmentPriorityGroup.getCode() : null;
        }
        return this.priorEnrollmentPriority;
    }

    @Override
    public String getPriorEnrollmentStatus() throws RuleException {
        EnrollmentDetermination prior = this.getPriorEnrollment();
        return prior != null && prior.getEnrollmentStatus() != null ? prior.getEnrollmentStatus().getCode() : null;
    }

    @Override
    public boolean isEnrollmentPriorityEqualToPrevious() throws RuleException {
        String prior = this.getPriorEnrollmentPriority();
        String incoming = this.getEnrollmentPriority();
        if (prior != null && incoming != null) {
            return prior.equals(incoming);
        }
        return prior == null && incoming == null;
    }

    @Override
    public boolean isEnrollmentPriorityImproved(Person incoming, Person onFile) throws RuleException {
        try {
            String incomingEnrollmentPriorityCode = this.getEnrollmentPriority(incoming);
            String onFileEnrollmentPriorityCode = this.getEnrollmentPriority(onFile);
            if (StringUtils.isNotEmpty((String)incomingEnrollmentPriorityCode) && StringUtils.isNotEmpty((String)onFileEnrollmentPriorityCode) && !incomingEnrollmentPriorityCode.equals(onFileEnrollmentPriorityCode)) {
                return new Integer(incomingEnrollmentPriorityCode) < new Integer(onFileEnrollmentPriorityCode);
            }
        }
        catch (Exception ex) {
            throw new RuleException("Error comparing enrollment priorities", (Throwable)ex);
        }
        return false;
    }

    @Override
    public boolean isEnrollmentPriorityChanged() throws RuleException {
        String prior = null;
        String result = null;
        if (this.getPristinePerson() != null && this.getPristinePerson().getEnrollmentDetermination() != null && this.getPristinePerson().getEnrollmentDetermination().getPriorityGroup() != null) {
            prior = this.getPristinePerson().getEnrollmentDetermination().getPriorityGroup().getCode();
        }
        result = this.getEnrollmentPriority();
        if (prior != null && result != null && prior.equals(result)) {
            return false;
        }
        return prior != null || result != null;
    }

    @Override
    public Date getESRImplementationDate() throws RuleException {
        try {
            return super.getEsrImplementationDate();
        }
        catch (Exception ex) {
            throw new RuleException("Error getting ESR implementation date", (Throwable)ex);
        }
    }

    @Override
    public Date getEnrollmentRegulationDate() throws RuleException {
        try {
            return super.getEnrollmentRegulationDate();
        }
        catch (Exception ex) {
            throw new RuleException("Error getting Enrollment Regulation date", (Throwable)ex);
        }
    }

    @Override
    public boolean hasApplicationDatePriorToEGTEffectiveDate() throws RuleException {
        try {
            return this.getEligibilityEnrollmentService().isApplicationDatePriortoEGTEffectiveDate(this.getIncomingPerson().getEntityKey());
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
    }

    @Override
    public boolean hasVerifiedEnrollmentWithCombatVeteran() throws RuleException {
        try {
            return this.getEligibilityEnrollmentService().isVerifiedEnrollmentExistsforCombatVeteran(this.getIncomingPerson().getEntityKey());
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
    }

    @Override
    public boolean eligForMedicaidChangedToNo365DaysAfterAppDt() throws RuleException {
        MedicaidFactor mf = this.getIncomingPerson().getMedicaidFactor();
        if (mf != null && mf.isEligibleForMedicaid() != null && !mf.isEligibleForMedicaid().booleanValue()) {
            Date changeDate = mf.getLastUpdateDate();
            Date appDate = this.getApplicationDate();
            if (changeDate != null && appDate != null) {
                GregorianCalendar daysAfter = new GregorianCalendar();
                daysAfter.setTime(appDate);
                daysAfter.add(5, 365);
                return changeDate.getTime() > daysAfter.getTime().getTime();
            }
        }
        return false;
    }

    @Override
    public boolean eligForMedicaidChangedToNo365DaysAfterMedLastChgDt() throws RuleException {
        return this.eligForMedicaidChangedToNo365DaysAfterAppDt();
    }

    @Override
    public boolean hasVerifiedEnrollmentWithAA() throws RuleException {
        return this.hasVerifiedEnrollmentWithEligibility(EligibilityType.AID_AND_ATTENDANCE.getCode());
    }

    @Override
    public boolean hasVerifiedEnrollmentWithEligibleForMedicaid() throws RuleException {
        try {
            return this.getEligibilityEnrollmentService().isVerifiedEnrollmentExistsForMedicaidEligibility(this.getIncomingPerson().getEntityKey());
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
    }

    @Override
    public boolean hasVerifiedEnrollmentWithHB() throws RuleException {
        return this.hasVerifiedEnrollmentWithEligibility(EligibilityType.HOUSEBOUND.getCode());
    }

    @Override
    public boolean hasVerifiedEnrollmentWithMT() throws RuleException {
        List incomeYears = this.getIncomeYearFromVerifiedEnrollmentDueToMT();
        return this.evaluateCERule15Criteria(incomeYears);
    }

    private boolean evaluateCERule15Criteria(List incomeYears) throws RuleException {
        boolean result = false;
        if (incomeYears != null) {
            for (int i = 0; i < incomeYears.size(); ++i) {
                boolean isHardshipGranted;
                MeansTestStatus mts;
                Integer incomeYear = (Integer)incomeYears.get(i);
                IncomeTest it = this.getIncomingPerson().getIncomeTest(incomeYear);
                if (it == null || (mts = it.getStatus()) == null || !MeansTestStatus.MT_STATUS_MT_COPAY_EXEMPT.getCode().equals(mts.getCode()) && !MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(mts.getCode()) && !MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(mts.getCode())) continue;
                if (MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getCode().equals(mts.getCode())) {
                    BigDecimal thresholdGMT = it.getGmtThresholdAmount();
                    BigDecimal thresholdMTT = it.getThresholdA();
                    BigDecimal resultNetIncome = new BigDecimal(0);
                    BigDecimal netIncome = it.getNetIncome();
                    if (netIncome != null) {
                        resultNetIncome = netIncome;
                    } else {
                        BigDecimal totalIncome = it.getTotalIncome();
                        BigDecimal deductableExpenses = it.getDeductibleExpenses();
                        if (totalIncome != null && deductableExpenses != null) {
                            resultNetIncome = this.isGreaterThan(totalIncome, deductableExpenses) ? totalIncome.subtract(deductableExpenses) : new BigDecimal(0);
                        } else if (totalIncome != null) {
                            resultNetIncome = totalIncome;
                        }
                    }
                    if (thresholdGMT == null || thresholdMTT == null || resultNetIncome == null || thresholdGMT.compareTo(thresholdMTT) <= 0 && (thresholdGMT.compareTo(thresholdMTT) >= 0 || resultNetIncome.compareTo(thresholdGMT) > 0)) continue;
                    return true;
                }
                Hardship hardship = it.getHardship();
                Boolean hasHardship = hardship != null ? hardship.getHardshipGranted() : null;
                boolean bl = isHardshipGranted = hasHardship != null ? hasHardship : false;
                if (isHardshipGranted) {
                    MeansTestStatus determinedStatus = it.getDeterminedStatus();
                    if (determinedStatus == null || !MeansTestStatus.MT_STATUS_GMT_COPAY_REQUIRED.getCode().equals(determinedStatus.getCode())) continue;
                    return true;
                }
                return true;
            }
        }
        return result;
    }

    @Override
    public boolean hasIncomeTestThatPreviouslyMetRule15Criteria() throws RuleException {
        List incomeYears = null;
        try {
            incomeYears = this.getEligibilityEnrollmentService().getHistoricalIncomeYearsForVerifiedMT(this.getIncomingPerson().getEntityKey());
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
        return incomeYears != null && incomeYears.size() > 0;
    }

    @Override
    public boolean hasVerifiedEnrollmentWithVAPension() throws RuleException {
        return this.hasVerifiedEnrollmentWithEligibility(EligibilityType.NSC_VA_PENSION.getCode());
    }

    @Override
    public boolean hasVerifiedEnrollmentWithAOLocationDMZ() throws RuleException {
        AgentOrangeExposureLocation location;
        AgentOrangeExposure aoe = this.getIncomingPerson().getAgentOrangeExposure();
        if (aoe != null && aoe.getAgentOrangeExposureIndicator() != null && aoe.getAgentOrangeExposureIndicator().toBoolean() != null && aoe.getAgentOrangeExposureIndicator().toBoolean().booleanValue() && (location = aoe.getLocation()) != null && location.getCode().equals(AgentOrangeExposureLocation.CODE_KOREAN_DMZ.getCode())) {
            Date enteredDate = aoe.getModifiedOn();
            Date implementationDate = this.getESRImplementationDate();
            if (enteredDate != null && implementationDate != null) {
                return this.isBefore(enteredDate, implementationDate);
            }
        }
        return false;
    }

    @Override
    public Boolean getEnrollmentOverrideForCE() throws RuleException {
        EnrollmentDetermination ed = this.getMostRecentEnrollmentDeterminationForCE();
        return ed != null ? ed.getOverridden() : null;
    }

    @Override
    public boolean hasVerifiedEnrollmentWithSC_GTE_10PERCENT() throws RuleException {
        try {
            return this.getEligibilityEnrollmentService().isVerifiedEnrollmentExistsforSvcConnPercent(this.getIncomingPerson().getEntityKey(), new Integer(TEN_PERCENT));
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
    }

    @Override
    public boolean isEGTPriorityCEGreaterThanCurrEGT() throws RuleException {
        String ceEGTPriorityCode;
        EnrollmentDetermination ce = this.getMostRecentEnrollmentDeterminationForCE();
        EGTSetting egtCE = ce != null ? ce.getEgtSetting() : null;
        EGTSetting currentEGTSetting = this.getCurrentEGTSetting();
        EnrollmentPriorityGroup currPriority = currentEGTSetting != null ? currentEGTSetting.getPriorityGroup() : null;
        EnrollmentPriorityGroup cePriority = egtCE != null ? egtCE.getPriorityGroup() : null;
        String currEGTPriorityCode = currPriority != null ? currPriority.getCode() : null;
        String string = ceEGTPriorityCode = cePriority != null ? cePriority.getCode() : null;
        if (currEGTPriorityCode == null || ceEGTPriorityCode == null) {
            return false;
        }
        return ceEGTPriorityCode.compareTo(currEGTPriorityCode) > 0;
    }

    private String getCancelDecline(Person person) {
        CancelDecline cancelDeclineObj;
        String result = null;
        CancelDecline cancelDecline = cancelDeclineObj = person != null ? person.getCancelDecline() : null;
        if (cancelDeclineObj != null) {
            boolean cancel;
            boolean bl = cancel = cancelDeclineObj.getCancelDeclineIndicator() != null ? cancelDeclineObj.getCancelDeclineIndicator() : false;
            if (cancel && cancelDeclineObj.getEffectiveDate() != null) {
                result = "Y";
            } else if (cancelDeclineObj.getReasonNotProcessed() != null) {
                result = NONVETERAN;
            }
        }
        return result;
    }

    private Date getCancelledDeclinedDate(Person person) {
        return person != null && person.getCancelDecline() != null ? person.getCancelDecline().getEffectiveDate() : null;
    }

    private boolean containsEligibility(Set eligibilities, Eligibility eligibility) {
        Eligibility found = (Eligibility)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)eligibility, eligibilities);
        return found != null;
    }

    private EnrollmentDetermination getIncomingEnrollmentDetermination() {
        if (this.incomingEnrollmentDetermination == null) {
            this.incomingEnrollmentDetermination = this.getEnrollmentDetermination(this.getIncomingPerson());
        }
        return this.incomingEnrollmentDetermination;
    }

    private EnrollmentDetermination getPristineEnrollmentDetermination() {
        if (this.pristineEnrollmentDetermination == null) {
            this.pristineEnrollmentDetermination = this.getEnrollmentDetermination(this.getPristinePerson());
        }
        return this.pristineEnrollmentDetermination;
    }

    private EnrollmentDetermination getResultEnrollmentDetermination() throws RuleException {
        if (this.resultEnrollmentDetermination == null) {
            this.resultEnrollmentDetermination = this.initializeResultEnrollment();
        }
        return this.resultEnrollmentDetermination;
    }

    private ReceivedEnrollment getReceivedEnrollment(Person person) {
        return person != null ? person.getReceivedEnrollment() : null;
    }

    @Override
    public String getEnrollmentStatusCode(Person person) throws RuleException {
        String code = null;
        try {
            EnrollmentStatus enrollmentStatus = this.getHelperService().getEnrollmentStatus(person);
            code = enrollmentStatus != null ? enrollmentStatus.getCode() : null;
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get a process state of type enrollment status", (Throwable)e);
        }
        return code;
    }

    private EnrollmentDetermination initializeResultEnrollment() throws RuleException {
        EnrollmentDetermination enrollmentDetermination = null;
        EGTSetting egtSetting = this.getCurrentEGTSetting();
        if (this.getEEInputData() != null) {
            enrollmentDetermination = this.getEEInputData().getResultEnrollmentDetermination();
        } else {
            enrollmentDetermination = this.getEnrollmentDetermination(this.getResultPerson());
            if (enrollmentDetermination == null) {
                enrollmentDetermination = new EnrollmentDetermination();
                this.getResultPerson().setEnrollmentDetermination(enrollmentDetermination);
            }
        }
        if (enrollmentDetermination != null && (enrollmentDetermination.getEgtSetting() == null || this.getBaseData().getActiveEGTSetting() != null)) {
            enrollmentDetermination.setEgtSetting(egtSetting);
        }
        return enrollmentDetermination;
    }

    private boolean containsReceivedEligibility(Set received, String code) {
        boolean contained = false;
        if (code != null && received != null && received.size() > 0) {
            for (ReceivedEligibility receivedEligibility : received) {
                if (!code.equals(receivedEligibility.getType().getCode())) continue;
                contained = true;
                break;
            }
        }
        return contained;
    }

    private Set getReceivedEligibilities(Person person) {
        ReceivedEligibility receivedEligibility;
        Set secondaries = person != null ? person.getReceivedSecondaryEligibilities() : null;
        HashSet<ReceivedEligibility> eligibilities = new HashSet<ReceivedEligibility>();
        if (secondaries != null && secondaries.size() > 0) {
            eligibilities.addAll(secondaries);
        }
        ReceivedEligibility receivedEligibility2 = receivedEligibility = person != null ? person.getReceivedPrimaryEligibility() : null;
        if (receivedEligibility != null) {
            eligibilities.add(receivedEligibility);
        }
        return eligibilities;
    }

    private boolean codesAreValid(Set received, String codes) {
        boolean valid = true;
        if (codes != null && received != null && received.size() > 0) {
            for (ReceivedEligibility receivedEligibility : received) {
                int i = codes.indexOf(receivedEligibility.getType().getDescription());
                if (i != -1) continue;
                valid = false;
                break;
            }
        }
        return valid;
    }

    private boolean matchReceivedEligibilities(Person incoming, Person onFile) {
        boolean compare2IsEmpty;
        boolean result = false;
        Set compare1 = this.getReceivedEligibilities(incoming);
        Set compare2 = this.getReceivedEligibilities(onFile);
        boolean compare1IsEmpty = compare1 == null || compare1.size() == 0;
        boolean bl = compare2IsEmpty = compare2 == null || compare2.size() == 0;
        if (compare1IsEmpty && compare2IsEmpty) {
            result = true;
        } else if (!compare1IsEmpty && !compare2IsEmpty && compare2.size() == compare1.size()) {
            for (ReceivedEligibility receivedEligibility : compare1) {
                ReceivedEligibility found = (ReceivedEligibility)this.getMergeRuleService().getMatchRuleService().findMatchingElement((AbstractEntity)receivedEligibility, compare2);
                if (found == null) {
                    result = false;
                    break;
                }
                result = true;
            }
        }
        return result;
    }

    private String getReceivedPrimaryEligibilityCode(Person person) {
        ReceivedEligibility primary = person != null ? person.getReceivedPrimaryEligibility() : null;
        return primary != null && primary.getType() != null ? primary.getType().getCode() : null;
    }

    private boolean isNonVeteranPrimaryEligibility(String code) throws RuleException {
        return this.getHelperService().isNonVeteranEligibilityCode(code);
    }

    private Application getApplication(Person person) {
        return person != null ? person.getApplication() : null;
    }

    private EnrollmentOverride getEnrollmentOverride(Person person) {
        return person != null ? person.getEnrollmentOverride() : null;
    }

    private boolean isValidReceivedCode(ReceivedEligibility re) {
        return re == null || !(re.getType().getCode().equals(EligibilityType.ALLIED_VETERAN.getName()) ? re.getAlliedCountry() == null : re.getType().getCode().equals(EligibilityType.OTHER_FEDERAL_AGENCY.getName()) && re.getOtherFederalAgency() == null);
    }

    @Override
    public String getEnrollmentCategory() throws RuleException {
        EnrollmentCategory category = null;
        try {
            category = this.getHelperService().getEnrollmentCategory(this.getIncomingPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get enrollment category", (Throwable)e);
        }
        return category != null ? category.getCode() : null;
    }

    @Override
    public boolean isCalculatedEnrPriorityLessThanEGTSetting() throws RuleException {
        try {
            String currentEGTSettingCode;
            String enrollmentPriorityCode = this.getEnrollmentPriority();
            EnrollmentPriorityGroup enrolPriorityGruop = this.getCurrentEGTSetting() != null ? this.getCurrentEGTSetting().getPriorityGroup() : null;
            String string = currentEGTSettingCode = enrolPriorityGruop != null ? enrolPriorityGruop.getCode() : null;
            if (StringUtils.isNotEmpty((String)enrollmentPriorityCode) && StringUtils.isNotEmpty((String)currentEGTSettingCode)) {
                return new Integer(enrollmentPriorityCode) < new Integer(currentEGTSettingCode);
            }
        }
        catch (Exception ex) {
            throw new RuleException("", (Throwable)ex);
        }
        return false;
    }

    @Override
    public Date getEnrollmentEffectiveDateForCE() throws RuleException {
        EnrollmentDetermination ed = this.getMostRecentEnrollmentDeterminationForCE();
        return ed != null ? ed.getEffectiveDate() : null;
    }

    @Override
    public String getEnrollmentStatusForCE() throws RuleException {
        EnrollmentDetermination ed = this.getMostRecentEnrollmentDeterminationForCE();
        return ed != null && ed.getEnrollmentStatus() != null ? ed.getEnrollmentStatus().getCode() : null;
    }

    @Override
    public Date getRecentEnrollmentEffectiveDate() throws RuleException {
        Date egtEffectiveDate = null;
        Date enrollmentApplicationDate = null;
        EGTSetting egtSetting = this.getCurrentEGTSetting();
        if (egtSetting != null) {
            egtEffectiveDate = egtSetting.getEffectiveDate();
        }
        enrollmentApplicationDate = this.getApplicationDate();
        if (egtEffectiveDate != null && enrollmentApplicationDate != null) {
            if (egtEffectiveDate.after(enrollmentApplicationDate)) {
                return egtEffectiveDate;
            }
            return enrollmentApplicationDate;
        }
        if (egtEffectiveDate != null) {
            return egtEffectiveDate;
        }
        if (enrollmentApplicationDate != null) {
            return enrollmentApplicationDate;
        }
        return this.getCurrentDate();
    }

    @Override
    public ReceivedEligibility getReceivedPrimaryEligibility(Person person) throws RuleException {
        return person != null ? person.getReceivedPrimaryEligibility() : null;
    }

    @Override
    public boolean isEffDatePriorToESRImplDate() throws RuleException {
        Date effectiveDate = this.getCurrentDate();
        Date implementationDate = this.getESRImplementationDate();
        return effectiveDate != null && implementationDate != null ? this.isBefore(effectiveDate, implementationDate) : false;
    }

    @Override
    public boolean isVetAppDatePriorToRegDate() throws RuleException {
        Date effectiveDate = this.getApplicationDate();
        Date regulationDate = this.getEnrollmentRegulationDate();
        return effectiveDate != null && regulationDate != null ? this.isBefore(effectiveDate, regulationDate) : false;
    }

    @Override
    public boolean isVetAppDateGTEToRegDate() throws RuleException {
        Date applicationDate = this.getApplicationDate();
        Date regulationDate = this.getEnrollmentRegulationDate();
        return applicationDate != null && regulationDate != null ? this.isSameDay(applicationDate, regulationDate) || this.isAfterIgnoreTime(applicationDate, regulationDate) : false;
    }

    @Override
    public boolean isEffDatePriorToRegDate() throws RuleException {
        Date effectiveDate = this.getEffectiveDateForEarliestVerifiedUnlessCancelled();
        Date regulationDate = this.getEnrollmentRegulationDate();
        return effectiveDate != null && regulationDate != null ? this.isBefore(effectiveDate, regulationDate) : false;
    }

    @Override
    public boolean isEffDateGTEToRegDate() throws RuleException {
        Date effectiveDate = this.getEffectiveDateForEarliestVerifiedUnlessCancelled();
        Date regulationDate = this.getEnrollmentRegulationDate();
        return effectiveDate != null && regulationDate != null ? this.isSameDay(effectiveDate, regulationDate) || this.isAfterIgnoreTime(effectiveDate, regulationDate) : false;
    }

    @Override
    public boolean isTodayGreaterThanOrEqualToRegulationDate() throws RuleException {
        Date today = new Date();
        Date regulationDate = this.getEnrollmentRegulationDate();
        return !this.isBefore(today, regulationDate);
    }

    @Override
    public boolean isReceivedPrimaryEligibilityValid(ReceivedEligibility re) throws RuleException {
        return this.isValidReceivedCode(re);
    }

    @Override
    public String getPriorNonNullPriority() throws RuleException {
        if (this.mostRecentNonNullPriorityCode == null) {
            try {
                this.mostRecentNonNullPriorityCode = this.getEligibilityEnrollmentService().getMostRecentNonNullPriorityCode(this.getPristinePerson().getEntityKey());
            }
            catch (ServiceException serviceEx) {
                throw new RuleException("Error getting most recent non-null enrollment priority", (Throwable)serviceEx);
            }
        }
        return this.mostRecentNonNullPriorityCode;
    }

    @Override
    public boolean hasVerifiedEnrollmentWithAOLocationVietnam() throws RuleException {
        try {
            AgentOrangeExposureLocation location;
            AgentOrangeExposure aoe = this.getIncomingPerson().getAgentOrangeExposure();
            if (aoe != null && aoe.getAgentOrangeExposureIndicator() != null && aoe.getAgentOrangeExposureIndicator().toBoolean() != null && aoe.getAgentOrangeExposureIndicator().toBoolean().booleanValue() && (location = aoe.getLocation()) != null && location.getCode().equals(AgentOrangeExposureLocation.CODE_VIETNAM.getCode()) && Boolean.FALSE.equals(this.getSystemParameterService().getAOTreatmentAuthorityIndicator())) {
                Date enteredDate = aoe.getModifiedOn();
                Date aoAuthorityExpDate = this.getSystemParameterService().getAOTreatmentAuthorityExpirationDate();
                if (enteredDate != null && aoAuthorityExpDate != null) {
                    return this.isBefore(enteredDate, aoAuthorityExpDate);
                }
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get Verified Enrollment with AO Location of Vietnam", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean hasVerifiedEnrollmentWithEC() throws RuleException {
        try {
            EnvironmentalContaminationExposure ece = this.getIncomingPerson().getEnvironmentalContaminationExposure();
            if (ece != null && ece.getEnvironmentalContaminationExposureIndicator() != null && ece.getEnvironmentalContaminationExposureIndicator().toBoolean() != null && ece.getEnvironmentalContaminationExposureIndicator().toBoolean().booleanValue() && Boolean.FALSE.equals(this.getSystemParameterService().getECTreamentAuthorityIndicator())) {
                Date enteredDate = ece.getModifiedOn();
                Date ecAuthorityExpDate = this.getSystemParameterService().getECTreatmentAuthorityExpirationDate();
                if (enteredDate != null && ecAuthorityExpDate != null) {
                    return this.isBefore(enteredDate, ecAuthorityExpDate);
                }
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get Verified Enrollment with SW Asia Condition", (Throwable)e);
        }
        return false;
    }

    @Override
    public boolean isPHOnly(Person person) throws RuleException {
        return this.isRegistryOnly(person, RegistryType.CODE_PH_REGISTRY.getCode());
    }

    @Override
    public boolean isPOWOnly(Person person) throws RuleException {
        return this.isRegistryOnly(person, RegistryType.CODE_POW_REGISTRY.getCode());
    }

    @Override
    public boolean isSHADOnly(Person person) throws RuleException {
        return this.isRegistryOnly(person, RegistryType.CODE_SHAD_REGISTRY.getCode());
    }

    @Override
    public void updateApplication() throws RuleException {
        Person inPerson = this.getIncomingPerson();
        Person result = this.getResultPerson();
        Application incoming = inPerson.getApplication();
        if (incoming != null) {
            if (result.getApplication() == null) {
                result.setApplication(new Application());
            }
            try {
                this.getMergeRuleService().mergeApplication(incoming, result.getApplication());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to merge application", (Throwable)e);
            }
        } else {
            result.setApplication(null);
        }
    }

    @Override
    public void updateReceivedEnrollment() throws RuleException {
        Person inPerson = this.getIncomingPerson();
        Person result = this.getResultPerson();
        ReceivedEnrollment incoming = inPerson.getReceivedEnrollment();
        if (incoming != null) {
            if (result.getReceivedEnrollment() == null) {
                result.setReceivedEnrollment(new ReceivedEnrollment());
            }
            try {
                this.getMergeRuleService().mergeReceivedEnrollment(incoming, result.getReceivedEnrollment());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to merge ReceivedEnrollment", (Throwable)e);
            }
        } else {
            result.setReceivedEnrollment(null);
        }
    }

    private boolean isRegistryOnly(Person person, String registryType) throws RuleException {
        try {
            RegistrySearchCriteria criteria = this.getRegistryService().getRegistrySearchCriteria(person, registryType);
            criteria.setMaxAllowedRecords(20);
            Registry reg = this.getRegistryService().getMatchingRegistry(criteria);
            if (reg != null && reg.getPerson() == null) {
                return true;
            }
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error searching registry", (Throwable)serviceEx);
        }
        return false;
    }

    @Override
    public void removeAllEligibilityFactors() throws RuleException {
        Person incoming = this.getIncomingPerson();
        if (incoming != null) {
            try {
                this.getEligibilityEnrollmentService().removeAllEligibilityFactors(incoming);
            }
            catch (ServiceException ex) {
                throw new RuleException("Error while removing eligibility factors", (Throwable)ex);
            }
        }
    }

    private EnrollmentDetermination getPriorEnrollment() throws RuleException {
        Person priorPerson = this.getPriorEEPerson();
        return priorPerson != null ? priorPerson.getEnrollmentDetermination() : null;
    }

    private Date getEarliestUnverifiedEnrollmentApplicationDate() throws RuleException {
        try {
            EligibilityEnrollmentService enrollmentService = this.getEligibilityEnrollmentService();
            Person person = this.getIncomingPerson();
            if (person != null && person.getEntityKey() != null) {
                return enrollmentService.getAppDateFromEarliestUnverifiedEnrollment(this.getIncomingPerson().getEntityKey());
            }
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting application date from unverified enrollment", (Throwable)serviceEx);
        }
        return null;
    }

    private boolean hasVerifiedEnrollmentWithEligibility(String code) throws RuleException {
        try {
            return this.getEligibilityEnrollmentService().isVerifiedEnrollmentExistsForEligibilityCode(this.getIncomingPerson().getEntityKey(), code);
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
    }

    private EnrollmentDetermination getMostRecentEnrollmentDeterminationForCE() throws RuleException {
        if (this.ceEnrollmentDetermination == null) {
            try {
                this.ceEnrollmentDetermination = this.getEligibilityEnrollmentService().getMostRecentEnrollmentforContinuousEnrollment(this.getIncomingPerson().getEntityKey());
            }
            catch (ServiceException ex) {
                throw new RuleException("Error getting enrollment for continuous enrollment rules", (Throwable)ex);
            }
        }
        return this.ceEnrollmentDetermination;
    }

    @Override
    public boolean isMostRecentEnrollmentEffectiveDateYearEqualToThisYear() throws RuleException {
        EnrollmentDetermination enrollmentDetermination = this.getMostRecentEnrollmentDeterminationForCE();
        Calendar calendar = Calendar.getInstance();
        Calendar theEffectiveDate = Calendar.getInstance();
        if (enrollmentDetermination == null || enrollmentDetermination.getEffectiveDate() == null) {
            return false;
        }
        theEffectiveDate.setTime(enrollmentDetermination.getEffectiveDate());
        return this.isEqual(new Integer(theEffectiveDate.get(1)), new Integer(calendar.get(1)));
    }

    private List getIncomeYearFromVerifiedEnrollmentDueToMT() throws RuleException {
        List incomeYear = null;
        try {
            incomeYear = this.getEligibilityEnrollmentService().getIncomeYearsForVerifiedMT(this.getIncomingPerson().getEntityKey());
        }
        catch (ServiceException ex) {
            throw new RuleException("Error getting verified enrollment", (Throwable)ex);
        }
        return incomeYear;
    }

    @Override
    public void setInitialEnrollmentPriority(String code) throws RuleException {
        try {
            if (code == null) {
                this.getResultEnrollmentDetermination().setInitialPriorityGroup(null);
            } else {
                this.getHelperService().setInitialEnrollmentPriority(code, this.getResultEnrollmentDetermination());
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set initial priority", (Throwable)e);
        }
    }

    @Override
    public void setInitialSubPriority(String code) throws RuleException {
        try {
            if (code == null) {
                this.getResultEnrollmentDetermination().setInitialPrioritySubGroup(null);
            } else {
                this.getHelperService().setInitialEnrollmentPrioritySubGroup(code, this.getResultEnrollmentDetermination());
            }
        }
        catch (ServiceException e) {
            throw new RuleException("failed to set initial sub priority", (Throwable)e);
        }
    }

    private EnrollmentDetermination getEarliestVerifiedEnrollmentDetermination(Person person) {
        Set enrollmentDeterminations = person.getEnrollmentDeterminations();
        EnrollmentDetermination enrollmentDetermination = null;
        EnrollmentDeterminationComparatorByEntityKeyValue comparator = new EnrollmentDeterminationComparatorByEntityKeyValue();
        if (enrollmentDeterminations != null) {
            EnrollmentDetermination edCandidate;
            int i;
            Object[] enrollmentDeterminationsArray = enrollmentDeterminations.toArray();
            Arrays.sort(enrollmentDeterminationsArray, comparator);
            for (i = enrollmentDeterminationsArray.length - 1; !(i <= -1 || (edCandidate = (EnrollmentDetermination)((Object)enrollmentDeterminationsArray[i])).getEnrollmentStatus() != null && EnrollmentStatus.CODE_CANCELLED_DECLINED.equals(edCandidate.getEnrollmentStatus().getCodeObject())); --i) {
            }
            if (i == -1) {
                i = 0;
            }
            while (i < enrollmentDeterminationsArray.length) {
                edCandidate = (EnrollmentDetermination)((Object)enrollmentDeterminationsArray[i]);
                if (edCandidate.getEnrollmentStatus() != null && EnrollmentStatus.CODE_VERIFIED.equals(edCandidate.getEnrollmentStatus().getCodeObject())) {
                    enrollmentDetermination = (EnrollmentDetermination)((Object)enrollmentDeterminationsArray[i]);
                    break;
                }
                ++i;
            }
        }
        return enrollmentDetermination;
    }

    private EnrollmentDetermination getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(Person person) throws RuleException {
        EnrollmentDetermination ed = null;
        try {
            EligibilityEnrollmentService enrollmentService = this.getEligibilityEnrollmentService();
            if (person != null && person.getEntityKey() != null) {
                ed = enrollmentService.getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(person.getEntityKey());
            }
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting application date from unverified enrollment", (Throwable)serviceEx);
        }
        return ed;
    }

    @Override
    public String getMostRecentVerifiedEnrollmentPriority(Person person) throws RuleException {
        if (this.mostRecentPriorityGroupOfVerifiedEnrollment == null) {
            this.initializeMostRecentPriorityGroup(person);
        }
        return this.mostRecentPriorityGroupOfVerifiedEnrollment;
    }

    @Override
    public String getMostRecentVerifiedEnrollmentSubPriority(Person person) throws RuleException {
        if (this.mostRecentPrioritySubGroupOfVerifiedEnrollment == null) {
            this.initializeMostRecentPriorityGroup(person);
        }
        return this.mostRecentPrioritySubGroupOfVerifiedEnrollment;
    }

    private void initializeMostRecentPriorityGroup(Person person) throws RuleException {
        try {
            String[] groups;
            if (person != null && person.getEntityKey() != null && (groups = this.getEligibilityEnrollmentService().getMostRecentVerifiedEnrollmentPriorityGroups(person.getEntityKey())) != null) {
                this.mostRecentPriorityGroupOfVerifiedEnrollment = groups[0] != null ? groups[0] : null;
                this.mostRecentPrioritySubGroupOfVerifiedEnrollment = groups[1] != null ? groups[1] : null;
            }
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error initializing most recent priority groups", (Throwable)serviceEx);
        }
    }

    @Override
    public String getEarliestEnrollmentPriority(Person person) throws RuleException {
        String priority = null;
        EnrollmentDetermination ed = null;
        ed = this.getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(person);
        if (ed != null && ed.getPriorityGroup() != null) {
            priority = ed.getPriorityGroup().getCode();
        }
        return priority;
    }

    @Override
    public String getEarliestEnrollmentSubPriority(Person person) throws RuleException {
        String subPriority = null;
        EnrollmentDetermination ed = null;
        ed = this.getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(person);
        if (ed != null && ed.getPrioritySubGroup() != null) {
            subPriority = ed.getPrioritySubGroup().getCode();
        }
        return subPriority;
    }

    @Override
    public String getResultReceivedPrimaryEligibilityCode() {
        Person person = this.getResultPerson();
        return this.getReceivedPrimaryEligibilityCode(person);
    }

    @Override
    public boolean isVOASpinalCordIndicatorYes() {
        return this.getIncomingPerson().getSpinalCordInjury() != null;
    }

    @Override
    public void cancelVOAPendingClock() throws RuleException {
        try {
            this.getScheduledTaskService().cancelClock(this.getIncomingPerson(), Clock.Type.VOA_3_DAY_CLOCK, Clock.Group.VOA_CLOCK_GROUP);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to cancel VOA pending clock", (Throwable)e);
        }
    }

    @Override
    public void updateVOAPendingClock() throws RuleException {
        try {
            this.getScheduledTaskService().startVOAPendingClock(this.getIncomingPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to start VOA pending clock", (Throwable)e);
        }
    }

    @Override
    public boolean hasVOAPendingClockExpired() {
        Clock.Type fired = this.getFiredClockType();
        return fired != null ? Clock.Type.VOA_3_DAY_CLOCK.getName().equals(fired.getName()) : true;
    }

    @Override
    public boolean hasVerifiedEnrollmentStatusAfterPeriodOfNoEnrollment() throws RuleException {
        if (this.earliestEffDateForVerifiedUnlessCancelled == null) {
            this.earliestEffDateForVerifiedUnlessCancelled = this.getEffectiveDateForEarliestVerifiedUnlessCancelled();
        }
        return this.earliestEffDateForVerifiedUnlessCancelled != null;
    }

    @Override
    public boolean isVoaHasAttachments() {
        ReceivedEligibility elig = this.getIncomingPerson().getReceivedPrimaryEligibility();
        return elig != null && elig.isVoaHasAttachment();
    }

    @Override
    public void updateVoaAttachmentWithPersonId() throws RuleException {
        if (this.getEEInputData().getMessageControlId() == null) {
            return;
        }
        String msgControlId = this.getEEInputData().getMessageControlId();
        BigDecimal personId = (BigDecimal)this.getPristinePerson().getEntityKey().getKeyValue();
        try {
            this.getVoaApplicationService().updateVoaAttachmentWithPersonId(msgControlId, personId);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to Update VOA Attachment with PersonId=" + personId + " for Message Control Id=" + msgControlId, (Throwable)e);
        }
    }

    @Override
    public boolean hasEligibilityCodeEqualTo(String eligibilityCode, Person person) {
        if (person == null || eligibilityCode == null) {
            return false;
        }
        EnrollmentDetermination enrollment = person.getEnrollmentDetermination();
        if (enrollment != null) {
            String primaryEligibilityCode;
            String string = primaryEligibilityCode = enrollment.getPrimaryEligibility() != null && enrollment.getPrimaryEligibility().getType() != null ? enrollment.getPrimaryEligibility().getType().getCode() : null;
            if (StringUtils.equals((String)eligibilityCode, primaryEligibilityCode)) {
                return true;
            }
            Set secondaries = enrollment.getSecondaryEligibilities();
            for (Eligibility eligibility : secondaries) {
                String code = eligibility.getType() != null ? eligibility.getType().getCode() : null;
                if (!StringUtils.equals((String)eligibilityCode, (String)code)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasVeteranCompletedMeansTestForYearOfApplication(Person person) {
        Date appDate;
        Date date = appDate = person != null && person.getApplication() != null ? person.getApplication().getApplicationDate() : null;
        if (appDate == null) {
            return false;
        }
        Calendar tempDate = Calendar.getInstance();
        tempDate.setTime(appDate);
        Integer year = new Integer(tempDate.get(1));
        IncomeTest test = year != null ? person.getIncomeTest(year) : null;
        return test != null;
    }

    @Override
    public boolean hasVeteranHadNoHealthBenefitPlan() {
        return !this.getPristineHealthBenefitProfile().containsHealthBenefitPlans();
    }

    private HealthBenefitProfile getPristineHealthBenefitProfile() {
        return this.getPristinePerson().getHealthBenefitProfile();
    }

    @Override
    public void updateHealthBenefitProfile() throws RuleException {
        Person inPerson = this.getIncomingPerson();
        Person result = this.getResultPerson();
        HealthBenefitProfile incoming = inPerson.getHealthBenefitProfile();
        if (incoming != null) {
            try {
                this.getMergeRuleService().mergeHealthBenefitProfile(incoming, result.getHealthBenefitProfile());
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to merge HealthBenefitProfile", (Throwable)e);
            }
        } else {
            result.setHealthBenefitProfile(null);
        }
    }
}

