/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.lookup.AACIndicator;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.EligibilityVerificationSource;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.EligibilityVerificationInput;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.rule.parameter.BaseParameter;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class EligibilityVerificationInputParameter
extends BaseParameter
implements EligibilityVerificationInput {
    private static final long serialVersionUID = -5394358886026071563L;
    private String messageType = null;
    private String aacEntitlementCode = null;
    private String unsolicitedType = null;
    private String queryStatus = null;
    private String siteNumber = null;

    @Override
    public void setQueryStatus(String indicator) throws RuleException {
        try {
            Person resultPerson = this.getResultPerson();
            this.getHelperService().setAACIndicator(indicator, resultPerson);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set AAC Indicator", (Throwable)e);
        }
    }

    @Override
    public String getQueryStatus() {
        if (this.queryStatus == null) {
            this.queryStatus = this.getRuleDataAware() instanceof EventInputData ? this.getQueryStatus(this.getIncomingPerson()) : (this.getAacInfo() != null ? this.getAacInfo().getTextMessage() : null);
        }
        return this.queryStatus;
    }

    @Override
    public String getQueryStatus(Person person) {
        EligibilityVerification ev = person != null ? person.getEligibilityVerification() : null;
        AACIndicator indicator = ev != null ? ev.getAacIndicator() : null;
        return indicator != null ? indicator.getCode() : null;
    }

    @Override
    public String getEligibilityStatus() throws RuleException {
        return this.getEligibilityStatus(this.getIncomingPerson());
    }

    @Override
    public String getEligibilityStatus(Person person) throws RuleException {
        String code = null;
        try {
            EligibilityStatus status = this.getHelperService().getEligibilityStatus(person);
            code = status != null ? status.getCode() : null;
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get eligibility status code", (Throwable)e);
        }
        return code;
    }

    @Override
    public void setEligibilityVerificationSource(String code) throws RuleException {
        try {
            this.getHelperService().setVerificationSource(code, this.getResultPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set verification source for code: " + code, (Throwable)e);
        }
    }

    @Override
    public void setEligibilityStatus(String status) throws RuleException {
        try {
            this.getHelperService().setEligibilityStatus(status, this.getResultPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set eligiblity status", (Throwable)e);
        }
    }

    @Override
    public void setEligibilityStatusDate(ImpreciseDate date) {
        Person resultPerson = this.getResultPerson();
        EligibilityVerification eligibilityVerification = resultPerson.getEligibilityVerification();
        if (eligibilityVerification == null) {
            eligibilityVerification = new EligibilityVerification();
            resultPerson.setEligibilityVerification(eligibilityVerification);
        }
        resultPerson.getEligibilityVerification().setEligibilityStatusDate(date);
    }

    @Override
    public void setEligibilityStatusDate(Date date) {
        if (date != null) {
            ImpreciseDate idate = ImpreciseDateUtils.createImpreciseDateWithoutTime(date);
            this.setEligibilityStatusDate(idate);
        } else {
            Person resultPerson = this.getResultPerson();
            EligibilityVerification eligibilityVerification = resultPerson.getEligibilityVerification();
            if (eligibilityVerification == null) {
                eligibilityVerification = new EligibilityVerification();
                resultPerson.setEligibilityVerification(eligibilityVerification);
            }
            resultPerson.getEligibilityVerification().setEligibilityStatusDate(null);
        }
    }

    @Override
    public String getMessageType() {
        if (this.messageType == null) {
            VerificationInfo info = this.getAacInfo();
            this.messageType = info != null ? info.getMessageType() : null;
        }
        return this.messageType;
    }

    @Override
    public boolean getTriggerEnrollmentProcess() {
        VerificationInfo info = this.getAacInfo();
        return info != null ? info.isTriggerEnrollmentProcess() : false;
    }

    @Override
    public boolean hasQualifyingMse() {
        VerificationInfo info = this.getAacInfo();
        return info != null ? info.hasQualifyingMse() : false;
    }

    @Override
    public ImpreciseDate getMsdsMessageDate() {
        VerificationInfo info = this.getAacInfo();
        return info != null && info.getMsdsMessageDate() != null ? info.getMsdsMessageDate() : ImpreciseDateUtils.createImpreciseDateWithoutTime(this.getCurrentDate());
    }

    @Override
    public void setTriggeredEnrollmentProcess(boolean flag) {
        VerificationInfo info = this.getAacInfo();
        if (info != null) {
            info.setTriggerEnrollmentProcess(flag);
        }
    }

    @Override
    public String getAACEntitlementCode() {
        if (this.aacEntitlementCode == null) {
            VerificationInfo info = this.getAacInfo();
            this.aacEntitlementCode = info != null ? info.getEntitlementCode() : null;
        }
        return this.aacEntitlementCode;
    }

    @Override
    public String getUnsolicitedType() {
        if (this.unsolicitedType == null) {
            VerificationInfo info = this.getAacInfo();
            this.unsolicitedType = info != null ? info.getUnsolicitedType() : null;
        }
        return this.unsolicitedType;
    }

    @Override
    public void setEligibilityVerificationFacility(String vaFacility) throws RuleException {
        try {
            this.getHelperService().setVerificationFacility(vaFacility, this.getResultPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set a verification facility", (Throwable)e);
        }
    }

    @Override
    public void setEligibilityVerificationMethod(String method) throws RuleException {
        try {
            this.getHelperService().setVerificationMethod(method, this.getResultPerson());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to set eligbility source of verification", (Throwable)e);
        }
    }

    @Override
    public String getEligibilityVerificationSource() throws RuleException {
        return this.getEligibilityVerificationSource(this.getIncomingPerson());
    }

    @Override
    public String getEligibilityVerificationSource(Person person) throws RuleException {
        EligibilityVerification verification = person != null ? person.getEligibilityVerification() : null;
        String code = null;
        if (verification != null) {
            EligibilityVerificationSource source = verification.getVerificationSource();
            code = source != null ? source.getCode() : null;
        }
        return code;
    }

    @Override
    public ImpreciseDate getEligibilityStatusDate() {
        return this.getEligibilityStatusDate(this.getIncomingPerson());
    }

    @Override
    public ImpreciseDate getEligibilityStatusDate(Person person) {
        EligibilityVerification verification = person != null ? person.getEligibilityVerification() : null;
        return verification != null ? verification.getEligibilityStatusDate() : null;
    }

    @Override
    public String getEligibilityVerificationMethod() {
        return this.getEligibilityVerificationMethod(this.getIncomingPerson());
    }

    @Override
    public String getEligibilityVerificationMethod(Person person) {
        EligibilityVerification verification = person != null ? person.getEligibilityVerification() : null;
        return verification != null ? verification.getVerificationMethod() : null;
    }

    @Override
    public String getSiteNumber() throws RuleException {
        if (this.siteNumber == null) {
            Person siteData = this.getMostRecentSiteData();
            String string = this.siteNumber = siteData != null ? siteData.getSendingFacility() : null;
            if (this.siteNumber == null) {
                VerificationInfo info = this.getAacInfo();
                this.siteNumber = info != null ? info.getSiteNumber() : null;
            }
        }
        return this.siteNumber;
    }

    @Override
    public void acceptSiteEligibilityData(Person incoming, Person onFile) throws RuleException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be NULL");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be NULL");
        MergeRuleService service = this.getMergeRuleService();
        try {
            onFile.setVeteran(incoming.getVeteran());
            service.mergeServiceConnectionAward(incoming.getServiceConnectionAward(), onFile);
            service.mergeMonetaryBenefitAward(incoming.getMonetaryBenefitAward(), onFile);
            service.mergeEligibilityVerification(incoming.getEligibilityVerification(), onFile);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to accept data from VBA message", (Throwable)e);
        }
    }

    @Override
    public void acceptEligibilityVerificationData(Person incoming, Person onFile) throws RuleException {
        Validate.notNull((Object)((Object)incoming), (String)"An incoming person must not be NULL");
        Validate.notNull((Object)((Object)onFile), (String)"An on file person must not be NULL");
        MergeRuleService service = this.getMergeRuleService();
        try {
            onFile.setVeteran(incoming.getVeteran());
            service.mergeEligibilityVerification(incoming.getEligibilityVerification(), onFile);
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to accept data from VBA message", (Throwable)e);
        }
    }
}

