/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.parameter;

import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.ee.EGTSetting;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.VerificationInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.lookup.EligibilityStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.BaseData;
import gov.va.med.esr.common.rule.data.CommsInputData;
import gov.va.med.esr.common.rule.data.EEInputData;
import gov.va.med.esr.common.rule.data.EventInputData;
import gov.va.med.esr.common.rule.data.ExternalSystemsInputData;
import gov.va.med.esr.common.rule.data.MilitaryServiceInputData;
import gov.va.med.esr.common.rule.data.POWInputData;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.data.SSNVerificationResponseInputData;
import gov.va.med.esr.common.rule.data.accessor.DemographicAccessor;
import gov.va.med.esr.common.rule.service.MergeRuleService;
import gov.va.med.esr.service.ApplicationInProcessService;
import gov.va.med.esr.service.ClinicalDeterminationService;
import gov.va.med.esr.service.CommsLogService;
import gov.va.med.esr.service.EGTService;
import gov.va.med.esr.service.EligibilityEnrollmentService;
import gov.va.med.esr.service.FinancialsService;
import gov.va.med.esr.service.HandBookService;
import gov.va.med.esr.service.LogTransmissionService;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.MessagingService;
import gov.va.med.esr.service.PersonHelperService;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.PurpleHeartService;
import gov.va.med.esr.service.RegistryService;
import gov.va.med.esr.service.RelaxationPercentageService;
import gov.va.med.esr.service.ScheduledTaskService;
import gov.va.med.esr.service.SystemParameterService;
import gov.va.med.esr.service.VOAApplicationService;
import gov.va.med.esr.service.WorkflowService;
import gov.va.med.fw.model.AbstractEntity;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.Lookup;
import gov.va.med.fw.rule.AbstractRuleParameter;
import gov.va.med.fw.rule.RuleDataAware;
import gov.va.med.fw.rule.RuleException;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.service.transaction.TransactionTimestampManager;
import gov.va.med.fw.util.DateUtils;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.Validate;

public abstract class BaseParameter
extends AbstractRuleParameter {
    private static final long serialVersionUID = -1370346746640850300L;
    public static final String YES_INDICATOR = "Y";
    public static final String NO_INDICATOR = "N";
    public static final String[] invalidSSN = new String[]{"000000000", "111111111", "222222222", "333333333", "444444444", "555555555", "666666666", "777777777", "888888888", "999999999", "123456789"};
    private SystemParameterService systemParameterService = null;
    private PersonHelperService helperService = null;
    private MergeRuleService mergeRuleService = null;
    private LookupService lookupService = null;
    private MessagingService messagingService = null;
    private RelaxationPercentageService relaxationPercentageService = null;
    private ApplicationInProcessService applicationInProcessService = null;
    private VOAApplicationService voaApplicationService = null;
    private String clinicalDeterminationServiceName = null;
    private String timestampManagerName = null;
    private String eligibilityEnrollmentServiceName = null;
    private String financialsServiceName = null;
    private String egtServiceName = null;
    private String purpleHeartServiceName = null;
    private String ScheduledTaskServiceName = null;
    private String commsLogServiceName = null;
    private String handBookServiceName = null;
    private WorkflowService workflowService = null;
    private String esrImplementationDateString = null;
    private Person verifiedSiteData = null;
    private Person verifiedAapData = null;
    private Person unverifiedSiteData = null;
    private Person mostRecentSiteData = null;
    private String registryServiceName = null;
    private LogTransmissionService logMessagingService;

    protected BaseParameter() {
    }

    public String getUseCaseName() {
        BaseData data = this.getBaseData();
        return data != null ? data.getUseCaseName() : null;
    }

    public boolean isDatePrecise(Date input) {
        return true;
    }

    public boolean isDatePrecise(ImpreciseDate input) {
        if (input != null) {
            if (input.isPrecise()) {
                return true;
            }
            if (!input.isMonthPrecise()) {
                return false;
            }
        }
        return true;
    }

    public boolean isSatelliteSite(VAFacility satellite, VAFacility incomingSite) throws RuleException {
        try {
            if (satellite != null && incomingSite != null) {
                BigDecimal childId = satellite.getIdentifier();
                BigDecimal parentId = satellite.getParentId();
                VAFacility parentFacility = null;
                while (parentId != null && parentId.compareTo(childId) != 0) {
                    if (parentId.compareTo(incomingSite.getIdentifier()) == 0) {
                        return true;
                    }
                    parentFacility = this.getLookupService().getVAFacilityById(parentId);
                    childId = parentId;
                    parentId = parentFacility == null ? null : parentFacility.getParentId();
                }
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get VA Facility ", (Throwable)e);
        }
        return false;
    }

    public VAFacility getParentSite(VAFacility preferredFacility) throws ServiceException {
        if (preferredFacility == null) {
            return null;
        }
        VAFacility facility = preferredFacility;
        if (Boolean.TRUE.equals(facility.isMfnzegRecipient())) {
            return facility;
        }
        if (facility.getParentId() == null) {
            return facility;
        }
        while (facility.getParentId() != null && facility.getParentId().compareTo(facility.getIdentifier()) != 0) {
            facility = this.getLookupService().getVAFacilityById(facility.getParentId());
            if (!Boolean.TRUE.equals(facility.isMfnzegRecipient())) continue;
            return facility;
        }
        throw new ServiceException("Parent sending site for facility " + preferredFacility.getStationNumber() + " cannot be found");
    }

    public boolean isAfterIgnoreTime(Date date1, Date date2) {
        return DateUtils.isAfterIgnoreTime((Date)date1, (Date)date2);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.helperService, (String)"Helper service must be configured");
    }

    public EntityKey getEntityKey() {
        EntityKey key = null;
        AbstractKeyedEntity entity = this.getKeyedEntity();
        if (entity instanceof AbstractKeyedEntity) {
            key = entity.getEntityKey();
        }
        return key;
    }

    public EGTService getEgtService() throws ServiceException {
        return (EGTService)this.getComponent(this.getEgtServiceName());
    }

    public Person getPristinePerson() {
        return (Person)this.getPristineData();
    }

    public Person getIncomingPerson() {
        return (Person)this.getIncomingData();
    }

    public Person getResultPerson() {
        return (Person)this.getResultData();
    }

    public VAFacility getSendingFacility() {
        BaseData data = this.getBaseData();
        return data != null ? data.getSendingFacility() : null;
    }

    public String getDfn() {
        BaseData data = this.getBaseData();
        return data != null ? data.getDfn() : null;
    }

    public VerificationInfo getAacInfo() {
        PersonInputData data = this.getPersonInputData();
        return data != null ? data.getVerificationInfo() : null;
    }

    public boolean isUpdateFromGUI() {
        if (this.getPersonInputData() == null) {
            return ((BaseData)this.getRuleDataAware()).isDataFromGUI();
        }
        return this.getPersonInputData().isUpdateFromGUI();
    }

    public boolean isUpdateFromMVI() {
        if (this.getPersonInputData() == null) {
            return ((BaseData)this.getRuleDataAware()).isDataFromMVI();
        }
        return this.getPersonInputData().isDataFromMVI();
    }

    public boolean isMsdsActive() throws RuleException {
        try {
            return this.getSystemParameterService().getMSDSServiceIndicator();
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting systemParameterService", (Throwable)serviceEx);
        }
    }

    public boolean isFromAddNewPerson() {
        BaseData bd = this.getBaseData();
        return bd != null ? bd.isFromAddNewPerson() : false;
    }

    public boolean isReconActive() throws RuleException {
        try {
            return this.getSystemParameterService().getMSDSReconIndicator();
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting systemParameterService", (Throwable)serviceEx);
        }
    }

    public EEInputData getEEInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof EEInputData) {
            return (EEInputData)ruleDataAware;
        }
        return null;
    }

    public EventInputData getEventInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof EventInputData) {
            return (EventInputData)ruleDataAware;
        }
        return null;
    }

    public ExternalSystemsInputData getExternalSystemsInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof ExternalSystemsInputData) {
            return (ExternalSystemsInputData)ruleDataAware;
        }
        return null;
    }

    public IncomeTest getPrimaryTest() {
        return this.getHelperService().getCurrentIncomeTest(this.getIncomingPerson());
    }

    public Person getVerifiedSiteData() throws RuleException {
        if (this.verifiedSiteData == null) {
            this.verifiedSiteData = this.getSiteData(EligibilityStatus.CODE_VERIFIED);
        }
        return this.verifiedSiteData;
    }

    public Person getVerifiedAapData() throws RuleException {
        if (this.verifiedAapData == null) {
            try {
                EligibilityVerification ev;
                Person pristine = this.getPristinePerson();
                String shortVPID = pristine.getVPIDEntityKey().getShortVPID();
                List list = this.getApplicationInProcessService().getApplicationStatusesByIcn(shortVPID);
                if (list == null || list.size() == 0 || list.size() > 1) {
                    return null;
                }
                Person aapPerson = this.getApplicationInProcessService().getCompletedPersonByIcn(shortVPID);
                if (aapPerson != null && (ev = aapPerson.getEligibilityVerification()) != null) {
                    String code;
                    String string = code = ev.getEligibilityStatus() != null ? ev.getEligibilityStatus().getCode() : null;
                    if (EligibilityStatus.CODE_VERIFIED.getCode().equals(code)) {
                        this.verifiedAapData = aapPerson;
                    }
                }
            }
            catch (ServiceException serviceEx) {
                throw new RuleException("Error getting Verified AAP Data", (Throwable)serviceEx);
            }
        }
        return this.verifiedAapData;
    }

    public Person getUnverifiedSiteData() throws RuleException {
        if (this.unverifiedSiteData == null) {
            this.unverifiedSiteData = this.getSiteData(EligibilityStatus.CODE_PENDING_VERIFICATION);
            if (this.unverifiedSiteData == null) {
                this.unverifiedSiteData = this.getSiteData(EligibilityStatus.CODE_PENDING_REVERIFICATION);
            }
        }
        return this.unverifiedSiteData;
    }

    public Person getMostRecentSiteData() throws RuleException {
        if (this.mostRecentSiteData == null) {
            this.mostRecentSiteData = this.getVerifiedSiteData();
            if (this.mostRecentSiteData == null) {
                this.mostRecentSiteData = this.getUnverifiedSiteData();
            }
        }
        return this.mostRecentSiteData;
    }

    public CommsInputData getCommsInputData() {
        if (this.getRuleDataAware() instanceof CommsInputData) {
            return (CommsInputData)this.getRuleDataAware();
        }
        return null;
    }

    public DemographicAccessor getDemographicAccessor() {
        if (this.getRuleDataAware() instanceof DemographicAccessor) {
            return (DemographicAccessor)this.getRuleDataAware();
        }
        return null;
    }

    public Clock.Type getFiredClockType() {
        RuleDataAware data = this.getRuleDataAware();
        if (data instanceof BaseData) {
            return ((BaseData)data).getFiredClockType();
        }
        return null;
    }

    public Date getClockStartDate(long days) {
        long msPerDay = 86400000L;
        long millis = msPerDay * days;
        return new Date(System.currentTimeMillis() + millis);
    }

    public Date getCurrentDate() {
        try {
            return this.getTimestampManager().getTransactionTimestamp();
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to get transaction timestamp.", ex);
        }
    }

    public boolean isSSNValid(String ssn) {
        return !StringUtils.isNotEmpty((String)ssn) || !StringUtils.contains((String[])invalidSSN, (String)ssn) && !StringUtils.equals((String)"000", (String)ssn.substring(0, 3)) && !StringUtils.equals((String)"00", (String)ssn.substring(3, 5)) && !StringUtils.equals((String)"0000", (String)ssn.substring(5, 9));
    }

    public Date getEsrImplementationDate() throws RuleException {
        try {
            return this.getSystemParameterService().getEsrImplementationDate();
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting PurpleHeartService", (Throwable)serviceEx);
        }
    }

    public Date getEnrollmentRegulationDate() throws RuleException {
        try {
            return this.getSystemParameterService().getEnrollmentRegulationDate();
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting PurpleHeartService", (Throwable)serviceEx);
        }
    }

    public void setImprovedByMSDS(boolean improvedByMSDS) {
        if (this.getRuleDataAware() instanceof MilitaryServiceInputData) {
            ((MilitaryServiceInputData)this.getRuleDataAware()).setImprovedByMSDS(improvedByMSDS);
        }
    }

    protected PurpleHeartService getPurpleHeartService() throws RuleException {
        try {
            return (PurpleHeartService)this.getComponent(this.getPurpleHeartServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting PurpleHeartService", (Throwable)serviceEx);
        }
    }

    protected CommsLogService getCommsLogService() throws RuleException {
        try {
            return (CommsLogService)this.getComponent(this.getCommsLogServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting CommsLogService", (Throwable)serviceEx);
        }
    }

    protected HandBookService getHandBookService() throws RuleException {
        try {
            return (HandBookService)this.getComponent(this.getHandBookServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting HandBookService", (Throwable)serviceEx);
        }
    }

    protected ScheduledTaskService getScheduledTaskService() throws RuleException {
        try {
            return (ScheduledTaskService)this.getComponent(this.getScheduledTaskServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting ScheduledTaskService", (Throwable)serviceEx);
        }
    }

    protected EGTSetting getActiveEGTSetting() {
        return this.getBaseData() != null ? this.getBaseData().getActiveEGTSetting() : null;
    }

    protected EGTSetting getCurrentEGTSetting() throws RuleException {
        EGTSetting egt = this.getActiveEGTSetting();
        if (egt == null) {
            try {
                egt = this.getEgtService().getCurrentEGTSetting();
            }
            catch (ServiceException e) {
                throw new RuleException("Failed to get egt setting ", (Throwable)e);
            }
        }
        return egt;
    }

    protected Date getDateOfBirth(Person person) {
        Date dateOfBirth = null;
        if (person != null) {
            BirthRecord birthRecord = person.getBirthRecord();
            ImpreciseDate impreciseDate = birthRecord != null ? birthRecord.getBirthDate() : null;
            dateOfBirth = impreciseDate != null ? ImpreciseDateUtils.getDateWithDefault(impreciseDate) : null;
        }
        return dateOfBirth;
    }

    protected EligibilityEnrollmentService getEligibilityEnrollmentService() throws RuleException {
        try {
            return (EligibilityEnrollmentService)this.getComponent(this.getEligibilityEnrollmentServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting EligibilityEnrollmentService", (Throwable)serviceEx);
        }
    }

    protected BaseData getBaseData() {
        RuleDataAware data = this.getRuleDataAware();
        if (data instanceof BaseData) {
            return (BaseData)data;
        }
        return null;
    }

    protected Person getPriorEEPerson() throws RuleException {
        Person person = this.getIncomingPerson();
        Validate.notNull((Object)((Object)person), (String)"A person must not be null ");
        try {
            return this.getEligibilityEnrollmentService().getPersonForPriorEnrollment(person.getEntityKey());
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get prior person", (Throwable)e);
        }
    }

    protected POWInputData getPOWInputData() {
        if (this.getRuleDataAware() instanceof POWInputData) {
            return (POWInputData)this.getRuleDataAware();
        }
        return null;
    }

    protected AbstractKeyedEntity getKeyedEntity() {
        AbstractKeyedEntity key = null;
        AbstractEntity entity = this.getIncomingData();
        if (entity instanceof AbstractKeyedEntity) {
            key = (AbstractKeyedEntity)entity;
        }
        return key;
    }

    protected List getSortedChangeEvents(Set events) {
        ArrayList sortedEvents = new ArrayList();
        if (events != null) {
            sortedEvents.addAll(events);
            Collections.sort(sortedEvents);
        }
        return sortedEvents;
    }

    protected Person getSiteData(EligibilityStatus.Code status) throws RuleException {
        Person verified = null;
        try {
            Person pristine;
            PersonService ps;
            PersonInputData data = this.getPersonInputData();
            PersonService personService = ps = data != null ? data.getPersonService() : null;
            if (ps != null && (pristine = this.getPristinePerson()) != null) {
                verified = ps.getPersonFromSiteData(pristine.getPersonEntityKey(), status.getName());
            }
        }
        catch (ServiceException e) {
            throw new RuleException("Failed to get a verified site data", (Throwable)e);
        }
        return verified;
    }

    protected ClinicalDeterminationService getClinicalDeterminationService() throws RuleException {
        try {
            return (ClinicalDeterminationService)this.getComponent(this.getClinicalDeterminationServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting ClinicalDeterminationService", (Throwable)serviceEx);
        }
    }

    protected TransactionTimestampManager getTimestampManager() throws RuleException {
        try {
            return (TransactionTimestampManager)this.getComponent(this.getTimestampManagerName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting TransactionTimestampManager", (Throwable)serviceEx);
        }
    }

    protected FinancialsService getFinancialsService() throws RuleException {
        try {
            return (FinancialsService)this.getComponent(this.getFinancialsServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting FinancialsService", (Throwable)serviceEx);
        }
    }

    private PersonInputData getPersonInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof PersonInputData) {
            return (PersonInputData)ruleDataAware;
        }
        return null;
    }

    protected SSNVerificationResponseInputData getSSNVerificationResponseInputData() {
        RuleDataAware ruleDataAware = this.getRuleDataAware();
        if (ruleDataAware instanceof SSNVerificationResponseInputData) {
            return (SSNVerificationResponseInputData)ruleDataAware;
        }
        return null;
    }

    protected String getCode(Lookup lookup) {
        return lookup == null ? null : lookup.getCode();
    }

    protected String getSubject() {
        String subject = "V";
        SSNVerificationResponseInputData data = this.getSSNVerificationResponseInputData();
        if (data != null && data.getResultSSNVerificationData() != null) {
            subject = data.getResultSSNVerificationData().isSsnVerificationForDependent() ? "D" : (data.getResultSSNVerificationData().isSsnVerificationForSpouse() ? "S" : "V");
        } else if (this.getCommsInputData() != null && this.getCommsInputData().getSubject() != null) {
            subject = this.getCommsInputData().getSubject();
        }
        return subject;
    }

    protected RegistryService getRegistryService() throws RuleException {
        try {
            return (RegistryService)this.getComponent(this.getRegistryServiceName());
        }
        catch (ServiceException serviceEx) {
            throw new RuleException("Error getting RegistryService", (Throwable)serviceEx);
        }
    }

    public boolean isMessageFromVOA() {
        if (this.isUpdateFromGUI() || this.getSendingFacility() == null) {
            return false;
        }
        Validate.notNull((Object)this.getSendingFacility().getCode(), (String)"sendingFacility station number cannot be null");
        return VAFacility.CODE_MHV.getCode().equals(this.getSendingFacility().getCode());
    }

    public boolean isMessageFromVista() {
        if (this.isUpdateFromGUI() || this.getSendingFacility() == null) {
            return false;
        }
        VAFacility facility = this.getSendingFacility();
        Validate.notNull((Object)facility.getCode(), (String)"sendingFacility station number cannot be null");
        return !VAFacility.CODE_MHV.getCode().equals(facility.getCode()) && !VAFacility.CODE_HEC.getCode().equals(facility.getCode()) && !VAFacility.CODE_HEC_INCORRECT.getCode().equals(facility.getCode()) && !VAFacility.CODE_MVR.getCode().equals(facility.getCode());
    }

    public boolean isCleanup() {
        return ((BaseData)this.getRuleDataAware()).isCleanup();
    }

    public PersonHelperService getHelperService() {
        return this.helperService;
    }

    public void setHelperService(PersonHelperService service) {
        this.helperService = service;
    }

    public MessagingService getMessagingService() {
        return this.messagingService;
    }

    public void setMessagingService(MessagingService messagingService) {
        this.messagingService = messagingService;
    }

    public RelaxationPercentageService getRelaxationPercentageService() {
        return this.relaxationPercentageService;
    }

    public void setRelaxationPercentageService(RelaxationPercentageService relaxationPercentageService) {
        this.relaxationPercentageService = relaxationPercentageService;
    }

    public MergeRuleService getMergeRuleService() {
        return this.mergeRuleService;
    }

    public void setMergeRuleService(MergeRuleService mergeRuleService) {
        this.mergeRuleService = mergeRuleService;
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public String getEligibilityEnrollmentServiceName() {
        return this.eligibilityEnrollmentServiceName;
    }

    public void setEligibilityEnrollmentServiceName(String eligibilityEnrollmentServiceName) {
        this.eligibilityEnrollmentServiceName = eligibilityEnrollmentServiceName;
    }

    public String getClinicalDeterminationServiceName() {
        return this.clinicalDeterminationServiceName;
    }

    public void setClinicalDeterminationServiceName(String clinicalDeterminationServiceName) {
        this.clinicalDeterminationServiceName = clinicalDeterminationServiceName;
    }

    public String getTimestampManagerName() {
        return this.timestampManagerName;
    }

    public void setTimestampManagerName(String timestampManagerName) {
        this.timestampManagerName = timestampManagerName;
    }

    public String getEgtServiceName() {
        return this.egtServiceName;
    }

    public void setEgtServiceName(String egtServiceName) {
        this.egtServiceName = egtServiceName;
    }

    public String getFinancialsServiceName() {
        return this.financialsServiceName;
    }

    public void setFinancialsServiceName(String financialsServiceName) {
        this.financialsServiceName = financialsServiceName;
    }

    public String getPurpleHeartServiceName() {
        return this.purpleHeartServiceName;
    }

    public void setPurpleHeartServiceName(String purpleHeartServiceName) {
        this.purpleHeartServiceName = purpleHeartServiceName;
    }

    public String getScheduledTaskServiceName() {
        return this.ScheduledTaskServiceName;
    }

    public void setScheduledTaskServiceName(String scheduledTaskServiceName) {
        this.ScheduledTaskServiceName = scheduledTaskServiceName;
    }

    public String getCommsLogServiceName() {
        return this.commsLogServiceName;
    }

    public void setCommsLogServiceName(String commsLogServiceName) {
        this.commsLogServiceName = commsLogServiceName;
    }

    public String getHandBookServiceName() {
        return this.handBookServiceName;
    }

    public void setHandBookServiceName(String handBookServiceName) {
        this.handBookServiceName = handBookServiceName;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }

    public void setEsrImplementationDateString(String esrImplementationDateString) {
        this.esrImplementationDateString = esrImplementationDateString;
    }

    public SystemParameterService getSystemParameterService() {
        return this.systemParameterService;
    }

    public void setSystemParameterService(SystemParameterService systemParameterService) {
        this.systemParameterService = systemParameterService;
    }

    protected String getEsrImplementationDateString() {
        return this.esrImplementationDateString;
    }

    public String getRegistryServiceName() {
        return this.registryServiceName;
    }

    public void setRegistryServiceName(String registryServiceName) {
        this.registryServiceName = registryServiceName;
    }

    public LogTransmissionService getLogMessagingService() {
        return this.logMessagingService;
    }

    public void setLogMessagingService(LogTransmissionService logMessagingService) {
        this.logMessagingService = logMessagingService;
    }

    public ApplicationInProcessService getApplicationInProcessService() {
        return this.applicationInProcessService;
    }

    public void setApplicationInProcessService(ApplicationInProcessService applicationInProcessService) {
        this.applicationInProcessService = applicationInProcessService;
    }

    public VOAApplicationService getVoaApplicationService() {
        return this.voaApplicationService;
    }

    public void setVoaApplicationService(VOAApplicationService voaApplicationService) {
        this.voaApplicationService = voaApplicationService;
    }
}

