/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.rule.data;

import gov.va.med.esr.common.model.lookup.MessageType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.rule.data.PersonInputData;
import gov.va.med.esr.common.rule.data.accessor.DemographicAccessor;
import gov.va.med.esr.common.rule.data.accessor.MessageTriggerAccessor;
import gov.va.med.esr.common.rule.data.accessor.PropertyAccessor;
import gov.va.med.esr.service.trigger.PersonTriggerEvent;
import gov.va.med.fw.hl7.Message;
import gov.va.med.fw.model.AbstractEntity;

public class ConsistencyCheckInputData
extends PersonInputData
implements DemographicAccessor,
MessageTriggerAccessor {
    private static final long serialVersionUID = 6371059960271645050L;
    private MessageType messageType;
    private Message message;
    private PersonTriggerEvent triggerEvent;

    public ConsistencyCheckInputData(Person person, PersonTriggerEvent triggerEvent, Message message, MessageType messageType) {
        if (person != null) {
            this.setIncomingData((AbstractEntity)person);
            this.setPristineData((AbstractEntity)person);
            this.setResultData((AbstractEntity)person);
        }
        this.messageType = messageType;
        this.message = message;
        this.triggerEvent = triggerEvent;
    }

    public ConsistencyCheckInputData(Person person, MessageType messageType) {
        super(person, person, person);
        this.messageType = messageType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public void setMessageType(MessageType messageType) {
        this.messageType = messageType;
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public PersonTriggerEvent getTriggerEvent() {
        return this.triggerEvent;
    }

    public void setTriggerEvent(PersonTriggerEvent triggerEvent) {
        this.triggerEvent = triggerEvent;
    }

    @Override
    public Address getAddress(PropertyAccessor.DataType dataType) {
        Person person = this.getPerson(dataType);
        return person != null ? person.getPermanentAddress() : null;
    }

    @Override
    public Message getMessage(PropertyAccessor.DataType dataType) {
        return this.getMessage();
    }

    @Override
    public PersonTriggerEvent getTriggerEvent(PropertyAccessor.DataType dataType) {
        return this.getTriggerEvent();
    }

    @Override
    public MessageType getMessageType(PropertyAccessor.DataType dataType) {
        return this.getMessageType();
    }
}

