/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.EnrollmentProcessStatus;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.ReportFormat;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportEnrollmentStatusComponent;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class QM3ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = 1178123948624532738L;

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
        ReportSetup setup = criteria.getReportSetup();
        ReportParameterSet parameters = setup.getParameterSet();
        if (reportCriteria instanceof StandardReportCriteria) {
            criteria.setStartDate(this.getDate(config, true));
            criteria.setEndDate(this.getDate(config, false));
            if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())) {
                Integer days = parameters.getOutlierDays();
                if (days == null) {
                    days = new Integer(0);
                }
                criteria.setExceedXDays(days.toString());
                Set enrollmentStatuses = parameters.getEnrollmentStatusComponents();
                for (ReportEnrollmentStatusComponent comp : enrollmentStatuses) {
                    String code = comp.getEnrollmentStatusComponent().getCode();
                    criteria.addCriterion("enrollmentStatusComponent" + code, "Y");
                }
            }
        }
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            EnrollmentProcessStatus processStatus;
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            if (startDate == null) {
                throw new ReportDataException("Missing Start Date in report " + config.getReportID());
            }
            Date endDate = parameters.getToDate();
            if (endDate == null) {
                throw new ReportDataException("Missing End Date in report " + config.getReportID());
            }
            query.setDate("startDate", startDate);
            query.setDate("endDate", endDate);
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy != null && !StringUtils.isEmpty((String)facilityDisplayBy.getCode())) {
                ArrayList<Integer> facilities;
                if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    List visns = this.getFacilitityIds(parameters.getFacilities());
                    if (visns != null && !visns.isEmpty()) {
                        query.setParameterList("visns", visns.toArray());
                    } else {
                        facilities = new ArrayList();
                        facilities.add(new Integer(0));
                        query.setParameterList("visns", facilities);
                    }
                    if (parameters.isNoVISNPresent()) {
                        query.setString("noVISN", "noVISN");
                    } else {
                        query.setString("noVISN", "VISN");
                    }
                } else {
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        facilities = new ArrayList<Integer>();
                        facilities.add(new Integer(0));
                        query.setParameterList("facilities", facilities);
                        query.setString("is_all", "all");
                    } else {
                        query.setParameterList("facilities", (Collection)this.getFacilitityIds(reportFacilities));
                        query.setString("is_all", "notAll");
                    }
                }
            }
            if ((processStatus = parameters.getEnrollmentProcessStatus()) != null && EnrollmentProcessStatus.CODE_INCOMPLETE.equals(processStatus.getCodeObject())) {
                query.setString("incompleteFlg", "Y");
            } else {
                query.setString("incompleteFlg", "N");
            }
            if (ReportFormat.DETAIL.getName().equals(parameters.getReportFormat().getCode())) {
                Integer days = parameters.getOutlierDays();
                if (days == null) {
                    days = new Integer(0);
                }
                query.setInteger("days", days.intValue());
                Set enrollmentStatuses = parameters.getEnrollmentStatusComponents();
                Iterator iter = enrollmentStatuses.iterator();
                ArrayList<String> listComps = new ArrayList<String>();
                while (iter.hasNext()) {
                    ReportEnrollmentStatusComponent comp = (ReportEnrollmentStatusComponent)iter.next();
                    String code = comp.getEnrollmentStatusComponent().getCode();
                    listComps.add(code);
                }
                query.setParameterList("enrollmentStatusComponent", listComps);
            }
        }
        return query;
    }

    private List getFacilitityIds(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null) continue;
            list.add(((VAFacility)rFacility.getLookup()).getIdentifier());
        }
        return list;
    }
}

