/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportUser;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class EED19ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            boolean isDetailedReport;
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            String[] params = query.getNamedParameters();
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            if (startDate == null) {
                throw new ReportDataException("Missing Start Date in report " + config.getReportID());
            }
            query.setDate("startDate", startDate);
            boolean bl = isDetailedReport = config.getReportOutputName().indexOf("Detailed") > 0;
            if (isDetailedReport) {
                Date endDate = parameters.getToDate();
                if (endDate == null) {
                    throw new ReportDataException("Missing End Date in report " + config.getReportID());
                }
                query.setDate("endDate", endDate);
                Set reportUsers = parameters.getUsers();
                if (reportUsers != null && !reportUsers.isEmpty()) {
                    ArrayList<String> userIds = new ArrayList<String>();
                    for (ReportUser reportuser : reportUsers) {
                        String userId = reportuser.getUser().getUserCredentials().getUserID();
                        userIds.add(userId);
                    }
                    if (userIds.isEmpty()) {
                        userIds.add("0");
                    }
                    query.setParameterList("recordsCreatedBy", userIds);
                    query.setString("is_all", "notAll");
                } else {
                    ArrayList<String> userIds = new ArrayList<String>();
                    userIds.add("");
                    query.setParameterList("recordsCreatedBy", userIds);
                    query.setString("is_all", "all");
                }
            }
        }
        return query;
    }
}

