/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data.impl;

import gov.va.med.esr.common.model.lookup.ReportEligibilityFactorLU;
import gov.va.med.esr.common.model.lookup.ReportFacilityDisplayBy;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.report.ReportEligibilityFactor;
import gov.va.med.esr.common.model.report.ReportFacility;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.report.data.StandardReportCriteria;
import gov.va.med.esr.common.report.data.impl.AbstractStandardReportDataDAOImpl;
import gov.va.med.fw.report.ReportConfiguration;
import gov.va.med.fw.report.data.QueryCriteria;
import gov.va.med.fw.report.data.ReportDataException;
import gov.va.med.fw.util.StopWatchLogger;
import gov.va.med.fw.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Query;
import org.hibernate.Session;

public class EED10ReportDataDAOImpl
extends AbstractStandardReportDataDAOImpl {
    private static final long serialVersionUID = -5657439440961807171L;
    private static final int MAX_VALUES_IN_LIST = 1000;

    @Override
    public void preDataRetrieval(ReportConfiguration config) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria) {
            ReportParameterSet parameters;
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date asOfdate = parameters.getAsOfDate();
            if (asOfdate != null) {
                criteria.addCriterion("asOfDate", asOfdate);
                criteria.setStartDate(null);
                criteria.setEndDate(null);
            } else {
                criteria.addCriterion("asOfDate", null);
                criteria.setStartDate(this.getDate(config, true));
                criteria.setEndDate(this.getDate(config, false));
            }
        }
    }

    @Override
    protected Query buildQuery(ReportConfiguration config, Session session) throws ReportDataException {
        QueryCriteria reportCriteria = config.getQueryCriteria();
        Query query = null;
        if (reportCriteria instanceof StandardReportCriteria) {
            List<Integer> visns;
            ReportParameterSet parameters;
            query = this.getNamedQuery(session);
            StandardReportCriteria criteria = (StandardReportCriteria)reportCriteria;
            ReportSetup setup = criteria.getReportSetup();
            ReportParameterSet reportParameterSet = parameters = setup != null ? setup.getParameterSet() : null;
            if (parameters == null) {
                throw new ReportDataException("Missing report parameters in report " + config.getReportID());
            }
            Date startDate = parameters.getFromDate();
            Date endDate = parameters.getToDate();
            Date asOfdate = parameters.getAsOfDate();
            if (asOfdate != null) {
                query.setString("asOfDateFlag", "Y");
                query.setDate("startDate", null);
                query.setDate("endDate", asOfdate);
            } else {
                query.setString("asOfDateFlag", "N");
                query.setDate("startDate", startDate);
                query.setDate("endDate", endDate);
            }
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy != null && StringUtils.isNotEmpty((String)facilityDisplayBy.getCode())) {
                if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    visns = this.getFacilitityIds(parameters.getFacilities());
                    if (visns != null && !visns.isEmpty()) {
                        query.setString("facilityType", "VISN");
                        query.setParameterList("firstFacilityList", visns.toArray());
                        query.setParameterList("secondFacilityList", visns.toArray());
                        query.setString("is_all", "notAll");
                    } else {
                        visns.add(new Integer(0));
                        query.setString("facilityType", "VISN");
                        query.setParameterList("firstFacilityList", visns.toArray());
                        query.setParameterList("secondFacilityList", visns.toArray());
                        query.setString("is_all", "all");
                    }
                } else {
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        ArrayList<Integer> facilities = new ArrayList<Integer>();
                        facilities.add(new Integer(0));
                        query.setString("facilityType", "FACILITY");
                        query.setParameterList("firstFacilityList", facilities);
                        query.setParameterList("secondFacilityList", facilities);
                        query.setString("is_all", "all");
                    } else {
                        query.setString("facilityType", "FACILITY");
                        List facilities = this.getFacilitityIds(reportFacilities);
                        ArrayList firstFacilityList = new ArrayList();
                        ArrayList secondFacilityList = new ArrayList();
                        this.getFacilitySubLists(facilities, firstFacilityList, secondFacilityList);
                        query.setParameterList("firstFacilityList", firstFacilityList);
                        query.setParameterList("secondFacilityList", secondFacilityList);
                        query.setString("is_all", "notAll");
                    }
                }
            } else {
                visns = new ArrayList<Integer>();
                visns.add(new Integer(0));
                query.setString("facilityType", "VISN");
                query.setParameterList("firstFacilityList", visns.toArray());
                query.setParameterList("secondFacilityList", visns.toArray());
                query.setString("is_all", "all");
            }
            List eligibilityFactorIds = this.getEligFactorIds(parameters.getEligibilityFactors());
            if (!eligibilityFactorIds.isEmpty()) {
                query.setString("is_all_elig", "notAll");
            } else {
                query.setString("is_all_elig", "all");
                eligibilityFactorIds.add(new Integer(0));
            }
            query.setParameterList("eligibilityFactors", (Collection)eligibilityFactorIds);
        }
        return query;
    }

    private List getFacilitityIds(Set facilities) {
        Iterator i = facilities != null ? facilities.iterator() : null;
        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
        while (i != null && i.hasNext()) {
            ReportFacility rFacility = (ReportFacility)i.next();
            if (rFacility == null) continue;
            list.add(((VAFacility)rFacility.getLookup()).getIdentifier());
        }
        return list;
    }

    private List getEligFactorIds(Set eligibilityFactors) {
        ArrayList<Integer> statusIds = new ArrayList<Integer>();
        if (eligibilityFactors != null && !eligibilityFactors.isEmpty()) {
            for (ReportEligibilityFactor factor : eligibilityFactors) {
                ReportEligibilityFactorLU status = factor.getReportEligibilityFactorLU();
                statusIds.add(new Integer(status.getCode()));
            }
        }
        return statusIds;
    }

    private void getFacilitySubLists(List facilities, List firstSubList, List secondSubList) {
        if (facilities.size() > 1000) {
            firstSubList.addAll(facilities.subList(0, 1000));
            secondSubList.addAll(facilities.subList(1000, facilities.size() - 1));
        } else {
            firstSubList.addAll(facilities);
            secondSubList.add(new Integer(0));
        }
    }

    public List getRecords(ReportConfiguration config, int firstRecord, int maxRecord) throws ReportDataException {
        List records = null;
        String executionInfo = "Executing EED10 Report query " + this.getQueryName() + " with criteria = " + this.getReportCriteria(config) + " First Record: " + firstRecord + " Max Record: " + maxRecord;
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)executionInfo);
        }
        StopWatchLogger watch = new StopWatchLogger(executionInfo);
        watch.start();
        records = super.getRecords(config, firstRecord, maxRecord);
        watch.stopAndLog(records.size() + " records returned. ");
        return records;
    }

    private String getReportCriteria(ReportConfiguration config) {
        StandardReportCriteria criteria;
        ReportSetup setup;
        StringBuffer result = new StringBuffer();
        QueryCriteria reportCriteria = config.getQueryCriteria();
        if (reportCriteria instanceof StandardReportCriteria && (setup = (criteria = (StandardReportCriteria)reportCriteria).getReportSetup()) != null) {
            ReportParameterSet parameters = setup.getParameterSet();
            Date startDate = parameters.getFromDate();
            Date endDate = parameters.getToDate();
            Date asOfDate = parameters.getAsOfDate();
            result.append("Start Date: " + startDate);
            result.append(" End Date: " + endDate);
            result.append(" As Of Date: " + asOfDate);
            ReportFacilityDisplayBy facilityDisplayBy = parameters.getFacilityDisplayBy();
            if (facilityDisplayBy != null && StringUtils.isNotEmpty((String)facilityDisplayBy.getCode())) {
                if (StringUtils.equals((String)facilityDisplayBy.getCode(), (String)ReportFacilityDisplayBy.CODE_VISN.getCode())) {
                    result.append(" Facility Type: VISN");
                    List visns = this.getFacilitityIds(parameters.getFacilities());
                    if (visns != null && !visns.isEmpty()) {
                        result.append(" VISNs: ");
                        result.append(this.buildValuesList(visns));
                        result.append(" is_all = notAll");
                    } else {
                        result.append(" is_all = all");
                    }
                } else {
                    result.append(" Facility Type: FACILITY");
                    Set reportFacilities = parameters.getFacilities();
                    if (reportFacilities == null || reportFacilities.isEmpty()) {
                        result.append(" is_all = all");
                    } else {
                        List facilities = this.getFacilitityIds(reportFacilities);
                        ArrayList firstFacilityList = new ArrayList();
                        ArrayList secondFacilityList = new ArrayList();
                        this.getFacilitySubLists(facilities, firstFacilityList, secondFacilityList);
                        result.append(" First Facility List: ");
                        result.append(this.buildValuesList(firstFacilityList));
                        result.append(" Second Facility List: ");
                        result.append(this.buildValuesList(secondFacilityList));
                        result.append(" is_all = notAll");
                    }
                }
            } else {
                result.append(" Default Facility Type: VISN");
                result.append(" is_all = notAll");
            }
            List eligibilityFactorIds = this.getEligFactorIds(parameters.getEligibilityFactors());
            if (!eligibilityFactorIds.isEmpty()) {
                result.append(" is_all_elig = notAll");
            } else {
                result.append(" is_all_elig = all");
            }
            result.append(" Eligibility Factors: " + eligibilityFactorIds);
        }
        return result.toString();
    }

    private String buildValuesList(List list) {
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i == list.size() - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

