/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.report.data;

import gov.va.med.esr.common.model.lookup.ReportEEDWeeklyType;
import gov.va.med.esr.common.model.lookup.StandardReport;
import gov.va.med.esr.common.model.report.ReportEEDWeeklyReportType;
import gov.va.med.esr.common.model.report.ReportParameterSet;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.security.ESRUserPrincipal;
import gov.va.med.esr.service.LookupService;
import gov.va.med.esr.service.StandardReportService;
import gov.va.med.esr.service.UnknownLookupCodeException;
import gov.va.med.esr.service.UnknownLookupTypeException;
import gov.va.med.fw.report.ReportExportedType;
import gov.va.med.fw.scheduling.AbstractScheduledProcess;
import gov.va.med.fw.scheduling.ScheduledProcessInvocationContext;
import gov.va.med.fw.security.SecurityContextHelper;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang.Validate;

public class WeeklyReportScheduledProcess
extends AbstractScheduledProcess {
    private LookupService lookupService = null;
    private StandardReportService standardReportService = null;

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.lookupService, (String)"A lookup service is required");
        Validate.notNull((Object)this.standardReportService, (String)"A standard report service is required");
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public void setStandardReportService(StandardReportService service) {
        this.standardReportService = service;
    }

    protected StandardReport getStandadReport(String code) throws UnknownLookupTypeException, UnknownLookupCodeException {
        return this.lookupService.getStandardReportByCode(code);
    }

    protected ReportExportedType getReportExportedType(String code) throws UnknownLookupTypeException, UnknownLookupCodeException {
        return this.lookupService.getReportExportedTypeByCode(code);
    }

    protected void generateReport(UserPrincipal user, ReportSetup setup) throws Exception {
        this.standardReportService.generateReport(user, setup);
    }

    protected void executeProcess(ScheduledProcessInvocationContext context) throws Exception {
        Date startTime = DateUtils.getFiscalYearFirstQuarter((int)DateUtils.getFiscalYear((Date)DateUtils.getCurrentDate()), (boolean)true).getTime();
        Calendar calendar = Calendar.getInstance();
        int dayOfWeek = calendar.get(7);
        dayOfWeek = dayOfWeek != 1 ? 1 : dayOfWeek;
        calendar.set(7, dayOfWeek);
        Date endTime = calendar.getTime();
        ReportParameterSet parameterSet = new ReportParameterSet();
        parameterSet.setFileType(this.getReportExportedType(ReportExportedType.PDF.getName()));
        parameterSet.setFromDate(startTime);
        parameterSet.setToDate(endTime);
        ReportEEDWeeklyReportType type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.OTHER_UPDATES.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_ADDRESS_STATS.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_AUTO_UDPATE.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.ENROLLMENT_UPDATES.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.AAC_ENROLLMENT_LETTERS.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.ELIGIBILITY_UPDATES.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        type = new ReportEEDWeeklyReportType();
        type.setReportEEDWeeklyType(this.lookupService.getReportEEDWeeklyTypeByCode(ReportEEDWeeklyType.PH_STATS.getCode()));
        parameterSet.addReportEEDWeeklyReportType(type);
        ReportSetup setup = new ReportSetup();
        setup.setReport(this.getStandadReport(StandardReport.CODE_EED_8.getCode()));
        setup.setParameterSet(parameterSet);
        UserPrincipal user = SecurityContextHelper.getSecurityContext().getUserPrincipal();
        setup.setSetupUser(user instanceof ESRUserPrincipal ? (ESRUserPrincipal)user : null);
        this.generateReport(user, setup);
    }
}

