/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.report.hibernate;

import gov.va.med.esr.common.model.report.CompletedReport;
import gov.va.med.esr.common.model.report.ReportSetup;
import gov.va.med.esr.common.model.report.ReportSetupLite;
import gov.va.med.esr.common.model.report.SimpleCompletedReport;
import gov.va.med.esr.common.persistent.report.ReportDAO;
import gov.va.med.esr.service.CompletedReportsSearchQueryInfo;
import gov.va.med.esr.service.ReportFilterSearchQueryInfo;
import gov.va.med.esr.service.ReportStatus;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.UserPrincipalImpl;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.MaxRecordsExceededException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import gov.va.med.fw.persistent.hibernate.PaginatedQueryExecutor;
import gov.va.med.fw.security.UserPrincipal;
import gov.va.med.fw.service.pagination.SearchQueryInfo;
import gov.va.med.fw.util.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Property;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateSystemException;

public class ReportDAOImpl
extends GenericDAOImpl
implements ReportDAO {
    private static final long serialVersionUID = -4505636222269910037L;
    private static final String SQL_QUERY_GET_ALL_REPORT_SETUP_BY_USER = "SQL_reportSetupQuery_GetAllReportSetupByUser";
    private static final String QUERY_GET_ALL_COMPLETED_REPORT_BY_USER = "completedReportQuery_GetAllCompletedReportByUser";
    private static final String QUERY_GET_DISTINCT_STANDARD_REPORTS_FROM_COMPLETED_REPORTS = "standardReportQuery_GetDistinctStandardReportsFromCompletedReports";
    private static final String QUERY_GET_DISTINCT_EXPORT_TYPES_FROM_COMPLETED_REPORTS = "reportExportTypeQuery_GetDistinctExportTypesFromCompletedReports";
    private static final String QUERY_GET_ACTIVE_INACTIVE_COMPLETED_REPORTS_COUNT = "completedReportQuery_GetActiveInactivateCompletedReportsCount";
    private static final String USER_PARAM_NAME = "user";
    private static final String USER_NAME = "userName";
    private static final String REPORT_SETUP_LITE = "reportSetupLite";

    @Override
    public List getReportSetups(UserPrincipal user) throws DAOException {
        List reportList = null;
        try {
            HashMap<String, UserPrincipal> contextData = new HashMap<String, UserPrincipal>();
            contextData.put(USER_PARAM_NAME, user);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) {
                    Query query = session.getNamedQuery(ReportDAOImpl.SQL_QUERY_GET_ALL_REPORT_SETUP_BY_USER);
                    session.createSQLQuery(query.getQueryString()).addEntity(ReportDAOImpl.REPORT_SETUP_LITE, ReportSetupLite.class);
                    query.setParameter(ReportDAOImpl.USER_NAME, (Object)((UserPrincipalImpl)this.getContextData().get(ReportDAOImpl.USER_PARAM_NAME)).getName());
                    return query.list();
                }
            };
            reportList = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get report setup by user", (Throwable)e);
        }
        return reportList;
    }

    @Override
    public ReportSetup getReportSetup(EntityKey identifier) throws DAOException {
        Validate.notNull((Object)identifier, (String)"ReportSetup identifier can not be null.");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"ReportSetup identifier key can not be null.");
        try {
            ReportSetup reportSetup = (ReportSetup)((Object)this.getHibernateTemplate().get(ReportSetup.class, identifier.getKeyValue()));
            return reportSetup;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get ReportSetup by id " + identifier.getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public void saveReportSetup(ReportSetup reportSetup) throws DAOException {
        super.saveObject((Object)reportSetup);
    }

    @Override
    public void deleteReportSetup(EntityKey identifier) throws DAOException {
        Validate.notNull((Object)identifier, (String)"ReportSetup identifier can not be null.");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"ReportSetup identifier key can not be null.");
        super.removeObject(identifier);
    }

    @Override
    public List getCompletedReports(UserPrincipal user) throws DAOException {
        try {
            return this.getHibernateTemplate().findByNamedQueryAndNamedParam(QUERY_GET_ALL_COMPLETED_REPORT_BY_USER, USER_PARAM_NAME, (Object)user);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get completed reports by user", (Throwable)e);
        }
    }

    @Override
    public CompletedReport getCompletedReport(EntityKey identifier) throws DAOException {
        Validate.notNull((Object)identifier, (String)"CompletedReport identifier can not be null.");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"CompletedReport identifier key can not be null.");
        try {
            CompletedReport completedReport = (CompletedReport)((Object)this.getHibernateTemplate().get(CompletedReport.class, identifier.getKeyValue()));
            return completedReport;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get ReportSetup by id " + identifier.getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public SimpleCompletedReport getSimpleCompletedReport(EntityKey identifier) throws DAOException {
        Validate.notNull((Object)identifier, (String)"SimpleCompletedReport identifier can not be null.");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"SimpleCompletedReport identifier key can not be null.");
        try {
            SimpleCompletedReport simpleCompletedReport = (SimpleCompletedReport)((Object)this.getHibernateTemplate().get(SimpleCompletedReport.class, identifier.getKeyValue()));
            return simpleCompletedReport;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get SimpleCompletedReport by id " + identifier.getKeyValueAsString(), (Throwable)e);
        }
    }

    @Override
    public void saveCompletedReport(CompletedReport completedReport) throws DAOException {
        super.saveObject((Object)completedReport);
    }

    @Override
    public List searchCompletedReports(CompletedReportsSearchQueryInfo searchCriteriaInfo) throws DAOException, MaxRecordsExceededException {
        HashMap<String, CompletedReportsSearchQueryInfo> contextData = new HashMap<String, CompletedReportsSearchQueryInfo>();
        contextData.put("cmpRptSearchCriteriaInfo", searchCriteriaInfo);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                CompletedReportsSearchQueryInfo targetQueryInfo = (CompletedReportsSearchQueryInfo)this.getContextData().get("cmpRptSearchCriteriaInfo");
                Criteria countCriteria = ReportDAOImpl.this.getSearchSelectCountCriteria(session, targetQueryInfo);
                Criteria dataCriteria = ReportDAOImpl.this.getSearchSelectDataCriteria(session, targetQueryInfo);
                PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countCriteria, dataCriteria, (SearchQueryInfo)targetQueryInfo, false);
                try {
                    List results = queryExecutor.executeQuery();
                    return results;
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
            }
        };
        try {
            return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
    }

    private Criteria getSearchSelectCountCriteria(Session session, CompletedReportsSearchQueryInfo targetQueryInfo) {
        Criteria criteria = this.buildBaseCriteria(session, targetQueryInfo);
        criteria.setProjection(Projections.rowCount());
        return criteria;
    }

    private Criteria getSearchSelectDataCriteria(Session session, CompletedReportsSearchQueryInfo targetQueryInfo) {
        Criteria criteria = this.buildBaseCriteria(session, targetQueryInfo);
        return criteria;
    }

    private Criteria buildBaseCriteria(Session session, CompletedReportsSearchQueryInfo targetQueryInfo) {
        Criteria criteria = session.createCriteria(SimpleCompletedReport.class);
        if (targetQueryInfo.getReportType() != null) {
            criteria.createCriteria("standardReport").createCriteria("type").add((Criterion)Restrictions.eq((String)"identifier", (Object)targetQueryInfo.getReportType().getIdentifier()));
        }
        if (targetQueryInfo.getStandardReport() != null) {
            Property stdRptId = Property.forName((String)"standardReport.identifier");
            criteria.add((Criterion)stdRptId.eq((Object)targetQueryInfo.getStandardReport().getIdentifier()));
        }
        if (targetQueryInfo.getReportExportedType() != null) {
            criteria.createCriteria("fileType").add((Criterion)Restrictions.eq((String)"identifier", (Object)targetQueryInfo.getReportExportedType().getIdentifier()));
        }
        if (targetQueryInfo.getDateFrom() != null) {
            criteria.add((Criterion)Expression.ge((String)"completedDate", (Object)targetQueryInfo.getDateFrom()));
        }
        if (targetQueryInfo.getDateTo() != null) {
            criteria.add((Criterion)Expression.le((String)"completedDate", (Object)targetQueryInfo.getDateTo()));
        }
        if (targetQueryInfo.getReportParameters() != null) {
            criteria.add(Expression.ilike((String)"reportParameterText", (Object)("%" + targetQueryInfo.getReportParameters() + "%")));
        }
        if (targetQueryInfo.getReportStatus() != null) {
            if (targetQueryInfo.getReportStatus().getCode().equals(ReportStatus.ACTIVE.getCode())) {
                criteria.add(Expression.isNull((String)"inactivatedDate"));
            } else if (targetQueryInfo.getReportStatus().getCode().equals(ReportStatus.INACTIVE.getCode())) {
                criteria.add(Expression.isNotNull((String)"inactivatedDate"));
            }
        }
        if (targetQueryInfo.getInactivatedDate() != null) {
            criteria.add((Criterion)Expression.ge((String)"inactivatedDate", (Object)targetQueryInfo.getInactivatedDate()));
            criteria.add((Criterion)Expression.lt((String)"inactivatedDate", (Object)DateUtils.getAddedDate((int)5, (int)1, (Calendar)DateUtils.createCalendar((Date)targetQueryInfo.getInactivatedDate()))));
        }
        return criteria;
    }

    @Override
    public List searchScheduledReports(ReportFilterSearchQueryInfo searchCriteriaInfo) throws DAOException, MaxRecordsExceededException {
        HashMap<String, ReportFilterSearchQueryInfo> contextData = new HashMap<String, ReportFilterSearchQueryInfo>();
        contextData.put("schRptSearchCriteriaInfo", searchCriteriaInfo);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                ReportFilterSearchQueryInfo targetQueryInfo = (ReportFilterSearchQueryInfo)this.getContextData().get("schRptSearchCriteriaInfo");
                Criteria countCriteria = ReportDAOImpl.this.getSearchSelectCountCriteria(session, targetQueryInfo);
                Criteria dataCriteria = ReportDAOImpl.this.getSearchSelectDataCriteria(session, targetQueryInfo);
                PaginatedQueryExecutor queryExecutor = new PaginatedQueryExecutor(countCriteria, dataCriteria, (SearchQueryInfo)targetQueryInfo, false);
                try {
                    List results = queryExecutor.executeQuery();
                    return results;
                }
                catch (MaxRecordsExceededException e) {
                    throw new DAOException("max records exceeded", (Throwable)e);
                }
            }
        };
        try {
            return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        }
        catch (HibernateSystemException e) {
            MaxRecordsExceededException rootCause = (MaxRecordsExceededException)this.getRootExceptionOfType(e, MaxRecordsExceededException.class);
            if (rootCause != null) {
                throw rootCause;
            }
            throw e;
        }
    }

    private Criteria getSearchSelectCountCriteria(Session session, ReportFilterSearchQueryInfo targetQueryInfo) {
        Criteria criteria = this.buildBaseCriteria(session, targetQueryInfo);
        criteria.setProjection(Projections.rowCount());
        return criteria;
    }

    private Criteria getSearchSelectDataCriteria(Session session, ReportFilterSearchQueryInfo targetQueryInfo) {
        Criteria criteria = this.buildBaseCriteria(session, targetQueryInfo);
        return criteria;
    }

    private Criteria buildBaseCriteria(Session session, ReportFilterSearchQueryInfo targetQueryInfo) {
        Criteria criteria = session.createCriteria(ReportSetupLite.class);
        if (targetQueryInfo.getReportType() != null) {
            criteria.createCriteria("report").createCriteria("type").add((Criterion)Restrictions.eq((String)"identifier", (Object)targetQueryInfo.getReportType().getIdentifier()));
        }
        if (targetQueryInfo.getStandardReport() != null) {
            Property stdRptId = Property.forName((String)"report.identifier");
            criteria.add((Criterion)stdRptId.eq((Object)targetQueryInfo.getStandardReport().getIdentifier()));
        }
        if (targetQueryInfo.getReportExportedType() != null) {
            criteria.createCriteria("fileType").add((Criterion)Restrictions.eq((String)"identifier", (Object)targetQueryInfo.getReportExportedType().getIdentifier()));
        }
        return criteria;
    }

    @Override
    public void deleteCompletedReport(EntityKey identifier) throws DAOException {
        Validate.notNull((Object)identifier, (String)"CompletedReport identifier can not be null.");
        Validate.notNull((Object)identifier.getKeyValue(), (String)"CompletedReport identifier key can not be null.");
        super.removeObject(identifier);
    }

    @Override
    public List getDistinctStandardReports() throws DAOException {
        try {
            return this.getHibernateTemplate().findByNamedQuery(QUERY_GET_DISTINCT_STANDARD_REPORTS_FROM_COMPLETED_REPORTS);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get distinct standard reports from complated reports", (Throwable)e);
        }
    }

    @Override
    public List getDistinctReportExportTypes() throws DAOException {
        try {
            return this.getHibernateTemplate().findByNamedQuery(QUERY_GET_DISTINCT_EXPORT_TYPES_FROM_COMPLETED_REPORTS);
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get distinct report export types from complated reports", (Throwable)e);
        }
    }

    @Override
    public Map getActiveInactiveReportsCount() throws DAOException {
        HashMap<String, Object> counts = new HashMap<String, Object>();
        try {
            Object[] obj;
            List list = this.getHibernateTemplate().findByNamedQuery(QUERY_GET_ACTIVE_INACTIVE_COMPLETED_REPORTS_COUNT);
            Object[] objectArray = obj = list != null && list.size() > 0 ? (Object[])list.get(0) : null;
            if (obj != null && obj.length > 0) {
                counts.put("activeReportsCount", obj[0]);
            }
            if (obj != null && obj.length > 1) {
                counts.put("inactiveReportsCount", obj[1]);
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get active and inactive report counts from complated reports", (Throwable)e);
        }
        return counts;
    }
}

