/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.messaging.hibernate;

import gov.va.med.esr.common.model.messaging.IrsTransmissionLogDetailEntry;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.persistent.messaging.IrsTransmissionLogDetailEntryDAO;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.annotation.Transactional;

public class IrsTransmissionLogDetailEntryDAOImpl
extends GenericDAOImpl
implements IrsTransmissionLogDetailEntryDAO {
    private static final long serialVersionUID = -4381743890112053737L;

    @Override
    @Transactional
    public IrsTransmissionLogDetailEntry getById(BigDecimal identifier) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("IrsTransmissionLogDetailEntryQuery_Identifier", "identifier", (Object)identifier);
            return results.isEmpty() ? null : (IrsTransmissionLogDetailEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public List<IrsTransmissionLogDetailEntry> findByPersonId(EntityKey personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("IrsTransmissionLogDetailEntryQuery_findByPersonId", "personId", (Object)((BigDecimal)personId.getKeyValue()));
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the message log entry by identifier", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public IrsTransmissionLogDetailEntry findMostRecentEntry(PersonEntityKey personId, String taxYear) throws DAOException {
        try {
            String[] params = new String[]{"personId", "taxYear"};
            Object[] values = new Object[]{personId.getKeyValue(), taxYear};
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("IrsTransmissionLogDetailEntryQuery_findMostRecentEntry", params, values);
            return results.isEmpty() ? null : (IrsTransmissionLogDetailEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the most recent tax year entry", (Throwable)e);
        }
    }

    @Override
    public List<IrsTransmissionLogDetailEntry> findAllowedCorrectionYears(EntityKey personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("IrsTransmissionLogDetailEntryQuery_findAllowedCorrectionYears", "personId", (Object)((BigDecimal)personId.getKeyValue()));
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get allowed correction years", (Throwable)e);
        }
    }

    @Override
    @Transactional
    public List<IrsTransmissionLogDetailEntry> getFailedPersonTransmissions() throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQuery("IrsTransmissionLogDetailEntryQuery_findFailures");
            return results;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to find person transmit failures", (Throwable)e);
        }
    }

    @Override
    public IrsTransmissionLogDetailEntry findOriginalForYear(String ien, String taxYear) throws DAOException {
        try {
            String[] params = new String[]{"ien", "taxYear"};
            Object[] values = new Object[]{ien, taxYear};
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("IrsTransmissionLogDetailEntryQuery_findOriginalForYear", params, values);
            if (results != null) {
                Comparator comparator = new Comparator(){

                    public int compare(Object pObject1, Object pObject2) {
                        Date date1 = pObject1 instanceof IrsTransmissionLogDetailEntry ? ((IrsTransmissionLogDetailEntry)((Object)pObject1)).getCreatedOn() : null;
                        Date date2 = pObject2 instanceof IrsTransmissionLogDetailEntry ? ((IrsTransmissionLogDetailEntry)((Object)pObject2)).getCreatedOn() : null;
                        return date1 != null && date2 != null ? -date1.compareTo(date2) : 0;
                    }
                };
                Collections.sort(results, comparator);
                Collections.reverse(results);
            }
            return results.isEmpty() ? null : (IrsTransmissionLogDetailEntry)((Object)results.get(0));
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the most recent entry by IEN", (Throwable)e);
        }
    }
}

