/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.lookup.EnrollmentStatus;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.persistent.history.HistoryDAOImpl;
import gov.va.med.esr.common.persistent.history.RulesEnrollmentHistoryDAO;
import gov.va.med.esr.service.EEResultInfo;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Filter;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;

public class RulesEnrollmentHistoryDAOImpl
extends HistoryDAOImpl
implements RulesEnrollmentHistoryDAO {
    private static final long serialVersionUID = -2356344899457437651L;
    private static final String FILTER_EFF_DATE_ASOF = "incomeTestEffDateAsOfFilter";
    private static final String FILTER_EFF_DATE_PRIOR = "incomeTestEffDatePriorToFilter";
    private static final String FILTER_PAR_EFF_DATE = "effectiveDate";
    private static final String INCOME_TEST_PROP_PATH = "internalIncomeTests";
    private static final String INCOME_TEST_STATUS_PROP_PATH = "internalIncomeTests.internalStatuses";
    private static final String getPreviousEnrollment_Date_Query = "enrollmentHistoryQuery_GetDateForPrevious";
    private static final String getMostRecentWStatus_Date_Query = "enrollmentHistoryQuery_GetDateForMostRecentWStatus";
    private static final String getApplicationDate_Query = "enrollmentHistoryQuery_GetApplicationDate";
    private static final String getFirstNotNullEffDate_Query = "enrollmentHistoryQuery_GetFirstNotNullEffDate";
    private static final String getEnDtForEarliestAfter_Query = "enrollmentHistoryQuery_GetEnDtForEarliestEnrollmentAfter";
    private static final String getEffectiveDateForEarliestAfter_Query = "enrollmentHistoryQuery_GetEffectiveDateForEarliestEnrollmentAfter";
    private static final String getPrGrpForEarliestAfter_Query = "enrollmentHistoryQuery_GetPrGrpForEarliestEnrollmentAfter";
    private static final String getPrGrpForEarliestWStatus_Query = "enrollmentHistoryQuery_GetPrGrpForEarliestWStatus";
    private static final String getEnDtForEarliestWStatus_Query = "enrollmentHistoryQuery_GetEnDtForEarliestWStatus";
    private static final String getEffectiveDateForEarliestWStatus_Query = "enrollmentHistoryQuery_GetEffectiveDateForEarliestWStatus";
    private static final String getAppDtForEarliestAfter_Query = "enrollmentHistoryQuery_GetAppDtForEarliestEnrollmentAfter";
    private static final String getAppDtForEarliestWStatus_Query = "enrollmentHistoryQuery_GetAppDtForEarliestWStatus";
    private static final String getStatusForEarliest_Query = "batchProcessQuery_GetStatusForEarliest";
    private static final String getPriorityGrpsForMostRecent_Query = "batchProcessQuery_GetPriorityGrpsForMostRecent";
    private static final String getMostRecentVerifiedEnrollPriorityGrps_Query = "enrollmentHistoryQuery_MostRecentVerifiedEnrollPriorityGrps";
    private static final String getMostRecentNonNullPriority_Query = "enrollmentHistoryQuery_GetMostRecentNonNullPriority";
    private static final String getMostRecentNonNullPriorityLevelByDate_Query = "enrollmentHistoryQuery_GetMostRecentNonNullPriorityLevelByDate";
    private static final String getPriorityGrpsBeforePH_Query = "enrollmentHistoryQuery_GetPriorityGrpsBeforePH";
    private static final String getPersonEnrollHistory_Query = "enrollmentHistoryQuery_GetPersonHistory";
    private static final String getPriorToEnrollHistory_Query = "enrollmentHistoryQuery_PriorToDate";

    @Override
    protected AbstractVersionedEntity getHistoricalEntity(Session session, ChangeEvent changeEvent) throws DAOException {
        Person p = null;
        try {
            String effDateFilterName;
            p = (Person)super.getHistoricalEntity(session, changeEvent);
            if (p != null && (effDateFilterName = this.getEffDateFilterName(session)) != null) {
                this.getSession().enableFilter(effDateFilterName).setParameter(FILTER_PAR_EFF_DATE, (Object)changeEvent.getTimeStamp());
                this.processNestedProperty((Object)p, INCOME_TEST_PROP_PATH, 0);
                this.getSession().disableFilter(effDateFilterName);
                this.processNestedProperty((Object)p, INCOME_TEST_STATUS_PROP_PATH, 0);
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to get Historical Entity for changeEvent: " + changeEvent, (Throwable)e);
        }
        return p;
    }

    private String getEffDateFilterName(Session session) {
        Filter f = session.getEnabledFilter("asOfDate");
        if (f != null) {
            return FILTER_EFF_DATE_ASOF;
        }
        f = session.getEnabledFilter("priorToDate");
        if (f != null) {
            return FILTER_EFF_DATE_PRIOR;
        }
        return null;
    }

    @Override
    protected void removeDeletedRecords(AbstractVersionedEntity entity) throws DAOException {
        super.removeDeletedRecords(entity);
        this.processNestedProperty(entity, INCOME_TEST_PROP_PATH, 1);
        this.processNestedProperty(entity, INCOME_TEST_STATUS_PROP_PATH, 1);
    }

    @Override
    protected boolean needPreviousVersion() {
        return false;
    }

    @Override
    public Person getPersonForPriorEnrollment(EntityKey personId) throws DAOException {
        Person p = null;
        ChangeEvent changeEvent = this.getHistoryChangeEventForQuery(getPreviousEnrollment_Date_Query, personId, null);
        if (changeEvent != null) {
            HashMap<String, ChangeEvent> contextData = new HashMap<String, ChangeEvent>();
            contextData.put("changeEvent", changeEvent);
            AbstractDAOAction callback = new AbstractDAOAction(contextData){

                public Object execute(Session session) throws DAOException {
                    return RulesEnrollmentHistoryDAOImpl.this.getCurrentVersion(session, (ChangeEvent)this.getContextData().get("changeEvent"));
                }
            };
            p = (Person)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
        }
        return p;
    }

    @Override
    public String getMostRecentNonNullPriorityCode(EntityKey personId) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getMostRecentNonNullPriority_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        String enrollmentPriorityGroupCode = iter.hasNext() ? (String)iter.next() : null;
        return enrollmentPriorityGroupCode;
    }

    @Override
    public String getMostRecentNonNullPriorityLevelByDate(EntityKey personId, final Date beforeDate) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getMostRecentNonNullPriorityLevelByDate_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("beforeDate", (Object)beforeDate);
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        String enrollmentPriorityGroupCode = iter.hasNext() ? (String)iter.next() : null;
        return enrollmentPriorityGroupCode;
    }

    @Override
    public Date getAppDateForMostRecentUnverifiedEnrollment(EntityKey personId) throws DAOException {
        Date applicationDate = null;
        ChangeEvent changeEvent = this.getHistoryChangeEventForQuery(getMostRecentWStatus_Date_Query, personId, EnrollmentStatus.CODE_UNVERIFIED.getCode());
        if (changeEvent != null) {
            applicationDate = this.getApplicationDate(changeEvent);
        }
        return applicationDate;
    }

    private Date getApplicationDate(ChangeEvent ce) {
        Date applicationDate = null;
        HashMap<String, ChangeEvent> contextData = new HashMap<String, ChangeEvent>();
        contextData.put("ce", ce);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                ChangeEvent targetChangeEvent = (ChangeEvent)this.getContextData().get("ce");
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getApplicationDate_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)targetChangeEvent.getEntityKey().getKeyValue());
                q.setParameter("historyDate", (Object)targetChangeEvent.getTimeStamp());
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = results.iterator();
        applicationDate = iter.hasNext() ? (Date)iter.next() : null;
        return applicationDate;
    }

    @Override
    public Date getFirstNotNullEffDate(EntityKey personId) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getFirstNotNullEffDate_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = results.iterator();
        Date effDate = iter.hasNext() ? (Date)iter.next() : null;
        return effDate;
    }

    private ChangeEvent getHistoryChangeEventForQuery(String queryName, EntityKey personId, String enrollmentStatus) throws DAOException {
        Timestamp modifiedDate;
        ChangeEvent changeEvent = null;
        HashMap<String, String> contextData = new HashMap<String, String>();
        contextData.put("queryName", queryName);
        contextData.put("personId", (String)personId);
        contextData.put("enrollmentStatus", enrollmentStatus);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery((String)this.getContextData().get("queryName"));
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                String targetEnrollmentStatus = (String)this.getContextData().get("enrollmentStatus");
                if (targetEnrollmentStatus != null) {
                    q.setParameter("status", (Object)targetEnrollmentStatus);
                }
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = results.iterator();
        Timestamp timestamp = modifiedDate = iter.hasNext() ? (Timestamp)iter.next() : null;
        if (modifiedDate != null) {
            changeEvent = new ChangeEvent(modifiedDate, personId);
        }
        return changeEvent;
    }

    @Override
    public Object[] getStatusAndAppDateForEarliest(EntityKey personId) throws DAOException {
        Object[] results = null;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getStatusForEarliest_Query);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        List resultsFromQuery = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = resultsFromQuery.iterator();
        if (iter.hasNext()) {
            Timestamp modifiedDate = null;
            EnrollmentStatus status = null;
            Date applicationDate = null;
            Object[] row = (Object[])iter.next();
            status = (EnrollmentStatus)((Object)row[0]);
            modifiedDate = (Timestamp)row[1];
            if (modifiedDate != null) {
                applicationDate = this.getApplicationDate(new ChangeEvent(modifiedDate, personId));
            }
            results = new Object[]{status, applicationDate};
        }
        return results;
    }

    @Override
    public String[] getPriorityGrpsForMostRecent(EntityKey personId) throws DAOException {
        Object[] results = null;
        String[] priorityGrps = null;
        Iterator iter = this.findByNamedQueryAndNamedParam(getPriorityGrpsForMostRecent_Query, "personId", (BigDecimal)personId.getKeyValue()).iterator();
        if (iter.hasNext()) {
            results = (Object[])iter.next();
            priorityGrps = new String[]{(String)results[0], (String)results[1]};
        }
        return priorityGrps;
    }

    @Override
    public Date getEnrollmentDateForEarliestVerifiedUnlessCancelled(EntityKey personId) throws DAOException {
        Date enrollmentDate = null;
        Date cancelDeclineDate = this.getDateForMostRecentCancelDeclineEnrollment(personId);
        if (cancelDeclineDate != null) {
            enrollmentDate = this.getEnrollmentDateForVerifiedEnrollmentAfter(personId, cancelDeclineDate);
            if (enrollmentDate == null) {
                enrollmentDate = new Date();
            }
        } else {
            enrollmentDate = this.getEnrollmentDateForEarliestVerifiedEnrollment(personId);
            if (enrollmentDate == null) {
                enrollmentDate = new Date();
            }
        }
        return enrollmentDate;
    }

    @Override
    public Date getEffectiveDateForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentThreshold(EntityKey personId) throws DAOException {
        Date effectiveDate = null;
        Date cancelDeclineDate = this.getDateForMostRecentCancelDeclineEnrollment(personId);
        Date rejectedDate = this.getDateForMostRecentRejectedBelowThresholdEnrollment(personId);
        Date latestDate = null;
        latestDate = cancelDeclineDate == null && rejectedDate == null ? null : (cancelDeclineDate != null && rejectedDate == null ? cancelDeclineDate : (cancelDeclineDate == null && rejectedDate != null ? rejectedDate : (cancelDeclineDate.before(rejectedDate) ? rejectedDate : cancelDeclineDate)));
        effectiveDate = latestDate != null ? this.getEffectiveDateForVerifiedEnrollmentAfter(personId, latestDate) : this.getEffectiveDateForEarliestVerifiedEnrollment(personId);
        return effectiveDate;
    }

    @Override
    public Date getEnrollmentApplicationDateForEarliestSpecifiedStatusUnlessCancelledOrRejectedBelowThreshold(EntityKey personId) throws DAOException {
        Date applicationDate = null;
        Date cancelDeclineDate = this.getDateForMostRecentCancelDeclineEnrollment(personId);
        Date rejectedDate = this.getDateForMostRecentRejectedBelowThresholdEnrollment(personId);
        Date latestDate = null;
        latestDate = cancelDeclineDate == null && rejectedDate == null ? null : (cancelDeclineDate != null && rejectedDate == null ? cancelDeclineDate : (cancelDeclineDate == null && rejectedDate != null ? rejectedDate : (cancelDeclineDate.before(rejectedDate) ? rejectedDate : cancelDeclineDate)));
        if (latestDate != null) {
            applicationDate = this.getEnrollmentApplicationDateForSpecifiedStatusAfter(personId, latestDate, EnrollmentStatus.CODE_UNVERIFIED.getCode());
            if (applicationDate == null) {
                applicationDate = this.getEnrollmentApplicationDateForSpecifiedStatusAfter(personId, latestDate, EnrollmentStatus.CODE_PENDING_ELIGIBILITY_STATUS_IS_UNVERIFIED.getCode());
            }
        } else {
            applicationDate = this.getEnrollmentApplicationDateForSpecifiedStatus(personId, EnrollmentStatus.CODE_UNVERIFIED.getCode());
            if (applicationDate == null) {
                applicationDate = this.getEnrollmentApplicationDateForSpecifiedStatus(personId, EnrollmentStatus.CODE_PENDING_ELIGIBILITY_STATUS_IS_UNVERIFIED.getCode());
            }
        }
        return applicationDate;
    }

    @Override
    public EnrollmentDetermination getEnrollmentDeterminationForEarliestVerifiedUnlessCancelledOrRejectedBelowEnrollmentGroupThreshold(EntityKey personId) throws DAOException {
        String priorityGroupCode = "";
        Date enrollmentDate = null;
        EnrollmentDetermination enrollmentDetermination = null;
        Date cancelDeclineDate = this.getDateForMostRecentCancelDeclineEnrollment(personId);
        Date rejectedDate = this.getDateForMostRecentRejectedBelowThresholdEnrollment(personId);
        Date latestDate = null;
        latestDate = cancelDeclineDate == null && rejectedDate == null ? null : (cancelDeclineDate != null && rejectedDate == null ? cancelDeclineDate : (cancelDeclineDate == null && rejectedDate != null ? rejectedDate : (cancelDeclineDate.before(rejectedDate) ? rejectedDate : cancelDeclineDate)));
        if (latestDate != null) {
            enrollmentDetermination = this.getPriorityGroupForVerifiedEnrollmentAfter(personId, latestDate);
            if (enrollmentDate == null) {
                enrollmentDate = new Date();
            }
        } else {
            enrollmentDetermination = this.getPriorityGroupForEarliestVerifiedEnrollment(personId);
        }
        return enrollmentDetermination;
    }

    @Override
    public Date getEarliestEnrollmentEffectiveDatewithAOWatDMZ(EntityKey personId) throws DAOException {
        Object row;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_verifiedEnrollmentForAOE");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = results.iterator();
        Timestamp enrollmentEffectiveDate = null;
        if (iter.hasNext() && (row = iter.next()) != null) {
            enrollmentEffectiveDate = (Timestamp)row;
        }
        return enrollmentEffectiveDate;
    }

    @Override
    public boolean isApplicationDatePriortoEGTEffectiveDate(EntityKey personId) throws DAOException {
        boolean exists = false;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_appDatePriorToEGTDate");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = results.iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public boolean isVerifiedEnrollmentExistsforCombatVeteran(EntityKey personId) throws DAOException {
        boolean exists = false;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_verifiedEnrollmentForCombatVeteran");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public boolean isVerifiedEnrollmentExistsForEligibilityCode(EntityKey personId, String eligiblityTypeCode) throws DAOException {
        boolean exists = false;
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("eligiblityTypeCode", eligiblityTypeCode);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_verifiedEnrollmentEligCode");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("eligibilityTypeCode", this.getContextData().get("eligiblityTypeCode"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public Integer getIncomeYearForVerifiedMT(EntityKey personId) throws DAOException {
        Object row;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_GetIncomeYearForVerifiedIncomeTest");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Integer incomeYear = null;
        if (iter.hasNext() && (row = iter.next()) != null) {
            incomeYear = (Integer)row;
        }
        return incomeYear;
    }

    @Override
    public List getIncomeYearsForVerifiedMT(EntityKey personId) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_GetMultiIncomeYearsForVerifiedIncomeTest");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Integer incomeYear = null;
        ArrayList<Integer> incomeYears = new ArrayList<Integer>();
        while (iter.hasNext()) {
            Object row = iter.next();
            if (row == null) continue;
            incomeYear = (Integer)row;
            incomeYears.add(incomeYear);
        }
        return incomeYears;
    }

    @Override
    public List getIncomeYearsForVerifiedP8(EntityKey personId) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_GetMultiIncomeYearsForVerifiedP8");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Integer incomeYear = null;
        ArrayList<Integer> incomeYears = new ArrayList<Integer>();
        while (iter.hasNext()) {
            Object row = iter.next();
            if (row == null) continue;
            incomeYear = (Integer)row;
            incomeYears.add(incomeYear);
        }
        return incomeYears;
    }

    @Override
    public String[] getMostRecentVerifiedEnrollmentPriorityGroups(EntityKey personId) throws DAOException {
        Object[] results = null;
        String[] priorityGrps = null;
        Iterator iter = this.findByNamedQueryAndNamedParam(getMostRecentVerifiedEnrollPriorityGrps_Query, "personId", (BigDecimal)personId.getKeyValue()).iterator();
        if (iter.hasNext()) {
            results = (Object[])iter.next();
            priorityGrps = new String[]{(String)results[0], (String)results[1]};
        }
        return priorityGrps;
    }

    @Override
    public boolean hasIncomeTestMeetingP8RecheckCriteria(EntityKey personId, float relaxPercent) throws DAOException {
        boolean exists = false;
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("relaxPercent", new Float(relaxPercent));
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_hasIncomeTestMeetingP8RecheckCriteria");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setFloat("relaxPercent", ((Float)this.getContextData().get("relaxPercent")).floatValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public List getHistoricalIncomeYearsForVerifiedMT(EntityKey personId) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_GetHistoricalMultiIncomeYearsForVerifiedIncomeTest");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Integer incomeYear = null;
        ArrayList<Integer> incomeYears = new ArrayList<Integer>();
        while (iter.hasNext()) {
            Object row = iter.next();
            if (row == null) continue;
            incomeYear = (Integer)row;
            incomeYears.add(incomeYear);
        }
        return incomeYears;
    }

    @Override
    public boolean isVerifiedEnrollmentExistsforSvcConnPercent(EntityKey personId, Integer percent) throws DAOException {
        boolean exists = false;
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("percent", percent);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_verifiedEnrollmentForSCAWP10");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public boolean hasAnyEnrollmentRecordBeforeDate(EntityKey personId, Date beforeDate) throws DAOException {
        boolean exists = false;
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("dateParam", beforeDate);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_anyEnrollmentBefore");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("dateParam", this.getContextData().get("dateParam"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public boolean isVerifiedEnrollmentExists(EntityKey personId) throws DAOException {
        boolean exists = false;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_verifiedEnrollment");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public EEResultInfo getMostRecentEnrollmentforContinuousEnrollment(EntityKey personId) throws DAOException {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_recentEnrollmentDataForCE");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            EEResultInfo results = new EEResultInfo();
            Object[] row = (Object[])iter.next();
            results.setEffectiveDate((Timestamp)row[0]);
            results.setOverrideFlag((Integer)row[1]);
            results.setGroupCode((String)row[2]);
            results.setStatusCode((String)row[3]);
            return results;
        }
        return null;
    }

    private Date getDateForMostRecentCancelDeclineEnrollment(EntityKey personId) throws DAOException {
        ChangeEvent changeEvent = this.getHistoryChangeEventForQuery(getMostRecentWStatus_Date_Query, personId, EnrollmentStatus.CODE_CANCELLED_DECLINED.getCode());
        return changeEvent == null ? null : changeEvent.getTimeStamp();
    }

    private Date getDateForMostRecentRejectedBelowThresholdEnrollment(EntityKey personId) throws DAOException {
        ChangeEvent changeEvent = this.getHistoryChangeEventForQuery(getMostRecentWStatus_Date_Query, personId, EnrollmentStatus.CODE_REJECTED_BELOW_ENROLLMENT_GROUP_THRESHOLD.getCode());
        return changeEvent == null ? null : changeEvent.getTimeStamp();
    }

    private Date getEffectiveDateForVerifiedEnrollmentAfter(EntityKey personId, Date cancelDeclineDate) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("cancelDeclineDate", cancelDeclineDate);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getEffectiveDateForEarliestAfter_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                q.setParameter("dateParam", this.getContextData().get("cancelDeclineDate"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Date effectiveDate = iter.hasNext() ? (Date)iter.next() : null;
        return effectiveDate;
    }

    private Date getEnrollmentDateForVerifiedEnrollmentAfter(EntityKey personId, Date cancelDeclineDate) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("cancelDeclineDate", cancelDeclineDate);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getEnDtForEarliestAfter_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                q.setParameter("dateParam", this.getContextData().get("cancelDeclineDate"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Date enrollmentDate = iter.hasNext() ? (Date)iter.next() : null;
        return enrollmentDate;
    }

    private Date getEnrollmentApplicationDateForSpecifiedStatusAfter(EntityKey personId, Date cancelDeclineDate, String status) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("cancelDeclineDate", cancelDeclineDate);
        contextData.put("status", status);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getAppDtForEarliestAfter_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", this.getContextData().get("status"));
                q.setParameter("dateParam", this.getContextData().get("cancelDeclineDate"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Date applicationDate = iter.hasNext() ? (Date)iter.next() : null;
        return applicationDate;
    }

    private Date getEnrollmentApplicationDateForSpecifiedStatus(EntityKey personId, String status) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("status", status);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getAppDtForEarliestWStatus_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", this.getContextData().get("status"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Date applicationDate = iter.hasNext() ? (Date)iter.next() : null;
        return applicationDate;
    }

    private EnrollmentDetermination getPriorityGroupForVerifiedEnrollmentAfter(EntityKey personId, Date cancelDeclineDate) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("cancelDeclineDate", cancelDeclineDate);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getPrGrpForEarliestAfter_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                q.setParameter("dateParam", this.getContextData().get("cancelDeclineDate"));
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        EnrollmentDetermination enrollmentDetermination = iter.hasNext() ? (EnrollmentDetermination)((Object)iter.next()) : null;
        return enrollmentDetermination;
    }

    @Override
    public String[] getEnrollmentPriorityBeforePH(EntityKey personId) throws DAOException {
        Object[] results = null;
        String[] priority = null;
        Iterator iter = this.findByNamedQueryAndNamedParam(getPriorityGrpsBeforePH_Query, "personId", (BigDecimal)personId.getKeyValue()).iterator();
        if (iter.hasNext()) {
            results = (Object[])iter.next();
            priority = new String[]{results[0] == null ? "" : (String)results[0], results[1] == null ? "" : (String)results[1]};
        }
        return priority;
    }

    private Date getEnrollmentDateForEarliestVerifiedEnrollment(EntityKey personId) {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getEnDtForEarliestWStatus_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Date enrollmentDate = iter.hasNext() ? (Date)iter.next() : null;
        return enrollmentDate;
    }

    private Date getEffectiveDateForEarliestVerifiedEnrollment(EntityKey personId) {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getEffectiveDateForEarliestWStatus_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        Date enrollmentDate = iter.hasNext() ? (Date)iter.next() : null;
        return enrollmentDate;
    }

    private EnrollmentDetermination getPriorityGroupForEarliestVerifiedEnrollment(EntityKey personId) {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getPrGrpForEarliestWStatus_Query);
                q.setMaxResults(1);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        EnrollmentDetermination enrollmentDetermination = iter.hasNext() ? (EnrollmentDetermination)((Object)iter.next()) : null;
        return enrollmentDetermination;
    }

    @Override
    public boolean isVerifiedEnrollmentExistsForMedicaidEligibility(EntityKey personId) {
        boolean exists = false;
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("contEnrollment_verifiedEnrollmentEligMedicaid");
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        if (iter.hasNext()) {
            exists = true;
        }
        return exists;
    }

    @Override
    public List getPersonEnrollmentDeterminationHistory(EntityKey personId) throws DAOException {
        return this.getEnrollmentDeterminationHistory(personId);
    }

    private List getEnrollmentDeterminationHistory(EntityKey personId) {
        HashMap<String, EntityKey> contextData = new HashMap<String, EntityKey>();
        contextData.put("personId", personId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getPersonEnrollHistory_Query);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                return q.list();
            }
        };
        Iterator iter = this.getHibernateTemplate().executeFind((HibernateCallback)callback).iterator();
        ArrayList<EnrollmentDetermination> enrollmentDeterminations = new ArrayList<EnrollmentDetermination>();
        EnrollmentDetermination enrollmentDetermination = null;
        while (iter.hasNext()) {
            Object row = iter.next();
            if (row == null) continue;
            enrollmentDetermination = (EnrollmentDetermination)((Object)row);
            enrollmentDeterminations.add(enrollmentDetermination);
        }
        return enrollmentDeterminations;
    }

    @Override
    public boolean getPriorToEnrDetermHistory(EntityKey personId, Date beforeDate, Date recModifiedDate) throws DAOException {
        return this.getEnrDetermHistoryPriorToDate(personId, beforeDate, recModifiedDate);
    }

    private boolean getEnrDetermHistoryPriorToDate(EntityKey personId, Date beforeDate, Date recModifiedDate) {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        contextData.put("personId", personId);
        contextData.put("dateParam", beforeDate);
        contextData.put("recModifiedDate", recModifiedDate);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery(RulesEnrollmentHistoryDAOImpl.getPriorToEnrollHistory_Query);
                q.setParameter("personId", (Object)((EntityKey)this.getContextData().get("personId")).getKeyValue());
                q.setParameter("dateParam", this.getContextData().get("dateParam"));
                q.setParameter("status", (Object)EnrollmentStatus.CODE_VERIFIED.getCode());
                q.setParameter("recModifiedDate", this.getContextData().get("recModifiedDate"));
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        return results.size() > 0;
    }
}

