/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.history;

import gov.va.med.esr.common.persistent.history.HistoryChangeColumns;
import gov.va.med.esr.common.persistent.history.HistoryDAO;
import gov.va.med.esr.service.impl.ChangeEvent;
import gov.va.med.esr.service.impl.HistoricalInfo;
import gov.va.med.fw.model.AbstractVersionedEntity;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.model.lookup.TransactionType;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Expression;
import org.hibernate.type.Type;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;

public class HistoryDAOImpl
extends GenericDAOImpl
implements HistoryDAO,
BeanNameAware {
    private static final long serialVersionUID = 5904704406446514977L;
    private static final String getChangeTimesSelectPart1 = "SELECT distinct obj";
    private static final String getChangeTimesSelectPart2 = ".modifiedOn ";
    private String[][] mappedClasses = null;
    private String[] historyTimesQueries = null;
    private static final String getHistoryByChangeTimeHQLPart1 = "select obj from ";
    private static final String getHistoryByChangeTimeHQLPart2 = " as obj where obj.id = :id order by obj.modifiedOn desc, obj.historyId desc";
    public static final String FILTER_AS_OF_DATE = "asOfDate";
    public static final String FILTER_PRIOR_TO_DATE = "priorToDate";
    public static final String FILTER_PAR_EFFECTIVE_DATE = "effectiveDate";
    public static final String FIELD_TRANSACTION_TYPE = "transactionType";
    private List lazyProperties = null;
    private String rootClassName = null;
    private List historyChangeColumns = null;
    private boolean singleRoot = true;
    protected static final int ACCESS_ONLY = 0;
    protected static final int ACCESS_AND_DELETE = 1;

    @Override
    public Set getHistoryChangeTimes(EntityKey entityKey) throws DAOException {
        if (this.hasSingleRoot()) {
            Validate.notNull((Object)entityKey, (String)"NULL EntityKey not allowed.");
        }
        TreeSet changeEvents = new TreeSet();
        if (this.historyChangeColumns != null) {
            for (HistoryChangeColumns historyChangeColumns : this.historyChangeColumns) {
                List newChangeEvents = this.getHistoryChangeTimesNew(entityKey, historyChangeColumns);
                changeEvents.addAll(newChangeEvents);
            }
        } else {
            int i;
            if (this.mappedClasses != null) {
                for (i = 0; i < this.mappedClasses.length; ++i) {
                    changeEvents.addAll(this.getHistoryChangeTimes(entityKey, this.mappedClasses[i]));
                }
            }
            if (this.historyTimesQueries != null) {
                for (i = 0; i < this.historyTimesQueries.length; ++i) {
                    changeEvents.addAll(this.getHistoryChangeTimes(entityKey, this.historyTimesQueries[i]));
                }
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("HistoryDaoImpl getHistoryChangeTimes: " + changeEvents));
        }
        return changeEvents;
    }

    @Override
    public List getDeletedEntities(Class clazz) throws DAOException {
        HashMap<String, Class> contextData = new HashMap<String, Class>();
        contextData.put("clazz", clazz);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Criteria criteria = session.createCriteria((Class)this.getContextData().get("clazz"));
                criteria.add((Criterion)Expression.eq((String)HistoryDAOImpl.FIELD_TRANSACTION_TYPE, (Object)TransactionType.CODE_DELETE.getName()));
                return criteria.list();
            }
        };
        return this.getHibernateTemplate().executeFind((HibernateCallback)callback);
    }

    private List getHistoryChangeTimes(EntityKey entityKey, String[] objectRelationPath) throws DAOException {
        ArrayList<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
        List results = null;
        try {
            results = this.hasSingleRoot() ? super.getHibernateTemplate().findByNamedParam(this.buildHistoryChangeTimesHQL(objectRelationPath), "parent_id", (Object)((BigDecimal)entityKey.getKeyValue())) : super.getHibernateTemplate().find(this.buildHistoryChangeTimesHQL(objectRelationPath));
            if (results != null) {
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    changeEvents.add(new ChangeEvent((Timestamp)i.next(), entityKey));
                }
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to retrieve the history change dates for entry:" + objectRelationPath, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("HistoryDaoImpl getHistoryChangeTimes: " + changeEvents));
        }
        return changeEvents;
    }

    private List getHistoryChangeTimes(EntityKey entityKey, String namedQuery) throws DAOException {
        ArrayList<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
        List results = null;
        Validate.notNull((Object)namedQuery);
        try {
            results = super.getHibernateTemplate().findByNamedQueryAndNamedParam(namedQuery, "parent_id", (Object)((BigDecimal)entityKey.getKeyValue()));
            if (results != null) {
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    changeEvents.add(new ChangeEvent((Timestamp)i.next(), entityKey));
                }
            }
        }
        catch (Exception e) {
            throw new DAOException("Failed to retrieve the history change dates for named query:" + namedQuery, (Throwable)e);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("HistoryDaoImpl getHistoryChangeTimes: " + changeEvents));
        }
        return changeEvents;
    }

    private String buildHistoryChangeTimesHQL(String[] objectRelationPath) {
        Validate.isTrue((objectRelationPath.length >= 2 ? 1 : 0) != 0);
        int depth = objectRelationPath.length - 1;
        String selectString = this.buildGetChangeTimesSelect(depth);
        String topClassName = objectRelationPath[0];
        String rootName = objectRelationPath[1];
        Validate.notNull((Object)topClassName);
        String fromString = this.buildGetChangeTimesFrom(topClassName);
        String joinString = this.buildGetChangeTimesJoin(objectRelationPath);
        String whereClause = this.buildGetChangeTimesWhereClause(rootName);
        String queryString = selectString + fromString + joinString + whereClause;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)queryString);
        }
        return queryString;
    }

    private String buildGetChangeTimesSelect(int depth) {
        return getChangeTimesSelectPart1 + depth + getChangeTimesSelectPart2;
    }

    private String buildGetChangeTimesFrom(String topClassName) {
        return "FROM " + topClassName + " as obj1 ";
    }

    private String buildGetChangeTimesJoin(String[] objectRelationPath) {
        String joinString = "";
        int length = objectRelationPath.length;
        if (length > 2) {
            for (int i = 2; i < length; ++i) {
                joinString = joinString + " JOIN obj" + (i - 1) + "." + objectRelationPath[i] + " as obj" + i;
            }
        }
        return joinString;
    }

    private String buildGetChangeTimesWhereClause(String rootName) {
        String whereClause = "";
        if (this.hasSingleRoot()) {
            whereClause = " WHERE obj1." + (StringUtils.isEmpty((String)rootName) ? "" : rootName + ".") + "id = :parent_id ";
        }
        return whereClause;
    }

    @Override
    public HistoricalInfo getHistoryByChangeTime(ChangeEvent changeEvent) throws DAOException {
        Validate.notNull((Object)changeEvent, (String)"NULL changeEvent not allowed.");
        if (this.hasSingleRoot()) {
            Validate.notNull((Object)changeEvent.getEntityKey(), (String)"NULL EntityKey not allowed.");
        }
        Validate.notNull((Object)changeEvent.getTimeStamp(), (String)"NULL Timestamp not allowed.");
        HashMap<String, ChangeEvent> contextData = new HashMap<String, ChangeEvent>();
        contextData.put("changeEvent", changeEvent);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) throws DAOException {
                ChangeEvent targetChangeEvent = (ChangeEvent)this.getContextData().get("changeEvent");
                AbstractVersionedEntity currentVersion = HistoryDAOImpl.this.getCurrentVersion(session, targetChangeEvent);
                AbstractVersionedEntity previousVersion = null;
                previousVersion = targetChangeEvent.getPrevousChangeEvent() == null ? HistoryDAOImpl.this.getPreviousVersion(session, targetChangeEvent) : HistoryDAOImpl.this.getCurrentVersion(session, targetChangeEvent.getPrevousChangeEvent());
                if (previousVersion != null) {
                    currentVersion.setPreviousVersion(previousVersion);
                }
                return new HistoricalInfo(targetChangeEvent, currentVersion);
            }
        };
        return (HistoricalInfo)((Object)this.getHibernateTemplate().execute((HibernateCallback)callback));
    }

    protected void accessData(AbstractVersionedEntity entity) throws DAOException {
        this.processData(entity, 0);
    }

    protected AbstractVersionedEntity getCurrentVersion(Session session, ChangeEvent changeEvent) throws DAOException {
        session.enableFilter(FILTER_AS_OF_DATE).setParameter(FILTER_PAR_EFFECTIVE_DATE, (Object)changeEvent.getTimeStamp());
        session.disableFilter(FILTER_PRIOR_TO_DATE);
        AbstractVersionedEntity currentVersion = this.getHistoricalEntity(session, changeEvent);
        if (currentVersion != null) {
            this.accessData(currentVersion);
            this.evict(currentVersion);
            this.removeDeletedRecords(currentVersion);
        } else {
            try {
                currentVersion = (AbstractVersionedEntity)Class.forName(this.getRootClassName()).newInstance();
            }
            catch (Exception e) {
                throw new DAOException("Error instantating class:" + this.getRootClassName(), (Throwable)e);
            }
        }
        return currentVersion;
    }

    private AbstractVersionedEntity getPreviousVersion(Session session, ChangeEvent changeEvent) throws DAOException {
        if (!this.needPreviousVersion()) {
            return null;
        }
        session.disableFilter(FILTER_AS_OF_DATE);
        session.enableFilter(FILTER_PRIOR_TO_DATE).setParameter(FILTER_PAR_EFFECTIVE_DATE, (Object)changeEvent.getTimeStamp());
        AbstractVersionedEntity previousVersion = this.getHistoricalEntity(session, changeEvent);
        if (previousVersion != null) {
            this.accessData(previousVersion);
            this.evict(previousVersion);
            this.removeDeletedRecords(previousVersion);
        }
        return previousVersion;
    }

    protected AbstractVersionedEntity getHistoricalEntity(Session session, ChangeEvent changeEvent) throws DAOException {
        AbstractVersionedEntity entity = null;
        String queryString = getHistoryByChangeTimeHQLPart1 + this.getRootClassName() + getHistoryByChangeTimeHQLPart2;
        Query q = session.createQuery(queryString);
        q.setMaxResults(1);
        q.setParameter("id", (Object)((BigDecimal)changeEvent.getEntityKey().getKeyValue()));
        List results = q.list();
        if (results == null || results.isEmpty()) {
            return null;
        }
        Iterator iter = results.iterator();
        if (iter.hasNext()) {
            entity = (AbstractVersionedEntity)iter.next();
        }
        if (entity != null && entity.isDeleted().booleanValue()) {
            this.evict(entity);
            entity = null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("HistoryDaoImpl getHistoricalEntity: " + entity));
        }
        return entity;
    }

    protected void removeDeletedRecords(AbstractVersionedEntity entity) throws DAOException {
        this.processData(entity, 1);
    }

    protected void processData(AbstractVersionedEntity entity, int processTask) throws DAOException {
        if (this.getLazyProperties() == null) {
            return;
        }
        String propName = null;
        Iterator iter = this.getLazyProperties().iterator();
        while (iter.hasNext()) {
            try {
                propName = (String)iter.next();
                this.processNestedProperty(entity, propName, processTask);
            }
            catch (Exception e) {
                throw new DAOException("Unable to " + (processTask == 0 ? "access " : "process deleted records from ") + "property:" + propName, (Throwable)e);
            }
        }
    }

    protected void processNestedProperty(Object bean, String name, int processTask) throws DAOException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified");
        }
        if (bean instanceof AbstractVersionedEntity && ((AbstractVersionedEntity)bean).isDeleted().booleanValue()) {
            return;
        }
        int indexOfNESTED_DELIM = name.indexOf(46);
        if (indexOfNESTED_DELIM < 0) {
            this.processSimpleProperty(bean, name, processTask);
        } else {
            String next = name.substring(0, indexOfNESTED_DELIM);
            if ((bean = this.getSimpleDeclaredProperty(bean, next)) == null) {
                return;
            }
            name = name.substring(indexOfNESTED_DELIM + 1);
            if (bean instanceof Set) {
                Set set = (Set)bean;
                Iterator i = set.iterator();
                while (i.hasNext()) {
                    this.processNestedProperty(i.next(), name, processTask);
                }
            } else if (bean instanceof Map) {
                Map map = (Map)bean;
                Set keys = map.keySet();
                Iterator i = keys.iterator();
                while (i.hasNext()) {
                    this.processNestedProperty(map.get(i.next()), name, processTask);
                }
            } else {
                this.processNestedProperty(bean, name, processTask);
            }
        }
    }

    private List getHistoryChangeTimesNew(final EntityKey entityKey, final HistoryChangeColumns historyChangeColumns) throws DAOException {
        ArrayList<ChangeEvent> changeEvents = new ArrayList<ChangeEvent>();
        List results = null;
        try {
            AbstractDAOAction callback = new AbstractDAOAction(){

                public Object execute(Session session) {
                    if (!historyChangeColumns.isIncludeColumnsSet()) {
                        HashSet histColumns = HistoryDAOImpl.this.getHistoryColumns(session, historyChangeColumns.getTable());
                        histColumns.removeAll(historyChangeColumns.getExcludeColumnList());
                        histColumns.remove(historyChangeColumns.getPrimaryKey());
                        histColumns.remove(historyChangeColumns.getPartitionKey());
                        historyChangeColumns.setIncludeColumnList(histColumns);
                    }
                    String sqlQuery = historyChangeColumns.getHistoryChangeTimesSqlQuery();
                    Query hibSqlQuery = session.createSQLQuery(sqlQuery).addScalar("RECORD_MODIFIED_DATE", (Type)Hibernate.TIMESTAMP).setString("id", entityKey.getKeyValueAsString());
                    return hibSqlQuery.list();
                }
            };
            results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
            if (results != null) {
                Iterator i = results.iterator();
                while (i.hasNext()) {
                    changeEvents.add(new ChangeEvent((Timestamp)i.next(), entityKey));
                }
            }
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to retrieve the history change dates for entry:" + historyChangeColumns.getTable(), (Throwable)e);
        }
        return changeEvents;
    }

    private HashSet getHistoryColumns(Session session, String table) {
        HashSet<String> historyColumns = new HashSet<String>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rst = null;
        try {
            String sqlQuery = "select * from " + table + " where rownum < 2";
            conn = session.connection();
            stmt = conn.createStatement();
            rst = stmt.executeQuery(sqlQuery);
            ResultSetMetaData rstMetadata = rst.getMetaData();
            int colCount = rstMetadata.getColumnCount();
            for (int i = 1; i <= colCount; ++i) {
                String colName = rstMetadata.getColumnName(i);
                colName = colName.toUpperCase();
                historyColumns.add(colName);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to retrieve the history change columns for table:" + table, e);
        }
        finally {
            try {
                if (rst != null) {
                    rst.close();
                }
            }
            catch (Exception e) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e) {}
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (Exception e) {}
        }
        return historyColumns;
    }

    private void processSimpleProperty(Object obj, String name, int processTask) throws DAOException {
        AbstractVersionedEntity accessedEntity;
        PropertyUtilsBean propUtil = new PropertyUtilsBean();
        Object accessedProperty = this.getSimpleDeclaredProperty(obj, name);
        if (accessedProperty instanceof Set) {
            this.processSimpleSet((Set)accessedProperty, processTask);
        } else if (accessedProperty instanceof Map) {
            this.processSimpleMap((Map)accessedProperty, processTask);
        } else if (processTask == 1 && accessedProperty instanceof AbstractVersionedEntity && (accessedEntity = (AbstractVersionedEntity)accessedProperty).isDeleted().booleanValue()) {
            try {
                propUtil.setProperty(obj, name, null);
            }
            catch (Exception e) {
                throw new DAOException("Could not set property to null for: name=" + name + ", obj=" + obj, (Throwable)e);
            }
        }
    }

    private void processSimpleSet(Set collection, int processTask) throws DAOException {
        if (collection == null) {
            return;
        }
        AbstractVersionedEntity entity = null;
        Iterator i = null;
        i = collection.iterator();
        while (i.hasNext()) {
            entity = (AbstractVersionedEntity)i.next();
            if (processTask != 1 || !entity.isDeleted().booleanValue()) continue;
            i.remove();
        }
    }

    private void processSimpleMap(Map map, int processTask) throws DAOException {
        if (map == null) {
            return;
        }
        Set keys = map.keySet();
        AbstractVersionedEntity entity = null;
        Iterator i = keys.iterator();
        while (i.hasNext()) {
            Object obj = map.get(i.next());
            if (obj instanceof Set) {
                this.processSimpleSet((Set)obj, processTask);
                continue;
            }
            if (!(obj instanceof AbstractVersionedEntity)) continue;
            entity = (AbstractVersionedEntity)obj;
            if (processTask != 1 || !entity.isDeleted().booleanValue()) continue;
            i.remove();
        }
    }

    private Object getSimpleDeclaredProperty(Object bean, String name) throws DAOException {
        Object value = null;
        try {
            Class<?> c;
            Field field = null;
            field = this.getFieldFromClass(c, name);
            for (c = bean.getClass(); field == null && c != null; c = c.getSuperclass()) {
                field = this.getFieldFromClass(c, name);
            }
            if (field == null) {
                throw new NoSuchFieldException();
            }
            field.setAccessible(true);
            value = field.get(bean);
        }
        catch (Exception e) {
            throw new DAOException("Failed to get field:" + name + " from object:" + bean, (Throwable)e);
        }
        return value;
    }

    private Field getFieldFromClass(Class c, String name) {
        Field f = null;
        try {
            f = c.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            // empty catch block
        }
        return f;
    }

    public String[][] getMappedClasses() {
        return this.mappedClasses;
    }

    public void setMappedClasses(String[][] mappedClasses) {
        this.mappedClasses = mappedClasses;
    }

    public List getLazyProperties() {
        return this.lazyProperties;
    }

    public void setLazyProperties(List lazyAssociataions) {
        this.lazyProperties = lazyAssociataions;
    }

    public String getRootClassName() {
        return this.rootClassName;
    }

    public void setRootClassName(String rootClassName) {
        this.rootClassName = rootClassName;
    }

    public String[] getHistoryTimesQueries() {
        return this.historyTimesQueries;
    }

    public void setHistoryTimesQueries(String[] namedQueries) {
        this.historyTimesQueries = namedQueries;
    }

    protected void setSingleRoot(boolean singleRoot) {
        this.singleRoot = singleRoot;
    }

    protected boolean hasSingleRoot() {
        return this.singleRoot;
    }

    protected boolean needPreviousVersion() {
        return true;
    }

    public List getHistoryChangeColumns() {
        return this.historyChangeColumns;
    }

    public void setHistoryChangeColumns(List dataChangeProperties) {
        this.historyChangeColumns = dataChangeProperties;
    }
}

