/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateStringFormat;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.hibernate.HibernateException;
import org.hibernate.type.StringType;
import org.hibernate.type.TimestampType;
import org.hibernate.usertype.UserType;

public class ImpreciseDateType
implements UserType {
    private final TimestampType timestampType = new TimestampType();
    private final StringType stringType = new StringType();

    public int[] sqlTypes() {
        return new int[]{this.timestampType.sqlType(), this.stringType.sqlType()};
    }

    public Class returnedClass() {
        return ImpreciseDate.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Timestamp date = (Timestamp)this.timestampType.nullSafeGet(rs, names[0]);
        String string = (String)this.stringType.nullSafeGet(rs, names[1]);
        if (date != null) {
            return new ImpreciseDate(date);
        }
        if (string != null) {
            return new ImpreciseDate(new ImpreciseDateStringFormat(string).getCalendar());
        }
        return null;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value != null) {
            ImpreciseDate impreciseDate = (ImpreciseDate)value;
            if (impreciseDate.isPrecise()) {
                this.timestampType.nullSafeSet(st, (Object)impreciseDate.getDate(), index);
                this.stringType.nullSafeSet(st, null, index + 1);
            } else {
                this.timestampType.nullSafeSet(st, null, index);
                this.stringType.nullSafeSet(st, (Object)impreciseDate.getString(), index + 1);
            }
        } else {
            this.timestampType.nullSafeSet(st, null, index);
            this.stringType.nullSafeSet(st, null, index + 1);
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public int hashCode(Object x) throws HibernateException {
        return x != null ? x.hashCode() : 0;
    }
}

