/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.hibernate;

import gov.va.med.esr.common.infra.ImpreciseDate;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import org.hibernate.HibernateException;
import org.hibernate.type.StringType;
import org.hibernate.usertype.UserType;

public class CombinedImpreciseDateType
implements UserType {
    private final StringType stringType = new StringType();
    public static final String DATABASE_FORMAT = "yyyyMMdd";

    public int[] sqlTypes() {
        return new int[]{this.stringType.sqlType()};
    }

    public Class returnedClass() {
        return ImpreciseDate.class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        return x == y || x != null && x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        String string = (String)this.stringType.nullSafeGet(rs, names[0]);
        try {
            return CombinedImpreciseDateType.fromDatabaseValue(string);
        }
        catch (ParseException e) {
            throw new HibernateException("Can not parse database String date into ImpreciseDate", (Throwable)e);
        }
    }

    public static ImpreciseDate fromDatabaseValue(String date) throws ParseException {
        ImpreciseDate val = null;
        if (date != null) {
            val = new ImpreciseDate(date);
        }
        return val;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        this.stringType.nullSafeSet(st, (Object)CombinedImpreciseDateType.toDatabaseValue((ImpreciseDate)value), index);
    }

    public static String toDatabaseValue(ImpreciseDate date) {
        return date != null ? date.toStandardFormat() : null;
    }

    public Object deepCopy(Object value) throws HibernateException {
        return value;
    }

    public boolean isMutable() {
        return false;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)value;
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return cached;
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return original;
    }

    public int hashCode(Object x) throws HibernateException {
        return x != null ? x.hashCode() : 0;
    }
}

