/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.persistent.comms.CommsTransLogDAO;
import gov.va.med.esr.common.persistent.comms.ExportFileDAO;
import gov.va.med.fw.service.ServiceException;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.IOUtils;

public class ExportFileDAOImpl
implements ExportFileDAO {
    private static final long serialVersionUID = -6919751063975875307L;
    private String filePath = null;
    private String cmsFilePath = null;
    private CommsTransLogDAO commsTransLogDAO = null;

    @Override
    public String getAacFileName(String aacExtractId) {
        return aacExtractId + ".tmp";
    }

    @Override
    public String getAacExtractId() {
        return this.getExtractId();
    }

    @Override
    public String getOriginalAacFileName(String aacExtractId) {
        return aacExtractId + ".ltr";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void save(String text, String aacExtractId) throws ServiceException {
        FileWriter fw = null;
        try {
            String fullQualifiedFileName = this.getAacFilePath() + this.getAacFileName(aacExtractId);
            File file = new File(fullQualifiedFileName);
            fw = new FileWriter(file, file.exists());
            fw.write(text);
            fw.flush();
            if (fw == null) return;
        }
        catch (IOException ioe) {
            try {
                throw new ServiceException("#### Error saving AAC Export Letter File", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                if (fw == null) throw throwable;
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fw);
        return;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void saveCms(String text, String extractId) throws ServiceException {
        FileWriter fw = null;
        try {
            String fullQualifiedFileName = this.getCmsFilePath() + this.getCmsFileName(extractId);
            File file = new File(fullQualifiedFileName);
            fw = new FileWriter(file, file.exists());
            fw.write(text);
            fw.flush();
            if (fw == null) return;
        }
        catch (IOException ioe) {
            try {
                throw new ServiceException("#### Error saving AAC Export Letter File", (Throwable)ioe);
            }
            catch (Throwable throwable) {
                if (fw == null) throw throwable;
                IOUtils.closeQuietly(fw);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Writer)fw);
        return;
    }

    @Override
    public void changeTmpFilesToLtr() throws IOException {
        File dir = new File(this.getAacFilePath());
        String target = "";
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".tmp");
            }
        };
        String[] files = dir.list(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String extn = ExportFileDAOImpl.getFileExtension(files[i]);
                if (!extn.equalsIgnoreCase("tmp")) continue;
                target = files[i].replaceAll("." + extn, ".ltr");
                new File(this.getAacFilePath() + files[i]).renameTo(new File(this.getAacFilePath() + target));
            }
        }
    }

    public static String getFileExtension(String f) {
        String ext = "";
        int i = f.lastIndexOf(46);
        if (i > 0 && i < f.length() - 1) {
            ext = f.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    @Override
    public String getAacFilePath() {
        if (this.filePath != null && !this.filePath.endsWith("/")) {
            this.filePath = this.filePath + "/";
        }
        return this.filePath;
    }

    @Override
    public void changeCmsTmpFilesToLtr() throws IOException {
        String path = this.getCmsFilePath();
        File dir = new File(path);
        String target = "";
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".tmp");
            }
        };
        String[] files = dir.list(filter);
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String extn = ExportFileDAOImpl.getFileExtension(files[i]);
                if (!extn.equalsIgnoreCase("tmp")) continue;
                target = files[i].replaceAll("." + extn, ".ltr");
                new File(path + files[i]).renameTo(new File(path + target));
            }
        }
    }

    @Override
    public String getCmsExtractId() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyDDD");
        String fileNameBeforeVersion = "W" + sdf.format(new Date());
        return fileNameBeforeVersion + this.getFileVersion(fileNameBeforeVersion);
    }

    @Override
    public String getCmsFileName(String cmsExtractId) {
        return cmsExtractId + ".tmp";
    }

    @Override
    public String getCmsFilePath() {
        if (this.cmsFilePath != null && !this.cmsFilePath.endsWith("/")) {
            this.cmsFilePath = this.cmsFilePath + "/";
        }
        return this.cmsFilePath;
    }

    @Override
    public String getOriginalCmsFileName(String cmsExtractId) {
        return cmsExtractId + ".ltr";
    }

    @Override
    public void setCmsFilePath(String cmsFilePath) {
        this.cmsFilePath = cmsFilePath;
    }

    @Override
    public void setAacFilePath(String filePath) {
        this.filePath = filePath;
    }

    public CommsTransLogDAO getCommsTransLogDAO() {
        return this.commsTransLogDAO;
    }

    public void setCommsTransLogDAO(CommsTransLogDAO commsTransLogDAO) {
        this.commsTransLogDAO = commsTransLogDAO;
    }

    private String padRight(int length, String str, char c) {
        if (length == 0 || str == null) {
            return null;
        }
        StringBuffer sbuf = new StringBuffer();
        for (int i = length - str.length(); i > 0; --i) {
            sbuf.insert(0, c);
        }
        return sbuf + str;
    }

    private String getExtractId() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyDDD");
        String fileNameBeforeVersion = "W" + sdf.format(new Date());
        return fileNameBeforeVersion + this.getFileVersion(fileNameBeforeVersion);
    }

    private String getFileVersion(String fileNameBeforeVersion) {
        String versionStr = "01";
        String latestFileName = this.commsTransLogDAO.findFileNameByMaxId(fileNameBeforeVersion);
        if (latestFileName != null && latestFileName.startsWith(fileNameBeforeVersion)) {
            int beginIndex = fileNameBeforeVersion.length();
            int endIndex = latestFileName.length() - ".tmp".length();
            if (endIndex > beginIndex) {
                String lastVersionStr = latestFileName.substring(beginIndex, endIndex);
                int lastVersionNum = Integer.parseInt(lastVersionStr);
                versionStr = ++lastVersionNum < 10 ? "0" + lastVersionNum : String.valueOf(lastVersionNum);
            }
        }
        return versionStr;
    }
}

