/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.persistent.comms.hibernate;

import gov.va.med.esr.common.model.comms.Correspondence;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.persistent.comms.CorrespondenceDAO;
import gov.va.med.fw.persistent.DAOException;
import gov.va.med.fw.persistent.hibernate.AbstractDAOAction;
import gov.va.med.fw.persistent.hibernate.GenericDAOImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class CorrespondenceDAOImpl
extends GenericDAOImpl
implements CorrespondenceDAO {
    private static final long serialVersionUID = 7401171707221279133L;

    @Override
    public List<Correspondence> findCorrespondenceByPersonId(String personId) throws DAOException {
        return null;
    }

    @Override
    public Address getHistoricalAddress(BigDecimal addressHId) throws DAOException {
        Object row;
        HashMap<String, BigDecimal> contextData = new HashMap<String, BigDecimal>();
        contextData.put("addressHId", addressHId);
        AbstractDAOAction callback = new AbstractDAOAction(contextData){

            public Object execute(Session session) {
                Query q = session.getNamedQuery("correspondenceQuery_findHistoryAddressById");
                q.setParameter("addressHId", (Object)((BigDecimal)this.getContextData().get("addressHId")));
                return q.list();
            }
        };
        List results = this.getHibernateTemplate().executeFind((HibernateCallback)callback);
        Iterator iter = results.iterator();
        Address address = null;
        if (iter.hasNext() && (row = iter.next()) != null) {
            address = (Address)row;
        }
        return address;
    }

    @Override
    public Correspondence findById(BigDecimal correspondenceId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"correspondenceId"};
            Object[] values = new Object[]{correspondenceId};
            ArrayList results = new ArrayList(tpl.findByNamedQueryAndNamedParam("CorrespondenceQuery_findById", params, values));
            if (results != null && results.size() == 1) {
                return (Correspondence)((Object)results.get(0));
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", (Throwable)e);
        }
    }

    @Override
    public ArrayList<Correspondence> findPendingCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId", "formId"};
            Object[] values = new Object[]{personId, formId};
            ArrayList<Correspondence> results = new ArrayList<Correspondence>(tpl.findByNamedQueryAndNamedParam("CorrespondenceQuery_findPendingByFormNumber", params, values));
            if (results != null && results.size() > 0) {
                return results;
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", (Throwable)e);
        }
    }

    @Override
    public ArrayList<Correspondence> findSentCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId", "formId"};
            Object[] values = new Object[]{personId, formId};
            ArrayList<Correspondence> results = new ArrayList<Correspondence>(tpl.findByNamedQueryAndNamedParam("CorrespondenceQuery_findSentByFormNumber", params, values));
            if (results != null && results.size() > 0) {
                return results;
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", (Throwable)e);
        }
    }

    @Override
    public ArrayList<Correspondence> findAllCorrespondenceByForm(BigDecimal personId, String formId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            String[] params = new String[]{"personId", "formId"};
            Object[] values = new Object[]{personId, formId};
            ArrayList<Correspondence> results = new ArrayList<Correspondence>(tpl.findByNamedQueryAndNamedParam("CorrespondenceQuery_findAllByFormNumber", params, values));
            if (results != null && results.size() > 0) {
                return results;
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the correspondence list by form and status ", (Throwable)e);
        }
    }

    @Override
    public BigDecimal findAddressHistoryIdByPersonId(BigDecimal personId) throws DAOException {
        try {
            HibernateTemplate tpl = this.getHibernateTemplate();
            List results = tpl.findByNamedQueryAndNamedParam("CorrespondenceQuery_findAddressHIdByPersonId", "personId", (Object)personId);
            if (results != null && results.size() == 1) {
                return (BigDecimal)results.get(0);
            }
            return null;
        }
        catch (DataAccessException e) {
            throw new DAOException("Failed to get the address_h id by identifier", (Throwable)e);
        }
    }
}

