/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.registry;

import gov.va.med.esr.common.model.lookup.RegistryType;
import gov.va.med.esr.common.model.registry.RegistryLoadException;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class RegistryLoadStatistics
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -4078984709658419472L;
    private RegistryType registryType;
    private int recordsRead;
    private int recordsPassedConsistencyCheck;
    private int recordsFailedConsistencyCheck;
    private int recordsNotMatchedToExistingRecords;
    private int recordsMatchedToExistingRecords;
    private int recordsAmbiguouslyMatched;
    private int newRegistryEntriesInserted;
    private Set internalRegistryLoadExceptions;

    public int getNewRegistryEntriesInserted() {
        return this.newRegistryEntriesInserted;
    }

    public void setNewRegistryEntriesInserted(int newRegistryEntriesInserted) {
        this.newRegistryEntriesInserted = newRegistryEntriesInserted;
    }

    public int getRecordsAmbiguouslyMatched() {
        return this.recordsAmbiguouslyMatched;
    }

    public void setRecordsAmbiguouslyMatched(int recordsAmbiguouslyMatched) {
        this.recordsAmbiguouslyMatched = recordsAmbiguouslyMatched;
    }

    public int getRecordsMatchedToExistingRecords() {
        return this.recordsMatchedToExistingRecords;
    }

    public void setRecordsMatchedToExistingRecords(int recordsMatchedToExistingRecords) {
        this.recordsMatchedToExistingRecords = recordsMatchedToExistingRecords;
    }

    public int getRecordsNotMatchedToExistingRecords() {
        return this.recordsNotMatchedToExistingRecords;
    }

    public void setRecordsNotMatchedToExistingRecords(int recordsNotMatchedToExistingRecords) {
        this.recordsNotMatchedToExistingRecords = recordsNotMatchedToExistingRecords;
    }

    public int getRecordsFailedConsistencyCheck() {
        return this.recordsFailedConsistencyCheck;
    }

    public void setRecordsFailedConsistencyCheck(int recordsFailedConsistencyCheck) {
        this.recordsFailedConsistencyCheck = recordsFailedConsistencyCheck;
    }

    public int getRecordsPassedConsistencyCheck() {
        return this.recordsPassedConsistencyCheck;
    }

    public void setRecordsPassedConsistencyCheck(int recordsPassedConsistencyCheck) {
        this.recordsPassedConsistencyCheck = recordsPassedConsistencyCheck;
    }

    public int getRecordsRead() {
        return this.recordsRead;
    }

    public void setRecordsRead(int recordsRead) {
        this.recordsRead = recordsRead;
    }

    public RegistryType getRegistryType() {
        return this.registryType;
    }

    public void setRegistryType(RegistryType registryType) {
        this.registryType = registryType;
    }

    private Set getInternalRegistryLoadExceptions() {
        if (this.internalRegistryLoadExceptions == null) {
            this.internalRegistryLoadExceptions = new HashSet();
        }
        return this.internalRegistryLoadExceptions;
    }

    public Set getRegistryLoadExceptions() {
        return Collections.unmodifiableSet(this.getInternalRegistryLoadExceptions());
    }

    public void setInternalRegistryLoadExceptions(Set internalRegistryLoadExceptions) {
        this.internalRegistryLoadExceptions = internalRegistryLoadExceptions;
    }

    public void addRegistryLoadException(RegistryLoadException registryLoadException) {
        Validate.notNull((Object)((Object)registryLoadException), (String)"Null registryLoadExceptionDetail specified.");
        registryLoadException.setRegistryLoadStatistics(this);
        this.getInternalRegistryLoadExceptions().add(registryLoadException);
    }

    public void addAllRegistryLoadExceptionDetails(Set registryLoadExceptions) {
        Validate.notNull((Object)registryLoadExceptions, (String)"Null set of registryLoadExceptionDetails specified.");
        if (registryLoadExceptions != null) {
            for (RegistryLoadException registryLoadException : registryLoadExceptions) {
                this.addRegistryLoadException(registryLoadException);
            }
        }
    }

    public RegistryLoadException getRegistryLoadExceptionByEntityKey(EntityKey identifier) {
        return (RegistryLoadException)RegistryLoadStatistics.getEntityByEntityKey((Collection)this.getRegistryLoadExceptions(), (EntityKey)identifier);
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("registryType", (Object)(this.registryType != null ? this.registryType.getDescription() : ""));
        builder.append("recordsRead", this.recordsRead);
        builder.append("recordsPassedConsistencyCheck", this.recordsPassedConsistencyCheck);
        builder.append("recordsFailedConsistencyCheck", this.recordsFailedConsistencyCheck);
        builder.append("recordsNotMatchedToExistingRecords", this.recordsNotMatchedToExistingRecords);
        builder.append("recordsMatchedToExistingRecords", this.recordsMatchedToExistingRecords);
        builder.append("recordsAmbiguouslyMatched", this.recordsAmbiguouslyMatched);
        builder.append("newRegistryEntriesInserted", this.newRegistryEntriesInserted);
    }
}

