/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.PatientProviderAssignmentLite;
import gov.va.med.esr.common.model.person.PreferredFacilityLite;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.Reflector;
import gov.va.med.person.idmgmt.VPID;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public class PreferredFacilityPerson
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 1239949174636157089L;
    private String VPIDValue;
    private Set internalPreferredFacilities = null;
    private Set internalProviderAssignments = null;
    private VAFacility mostRecentPreferredFacility = null;
    PersonIdentityTraits identityTraits = null;

    public VPIDEntityKey getVPIDEntityKey() {
        return this.VPIDValue != null ? CommonEntityKeyFactory.createVPIDEntityKey(this.VPIDValue) : null;
    }

    private String getVPIDValue() {
        return this.VPIDValue;
    }

    private void setVPIDValue(String VPIDValue) {
        this.VPIDValue = VPIDValue;
    }

    public String getShortVPID() {
        return VPID.getShortVPID((String)this.getVPIDValue());
    }

    protected Class getEntityKeyClass() {
        return PersonIdEntityKeyImpl.class;
    }

    public PersonEntityKey getPersonEntityKey() {
        return (PersonEntityKey)this.getEntityKey();
    }

    public PersonIdentityTraits getIdentityTraits() {
        return this.identityTraits;
    }

    public void setIdentityTraits(PersonIdentityTraits identityTraits) {
        this.identityTraits = identityTraits;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.setVPIDValue(null);
    }

    public VAFacility getMostRecentPreferredFacility() {
        return this.mostRecentPreferredFacility;
    }

    public void setMostRecentPreferredFacility(VAFacility mostRecentPreferredFacility) {
        this.mostRecentPreferredFacility = mostRecentPreferredFacility;
    }

    public Set getPreferredFacilities() {
        return Collections.unmodifiableSet(this.getInternalPreferredFacilities());
    }

    private Set getInternalPreferredFacilities() {
        if (this.internalPreferredFacilities == null) {
            this.internalPreferredFacilities = new HashSet();
        }
        return this.internalPreferredFacilities;
    }

    private void setInternalPreferredFacilities(Set preferredFacilities) {
        this.internalPreferredFacilities = preferredFacilities;
    }

    public void addPreferredFacility(PreferredFacilityLite preferredFacility) {
        Validate.notNull((Object)((Object)preferredFacility), (String)"Null preferredFacility specified.");
        this.getInternalPreferredFacilities().add(preferredFacility);
        preferredFacility.setPersonLite(this);
    }

    public void addAllPreferredFacilities(Set preferredFacilities) {
        Validate.notNull((Object)preferredFacilities, (String)"Empty set of preferredFacilities specified.");
        this.setOwner(preferredFacilities);
        Set internal = this.getInternalPreferredFacilities();
        internal.addAll(preferredFacilities);
    }

    public void removePreferredFacility(PreferredFacilityLite preferredFacility) {
        Validate.notNull((Object)((Object)preferredFacility), (String)"Null PreferredFacility specified.");
        preferredFacility.setPersonLite(null);
        this.getInternalPreferredFacilities().remove((Object)preferredFacility);
    }

    public void removeAllPreferredFacilities() {
        this.getInternalPreferredFacilities().clear();
    }

    public Set getProviderAssignments() {
        return Collections.unmodifiableSet(this.getInternalProviderAssignments());
    }

    private Set getInternalProviderAssignments() {
        if (this.internalProviderAssignments == null) {
            this.internalProviderAssignments = new HashSet();
        }
        return this.internalProviderAssignments;
    }

    private void setInternalProviderAssignments(Set providerAssignments) {
        this.internalProviderAssignments = providerAssignments;
    }

    public void addProviderAssignment(PatientProviderAssignmentLite providerAssignment) {
        Validate.notNull((Object)((Object)providerAssignment), (String)"Null ProviderAssignment specified.");
        this.getInternalProviderAssignments().add(providerAssignment);
        providerAssignment.setPersonLite(this);
    }

    public void addAllProviderAssignments(Set providerAssignments) {
        Validate.notNull((Object)providerAssignments, (String)"Empty set of providerAssignments specified.");
        this.setOwner(providerAssignments);
        Set internal = this.getInternalProviderAssignments();
        internal.addAll(providerAssignments);
    }

    public void removeProviderAssignment(PatientProviderAssignmentLite providerAssignment) {
        Validate.notNull((Object)((Object)providerAssignment), (String)"Null PatientProviderAssignments specified.");
        providerAssignment.setPersonLite(null);
        this.getInternalProviderAssignments().remove((Object)providerAssignment);
    }

    public void removeAllProviderAssignments() {
        this.getInternalProviderAssignments().clear();
    }

    private void setOwner(AbstractKeyedEntity entity) {
        block2: {
            Validate.notNull((Object)entity, (String)"Null entity specified");
            try {
                Reflector.invoke((Object)entity, (String)"setPerson", (Object[])new Object[]{this});
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug((Object)("Failed to set person as an owner for entity " + entity), (Throwable)e);
            }
        }
    }

    private void setOwner(Collection entities) {
        Validate.notNull((Object)entities, (String)"Null entity specified");
        for (Object entity : entities) {
            this.setOwner((AbstractKeyedEntity)entity);
        }
    }
}

