/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PersonMergeInfo
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 3453931235558751426L;
    private Person primaryPerson = null;
    private Person deprecatedPerson = null;
    private Serializable primaryPersonIdentifier = null;
    private Serializable deprecatedPersonIdentifier = null;
    private Boolean recordLocked = Boolean.FALSE;
    private Date mergeStartDate = null;
    private Date mergeEndDate = null;
    private String mergeSelections = null;
    private PersonIdentityTraits primaryPersonIdentityTraits = null;
    private PersonIdentityTraits deprecatedPersonIdentityTraits = null;

    public PersonIdentityTraits getDeprecatedPersonIdentityTraits() {
        return this.deprecatedPersonIdentityTraits;
    }

    public void setDeprecatedPersonIdentityTraits(PersonIdentityTraits deprecatedPersonIdentityTraits) {
        this.deprecatedPersonIdentityTraits = deprecatedPersonIdentityTraits;
    }

    public Date getMergeStartDate() {
        return this.mergeStartDate;
    }

    public void setMergeStartDate(Date mergeStartDate) {
        this.mergeStartDate = mergeStartDate;
    }

    public boolean isMergeInProgress() {
        return this.getMergeStartDate() != null;
    }

    public Date getMergeEndDate() {
        return this.mergeEndDate;
    }

    public void setMergeEndDate(Date mergeEndDate) {
        this.mergeEndDate = mergeEndDate;
    }

    public boolean isMergeCompleted() {
        return this.getMergeEndDate() != null;
    }

    public String getMergeSelections() {
        return this.mergeSelections;
    }

    public void setMergeSelections(String mergeSelections) {
        this.mergeSelections = mergeSelections;
    }

    public PersonIdentityTraits getPrimaryPersonIdentityTraits() {
        return this.primaryPersonIdentityTraits;
    }

    public void setPrimaryPersonIdentityTraits(PersonIdentityTraits primaryPersonIdentityTraits) {
        this.primaryPersonIdentityTraits = primaryPersonIdentityTraits;
    }

    public Boolean isRecordLocked() {
        return this.recordLocked;
    }

    public Boolean getRecordLocked() {
        return this.recordLocked;
    }

    public void setRecordLocked(Boolean recordLocked) {
        this.recordLocked = recordLocked;
    }

    private PersonIdEntityKey getPersonIdEntityKey(Serializable identifier) {
        PersonIdEntityKey key = null;
        if (identifier != null) {
            key = CommonEntityKeyFactory.createPersonIdEntityKey(identifier);
        }
        return key;
    }

    public PersonIdEntityKey getPrimaryPersonEntityKey() {
        return this.getPersonIdEntityKey(this.getPrimaryPersonIdentifier());
    }

    public void setPrimaryPersonEntityKey(PersonIdEntityKey primaryPersonEntityKey) {
        if (primaryPersonEntityKey != null) {
            this.setPrimaryPersonIdentifier(primaryPersonEntityKey.getKeyValue());
        }
    }

    public PersonIdEntityKey getDeprecatedPersonEntityKey() {
        return this.getPersonIdEntityKey(this.getDeprecatedPersonIdentifier());
    }

    public void setDeprecatedPersonEntityKey(PersonIdEntityKey deprecatedPersonEntityKey) {
        if (deprecatedPersonEntityKey != null) {
            this.setDeprecatedPersonIdentifier(deprecatedPersonEntityKey.getKeyValue());
        }
    }

    private Serializable getPrimaryPersonIdentifier() {
        return this.primaryPersonIdentifier;
    }

    private void setPrimaryPersonIdentifier(Serializable primaryPersonIdentifier) {
        this.primaryPersonIdentifier = primaryPersonIdentifier;
    }

    private Serializable getDeprecatedPersonIdentifier() {
        return this.deprecatedPersonIdentifier;
    }

    private void setDeprecatedPersonIdentifier(Serializable deprecatedPersonIdentifier) {
        this.deprecatedPersonIdentifier = deprecatedPersonIdentifier;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("deprecatedPersonIdentifier", (Object)this.deprecatedPersonIdentifier);
        builder.append("primaryPersonIdentifier", (Object)this.primaryPersonIdentifier);
        builder.append("deprecatedPersonIdentityTraits", (Object)this.deprecatedPersonIdentityTraits);
        builder.append("primaryPersonIdentityTraits", (Object)this.primaryPersonIdentityTraits);
        builder.append("recordLocked", (Object)this.recordLocked);
        builder.append("mergeStartDate", (Object)this.mergeStartDate);
        builder.append("mergeEndDate", (Object)this.mergeEndDate);
        builder.append("mergeSelections", (Object)this.mergeSelections);
        builder.append("primaryPerson", (Object)this.primaryPerson);
        builder.append("deprecatedPerson", (Object)this.deprecatedPerson);
    }

    public Person getPrimaryPerson() {
        return this.primaryPerson;
    }

    public void setPrimaryPerson(Person primaryPerson) {
        this.primaryPerson = primaryPerson;
    }

    public Person getDeprecatedPerson() {
        return this.deprecatedPerson;
    }

    public void setDeprecatedPerson(Person deprecatedPerson) {
        this.deprecatedPerson = deprecatedPerson;
    }
}

