/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.esr.common.infra.PredicatedTransformer;
import gov.va.med.esr.common.infra.RemoveTransformedSet;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.comms.DeliveryPreference;
import gov.va.med.esr.common.model.ee.AgentOrangeExposure;
import gov.va.med.esr.common.model.ee.Application;
import gov.va.med.esr.common.model.ee.CampLejeuneVerification;
import gov.va.med.esr.common.model.ee.CancelDecline;
import gov.va.med.esr.common.model.ee.CatastrophicDisability;
import gov.va.med.esr.common.model.ee.ClinicalDetermination;
import gov.va.med.esr.common.model.ee.Decoration;
import gov.va.med.esr.common.model.ee.EligibilityVerification;
import gov.va.med.esr.common.model.ee.EnrollmentDetermination;
import gov.va.med.esr.common.model.ee.EnrollmentOverride;
import gov.va.med.esr.common.model.ee.EnvironmentalContaminationExposure;
import gov.va.med.esr.common.model.ee.FeeBasis;
import gov.va.med.esr.common.model.ee.HealthBenefitProfile;
import gov.va.med.esr.common.model.ee.IncompetenceRuling;
import gov.va.med.esr.common.model.ee.IneligibilityFactor;
import gov.va.med.esr.common.model.ee.MedalOfHonor;
import gov.va.med.esr.common.model.ee.MedicaidFactor;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.ee.MilitarySexualTrauma;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.ee.NoseThroatRadium;
import gov.va.med.esr.common.model.ee.PrisonerOfWar;
import gov.va.med.esr.common.model.ee.PurpleHeart;
import gov.va.med.esr.common.model.ee.RadiationExposure;
import gov.va.med.esr.common.model.ee.ReceivedEligibility;
import gov.va.med.esr.common.model.ee.ReceivedEnrollment;
import gov.va.med.esr.common.model.ee.SHAD;
import gov.va.med.esr.common.model.ee.ServiceConnectionAward;
import gov.va.med.esr.common.model.ee.SpecialFactor;
import gov.va.med.esr.common.model.ee.SpinalCordInjury;
import gov.va.med.esr.common.model.financials.BeneficiaryTravel;
import gov.va.med.esr.common.model.financials.FinancialStatement;
import gov.va.med.esr.common.model.financials.InProcessFinancialInfo;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.common.model.financials.PatientVisitSummary;
import gov.va.med.esr.common.model.insurance.InsurancePolicy;
import gov.va.med.esr.common.model.insurance.Medicare;
import gov.va.med.esr.common.model.insurance.PrivateInsurance;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.AssociationType;
import gov.va.med.esr.common.model.lookup.ConfidentialAddressCategoryType;
import gov.va.med.esr.common.model.lookup.Gender;
import gov.va.med.esr.common.model.lookup.MaritalStatus;
import gov.va.med.esr.common.model.lookup.NameType;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.RaceType;
import gov.va.med.esr.common.model.lookup.Relationship;
import gov.va.med.esr.common.model.lookup.Religion;
import gov.va.med.esr.common.model.lookup.SSNType;
import gov.va.med.esr.common.model.lookup.SelfIdentifiedGenderIdentity;
import gov.va.med.esr.common.model.lookup.SensitivityChangeSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.ConfidentialAddressCategory;
import gov.va.med.esr.common.model.party.Email;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Association;
import gov.va.med.esr.common.model.person.BirthRecord;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.esr.common.model.person.EmergencyResponseIndicator;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.esr.common.model.person.Ethnicity;
import gov.va.med.esr.common.model.person.Name;
import gov.va.med.esr.common.model.person.PatientProviderAssignment;
import gov.va.med.esr.common.model.person.PersonLockedReason;
import gov.va.med.esr.common.model.person.PreferredFacility;
import gov.va.med.esr.common.model.person.PreferredLanguage;
import gov.va.med.esr.common.model.person.Race;
import gov.va.med.esr.common.model.person.Relation;
import gov.va.med.esr.common.model.person.SSN;
import gov.va.med.esr.common.model.person.SignatureImage;
import gov.va.med.esr.common.model.person.id.PersonEntityKey;
import gov.va.med.esr.common.model.person.id.PersonIdEntityKeyImpl;
import gov.va.med.esr.common.model.person.id.VPIDEntityKey;
import gov.va.med.esr.service.PersonIdentityTraits;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.AuditInfo;
import gov.va.med.fw.model.EntityKey;
import gov.va.med.fw.util.CollectionUtils;
import gov.va.med.fw.util.Reflector;
import gov.va.med.ps.model.PersonVPID;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.collections.set.TransformedSet;
import org.apache.commons.collections.set.UnmodifiableSet;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class Person
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 6901518517513943128L;
    private Boolean appointmentRequestResponse = null;
    private Date appointmentRequestDate = null;
    private Date demographicUpdateDate = null;
    private Gender gender = null;
    private String degree = null;
    private MaritalStatus maritalStatus = null;
    private MilitaryService militaryService = null;
    private BirthRecord birthRecord = null;
    private DeathRecord deathRecord = null;
    private Integer userEnrolleeValidThrough = null;
    private VAFacility userEnrolleeSite = null;
    private String claimFolderNumber = null;
    private Date sensitivityChangeDate = null;
    private SensitivityChangeSource sensitivityChangeSource = null;
    private VAFacility sensitivityChangeSite = null;
    private VAFacility claimFolderLocation = null;
    private VAFacility mostRecentPreferredFacility = null;
    private PersonVPID vpid = null;
    private String vpidValue = null;
    private PersonIdentityTraits pendingUpdatesForIdentityTraits = null;
    private Set otherNames = null;
    private Set otherSsns = null;
    private Name fathersName = null;
    private Name mothersName = null;
    private Set siteIdentities = null;
    private Set internalDependents = null;
    private Set internalNames = null;
    private Set internalAddresses = null;
    private Set internalPhones = null;
    private Set internalEmails = null;
    private Set internalEmergencyResponseIndicators = null;
    private Set internalAssociations = null;
    private Set internalConfidentialAddressCategories = null;
    private Set internalInsurances = null;
    private Set internalEnrollmentDeterminations = null;
    private Set internalMedicaidFactors = null;
    private Set internalPreferredLanguages = null;
    private Set internalReceivedEnrollments = null;
    private Set internalReceivedPrimaryEligibilities = null;
    private Set internalReceivedSecondaryEligibilities = null;
    private Set internalServiceConnectionAwards = null;
    private Set internalSpecialFactors = null;
    private Set internalMSTs = null;
    private Set internalNTRs = null;
    private Set internalCDs = null;
    private Set internalSCIs = null;
    private Set internalIneligibilityFactors = null;
    private Set internalIncompetenceRulings = null;
    private Set internalDecorations = null;
    private Set internalMedalOfHonors = null;
    private Set internalShads = null;
    private Set internalMonetaryBenefitAwards = null;
    private Set internalPrisonerOfWars = null;
    private Set internalEnrollmentOverrides = null;
    private Set internalCancelDeclines = null;
    private Set internalApplications = null;
    private Set internalSsns = null;
    private Set internalEligibilityVerifications = null;
    private Set internalSignatureImages = null;
    private Set internalFeeBasis = null;
    private Set internalPreferredFacilities = null;
    private Set internalProviderAssignments = null;
    private Set internalHealthBenefitProfiles = null;
    private Map internalBeneficiaryTravels = null;
    private Map internalPatientVisitSummaries = null;
    private Map internalFinancialStatements = null;
    private Map internalInProcessFinancials = null;
    private Map internalIncomeTests = null;
    private Map changeEvents = null;
    private Boolean veteran = null;
    private Boolean sensitiveRecord = null;
    private Boolean migratedEE;
    private PersonLockedReason personLockedReason = null;
    private int openCasesCount = 0;
    private String sendingFacility = null;
    private AuditInfo identityTraitsAuditInfo;
    private String mothersMaidenName;
    private Set internalEmployments = null;
    private Set internalRaces = null;
    private Set internalEthnicities = null;
    private Religion religion = null;
    private Set internalDeliveryPreferences = null;
    private boolean esrCorrelationAdded = false;
    private Set internalRelations = null;
    private Character VOAIndicator = null;
    private boolean voaFormProcessPendingStatus = false;
    private Boolean eligibleForClassIIDental = null;
    private Date classIIDentalApplicationDueBefore = null;
    public static final Integer EARLIEST_INCOME_YEAR = new Integer(1980);
    private Boolean needCareDueToAccident = null;
    private Boolean needCareDueToInjury = null;
    private int idmMatchType;
    private Date enrollmentSignatureDate = null;
    private SelfIdentifiedGenderIdentity selfIdentifiedGenderIdentity = null;
    private boolean justAdded = false;

    public Person() {
    }

    public Person(VPIDEntityKey key) {
        this.vpidValue = key.getVPID();
    }

    protected Class getEntityKeyClass() {
        return PersonIdEntityKeyImpl.class;
    }

    public PersonEntityKey getPersonEntityKey() {
        return this.getPersonEntityKey(false);
    }

    public PersonEntityKey getPersonEntityKey(boolean shouldIncludeVersion) {
        PersonEntityKey key = (PersonEntityKey)this.getEntityKey();
        if (key != null && !shouldIncludeVersion) {
            key.disableVersionCheck();
        }
        return key;
    }

    public Date getAppointmentRequestDate() {
        return this.appointmentRequestDate;
    }

    public void setAppointmentRequestDate(Date appointmentRequestDate) {
        this.appointmentRequestDate = appointmentRequestDate;
    }

    public Date getDemographicUpdateDate() {
        return this.demographicUpdateDate;
    }

    public void setDemographicUpdateDate(Date demographicUpdateDate) {
        this.demographicUpdateDate = demographicUpdateDate;
    }

    public Boolean getAppointmentRequestResponse() {
        return this.appointmentRequestResponse;
    }

    public void setAppointmentRequestResponse(Boolean appointmentRequestResponse) {
        this.appointmentRequestResponse = appointmentRequestResponse;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public String getDegree() {
        return this.degree;
    }

    public void setDegree(String degree) {
        this.degree = degree;
    }

    public MaritalStatus getMaritalStatus() {
        return this.maritalStatus;
    }

    public void setMaritalStatus(MaritalStatus maritalStatus) {
        this.maritalStatus = maritalStatus;
    }

    private Set getInternalSsns() {
        if (this.internalSsns == null) {
            this.internalSsns = new HashSet();
        }
        return this.internalSsns;
    }

    private void setInternalSsns(Set internalSsns) {
        this.internalSsns = internalSsns;
    }

    public Set getSsns() {
        return Collections.unmodifiableSet(this.getInternalSsns());
    }

    public void addSsn(SSN ssn) {
        Validate.notNull((Object)((Object)ssn), (String)"SSN cannot be null");
        this.getInternalSsns().add(ssn);
    }

    public void removeSsn(SSN ssn) {
        Validate.notNull((Object)((Object)ssn), (String)"SSN cannot be null");
        this.getInternalSsns().remove((Object)ssn);
    }

    private void removeAllSsns() {
        this.getInternalSsns().clear();
    }

    public SSN getOfficialSsn() {
        return SSN.getSSNOfType(this.getInternalSsns(), SSNType.CODE_ACTIVE.getName());
    }

    public SSN getPseudoSsn() {
        return SSN.getSSNOfType(this.getInternalSsns(), SSNType.CODE_PSEUDO.getName());
    }

    public Set getOfficialSsns() {
        Set otherSsns = SSN.getSSNsOfType(this.getInternalSsns(), SSNType.CODE_ACTIVE.getName());
        return Collections.unmodifiableSet(otherSsns);
    }

    public Set getOtherSsns() {
        Set otherSsns = SSN.getSSNsOfType(this.getInternalSsns(), SSNType.CODE_ALIAS.getName());
        return Collections.unmodifiableSet(otherSsns);
    }

    public void removeOtherSsns(Set otherSsns) {
        if (otherSsns == null) {
            return;
        }
        Iterator i = otherSsns.iterator();
        while (i.hasNext()) {
            this.removeSsn((SSN)((Object)i.next()));
        }
    }

    public Name getLegalName() {
        return Name.getNameOfType(this.getInternalNames(), NameType.LEGAL_NAME.getName());
    }

    public Name getAliasName() {
        return Name.getNameOfType(this.getInternalNames(), NameType.ALIAS_NAME.getName());
    }

    public void setAliasName(Name name) {
        Name aliasName = this.getAliasName();
        if (aliasName != null) {
            this.removeName(aliasName);
        }
        this.addName(name);
    }

    public void setLegalName(Name name) {
        Name legalName = this.getLegalName();
        if (legalName != null) {
            this.removeName(legalName);
        }
        this.addName(name);
    }

    public Set getNames() {
        return Collections.unmodifiableSet(this.getInternalNames());
    }

    public Set getOtherNames() {
        HashSet otherNames = new HashSet(this.getNames());
        Name legalName = this.getLegalName();
        if (legalName != null) {
            otherNames.remove(legalName);
        }
        return Collections.unmodifiableSet(otherNames);
    }

    private Set getInternalNames() {
        if (this.internalNames == null) {
            this.internalNames = new HashSet();
        }
        return this.internalNames;
    }

    private void setInternalNames(Set internalNames) {
        this.internalNames = internalNames;
    }

    public void addName(Name name) {
        Validate.notNull((Object)name, (String)"Null Name specified.");
        this.getInternalNames().add(name);
    }

    public void removeName(Name name) {
        Validate.notNull((Object)name, (String)"Null Name specified.");
        this.getInternalNames().remove(name);
    }

    public void removeAllNames() {
        this.getInternalNames().clear();
    }

    public Set getAddresses() {
        return Collections.unmodifiableSet(this.getInternalAddresses());
    }

    public Address getAddressByEntityKey(EntityKey identifier) {
        return (Address)Person.getEntityByEntityKey((Collection)this.getAddresses(), (EntityKey)identifier);
    }

    private void setInternalAddresses(Set addresses) {
        this.internalAddresses = addresses;
    }

    private Set getInternalAddresses() {
        if (this.internalAddresses == null) {
            this.internalAddresses = new HashSet();
        }
        return this.internalAddresses;
    }

    public void addAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        this.getInternalAddresses().add(address);
        address.setPerson(this);
    }

    public void removeAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        this.getInternalAddresses().remove(address);
    }

    public Address getConfidentialAddress() {
        return Address.getAddressOfType(this.getInternalAddresses(), AddressType.CODE_CONFIDENTIAL_ADDRESS.getName());
    }

    public Address getTemporaryCorrespondenceAddress() {
        return Address.getAddressOfType(this.getInternalAddresses(), AddressType.CODE_TEMPORARY_CORRESPONDENCE_ADDRESS.getName());
    }

    public Address getPermanentAddress() {
        return Address.getAddressOfType(this.getInternalAddresses(), AddressType.CODE_PERMANENT_ADDRESS.getName());
    }

    public void removeAllAddresses() {
        this.getInternalAddresses().clear();
    }

    public Set getPhones() {
        return Collections.unmodifiableSet(this.getInternalPhones());
    }

    public Phone getPhoneByEntityKey(EntityKey identifier) {
        return (Phone)Person.getEntityByEntityKey((Collection)this.getPhones(), (EntityKey)identifier);
    }

    public Phone removePhoneByEntityKey(EntityKey identifier) {
        return (Phone)Person.removeEntityByEntityKey((Collection)this.getInternalPhones(), (EntityKey)identifier);
    }

    public Phone getHomePhone() {
        return Phone.getPhoneOfType(this.getInternalPhones(), PhoneType.CODE_HOME.getName());
    }

    public Phone getBusinessPhone() {
        return Phone.getPhoneOfType(this.getInternalPhones(), PhoneType.CODE_BUSINESS.getName());
    }

    public Phone getConfidentialPhone() {
        return Phone.getPhoneOfType(this.getInternalPhones(), PhoneType.CODE_CONFIDENTIAL.getName());
    }

    private Set getInternalPhones() {
        if (this.internalPhones == null) {
            this.internalPhones = new HashSet();
        }
        return this.internalPhones;
    }

    private void setInternalPhones(Set phones) {
        this.internalPhones = phones;
    }

    public void addPhone(Phone phone) {
        Validate.notNull((Object)((Object)phone), (String)"Null phone specified.");
        phone.setPerson(this);
        this.getInternalPhones().add(phone);
    }

    public void addAllPhones(Set phones) {
        Validate.notNull((Object)phones, (String)"Null set of phones specified.");
        this.setOwner(phones);
        Set internal = this.getInternalPhones();
        internal.addAll(phones);
    }

    public void removePhone(Phone phone) {
        Validate.notNull((Object)((Object)phone), (String)"Null phone specified.");
        this.getInternalPhones().remove((Object)phone);
        phone.setPerson(null);
    }

    public void removeAllPhones() {
        this.getInternalPhones().clear();
    }

    public Set getEmails() {
        return Collections.unmodifiableSet(this.getInternalEmails());
    }

    public Email getEmailByEntityKey(EntityKey identifier) {
        return (Email)Person.getEntityByEntityKey((Collection)this.getEmails(), (EntityKey)identifier);
    }

    public Email removeEmailByEntityKey(EntityKey identifier) {
        return (Email)Person.removeEntityByEntityKey((Collection)this.getInternalEmails(), (EntityKey)identifier);
    }

    private Set getInternalEmails() {
        if (this.internalEmails == null) {
            this.internalEmails = new HashSet();
        }
        return this.internalEmails;
    }

    private void setInternalEmails(Set emails) {
        this.internalEmails = emails;
    }

    public void addEmail(Email email) {
        Validate.notNull((Object)((Object)email), (String)"Null email specified.");
        this.getInternalEmails().add(email);
        email.setPerson(this);
    }

    public void addAllEmails(Set emails) {
        Validate.notNull((Object)emails, (String)"Empty set of emails specified.");
        this.setOwner(emails);
        Set internal = this.getInternalEmails();
        internal.addAll(emails);
    }

    public void removeEmail(Email email) {
        Validate.notNull((Object)((Object)email), (String)"Null Email specified.");
        email.setPerson(null);
        this.getInternalEmails().remove((Object)email);
    }

    public void removeAllEmails() {
        this.getInternalEmails().clear();
    }

    public Set getEmergencyResponseIndicators() {
        return Collections.unmodifiableSet(this.getInternalEmergencyResponseIndicators());
    }

    public EmergencyResponseIndicator getEmergencyResponseIndicatorByEntityKey(EntityKey identifier) {
        return (EmergencyResponseIndicator)Person.getEntityByEntityKey((Collection)this.getEmergencyResponseIndicators(), (EntityKey)identifier);
    }

    public EmergencyResponseIndicator removeEmergencyResponseIndicatorByEntityKey(EntityKey identifier) {
        return (EmergencyResponseIndicator)Person.removeEntityByEntityKey((Collection)this.getInternalEmergencyResponseIndicators(), (EntityKey)identifier);
    }

    public Set getConfidentialAddressCategories() {
        return this.getInternalConfidentialAddressCategories();
    }

    private void setInternalConfidentialAddressCategories(Set confidentialAddressCategories) {
        this.internalConfidentialAddressCategories = confidentialAddressCategories;
    }

    private Set getInternalConfidentialAddressCategories() {
        if (this.internalConfidentialAddressCategories == null) {
            this.internalConfidentialAddressCategories = new HashSet();
        }
        return this.internalConfidentialAddressCategories;
    }

    public void addConfidentialAddressCategory(ConfidentialAddressCategoryType type) {
        Validate.notNull((Object)((Object)type), (String)"Null ConfidentialAddressCategoryType specified");
        ConfidentialAddressCategory cat = this.getConfidentialAddressCategory(type);
        if (cat != null) {
            return;
        }
        cat = new ConfidentialAddressCategory();
        cat.setPerson(this);
        cat.setType(type);
        this.getInternalConfidentialAddressCategories().add(cat);
    }

    public void removeConfidentialAddressCategory(ConfidentialAddressCategoryType type) {
        Validate.notNull((Object)((Object)type), (String)"Null ConfidentialAddressCategoryType specified");
        ConfidentialAddressCategory cat = this.getConfidentialAddressCategory(type);
        if (cat != null) {
            this.getInternalConfidentialAddressCategories().remove((Object)cat);
        }
    }

    public void removeAllConfidentialAddressCategories() {
        this.getConfidentialAddressCategories().clear();
    }

    private ConfidentialAddressCategory getConfidentialAddressCategory(ConfidentialAddressCategoryType type) {
        Validate.notNull((Object)((Object)type), (String)"Null ConfidentialAddressCategoryType specified");
        for (ConfidentialAddressCategory cat : this.getInternalConfidentialAddressCategories()) {
            if (!type.getCode().equals(cat.getType().getCode())) continue;
            return cat;
        }
        return null;
    }

    private Set getInternalEmergencyResponseIndicators() {
        if (this.internalEmergencyResponseIndicators == null) {
            this.internalEmergencyResponseIndicators = new HashSet();
        }
        return this.internalEmergencyResponseIndicators;
    }

    private void setInternalEmergencyResponseIndicators(Set emergencyResponseIndicators) {
        this.internalEmergencyResponseIndicators = emergencyResponseIndicators;
    }

    public void addEmergencyResponseIndicator(EmergencyResponseIndicator emergencyResponseIndicator) {
        Validate.notNull((Object)((Object)emergencyResponseIndicator), (String)"Null emergencyResponseIndicator specified.");
        this.getInternalEmergencyResponseIndicators().add(emergencyResponseIndicator);
        emergencyResponseIndicator.setPerson(this);
    }

    public void addAllEmergencyResponseIndicators(Set emergencyResponseIndicators) {
        Validate.notNull((Object)emergencyResponseIndicators, (String)"Empty set of emergencyResponseIndicators specified.");
        this.setOwner(emergencyResponseIndicators);
        Set internal = this.getInternalEmergencyResponseIndicators();
        internal.addAll(emergencyResponseIndicators);
    }

    public void removeEmergencyResponseIndicator(EmergencyResponseIndicator emergencyResponseIndicator) {
        Validate.notNull((Object)((Object)emergencyResponseIndicator), (String)"Null EmergencyResponseIndicator specified.");
        emergencyResponseIndicator.setPerson(null);
        this.getInternalEmergencyResponseIndicators().remove((Object)emergencyResponseIndicator);
    }

    public void removeAllEmergencyResponseIndicators() {
        this.getInternalEmergencyResponseIndicators().clear();
    }

    public Set getAllAssociations() {
        return Collections.unmodifiableSet(this.getInternalAssociations());
    }

    public Set getAssociations() {
        HashSet<Association> activeAssocs = new HashSet<Association>();
        for (Association assoc : this.getInternalAssociations()) {
            if (assoc.isExpired()) continue;
            activeAssocs.add(assoc);
        }
        return Collections.unmodifiableSet(activeAssocs);
    }

    private Set getInternalAssociations() {
        if (this.internalAssociations == null) {
            this.internalAssociations = new HashSet();
        }
        return this.internalAssociations;
    }

    private void setInternalAssociations(Set associations) {
        this.internalAssociations = associations;
    }

    public void addAssociation(Association association) {
        Validate.notNull((Object)association, (String)"Null association specified.");
        this.getInternalAssociations().add(association);
        association.setPerson(this);
    }

    public void addAllAssociations(Set associations) {
        Validate.notEmpty((Collection)associations, (String)"Associations cannot be null or empty");
        for (Object association : associations) {
            if (!(association instanceof Association)) continue;
            this.addAssociation((Association)association);
        }
    }

    public void removeAssociation(Association association) {
        Validate.notNull((Object)association, (String)"Null association specified.");
        this.getInternalAssociations().remove(association);
    }

    public Association getAssociationByEntityKey(EntityKey identifier) {
        return (Association)Person.getEntityByEntityKey((Collection)this.getInternalAssociations(), (EntityKey)identifier);
    }

    public Association getEmergencyContact() {
        return Association.getAssociationOfType(this.getInternalAssociations(), AssociationType.CODE_EMERGENCY_CONTACT.getCode());
    }

    public Association getPOA() {
        return Association.getAssociationOfType(this.getInternalAssociations(), AssociationType.CODE_POWER_OF_ATTORNEY.getCode());
    }

    public Association getVAGuardian() {
        return Association.getAssociationOfType(this.getInternalAssociations(), AssociationType.CODE_GUARDIAN_VA.getCode());
    }

    public Association removeAssociationByEntityKey(EntityKey identifier) {
        return (Association)Person.removeEntityByEntityKey((Collection)this.getInternalAssociations(), (EntityKey)identifier);
    }

    public void removeAllAssociations() {
        this.getInternalAssociations().clear();
    }

    public Set getInsurances() {
        return Collections.unmodifiableSet(this.getInternalInsurances());
    }

    public Set getMedicareInsurances() {
        HashSet returnSet = new HashSet();
        for (Object insuranceObject : this.internalInsurances) {
            if (!Medicare.class.isAssignableFrom(insuranceObject.getClass())) continue;
            returnSet.add(insuranceObject);
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public Set getPrivateInsurances() {
        HashSet returnSet = new HashSet();
        for (Object insuranceObject : this.internalInsurances) {
            if (!PrivateInsurance.class.isAssignableFrom(insuranceObject.getClass())) continue;
            returnSet.add(insuranceObject);
        }
        return Collections.unmodifiableSet(returnSet);
    }

    public InsurancePolicy getInsuranceByEntityKey(EntityKey identifier) {
        return (InsurancePolicy)Person.getEntityByEntityKey((Collection)this.getInsurances(), (EntityKey)identifier);
    }

    private Set getInternalInsurances() {
        if (this.internalInsurances == null) {
            this.internalInsurances = new HashSet();
        }
        return this.internalInsurances;
    }

    private void setInternalInsurances(Set internalInsurances) {
        this.internalInsurances = internalInsurances;
    }

    public void addInsurance(InsurancePolicy policy) {
        Validate.notNull((Object)policy, (String)"Insurance policy cannot be null");
        this.getInternalInsurances().add(policy);
        policy.setPerson(this);
    }

    public void addAllInsurances(Set policies) {
        Validate.notEmpty((Collection)policies, (String)"Insurance policies cannot be null or empty");
        for (Object policy : policies) {
            if (!(policy instanceof InsurancePolicy)) continue;
            this.addInsurance((InsurancePolicy)policy);
        }
    }

    public void removeInsurance(InsurancePolicy insurance) {
        Validate.notNull((Object)insurance, (String)"Insurance policy cannot be null");
        this.getInternalInsurances().remove(insurance);
    }

    public InsurancePolicy removeInsuranceByEntityKey(EntityKey identifier) {
        return (InsurancePolicy)Person.removeEntityByEntityKey((Collection)this.getInternalInsurances(), (EntityKey)identifier);
    }

    public void removeAllInsurances() {
        this.getInternalInsurances().clear();
    }

    private Set getInternalReceivedPrimaryEligibilities() {
        if (this.internalReceivedPrimaryEligibilities == null) {
            this.internalReceivedPrimaryEligibilities = new HashSet();
        }
        return this.internalReceivedPrimaryEligibilities;
    }

    private void setInternalReceivedPrimaryEligibilities(Set internalReceivedPrimaryEligibilities) {
        this.internalReceivedPrimaryEligibilities = internalReceivedPrimaryEligibilities;
    }

    public ReceivedEligibility getReceivedPrimaryEligibility() {
        Set eligibilities = this.getInternalReceivedPrimaryEligibilities();
        if (eligibilities.size() > 0) {
            return (ReceivedEligibility)((Object)this.internalReceivedPrimaryEligibilities.iterator().next());
        }
        return null;
    }

    public void setReceivedPrimaryEligiblity(ReceivedEligibility primaryEligibility) {
        Set eligibilities = this.getInternalReceivedPrimaryEligibilities();
        eligibilities.clear();
        if (primaryEligibility != null) {
            this.addReceivedPrimaryEligibility(primaryEligibility);
        }
    }

    private void addReceivedPrimaryEligibility(ReceivedEligibility primaryEligibility) {
        Validate.notNull((Object)((Object)primaryEligibility), (String)"Primary eligibility cannot be null");
        this.getInternalReceivedPrimaryEligibilities().add(primaryEligibility);
        primaryEligibility.setPrimary();
        primaryEligibility.setPerson(this);
    }

    private Set getInternalReceivedSecondaryEligibilities() {
        if (this.internalReceivedSecondaryEligibilities == null) {
            this.internalReceivedSecondaryEligibilities = new HashSet();
        }
        return this.internalReceivedSecondaryEligibilities;
    }

    private void setInternalReceivedSecondaryEligibilities(Set internalReceivedSecondaryEligibilities) {
        this.internalReceivedSecondaryEligibilities = internalReceivedSecondaryEligibilities;
    }

    public Set getReceivedSecondaryEligibilities() {
        return Collections.unmodifiableSet(this.getInternalReceivedSecondaryEligibilities());
    }

    public void addReceivedSecondaryEligibility(ReceivedEligibility secondaryEligibility) {
        Validate.notNull((Object)((Object)secondaryEligibility), (String)"secondary eligibility cannot be null");
        secondaryEligibility.setSecondary();
        secondaryEligibility.setPerson(this);
        this.getInternalReceivedSecondaryEligibilities().add(secondaryEligibility);
    }

    public void removeReceivedSecondaryEligibility(ReceivedEligibility secondaryEligibility) {
        Validate.notNull((Object)((Object)secondaryEligibility), (String)"Secondary eligibility cannot be null");
        this.getInternalReceivedSecondaryEligibilities().remove((Object)secondaryEligibility);
    }

    public void removeAllReceivedSecondaryEligibilities() {
        this.getInternalReceivedSecondaryEligibilities().clear();
    }

    private Set getInternalReceivedEnrollments() {
        if (this.internalReceivedEnrollments == null) {
            this.internalReceivedEnrollments = new HashSet();
        }
        return this.internalReceivedEnrollments;
    }

    private void setInternalReceivedEnrollments(Set internalReceivedEnrollments) {
        this.internalReceivedEnrollments = internalReceivedEnrollments;
    }

    public ReceivedEnrollment getReceivedEnrollment() {
        Set enrollments = this.getInternalReceivedEnrollments();
        if (enrollments.size() > 0) {
            return (ReceivedEnrollment)((Object)this.internalReceivedEnrollments.iterator().next());
        }
        return null;
    }

    public void setReceivedEnrollment(ReceivedEnrollment receivedEnrollment) {
        Set enrollments = this.getInternalReceivedEnrollments();
        enrollments.clear();
        if (receivedEnrollment != null) {
            enrollments.add(receivedEnrollment);
            receivedEnrollment.setPerson(this);
        }
    }

    private Set getInternalServiceConnectionAwards() {
        if (this.internalServiceConnectionAwards == null) {
            this.internalServiceConnectionAwards = new HashSet();
        }
        return this.internalServiceConnectionAwards;
    }

    private void setInternalServiceConnectionAwards(Set internalServiceConnectionAwards) {
        this.internalServiceConnectionAwards = internalServiceConnectionAwards;
    }

    public ServiceConnectionAward getServiceConnectionAward() {
        Set scAwards = this.getInternalServiceConnectionAwards();
        if (scAwards.size() > 0) {
            return (ServiceConnectionAward)((Object)this.internalServiceConnectionAwards.iterator().next());
        }
        return null;
    }

    public void setServiceConnectionAward(ServiceConnectionAward serviceConnectionAward) {
        Set scAwards = this.getInternalServiceConnectionAwards();
        scAwards.clear();
        if (serviceConnectionAward != null) {
            this.getInternalServiceConnectionAwards().add(serviceConnectionAward);
            serviceConnectionAward.setPerson(this);
        }
    }

    private Set getInternalPrisonerOfWars() {
        if (this.internalPrisonerOfWars == null) {
            this.internalPrisonerOfWars = new HashSet();
        }
        return this.internalPrisonerOfWars;
    }

    private void setInternalPrisonerOfWars(Set prisonerOfWars) {
        this.internalPrisonerOfWars = prisonerOfWars;
    }

    public PrisonerOfWar getPrisonerOfWar() {
        Set prisonerOfWars = this.getInternalPrisonerOfWars();
        return prisonerOfWars.size() > 0 ? (PrisonerOfWar)((Object)prisonerOfWars.iterator().next()) : null;
    }

    public void setPrisonerOfWar(PrisonerOfWar prisonerOfWar) {
        Set prisonerOfWars = this.getInternalPrisonerOfWars();
        Iterator iter = prisonerOfWars.iterator();
        if (iter.hasNext()) {
            PrisonerOfWar o = (PrisonerOfWar)((Object)iter.next());
            o.setPerson(null);
        }
        prisonerOfWars.clear();
        if (prisonerOfWar != null) {
            prisonerOfWars.add(prisonerOfWar);
            prisonerOfWar.setPerson(this);
        }
    }

    private Set getInternalHealthBenefitProfiles() {
        if (this.internalHealthBenefitProfiles == null) {
            this.internalHealthBenefitProfiles = new HashSet();
        }
        return this.internalHealthBenefitProfiles;
    }

    private void setInternalHealthBenefitProfiles(Set internalHealthBenefitProfiles) {
        this.internalHealthBenefitProfiles = internalHealthBenefitProfiles;
    }

    public HealthBenefitProfile getHealthBenefitProfile() {
        Set hbps = this.getInternalHealthBenefitProfiles();
        if (hbps.size() == 0) {
            HealthBenefitProfile hbp = new HealthBenefitProfile();
            hbp.setPerson(this);
            this.setHealthBenefitProfile(hbp);
        }
        return (HealthBenefitProfile)((Object)hbps.iterator().next());
    }

    public void setHealthBenefitProfile(HealthBenefitProfile healthBenefitProfile) {
        Set hbps = this.getInternalHealthBenefitProfiles();
        Iterator iter = hbps.iterator();
        if (iter.hasNext()) {
            HealthBenefitProfile hbp = (HealthBenefitProfile)((Object)iter.next());
            hbp.setPerson(null);
        }
        hbps.clear();
        if (healthBenefitProfile != null) {
            hbps.add(healthBenefitProfile);
            healthBenefitProfile.setPerson(this);
        }
    }

    private void setInternalSpecialFactors(Set specialFactors) {
        this.internalSpecialFactors = specialFactors;
    }

    private Set getInternalSpecialFactors() {
        if (this.internalSpecialFactors == null) {
            this.internalSpecialFactors = new HashSet();
        }
        return this.internalSpecialFactors;
    }

    public Set getSpecialFactors() {
        return UnmodifiableSet.decorate((Set)this.getInternalSpecialFactors());
    }

    public void addSpecialFactor(SpecialFactor specialFactor) {
        this.getInternalSpecialFactors().add(specialFactor);
        specialFactor.setPerson(this);
    }

    public void removeSpecialFactor(SpecialFactor specialFactor) {
        Validate.notNull((Object)((Object)specialFactor), (String)"Null Special Factor specified.");
        this.getInternalSpecialFactors().remove((Object)specialFactor);
        specialFactor.setPerson(null);
    }

    public SpecialFactor getSpecialFactorByEntityKey(EntityKey identifier) {
        return (SpecialFactor)Person.getEntityByEntityKey((Collection)this.getSpecialFactors(), (EntityKey)identifier);
    }

    public SpecialFactor removeSpecialFactorByEntityKey(EntityKey identifier) {
        return (SpecialFactor)Person.removeEntityByEntityKey((Collection)this.getInternalSpecialFactors(), (EntityKey)identifier);
    }

    public SpecialFactor getSpecialFactorByType(Class specialFactorType) {
        return (SpecialFactor)((Object)CollectionUtils.getObjectOfClassType((Collection)this.getSpecialFactors(), (Class)specialFactorType));
    }

    public SpecialFactor removeSpecialFactorByType(Class specialFactorType) {
        return (SpecialFactor)((Object)CollectionUtils.removeObjectOfClassType((Collection)this.getInternalSpecialFactors(), (Class)specialFactorType));
    }

    public void removeAllSpecialFactors() {
        this.getInternalSpecialFactors().clear();
    }

    private Set getInternalMSTs() {
        if (this.internalMSTs == null) {
            this.internalMSTs = new HashSet();
        }
        return this.internalMSTs;
    }

    private void setInternalMSTs(Set internalMSTs) {
        this.internalMSTs = internalMSTs;
    }

    private Set getInternalCDs() {
        if (this.internalCDs == null) {
            this.internalCDs = new HashSet();
        }
        return this.internalCDs;
    }

    private void setInternalCDs(Set internalCDs) {
        this.internalCDs = internalCDs;
    }

    private Set getInternalNTRs() {
        if (this.internalNTRs == null) {
            this.internalNTRs = new HashSet();
        }
        return this.internalNTRs;
    }

    private void setInternalNTRs(Set internalNTRs) {
        this.internalNTRs = internalNTRs;
    }

    private Set getInternalSCIs() {
        if (this.internalSCIs == null) {
            this.internalSCIs = new HashSet();
        }
        return this.internalSCIs;
    }

    private void setInternalSCIs(Set internalSCIs) {
        this.internalSCIs = internalSCIs;
    }

    public Set getClinicalDeterminations() {
        HashSet allClinicalDeterminations = new HashSet();
        allClinicalDeterminations.addAll(this.getInternalCDs());
        allClinicalDeterminations.addAll(this.getInternalMSTs());
        allClinicalDeterminations.addAll(this.getInternalNTRs());
        allClinicalDeterminations.addAll(this.getInternalSCIs());
        return Collections.unmodifiableSet(allClinicalDeterminations);
    }

    public void addClinicalDetermination(ClinicalDetermination clinicalDetermination) {
        Validate.notNull((Object)((Object)clinicalDetermination), (String)"Null ClinicalDetermination specified.");
        clinicalDetermination.setPerson(this);
        if (clinicalDetermination instanceof CatastrophicDisability) {
            this.getInternalCDs().add(clinicalDetermination);
        } else if (clinicalDetermination instanceof MilitarySexualTrauma) {
            this.getInternalMSTs().add(clinicalDetermination);
        } else if (clinicalDetermination instanceof NoseThroatRadium) {
            this.getInternalNTRs().add(clinicalDetermination);
        } else if (clinicalDetermination instanceof SpinalCordInjury) {
            this.getInternalSCIs().add(clinicalDetermination);
        }
    }

    public void removeClinicalDetermination(ClinicalDetermination clinicalDetermination) {
        Validate.notNull((Object)((Object)clinicalDetermination), (String)"Null clinicalDetermination specified.");
        if (clinicalDetermination instanceof CatastrophicDisability) {
            this.getInternalCDs().remove((Object)clinicalDetermination);
        } else if (clinicalDetermination instanceof MilitarySexualTrauma) {
            this.getInternalMSTs().remove((Object)clinicalDetermination);
        } else if (clinicalDetermination instanceof NoseThroatRadium) {
            this.getInternalNTRs().remove((Object)clinicalDetermination);
        } else if (clinicalDetermination instanceof SpinalCordInjury) {
            this.getInternalSCIs().remove((Object)clinicalDetermination);
        }
        clinicalDetermination.setPerson(null);
    }

    public void removeAllClinicalDeterminations() {
        this.getInternalCDs().clear();
        this.getInternalMSTs().clear();
        this.getInternalNTRs().clear();
        this.getInternalSCIs().clear();
    }

    public ClinicalDetermination getClinicalDeterminationByEntityKey(EntityKey identifier) {
        return (ClinicalDetermination)Person.getEntityByEntityKey((Collection)this.getClinicalDeterminations(), (EntityKey)identifier);
    }

    public ClinicalDetermination removeClinicalDeterminationByEntityKey(EntityKey identifier) {
        ClinicalDetermination match = (ClinicalDetermination)Person.removeEntityByEntityKey((Collection)this.getInternalCDs(), (EntityKey)identifier);
        if (match == null) {
            match = (ClinicalDetermination)Person.removeEntityByEntityKey((Collection)this.getInternalMSTs(), (EntityKey)identifier);
        }
        if (match == null) {
            match = (ClinicalDetermination)Person.removeEntityByEntityKey((Collection)this.getInternalNTRs(), (EntityKey)identifier);
        }
        if (match == null) {
            match = (ClinicalDetermination)Person.removeEntityByEntityKey((Collection)this.getInternalSCIs(), (EntityKey)identifier);
        }
        return match;
    }

    public ClinicalDetermination getClinicalDeterminationByType(Class clinicalDeterminationType) {
        return (ClinicalDetermination)((Object)CollectionUtils.getObjectOfClassType((Collection)this.getClinicalDeterminations(), (Class)clinicalDeterminationType));
    }

    public ClinicalDetermination removeClinicalDeterminationByType(Class clinicalDeterminationType) {
        if (CatastrophicDisability.class.isAssignableFrom(clinicalDeterminationType)) {
            return (ClinicalDetermination)((Object)CollectionUtils.removeObjectOfClassType((Collection)this.getInternalCDs(), (Class)clinicalDeterminationType));
        }
        if (MilitarySexualTrauma.class.isAssignableFrom(clinicalDeterminationType)) {
            return (ClinicalDetermination)((Object)CollectionUtils.removeObjectOfClassType((Collection)this.getInternalMSTs(), (Class)clinicalDeterminationType));
        }
        if (NoseThroatRadium.class.isAssignableFrom(clinicalDeterminationType)) {
            return (ClinicalDetermination)((Object)CollectionUtils.removeObjectOfClassType((Collection)this.getInternalNTRs(), (Class)clinicalDeterminationType));
        }
        if (SpinalCordInjury.class.isAssignableFrom(clinicalDeterminationType)) {
            return (ClinicalDetermination)((Object)CollectionUtils.removeObjectOfClassType((Collection)this.getInternalSCIs(), (Class)clinicalDeterminationType));
        }
        return null;
    }

    public CatastrophicDisability getCatastrophicDisability() {
        return (CatastrophicDisability)this.getClinicalDeterminationByType(CatastrophicDisability.class);
    }

    public MilitarySexualTrauma getMilitarySexualTrauma() {
        return (MilitarySexualTrauma)this.getClinicalDeterminationByType(MilitarySexualTrauma.class);
    }

    public NoseThroatRadium getNoseThroatRadium() {
        return (NoseThroatRadium)this.getClinicalDeterminationByType(NoseThroatRadium.class);
    }

    public SpinalCordInjury getSpinalCordInjury() {
        return (SpinalCordInjury)this.getClinicalDeterminationByType(SpinalCordInjury.class);
    }

    public void setCatastrophicDisability(CatastrophicDisability catastrophicDisability) {
        if (catastrophicDisability == null) {
            this.removeClinicalDeterminationByType(CatastrophicDisability.class);
        } else {
            this.removeAndAddClinicalDetermination(catastrophicDisability);
        }
    }

    public void setMilitarySexualTrauma(MilitarySexualTrauma militarySexualTrauma) {
        if (militarySexualTrauma == null) {
            this.removeClinicalDeterminationByType(MilitarySexualTrauma.class);
        } else {
            this.removeAndAddClinicalDetermination(militarySexualTrauma);
        }
    }

    public void setNoseThroatRadium(NoseThroatRadium noseThroatRadium) {
        if (noseThroatRadium == null) {
            this.removeClinicalDeterminationByType(NoseThroatRadium.class);
        } else {
            this.removeAndAddClinicalDetermination(noseThroatRadium);
        }
    }

    public void setSpinalCordInjury(SpinalCordInjury spinalCordInjury) {
        if (spinalCordInjury == null) {
            this.removeClinicalDeterminationByType(SpinalCordInjury.class);
        } else {
            this.removeAndAddClinicalDetermination(spinalCordInjury);
        }
    }

    private void removeAndAddClinicalDetermination(ClinicalDetermination clinicalDetermination) {
        ClinicalDetermination old = this.getClinicalDeterminationByType(((Object)((Object)clinicalDetermination)).getClass());
        if (old == null) {
            this.addClinicalDetermination(clinicalDetermination);
        } else if (old != clinicalDetermination) {
            this.removeClinicalDetermination(old);
            this.addClinicalDetermination(clinicalDetermination);
        }
    }

    private Map getInternalBeneficiaryTravels() {
        if (this.internalBeneficiaryTravels == null) {
            this.internalBeneficiaryTravels = new HashMap();
        }
        return this.internalBeneficiaryTravels;
    }

    private void setInternalBeneficiaryTravels(Map internalBeneficiaryTravels) {
        this.internalBeneficiaryTravels = internalBeneficiaryTravels;
    }

    public Map getBeneficiaryTravels() {
        return Collections.unmodifiableMap(this.getInternalBeneficiaryTravels());
    }

    public Set getBeneficiaryTravels(Integer incomeYear) {
        Validate.notNull((Object)incomeYear, (String)"Income year can not be null");
        HashSet<BeneficiaryTravel> s = new HashSet<BeneficiaryTravel>();
        for (BeneficiaryTravel t : this.getBeneficiaryTravels().values()) {
            if (!incomeYear.equals(t.getYear())) continue;
            s.add(t);
        }
        return Collections.unmodifiableSet(s);
    }

    public BeneficiaryTravel getBeneficiaryTravel(Integer year, VAFacility facilityVisited) {
        SiteYear siteYear = new SiteYear(year, facilityVisited);
        return (BeneficiaryTravel)((Object)this.getInternalBeneficiaryTravels().get((Object)siteYear));
    }

    public void setBeneficiaryTravel(Integer year, VAFacility facilityVisited, BeneficiaryTravel bTravel) {
        Validate.notNull((Object)year, (String)"Beneficiary Travel year  cannot be null");
        Validate.notNull((Object)((Object)facilityVisited), (String)"facility visited cannot be null");
        BeneficiaryTravel currentBTravel = this.getBeneficiaryTravel(year, facilityVisited);
        if (currentBTravel != bTravel) {
            SiteYear siteYear = new SiteYear(year, facilityVisited);
            if (currentBTravel != null) {
                this.getInternalBeneficiaryTravels().remove((Object)siteYear);
                currentBTravel.setPerson(null);
            }
            if (bTravel != null) {
                bTravel.setFacilityVisited(siteYear.getFacility());
                bTravel.setYear(siteYear.getYear());
                bTravel.setPerson(this);
                this.getInternalBeneficiaryTravels().put(siteYear, bTravel);
            }
        }
    }

    private Map getInternalPatientVisitSummaries() {
        if (this.internalPatientVisitSummaries == null) {
            this.internalPatientVisitSummaries = new HashMap();
        }
        return this.internalPatientVisitSummaries;
    }

    private void setInternalPatientVisitSummaries(Map internalPatientVisitSummaries) {
        this.internalPatientVisitSummaries = internalPatientVisitSummaries;
    }

    public Map getPatientVisitSummaries() {
        return Collections.unmodifiableMap(this.getInternalPatientVisitSummaries());
    }

    public Set getPatientVisitSummaries(Integer incomeYear) {
        return PatientVisitSummary.getPatientVisitSummaries(this.getInternalPatientVisitSummaries().values(), incomeYear);
    }

    public Set getPatientVisitSummaries(VAFacility facilityVisited) {
        return PatientVisitSummary.getPatientVisitSummaries(this.getInternalPatientVisitSummaries().values(), facilityVisited);
    }

    public PatientVisitSummary getPatientVisitSummary(Integer incomeYear, VAFacility facilityVisited) {
        SiteYear siteYear = new SiteYear(incomeYear, facilityVisited);
        return (PatientVisitSummary)((Object)this.getInternalPatientVisitSummaries().get((Object)siteYear));
    }

    public void removePatientVisitSummary(VAFacility facilityVisited) {
        Set set = this.getPatientVisitSummaries(facilityVisited);
        for (PatientVisitSummary visitSummary : set) {
            this.setPatientVisitSummary(visitSummary.getIncomeYear(), visitSummary.getFacilityVisited(), null);
        }
    }

    public void addPatientVisitSummary(PatientVisitSummary visitSummary) {
        this.setPatientVisitSummary(visitSummary.getIncomeYear(), visitSummary.getFacilityVisited(), visitSummary);
    }

    public void setPatientVisitSummary(Integer incomeYear, VAFacility facilityVisited, PatientVisitSummary visitSummary) {
        Validate.notNull((Object)incomeYear, (String)"Income year  cannot be null");
        Validate.notNull((Object)((Object)facilityVisited), (String)"facility visited cannot be null");
        PatientVisitSummary currentVisitSummary = this.getPatientVisitSummary(incomeYear, facilityVisited);
        if (currentVisitSummary != visitSummary) {
            SiteYear siteYear = new SiteYear(incomeYear, facilityVisited);
            if (currentVisitSummary != null) {
                this.getInternalPatientVisitSummaries().remove((Object)siteYear);
                currentVisitSummary.setPerson(null);
            }
            if (visitSummary != null) {
                visitSummary.setFacilityVisited(siteYear.getFacility());
                visitSummary.setIncomeYear(siteYear.getYear());
                visitSummary.setPerson(this);
                this.getInternalPatientVisitSummaries().put(siteYear, visitSummary);
            }
        }
    }

    private Set getInternalFeeBasis() {
        if (this.internalFeeBasis == null) {
            this.internalFeeBasis = new HashSet();
        }
        return this.internalFeeBasis;
    }

    private void setInternalFeeBasis(Set internalFeeBasis) {
        this.internalFeeBasis = internalFeeBasis;
    }

    public Set getFeeBasis() {
        return Collections.unmodifiableSet(this.getInternalFeeBasis());
    }

    public Set getFeeBasis(VAFacility reportedSite) {
        Validate.notNull((Object)((Object)reportedSite), (String)"reported Site cannot be null");
        HashSet<FeeBasis> siteFeeBasis = new HashSet<FeeBasis>();
        for (FeeBasis feeBasis : this.getInternalFeeBasis()) {
            if (!reportedSite.equals((Object)feeBasis.getReportSite())) continue;
            siteFeeBasis.add(feeBasis);
        }
        return siteFeeBasis;
    }

    public void addFeeBasis(FeeBasis feeBasis) {
        if (feeBasis != null) {
            this.getInternalFeeBasis().add(feeBasis);
            feeBasis.setPerson(this);
        }
    }

    public void removeFeeBasis(FeeBasis feeBasis) {
        this.getInternalFeeBasis().remove((Object)feeBasis);
    }

    public void removeFeeBasis(VAFacility facilityVisited) {
        Set set = this.getFeeBasis(facilityVisited);
        for (FeeBasis feeBasis : set) {
            this.removeFeeBasis(feeBasis);
        }
    }

    public void removeAllFeeBasis() {
        this.getInternalFeeBasis().clear();
    }

    private Set getInternalIneligibilityFactors() {
        if (this.internalIneligibilityFactors == null) {
            this.internalIneligibilityFactors = new HashSet();
        }
        return this.internalIneligibilityFactors;
    }

    private void setInternalIneligibilityFactors(Set internalIneligibilityFactors) {
        this.internalIneligibilityFactors = internalIneligibilityFactors;
    }

    public IneligibilityFactor getIneligibilityFactor() {
        Set ineligibilityFactors = this.getInternalIneligibilityFactors();
        return ineligibilityFactors.size() > 0 ? (IneligibilityFactor)((Object)ineligibilityFactors.iterator().next()) : null;
    }

    public void setIneligibilityFactor(IneligibilityFactor ineligibilityFactor) {
        Set ineligibilityFactors = this.getInternalIneligibilityFactors();
        Iterator iter = ineligibilityFactors.iterator();
        if (iter.hasNext()) {
            IneligibilityFactor o = (IneligibilityFactor)((Object)iter.next());
            o.setPerson(null);
        }
        ineligibilityFactors.clear();
        if (ineligibilityFactor != null) {
            ineligibilityFactors.add(ineligibilityFactor);
            ineligibilityFactor.setPerson(this);
        }
    }

    private Set getInternalIncompetenceRulings() {
        if (this.internalIncompetenceRulings == null) {
            this.internalIncompetenceRulings = new HashSet();
        }
        return this.internalIncompetenceRulings;
    }

    private void setInternalIncompetenceRulings(Set internalIncompetenceRulings) {
        this.internalIncompetenceRulings = internalIncompetenceRulings;
    }

    public IncompetenceRuling getIncompetenceRuling() {
        Set rulings = this.getInternalIncompetenceRulings();
        if (rulings.size() > 0) {
            return (IncompetenceRuling)((Object)rulings.iterator().next());
        }
        return null;
    }

    public void setIncompetenceRuling(IncompetenceRuling incompetenceRuling) {
        Set rulings = this.getInternalIncompetenceRulings();
        rulings.clear();
        if (incompetenceRuling != null) {
            rulings.add(incompetenceRuling);
            incompetenceRuling.setPerson(this);
        }
    }

    private Map getInternalFinancialStatements() {
        if (this.internalFinancialStatements == null) {
            this.internalFinancialStatements = new HashMap();
        }
        return this.internalFinancialStatements;
    }

    private void setInternalFinancialStatements(Map internalFinancialStatements) {
        this.internalFinancialStatements = internalFinancialStatements;
    }

    public Map getFinancialStatements() {
        return Collections.unmodifiableMap(this.getInternalFinancialStatements());
    }

    public FinancialStatement getFinancialStatement(Integer incomeYear) {
        return (FinancialStatement)((Object)this.getInternalFinancialStatements().get(incomeYear));
    }

    public void setFinancialStatement(Integer incomeYear, FinancialStatement financialStatement) {
        this.setFinancialStatement(incomeYear, financialStatement, false);
    }

    public Integer getLatestIncomeYear() {
        Map stmts = this.getFinancialStatements();
        Iterator itr = stmts != null ? stmts.keySet().iterator() : null;
        Integer incomeYear = null;
        Integer latestIncomeYear = null;
        while (itr != null && itr.hasNext()) {
            incomeYear = (Integer)itr.next();
            if (latestIncomeYear == null) {
                latestIncomeYear = incomeYear;
                continue;
            }
            if (incomeYear <= latestIncomeYear) continue;
            latestIncomeYear = incomeYear;
        }
        return latestIncomeYear;
    }

    public void setFinancialStatement(Integer incomeYear, FinancialStatement financialStatement, boolean keepNullValue) {
        Validate.notNull((Object)incomeYear, (String)"Income year cannot be null");
        FinancialStatement current = this.getFinancialStatement(incomeYear);
        if (current == null && financialStatement == null || current != financialStatement) {
            if (current != null) {
                this.getInternalFinancialStatements().remove(incomeYear);
                current.setPerson(null);
            }
            if (financialStatement != null) {
                this.getInternalFinancialStatements().put(incomeYear, financialStatement);
                financialStatement.setPerson(this);
                financialStatement.setIncomeYear(incomeYear);
            } else if (keepNullValue) {
                this.getInternalFinancialStatements().put(incomeYear, null);
            }
        }
    }

    public void removeAllFinancialStatements() {
        this.getInternalFinancialStatements().clear();
    }

    private Map getInternalInProcessFinancials() {
        if (this.internalInProcessFinancials == null) {
            this.internalInProcessFinancials = new HashMap();
        }
        return this.internalInProcessFinancials;
    }

    private Map setInternalInProcessFinancials(Map inProcessFinancials) {
        this.internalInProcessFinancials = inProcessFinancials;
        return this.internalInProcessFinancials;
    }

    public InProcessFinancialInfo getInProcessFinancial(Integer incomeYear) {
        return (InProcessFinancialInfo)((Object)this.getInternalInProcessFinancials().get(incomeYear));
    }

    public void setInProcessFinancial(Integer incomeYear, InProcessFinancialInfo inProcessFinancial) {
        Validate.notNull((Object)incomeYear, (String)"Income year cannot be null");
        InProcessFinancialInfo current = this.getInProcessFinancial(incomeYear);
        if (current != inProcessFinancial) {
            if (current != null) {
                this.getInternalInProcessFinancials().remove(incomeYear);
                current.setPerson(null);
            }
            if (inProcessFinancial != null) {
                this.getInternalInProcessFinancials().put(incomeYear, inProcessFinancial);
                inProcessFinancial.setPerson(this);
                inProcessFinancial.setIncomeYear(incomeYear);
            }
        }
    }

    public void removeAllInProcessFinancials() {
        this.getInternalInProcessFinancials().clear();
    }

    private Map getInternalIncomeTests() {
        if (this.internalIncomeTests == null) {
            this.internalIncomeTests = new HashMap();
        }
        return this.internalIncomeTests;
    }

    private Map setInternalIncomeTests(Map incomeTests) {
        this.internalIncomeTests = incomeTests;
        return this.internalIncomeTests;
    }

    public Map getIncomeTests() {
        return Collections.unmodifiableMap(this.getInternalIncomeTests());
    }

    public IncomeTest getIncomeTest(Integer incomeYear) {
        return (IncomeTest)((Object)this.getInternalIncomeTests().get(incomeYear));
    }

    public void setIncomeTest(Integer incomeYear, IncomeTest incomeTest) {
        this.setIncomeTest(incomeYear, incomeTest, false);
    }

    public void setIncomeTest(Integer incomeYear, IncomeTest incomeTest, boolean keepNullValue) {
        Validate.notNull((Object)incomeYear, (String)"Income year cannot be null");
        IncomeTest current = this.getIncomeTest(incomeYear);
        if (current != incomeTest) {
            if (current != null) {
                this.getInternalIncomeTests().remove(incomeYear);
                current.setPerson(null);
            }
            if (incomeTest != null) {
                this.getInternalIncomeTests().put(incomeYear, incomeTest);
                incomeTest.setPerson(this);
                Validate.isTrue((boolean)incomeYear.equals(incomeTest.getIncomeYear()), (String)"incomeYear should match incomeTest.incomeYear");
            } else if (keepNullValue) {
                this.getInternalIncomeTests().put(incomeYear, null);
            }
        }
    }

    public void removeAllIncomeTests() {
        this.getInternalIncomeTests().clear();
    }

    public Set getDecorations() {
        return Collections.unmodifiableSet(this.getInternalDecorations());
    }

    public Decoration getDecorationByEntityKey(EntityKey identifier) {
        return (Decoration)Person.getEntityByEntityKey((Collection)this.getDecorations(), (EntityKey)identifier);
    }

    public Decoration removeDecorationByEntityKey(EntityKey identifier) {
        return (Decoration)Person.removeEntityByEntityKey((Collection)this.getInternalDecorations(), (EntityKey)identifier);
    }

    public Decoration getDecorationByType(Class type) {
        Set decorations = this.getInternalDecorations();
        Object decoration = type != null ? CollectionUtils.getObjectOfClassType((Collection)decorations, (Class)type) : null;
        return decoration instanceof Decoration ? (Decoration)decoration : null;
    }

    public PurpleHeart getPurpleHeart() {
        Decoration decoration = this.getDecorationByType(PurpleHeart.class);
        return decoration instanceof PurpleHeart ? (PurpleHeart)decoration : null;
    }

    public void setPurpleHeart(PurpleHeart purpleHeart) {
        this.getInternalDecorations().clear();
        if (purpleHeart != null) {
            this.getInternalDecorations().add(purpleHeart);
            purpleHeart.setPerson(this);
        }
    }

    private Set getInternalDecorations() {
        if (this.internalDecorations == null) {
            this.internalDecorations = new HashSet();
        }
        return this.internalDecorations;
    }

    public void addDecoration(Decoration decoration) {
        Validate.notNull((Object)decoration, (String)"Null Decoration record specified.");
        this.getInternalDecorations().add(decoration);
        decoration.setPerson(this);
    }

    public void removeDecoration(Decoration decoration) {
        Validate.notNull((Object)decoration, (String)"Null Decoration record specified.");
        this.getInternalDecorations().remove(decoration);
        decoration.setPerson(null);
    }

    private void setInternalDecorations(Set decorations) {
        this.internalDecorations = decorations;
    }

    public void removeAllDecorations() {
        this.getInternalDecorations().clear();
    }

    public MedalOfHonor getMedalOfHonor() {
        Set honors = this.getInternalMedalOfHonors();
        if (honors.size() > 0) {
            return (MedalOfHonor)honors.iterator().next();
        }
        return null;
    }

    public void setMedalOfHonor(MedalOfHonor medalOfHonor) {
        this.getInternalMedalOfHonors().clear();
        if (medalOfHonor != null) {
            this.getInternalMedalOfHonors().add(medalOfHonor);
            medalOfHonor.setPerson(this);
        }
    }

    public void removeAllMedalOfHonors() {
        this.getInternalMedalOfHonors().clear();
    }

    private Set getInternalMedalOfHonors() {
        if (this.internalMedalOfHonors == null) {
            this.internalMedalOfHonors = new HashSet();
        }
        return this.internalMedalOfHonors;
    }

    private void setInternalMedalOfHonors(Set internalMedalOfHonors) {
        this.internalMedalOfHonors = internalMedalOfHonors;
    }

    public SHAD getShad() {
        Set shads = this.getInternalShads();
        return shads.size() > 0 ? (SHAD)((Object)shads.iterator().next()) : null;
    }

    public void setShad(SHAD shad) {
        Set shads = this.getInternalShads();
        Iterator iter = shads.iterator();
        if (iter.hasNext()) {
            SHAD o = (SHAD)((Object)iter.next());
            o.setPerson(null);
        }
        shads.clear();
        if (shad != null) {
            shads.add(shad);
            shad.setPerson(this);
        }
    }

    private Set getInternalShads() {
        if (this.internalShads == null) {
            this.internalShads = new HashSet();
        }
        return this.internalShads;
    }

    private void setInternalShads(Set shads) {
        this.internalShads = shads;
    }

    private Set getInternalMonetaryBenefitAwards() {
        if (this.internalMonetaryBenefitAwards == null) {
            this.internalMonetaryBenefitAwards = new HashSet();
        }
        return this.internalMonetaryBenefitAwards;
    }

    private void setInternalMonetaryBenefitAwards(Set internalMonetaryBenefitAwards) {
        this.internalMonetaryBenefitAwards = internalMonetaryBenefitAwards;
    }

    public MonetaryBenefitAward getMonetaryBenefitAward() {
        Set awards = this.getInternalMonetaryBenefitAwards();
        if (awards.size() > 0) {
            return (MonetaryBenefitAward)((Object)awards.iterator().next());
        }
        return null;
    }

    public void setMonetaryBenefitAward(MonetaryBenefitAward monetaryBenefitAward) {
        Set awards = this.getInternalMonetaryBenefitAwards();
        awards.clear();
        if (monetaryBenefitAward != null) {
            awards.add(monetaryBenefitAward);
            monetaryBenefitAward.setPerson(this);
        }
    }

    public MilitaryService getMilitaryService() {
        if (this.militaryService == null) {
            this.militaryService = new MilitaryService();
            this.militaryService.setPerson(this);
        }
        return this.militaryService;
    }

    public Set getMilitaryServiceNumbers() {
        Set siteRecords;
        HashSet<String> nums = new HashSet<String>();
        MilitaryServiceEpisode ep2 = null;
        if (this.getMilitaryService() != null && (siteRecords = this.getMilitaryService().getMilitaryServiceSiteRecords()) != null) {
            Iterator itr = siteRecords.iterator();
            MilitaryServiceSiteRecord siteRec = null;
            while (itr.hasNext()) {
                siteRec = (MilitaryServiceSiteRecord)((Object)itr.next());
                Set eps = siteRec.getMilitaryServiceEpisodes();
                if (eps == null) continue;
                for (MilitaryServiceEpisode ep2 : eps) {
                    if (ep2.getServiceNumber() == null) continue;
                    nums.add(ep2.getServiceNumber());
                }
            }
        }
        return nums;
    }

    public void setMilitaryService(MilitaryService militaryService) {
        if (this.militaryService != militaryService) {
            if (this.militaryService != null) {
                this.militaryService.setPerson(null);
            }
            if (militaryService != null) {
                militaryService.setPerson(this);
            }
            this.militaryService = militaryService;
        }
    }

    public VAFacility getMostRecentPreferredFacility() {
        return this.mostRecentPreferredFacility;
    }

    public void setMostRecentPreferredFacility(VAFacility mostRecentPreferredFacility) {
        this.mostRecentPreferredFacility = mostRecentPreferredFacility;
    }

    public BirthRecord getBirthRecord() {
        return this.birthRecord;
    }

    public void setBirthRecord(BirthRecord birthRecord) {
        this.birthRecord = birthRecord;
    }

    public DeathRecord getDeathRecord() {
        return this.deathRecord;
    }

    public void setDeathRecord(DeathRecord deathRecord) {
        this.deathRecord = deathRecord;
    }

    public boolean isDeceased() {
        return this.deathRecord != null && this.deathRecord.getDeathDate() != null;
    }

    private Set getInternalCancelDeclines() {
        if (this.internalCancelDeclines == null) {
            this.internalCancelDeclines = new HashSet();
        }
        return this.internalCancelDeclines;
    }

    private void setInternalCancelDeclines(Set internalCancelDeclines) {
        this.internalCancelDeclines = internalCancelDeclines;
    }

    public CancelDecline getCancelDecline() {
        Set declines = this.getInternalCancelDeclines();
        if (declines.size() > 0) {
            return (CancelDecline)((Object)declines.iterator().next());
        }
        return null;
    }

    public void setCancelDecline(CancelDecline cancelDecline) {
        Set declines = this.getInternalCancelDeclines();
        declines.clear();
        if (cancelDecline != null) {
            declines.add(cancelDecline);
            cancelDecline.setPerson(this);
        }
    }

    private Set getInternalApplications() {
        if (this.internalApplications == null) {
            this.internalApplications = new HashSet();
        }
        return this.internalApplications;
    }

    private void setInternalApplications(Set internalApplications) {
        this.internalApplications = internalApplications;
    }

    public Application getApplication() {
        Set applications = this.getInternalApplications();
        return applications.size() > 0 ? (Application)((Object)applications.iterator().next()) : null;
    }

    public void setApplication(Application application) {
        Set applications = this.getInternalApplications();
        Iterator iter = applications.iterator();
        if (iter.hasNext()) {
            Application o = (Application)((Object)iter.next());
            applications.remove((Object)o);
            o.setPerson(null);
        }
        if (application != null) {
            applications.add(application);
            application.setPerson(this);
        }
    }

    private Set getInternalMedicaidFactors() {
        if (this.internalMedicaidFactors == null) {
            this.internalMedicaidFactors = new HashSet();
        }
        return this.internalMedicaidFactors;
    }

    private void setInternalMedicaidFactors(Set internalMedicaidFactors) {
        this.internalMedicaidFactors = internalMedicaidFactors;
    }

    public MedicaidFactor getMedicaidFactor() {
        Set factors = this.getInternalMedicaidFactors();
        if (factors.size() > 0) {
            return (MedicaidFactor)((Object)factors.iterator().next());
        }
        return null;
    }

    public void setMedicaidFactor(MedicaidFactor medicaidFactor) {
        Set factors = this.getInternalMedicaidFactors();
        factors.clear();
        if (medicaidFactor != null) {
            factors.add(medicaidFactor);
            medicaidFactor.setPerson(this);
        }
    }

    private Set getInternalPreferredLanguages() {
        if (this.internalPreferredLanguages == null) {
            this.internalPreferredLanguages = new HashSet();
        }
        return this.internalPreferredLanguages;
    }

    private void setInternalPreferredLanguages(Set internalPreferredLanguages) {
        this.internalPreferredLanguages = internalPreferredLanguages;
    }

    public PreferredLanguage getPreferredLanguage() {
        Set languages = this.getInternalPreferredLanguages();
        if (languages.size() > 0) {
            return (PreferredLanguage)((Object)languages.iterator().next());
        }
        return null;
    }

    public void setPreferredLanguage(PreferredLanguage preferredLanguage) {
        Set languages = this.getInternalPreferredLanguages();
        languages.clear();
        if (preferredLanguage != null) {
            languages.add(preferredLanguage);
            preferredLanguage.setPerson(this);
        }
    }

    private Set getInternalEligibilityVerifications() {
        if (this.internalEligibilityVerifications == null) {
            this.internalEligibilityVerifications = new HashSet();
        }
        return this.internalEligibilityVerifications;
    }

    private void setInternalEligibilityVerifications(Set internalEligibilityVerifications) {
        this.internalEligibilityVerifications = internalEligibilityVerifications;
    }

    public EligibilityVerification getEligibilityVerification() {
        Set verifications = this.getInternalEligibilityVerifications();
        if (verifications.size() > 0) {
            return (EligibilityVerification)((Object)this.internalEligibilityVerifications.iterator().next());
        }
        return null;
    }

    public void setEligibilityVerification(EligibilityVerification eligibilityVerification) {
        Set verifications = this.getInternalEligibilityVerifications();
        verifications.clear();
        if (eligibilityVerification != null) {
            this.getInternalEligibilityVerifications().add(eligibilityVerification);
            eligibilityVerification.setPerson(this);
        }
    }

    private Set getInternalEnrollmentDeterminations() {
        if (this.internalEnrollmentDeterminations == null) {
            this.internalEnrollmentDeterminations = new HashSet();
        }
        return this.internalEnrollmentDeterminations;
    }

    private void setInternalEnrollmentDeterminations(Set internalEnrollmentDeterminations) {
        this.internalEnrollmentDeterminations = internalEnrollmentDeterminations;
    }

    public Set getEnrollmentDeterminations() {
        return this.internalEnrollmentDeterminations;
    }

    public EnrollmentDetermination getEnrollmentDetermination() {
        Set determinations = this.getInternalEnrollmentDeterminations();
        if (determinations.size() == 1) {
            return (EnrollmentDetermination)((Object)determinations.iterator().next());
        }
        if (determinations.size() > 1) {
            EnrollmentDetermination enrollment = null;
            for (EnrollmentDetermination e : determinations) {
                if (enrollment == null) {
                    enrollment = e;
                    continue;
                }
                if (e == null || e.getEntityKey() == null || enrollment.getEntityKey() == null || e.getEntityKey().getKeyValue() == null || enrollment.getEntityKey().getKeyValue() == null || ((BigDecimal)e.getEntityKey().getKeyValue()).compareTo((BigDecimal)enrollment.getEntityKey().getKeyValue()) <= 0) continue;
                enrollment = e;
            }
            return enrollment;
        }
        return null;
    }

    public void setEnrollmentDetermination(EnrollmentDetermination enrollmentDetermination) {
        Set determinations = this.getInternalEnrollmentDeterminations();
        determinations.clear();
        if (enrollmentDetermination != null) {
            determinations.add(enrollmentDetermination);
            enrollmentDetermination.setPerson(this);
            this.setMigratedEE();
        }
    }

    public void setMigratedEE() {
        if (Boolean.FALSE.equals(this.getMigratedEE())) {
            this.setMigratedEE(Boolean.TRUE);
        }
    }

    public Integer getUserEnrolleeValidThrough() {
        return this.userEnrolleeValidThrough;
    }

    public void setUserEnrolleeValidThrough(Integer userEnrolleeValidThrough) {
        this.userEnrolleeValidThrough = userEnrolleeValidThrough;
    }

    public VAFacility getUserEnrolleeSite() {
        return this.userEnrolleeSite;
    }

    public void setUserEnrolleeSite(VAFacility userEnrolleeSite) {
        this.userEnrolleeSite = userEnrolleeSite;
    }

    public Boolean getSensitiveRecord() {
        return this.sensitiveRecord;
    }

    public Boolean isSensitiveRecord() {
        return this.sensitiveRecord;
    }

    public void setSensitiveRecord(Boolean sensitiveRecord) {
        this.sensitiveRecord = sensitiveRecord;
    }

    public boolean isPersonLocked() {
        return this.getPersonLockedReason() != null;
    }

    public PersonLockedReason getPersonLockedReason() {
        return this.personLockedReason;
    }

    public void setPersonLockedReason(PersonLockedReason personLockedReason) {
        this.personLockedReason = personLockedReason;
    }

    public Date getSensitivityChangeDate() {
        return this.sensitivityChangeDate;
    }

    public void setSensitivityChangeDate(Date sensitivityChangeDate) {
        this.sensitivityChangeDate = sensitivityChangeDate;
    }

    public SensitivityChangeSource getSensitivityChangeSource() {
        return this.sensitivityChangeSource;
    }

    public void setSensitivityChangeSource(SensitivityChangeSource sensitivityChangeSource) {
        this.sensitivityChangeSource = sensitivityChangeSource;
    }

    public VAFacility getSensitivityChangeSite() {
        return this.sensitivityChangeSite;
    }

    public void setSensitivityChangeSite(VAFacility sensitivityChangeSite) {
        this.sensitivityChangeSite = sensitivityChangeSite;
    }

    public Boolean isVeteran() {
        return this.getVeteran();
    }

    public Boolean getVeteran() {
        return this.veteran;
    }

    public void setVeteran(Boolean veteran) {
        this.veteran = veteran;
    }

    public String getClaimFolderNumber() {
        return this.claimFolderNumber;
    }

    public void setClaimFolderNumber(String claimFolderNumber) {
        this.claimFolderNumber = claimFolderNumber;
    }

    public VAFacility getClaimFolderLocation() {
        return this.claimFolderLocation;
    }

    public void setClaimFolderLocation(VAFacility claimFolderLocation) {
        this.claimFolderLocation = claimFolderLocation;
    }

    private Set getInternalEnrollmentOverrides() {
        if (this.internalEnrollmentOverrides == null) {
            this.internalEnrollmentOverrides = new HashSet();
        }
        return this.internalEnrollmentOverrides;
    }

    private void setInternalEnrollmentOverrides(Set internalEnrollmentOverrides) {
        this.internalEnrollmentOverrides = internalEnrollmentOverrides;
    }

    public EnrollmentOverride getEnrollmentOverride() {
        Set overrides = this.getInternalEnrollmentOverrides();
        return overrides.size() > 0 ? (EnrollmentOverride)((Object)overrides.iterator().next()) : null;
    }

    public void setEnrollmentOverride(EnrollmentOverride enrollmentOverride) {
        Set overrides = this.getInternalEnrollmentOverrides();
        Iterator iter = overrides.iterator();
        if (iter.hasNext()) {
            EnrollmentOverride o = (EnrollmentOverride)((Object)iter.next());
            overrides.remove((Object)o);
            o.setPerson(null);
        }
        if (enrollmentOverride != null) {
            overrides.add(enrollmentOverride);
            enrollmentOverride.setPerson(this);
        }
    }

    public Set getSignatureImages() {
        return Collections.unmodifiableSet(this.getInternalSignatureImages());
    }

    public SignatureImage getSignatureImage(Integer year) {
        Validate.notNull((Object)year, (String)"Income year can not be null.");
        for (SignatureImage sigImg : this.getInternalSignatureImages()) {
            if (!year.equals(sigImg.getIncomeYear())) continue;
            return sigImg;
        }
        return null;
    }

    public SignatureImage getSignatureImageByEntityKey(EntityKey identifier) {
        return (SignatureImage)Person.getEntityByEntityKey((Collection)this.getSignatureImages(), (EntityKey)identifier);
    }

    public SignatureImage removeSignatureImageByEntityKey(EntityKey identifier) {
        return (SignatureImage)Person.removeEntityByEntityKey((Collection)this.getInternalSignatureImages(), (EntityKey)identifier);
    }

    private Set getInternalSignatureImages() {
        if (this.internalSignatureImages == null) {
            this.internalSignatureImages = new HashSet();
        }
        return this.internalSignatureImages;
    }

    private void setInternalSignatureImages(Set signatureImages) {
        this.internalSignatureImages = signatureImages;
    }

    public void addSignatureImage(SignatureImage signatureImage) {
        Validate.notNull((Object)signatureImage, (String)"Null signature image specified.");
        signatureImage.setPerson(this);
        this.getInternalSignatureImages().add(signatureImage);
    }

    public void addAllSignatureImages(Set signatureImages) {
        Validate.notNull((Object)signatureImages, (String)"Null set of signature images specified.");
        this.setOwner(signatureImages);
        Set internal = this.getInternalSignatureImages();
        internal.addAll(signatureImages);
    }

    public void removeSignatureImage(SignatureImage signatureImage) {
        Validate.notNull((Object)signatureImage, (String)"Null signatureImage specified.");
        this.getInternalSignatureImages().remove(signatureImage);
    }

    public void removeAllSignatureImages() {
        this.getInternalSignatureImages().clear();
    }

    public VPIDEntityKey getVPIDEntityKey() {
        return this.vpidValue != null ? CommonEntityKeyFactory.createVPIDEntityKey(this.vpidValue) : null;
    }

    private Set createDecoratedSet(Set internalSet, Class type, Transformer transformer, Transformer removeTransformer) {
        Predicate predicate = AndPredicate.getInstance((Predicate)NotNullPredicate.getInstance(), (Predicate)InstanceofPredicate.getInstance((Class)type));
        Transformer predicatedTransformer = PredicatedTransformer.getInstance(transformer, predicate);
        Set decorate = TransformedSet.decorate((Set)internalSet, (Transformer)predicatedTransformer);
        return RemoveTransformedSet.decorate(decorate, removeTransformer);
    }

    public boolean hasPendingUpdatesToIdentityTraits() {
        return this.pendingUpdatesForIdentityTraits != null;
    }

    public String getVPIDValue() {
        return this.vpidValue;
    }

    public void setVPIDValue(String vpidValue) {
        this.vpidValue = vpidValue;
    }

    private PersonVPID getVPID() {
        return this.vpid;
    }

    public void setVPID(PersonVPID vpid) {
        this.vpid = vpid;
    }

    private void setOwner(AbstractKeyedEntity entity) {
        block2: {
            Validate.notNull((Object)entity, (String)"Null entity specified");
            try {
                Reflector.invoke((Object)entity, (String)"setPerson", (Object[])new Object[]{this});
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug((Object)("Failed to set person as an owner for entity " + entity), (Throwable)e);
            }
        }
    }

    private void setOwner(Collection entities) {
        Validate.notNull((Object)entities, (String)"Null entity specified");
        for (Object entity : entities) {
            this.setOwner((AbstractKeyedEntity)entity);
        }
    }

    protected void buildToString(ToStringBuilder builder) {
        builder.append("appointmentRequestDate", (Object)this.appointmentRequestDate);
        builder.append("appointmentRequestResponse", (Object)this.appointmentRequestResponse);
        builder.append("gender", (Object)this.gender);
        builder.append("selfIdentifiedGender", (Object)this.selfIdentifiedGenderIdentity);
        builder.append("degree", (Object)this.degree);
        builder.append("maritalStatus", (Object)this.maritalStatus);
        builder.append("vpidValue", (Object)this.vpidValue);
        builder.append("names", (Object)this.internalNames);
        builder.append("internalAssociations", (Object)this.internalAssociations);
        builder.append("internalInsurances", (Object)this.internalInsurances);
        builder.append("internalPreferredLanguages", (Object)this.internalPreferredLanguages);
        builder.append("birthRecord", (Object)this.birthRecord);
        builder.append("deathRecord", (Object)this.deathRecord);
        builder.append("medicaidFactor", (Object)this.internalMedicaidFactors);
        builder.append("patientSensitivity", (Object)this.sensitiveRecord);
        builder.append("patientSensitivityChangeDate", (Object)this.sensitivityChangeDate);
        builder.append("patientSensitivityChangeSource", (Object)this.sensitivityChangeSource);
        builder.append("patientSensitivityChangeSite", (Object)this.sensitivityChangeSite);
        builder.append("userEnrolleeValidThrough", (Object)this.userEnrolleeValidThrough);
        builder.append("internalEligibilityVerifications", (Object)this.internalEligibilityVerifications);
        builder.append("veteran", (Object)this.veteran);
        builder.append("specialFactors", (Object)this.internalSpecialFactors);
        builder.append("militaryService", (Object)this.militaryService);
        builder.append("religion", (Object)this.religion);
        builder.append("VOAIndicator", (Object)this.VOAIndicator);
        builder.append("idmMatchType", this.idmMatchType);
        super.buildToString(builder);
    }

    public PersonIdentityTraits getPendingUpdatesForIdentityTraits() {
        return this.pendingUpdatesForIdentityTraits;
    }

    public void setPendingUpdatesForIdentityTraits(PersonIdentityTraits pendingUpdatesForIdentityTraits) {
        this.pendingUpdatesForIdentityTraits = pendingUpdatesForIdentityTraits;
    }

    public PersonIdentityTraits getIdentityTraits() {
        PersonIdentityTraits traits = new PersonIdentityTraits();
        traits.setGender(this.getGender());
        traits.setNames(this.getNames());
        traits.setMothersMaidenName(this.mothersMaidenName);
        SSN ssnOfficial = this.getOfficialSsn();
        if (ssnOfficial != null) {
            traits.setSsn(ssnOfficial);
        } else {
            Set ssnOther = this.getOtherSsns();
            if (ssnOther != null && !ssnOther.isEmpty()) {
                traits.setSsn((SSN)((Object)ssnOther.iterator().next()));
            }
        }
        traits.setBirthRecord(this.getBirthRecord());
        traits.setVpid(this.getVPIDEntityKey());
        PersonLockedReason plr = this.getPersonLockedReason();
        if (plr != null) {
            if (PersonLockedReason.PENDING_IDENTITY_TRAIT_UPDATES.equals(plr.getReason())) {
                traits.setHasPendingUpdates(true);
            } else if (PersonLockedReason.PERSON_DEPRECATED.equals(plr.getReason())) {
                traits.setDeprecated(true);
            }
        }
        return traits;
    }

    public void setIdentityTraits(PersonIdentityTraits traits) {
        Iterator itr;
        if (traits == null) {
            return;
        }
        this.removeAllNames();
        Iterator iterator = itr = traits.getNames() != null ? traits.getNames().iterator() : null;
        while (itr != null && itr.hasNext()) {
            this.addName((Name)itr.next());
        }
        this.mothersMaidenName = traits.getMothersMaidenName();
        this.setBirthRecord(traits.getBirthRecord());
        this.removeAllSsns();
        SSN psimSSN = traits.getSsn();
        if (psimSSN != null) {
            this.addSsn(psimSSN);
        }
        this.setGender(traits.getGender());
        this.identityTraitsAuditInfo = traits.getAuditInfo();
        this.setSiteIdentities(traits.getSiteIdentities());
    }

    public Set getFacilities() {
        HashSet<VAFacility> facilities = new HashSet<VAFacility>();
        Set keySet = this.getPatientVisitSummaries().keySet();
        Iterator<Object> i = keySet.iterator();
        while (i.hasNext()) {
            facilities.add(((SiteYear)((Object)i.next())).getFacility());
        }
        for (FeeBasis feeBasis : this.getInternalFeeBasis()) {
            facilities.add(feeBasis.getReportSite());
        }
        return facilities;
    }

    public AgentOrangeExposure getAgentOrangeExposure() {
        return (AgentOrangeExposure)this.getSpecialFactorByType(AgentOrangeExposure.class);
    }

    public RadiationExposure getRadiationExposure() {
        return (RadiationExposure)this.getSpecialFactorByType(RadiationExposure.class);
    }

    public EnvironmentalContaminationExposure getEnvironmentalContaminationExposure() {
        return (EnvironmentalContaminationExposure)this.getSpecialFactorByType(EnvironmentalContaminationExposure.class);
    }

    public CampLejeuneVerification getCampLejeuneVerification() {
        return (CampLejeuneVerification)this.getSpecialFactorByType(CampLejeuneVerification.class);
    }

    public void setCampLejeuneVerification(CampLejeuneVerification campLejeuneVerification) {
        if (campLejeuneVerification == null) {
            this.removeSpecialFactorByType(CampLejeuneVerification.class);
        } else {
            this.removeAndAddSpecialFactor(campLejeuneVerification);
        }
    }

    public void setAgentOrangeExposure(AgentOrangeExposure agentOrangeExposure) {
        if (agentOrangeExposure == null) {
            this.removeSpecialFactorByType(AgentOrangeExposure.class);
        } else {
            this.removeAndAddSpecialFactor(agentOrangeExposure);
        }
    }

    public void setRadiationExposure(RadiationExposure radiationExposure) {
        if (radiationExposure == null) {
            this.removeSpecialFactorByType(RadiationExposure.class);
        } else {
            this.removeAndAddSpecialFactor(radiationExposure);
        }
    }

    public void setEnvironmentalContaminationExposure(EnvironmentalContaminationExposure environmentalContaminationExposure) {
        if (environmentalContaminationExposure == null) {
            this.removeSpecialFactorByType(EnvironmentalContaminationExposure.class);
        } else {
            this.removeAndAddSpecialFactor(environmentalContaminationExposure);
        }
    }

    private void removeAndAddSpecialFactor(SpecialFactor specialFactor) {
        SpecialFactor old = this.getSpecialFactorByType(((Object)((Object)specialFactor)).getClass());
        if (old == null) {
            this.addSpecialFactor(specialFactor);
        } else if (old != specialFactor) {
            this.removeSpecialFactor(old);
            this.addSpecialFactor(specialFactor);
        }
    }

    public int getOpenCasesCount() {
        return this.openCasesCount;
    }

    public void setOpenCasesCount(int openCases) {
        this.openCasesCount = openCases;
    }

    public Boolean getMigratedEE() {
        return this.migratedEE;
    }

    public void setMigratedEE(Boolean migratedEE) {
        this.migratedEE = migratedEE;
    }

    public String getSendingFacility() {
        return this.sendingFacility;
    }

    public void setSendingFacility(String sendingFacility) {
        this.sendingFacility = sendingFacility;
    }

    public boolean isEnrolled() {
        return this.getEnrollmentDetermination() != null;
    }

    public AuditInfo getIdentityTraitsAuditInfo() {
        return this.identityTraitsAuditInfo;
    }

    public String getMothersMaidenName() {
        return this.mothersMaidenName;
    }

    public void setMothersMaidenName(String mothersMaidenName) {
        this.mothersMaidenName = mothersMaidenName;
    }

    public void setIdentifier(Serializable identifier) {
        super.setIdentifier(identifier);
    }

    public Employment getEmployment() {
        Set employments = this.getInternalEmployments();
        return employments.size() > 0 ? (Employment)((Object)employments.iterator().next()) : null;
    }

    public void setEmployment(Employment employment) {
        Set employments = this.getInternalEmployments();
        Iterator iter = employments.iterator();
        if (iter.hasNext()) {
            Employment e = (Employment)((Object)iter.next());
            employments.remove((Object)e);
            e.setPerson(null);
        }
        if (employment != null) {
            employments.add(employment);
            employment.setPerson(this);
        }
    }

    public void removeEmployment(Employment employment) {
        Validate.notNull((Object)((Object)employment), (String)"Employment cannot be null");
        this.getInternalEmployments().remove((Object)employment);
    }

    private Set getInternalEmployments() {
        if (this.internalEmployments == null) {
            this.internalEmployments = new HashSet();
        }
        return this.internalEmployments;
    }

    private void setInternalEmployments(Set employments) {
        this.internalEmployments = employments;
    }

    private Set getInternalRaces() {
        if (this.internalRaces == null) {
            this.internalRaces = new HashSet();
        }
        return this.internalRaces;
    }

    private void setInternalRaces(Set internalRaces) {
        this.internalRaces = internalRaces;
    }

    public Set getRaces() {
        return Collections.unmodifiableSet(this.getInternalRaces());
    }

    public void addRace(Race race) {
        Validate.notNull((Object)((Object)race), (String)"Null Race specified");
        Validate.notNull((Object)((Object)race.getRaceType()), (String)"Null RaceType specified");
        Race existingRace = this.getRaceByType(race.getRaceType());
        if (existingRace != null) {
            return;
        }
        this.getInternalRaces().add(race);
        race.setPerson(this);
    }

    public void removeRace(Race race) {
        Validate.notNull((Object)((Object)race), (String)"Race cannot be null");
        this.getInternalRaces().remove((Object)race);
    }

    public void removeAllRaces() {
        this.getInternalRaces().clear();
    }

    public Race getRaceByType(RaceType type) {
        Validate.notNull((Object)((Object)type), (String)"Null RaceType specified");
        for (Race race : this.getInternalRaces()) {
            if (!type.getCode().equals(race.getRaceType().getCode())) continue;
            return race;
        }
        return null;
    }

    public Ethnicity getEthnicity() {
        Set ethnicities = this.getInternalEthnicities();
        return ethnicities.size() > 0 ? (Ethnicity)((Object)ethnicities.iterator().next()) : null;
    }

    public void setEthnicity(Ethnicity ethnicity) {
        Set ethnicities = this.getInternalEthnicities();
        Iterator iter = ethnicities.iterator();
        if (iter.hasNext()) {
            Ethnicity e = (Ethnicity)((Object)iter.next());
            e.setPerson(null);
        }
        ethnicities.clear();
        if (ethnicity != null) {
            ethnicities.add(ethnicity);
            ethnicity.setPerson(this);
        }
    }

    private Set getInternalEthnicities() {
        if (this.internalEthnicities == null) {
            this.internalEthnicities = new HashSet();
        }
        return this.internalEthnicities;
    }

    private void setInternalEthnicities(Set ethnicities) {
        this.internalEthnicities = ethnicities;
    }

    public Religion getReligion() {
        return this.religion;
    }

    public void setReligion(Religion religion) {
        this.religion = religion;
    }

    private Set getInternalRelations() {
        if (this.internalRelations == null) {
            this.internalRelations = new HashSet();
        }
        return this.internalRelations;
    }

    private Set setInternalRelations(Set internalRelations) {
        this.internalRelations = internalRelations;
        return this.internalRelations;
    }

    public Set getRelations() {
        return Collections.unmodifiableSet(this.getInternalRelations());
    }

    public Relation getRelationByEntityKey(EntityKey identifier) {
        return (Relation)Person.getEntityByEntityKey((Collection)this.getRelations(), (EntityKey)identifier);
    }

    public Relation removeRelationByEntityKey(EntityKey identifier) {
        return (Relation)Person.removeEntityByEntityKey((Collection)this.getInternalRelations(), (EntityKey)identifier);
    }

    public Relation getMother() {
        return this.getRelation(Relationship.CODE_MOTHER.getCode());
    }

    public Relation getFather() {
        return this.getRelation(Relationship.CODE_FATHER.getCode());
    }

    public void setMother(Relation relation) {
        this.setRelation(Relationship.CODE_MOTHER.getCode(), relation);
    }

    public void setFather(Relation relation) {
        this.setRelation(Relationship.CODE_FATHER.getCode(), relation);
    }

    public Relation getRelation(String relationshipCode) {
        Validate.notNull((Object)relationshipCode, (String)"RelationshipCode must not be null");
        Validate.isTrue((relationshipCode == Relationship.CODE_MOTHER.getCode() || relationshipCode == Relationship.CODE_FATHER.getCode() ? 1 : 0) != 0, (String)"This method only applies to Mother and Father");
        if (this.getInternalRelations() == null) {
            return null;
        }
        for (Relation relation : this.getInternalRelations()) {
            Relationship relationType = relation.getRelationship();
            if (relationType == null || !relationType.getCode().equals(relationshipCode)) continue;
            return relation;
        }
        return null;
    }

    public void setRelation(String relationshipCode, Relation relation) {
        Validate.notNull((Object)((Object)relation), (String)"relation cannot be null");
        Validate.notNull((Object)relationshipCode, (String)"relationshipCode cannot be null");
        Validate.isTrue((relationshipCode.equals(Relationship.CODE_MOTHER.getCode()) || relationshipCode.equals(Relationship.CODE_FATHER.getCode()) ? 1 : 0) != 0, (String)"This method only applies to Mother and Father");
        Relation current = this.getRelation(relationshipCode);
        if (current != relation) {
            if (current != null) {
                this.getInternalRelations().remove((Object)current);
                current.setPerson(null);
            }
            if (relation != null) {
                Validate.isTrue((relation.getRelationship() != null && relationshipCode.equals(relation.getRelationship().getCode()) ? 1 : 0) != 0, (String)"relationshipCode should match relation.relationship code");
                this.addRelation(relation);
            }
        }
    }

    public void addRelation(Relation relation) {
        Validate.notNull((Object)((Object)relation), (String)"Null relation specified.");
        this.getInternalRelations().add(relation);
        relation.setPerson(this);
    }

    public void removeRelation(Relation relation) {
        Validate.notNull((Object)((Object)relation), (String)"Null relation specified.");
        this.getInternalRelations().remove((Object)relation);
        relation.setPerson(null);
    }

    public void removeAllRelations() {
        this.getInternalRelations().clear();
    }

    public Character getVOAIndicator() {
        return this.VOAIndicator;
    }

    public void setVOAIndicator(Character VOAIndicator) {
        this.VOAIndicator = VOAIndicator;
    }

    public boolean isVOAOnly() {
        return this.VOAIndicator == null ? false : this.VOAIndicator.equals(Character.valueOf('2'));
    }

    public Date getClassIIDentalApplicationDueBefore() {
        return this.classIIDentalApplicationDueBefore;
    }

    public void setClassIIDentalApplicationDueBefore(Date classIIDentalApplicationDueBefore) {
        this.classIIDentalApplicationDueBefore = classIIDentalApplicationDueBefore;
    }

    public Boolean getEligibleForClassIIDental() {
        return this.eligibleForClassIIDental;
    }

    public void setEligibleForClassIIDental(Boolean eligibleForClassIIDental) {
        this.eligibleForClassIIDental = eligibleForClassIIDental;
    }

    public Boolean getNeedCareDueToAccident() {
        return this.needCareDueToAccident;
    }

    public void setNeedCareDueToAccident(Boolean needCareDueToAccident) {
        this.needCareDueToAccident = needCareDueToAccident;
    }

    public Boolean getNeedCareDueToInjury() {
        return this.needCareDueToInjury;
    }

    public Name getFathersName() {
        return this.fathersName;
    }

    public void setFathersName(Name fathersName) {
        this.fathersName = fathersName;
    }

    public Name getMothersName() {
        return this.mothersName;
    }

    public void setMothersName(Name mothersName) {
        this.mothersName = mothersName;
    }

    public void setNeedCareDueToInjury(Boolean needCareDueToInjury) {
        this.needCareDueToInjury = needCareDueToInjury;
    }

    public void setEnrollmentSignatureDate(Date date) {
        this.enrollmentSignatureDate = date;
    }

    public Date getEnrollmentSignatureDate() {
        return this.enrollmentSignatureDate;
    }

    public Set getPreferredFacilities() {
        return Collections.unmodifiableSet(this.getInternalPreferredFacilities());
    }

    public VAFacility getPreferredFacility() {
        if (this.getPreferredFacilities().size() > 0) {
            return ((PreferredFacility)((Object)this.getPreferredFacilities().iterator().next())).getFacility();
        }
        return null;
    }

    private Set getInternalPreferredFacilities() {
        if (this.internalPreferredFacilities == null) {
            this.internalPreferredFacilities = new HashSet();
        }
        return this.internalPreferredFacilities;
    }

    private void setInternalPreferredFacilities(Set preferredFacilities) {
        this.internalPreferredFacilities = preferredFacilities;
    }

    public void addPreferredFacility(PreferredFacility preferredFacility) {
        Validate.notNull((Object)((Object)preferredFacility), (String)"Null preferredFacility specified.");
        this.getInternalPreferredFacilities().add(preferredFacility);
        preferredFacility.setPerson(this);
    }

    public void addAllPreferredFacilities(Set preferredFacilities) {
        Validate.notNull((Object)preferredFacilities, (String)"Empty set of preferredFacilities specified.");
        this.setOwner(preferredFacilities);
        Set internal = this.getInternalPreferredFacilities();
        internal.addAll(preferredFacilities);
    }

    public void removePreferredFacility(PreferredFacility preferredFacility) {
        Validate.notNull((Object)((Object)preferredFacility), (String)"Null PreferredFacility specified.");
        preferredFacility.setPerson(null);
        this.getInternalPreferredFacilities().remove((Object)preferredFacility);
    }

    public void removeAllPreferredFacilities() {
        this.getInternalPreferredFacilities().clear();
    }

    public PreferredFacility getPreferredFacilityByEntityKey(EntityKey identifier) {
        return (PreferredFacility)Person.getEntityByEntityKey((Collection)this.getPreferredFacilities(), (EntityKey)identifier);
    }

    public Set getProviderAssignments() {
        return Collections.unmodifiableSet(this.getInternalProviderAssignments());
    }

    private Set getInternalProviderAssignments() {
        if (this.internalProviderAssignments == null) {
            this.internalProviderAssignments = new HashSet();
        }
        return this.internalProviderAssignments;
    }

    private void setInternalProviderAssignments(Set providerAssignments) {
        this.internalProviderAssignments = providerAssignments;
    }

    public void addProviderAssignment(PatientProviderAssignment providerAssignment) {
        Validate.notNull((Object)((Object)providerAssignment), (String)"Null ProviderAssignment specified.");
        this.getInternalProviderAssignments().add(providerAssignment);
        providerAssignment.setPerson(this);
    }

    public void addAllProviderAssignments(Set providerAssignments) {
        Validate.notNull((Object)providerAssignments, (String)"Empty set of providerAssignments specified.");
        this.setOwner(providerAssignments);
        Set internal = this.getInternalProviderAssignments();
        internal.addAll(providerAssignments);
    }

    public void removeProviderAssignment(PatientProviderAssignment providerAssignment) {
        Validate.notNull((Object)((Object)providerAssignment), (String)"Null PatientProviderAssignments specified.");
        providerAssignment.setPerson(null);
        this.getInternalProviderAssignments().remove((Object)providerAssignment);
    }

    public void removeAllProviderAssignments() {
        this.getInternalProviderAssignments().clear();
    }

    public int getIdmMatchType() {
        return this.idmMatchType;
    }

    public void setIdmMatchType(int idmMatchType) {
        this.idmMatchType = idmMatchType;
    }

    public Set getInternalDeliveryPreferences() {
        if (this.internalDeliveryPreferences == null) {
            this.internalDeliveryPreferences = new HashSet();
        }
        return this.internalDeliveryPreferences;
    }

    public void setInternalDeliveryPreferences(Set internalDeliveryPreferences) {
        this.internalDeliveryPreferences = internalDeliveryPreferences;
    }

    public DeliveryPreference getDeliveryPreference() {
        if (this.internalDeliveryPreferences != null && this.internalDeliveryPreferences.size() > 0) {
            return (DeliveryPreference)((Object)this.internalDeliveryPreferences.iterator().next());
        }
        return null;
    }

    public void addDeliveryPreference(DeliveryPreference deliveryPreference) {
        Validate.notNull((Object)((Object)deliveryPreference), (String)"Null Delivery Preference specified.");
        this.getInternalDeliveryPreferences().add(deliveryPreference);
        deliveryPreference.setPerson(this);
    }

    public boolean isVoaFormProcessPendingStatus() {
        return this.voaFormProcessPendingStatus;
    }

    public void setVoaFormProcessPendingStatusTrue() {
        this.voaFormProcessPendingStatus = true;
    }

    public Map getChangeEvents() {
        if (this.changeEvents == null) {
            this.changeEvents = new HashMap();
        }
        return this.changeEvents;
    }

    public void setChangeEvent(String key, String event) {
        this.getChangeEvents().put(key, event);
    }

    public boolean isEsrCorrelationAdded() {
        return this.esrCorrelationAdded;
    }

    public void setEsrCorrelationAdded(boolean esrCorrelationAdded) {
        this.esrCorrelationAdded = esrCorrelationAdded;
    }

    public Set getSiteIdentities() {
        return this.siteIdentities;
    }

    public void setSiteIdentities(Set siteIdentities) {
        this.siteIdentities = siteIdentities;
    }

    public SelfIdentifiedGenderIdentity getSelfIdentifiedGenderIdentity() {
        return this.selfIdentifiedGenderIdentity;
    }

    public void setSelfIdentifiedGenderIdentity(SelfIdentifiedGenderIdentity selfIdentifiedGenderIdentity) {
        this.selfIdentifiedGenderIdentity = selfIdentifiedGenderIdentity;
    }

    public boolean isJustAdded() {
        return this.justAdded;
    }

    public void setJustAdded(boolean justAdded) {
        this.justAdded = justAdded;
    }
}

