/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.person;

import gov.va.med.fw.model.AbstractKeyedEntity;

public class FullyQualifiedIdentity
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -662856570689099399L;
    private static final String NATIONAL_ICN = "NI";
    private static final String PATIENT_IDENTIFIER = "PI";
    private static final String US_VHA = "USVHA";
    private String idValue = null;
    private String identifierType = null;
    private String stationNumber = null;
    private String assigningAuthority = null;
    private String idmExtension = null;

    public FullyQualifiedIdentity(String shortVPID) {
        this.idValue = shortVPID;
        this.identifierType = NATIONAL_ICN;
        this.idmExtension = shortVPID + "^NI";
    }

    public FullyQualifiedIdentity(String dfn, String stationNumber) {
        this.idValue = dfn;
        this.identifierType = PATIENT_IDENTIFIER;
        this.stationNumber = stationNumber;
        this.assigningAuthority = US_VHA;
        this.idmExtension = dfn + "^PI^" + stationNumber + "^USVHA";
    }

    public FullyQualifiedIdentity(String idValue, String identifierType, String stationNumber, String assigningAuthority) {
        this.idValue = idValue;
        this.identifierType = identifierType;
        this.stationNumber = stationNumber;
        this.assigningAuthority = assigningAuthority;
        this.idmExtension = idValue + "^" + identifierType + "^" + stationNumber + "^" + assigningAuthority;
    }

    public String getAssigningAuthority() {
        return this.assigningAuthority;
    }

    public String getIdentifierType() {
        return this.identifierType;
    }

    public String getIdValue() {
        return this.idValue;
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public String getIdmExtension() {
        return this.idmExtension;
    }
}

