/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.lookup;

import gov.va.med.esr.common.model.lookup.State;
import gov.va.med.esr.common.model.lookup.VAFacilityType;
import gov.va.med.fw.model.lookup.AbstractCode;
import gov.va.med.fw.model.lookup.AbstractNamedActiveLookup;
import gov.va.med.fw.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;

public class VAFacility
extends AbstractNamedActiveLookup {
    private static final long serialVersionUID = 922875941730007979L;
    public static final Code CODE_ALBUQUERQUE = new Code("724");
    public static final Code CODE_HEC = new Code("742");
    public static final Code CODE_HEC_INCORRECT = CODE_ALBUQUERQUE;
    public static final Code CODE_MVR = new Code("200");
    public static final Code CODE_CONNECTICUT_HCS = new Code("689");
    public static final Code CODE_NEW_BEDFORD_CBOC = new Code("650GA");
    public static final Code CODE_MICHAEL_E_DEBAKEY_VA_MEDICAL_CENTER = new Code("580");
    public static final Code CODE_IRON_MOUNTAIN_VA_MEDICAL_CENTER = new Code("585");
    public static final Code CODE_DEFAULT_CLAIM_FOLDER_LOCATION = new Code("376");
    public static final Code CODE_MPI_TRIGGER = new Code("200M");
    public static Code CODE_MHV;
    public static final String QUERY_FIND_ALL_MFNZEG_RECIPIENTS = "vaFacilityQuery_FindAllMfnzegRecipients";
    public static final String QUERY_FIND_ALL_DEATH_NOTIFICATION_SITES = "vaFacilityQuery_FindAllDeathNotificationSites";
    public static final String QUERY_FIND_ALL_DEATH_NOTIFICATION_SITES_NCA = "vaFacilityQuery_FindAllDeathNotificationSites_NCA";
    private String stationNumber;
    private VAFacilityType type;
    private VAFacilityAddress address = null;
    private BigDecimal visnId;
    private BigDecimal parentId;
    private Boolean mfnzegRecipient = null;
    private String emailDomainName = null;
    private String errorReason = null;

    public static void setVoaStationNumber(String stationNumber) {
        CODE_MHV = new Code(stationNumber);
    }

    public VAFacilityType getType() {
        return this.type;
    }

    public void setType(VAFacilityType type) {
        this.type = type;
    }

    public String getStationNumber() {
        return this.stationNumber;
    }

    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    public VAFacilityAddress getStreetAddress() {
        return this.address;
    }

    public void setStreetAddress(VAFacilityAddress address) {
        this.address = address;
    }

    public String getFacilityName() {
        return this.getStationNumber() == null ? this.getDescription() : this.getDescription() + " (#" + this.getStationNumber() + ")";
    }

    public BigDecimal getVisnId() {
        return this.visnId;
    }

    public void setVisnId(BigDecimal visnId) {
        this.visnId = visnId;
    }

    public BigDecimal getParentId() {
        return this.parentId;
    }

    public void setParentId(BigDecimal parentId) {
        this.parentId = parentId;
    }

    public Boolean getMfnzegRecipient() {
        return this.mfnzegRecipient;
    }

    public Boolean isMfnzegRecipient() {
        return this.mfnzegRecipient;
    }

    public void setMfnzegRecipient(Boolean mfnzegRecipient) {
        this.mfnzegRecipient = mfnzegRecipient;
    }

    public String getEmailDomainName() {
        return this.emailDomainName;
    }

    public void setEmailDomainName(String domainName) {
        this.emailDomainName = domainName;
    }

    public String getSiteNumberAndName() {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isNotEmpty((String)this.getCode())) {
            buffer.append(this.getCode());
        }
        if (StringUtils.isNotEmpty((String)this.getDescription())) {
            if (buffer.length() > 0) {
                buffer.append(" - ");
            }
            buffer.append(this.getDescription());
        }
        return buffer.toString();
    }

    public String getErrorReason() {
        return this.errorReason;
    }

    public void setErrorReason(String errorReason) {
        this.errorReason = errorReason;
    }

    public static class VAFacilityAddress
    implements Serializable {
        private static final long serialVersionUID = 237630687409244815L;
        private String line1;
        private String line2;
        private String line3;
        private String city;
        private String zipCode;
        private State state;

        public String getLine1() {
            return this.line1;
        }

        private void setLine1(String line1) {
            this.line1 = line1;
        }

        public String getLine2() {
            return this.line2;
        }

        private void setLine2(String line2) {
            this.line2 = line2;
        }

        public String getLine3() {
            return this.line3;
        }

        private void setLine3(String line3) {
            this.line3 = line3;
        }

        public String getCity() {
            return this.city;
        }

        private void setCity(String city) {
            this.city = city;
        }

        public String getZipCode() {
            return this.zipCode;
        }

        private void setZipCode(String zipCode) {
            this.zipCode = zipCode;
        }

        public State getState() {
            return this.state;
        }

        private void setState(State state) {
            this.state = state;
        }
    }

    public static class Code
    extends AbstractCode {
        private static final long serialVersionUID = 9209295537751778591L;

        private Code(String code) {
            super(code);
        }

        public static Code getByCode(String code) {
            return (Code)Code.getCode(Code.class, (String)code);
        }
    }
}

