/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.insurance;

import gov.va.med.esr.common.model.insurance.InsurancePlan;
import gov.va.med.esr.common.model.insurance.InsuranceSubscriber;
import gov.va.med.esr.common.model.lookup.InsuranceReportSource;
import gov.va.med.esr.common.model.lookup.InsuranceSiteUploadStatus;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.esr.common.model.lookup.ReasonInsuranceNotUploaded;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.party.Phone;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.StringUtils;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public abstract class InsurancePolicy
extends AbstractKeyedEntity
implements Comparable {
    private static final long serialVersionUID = -1370346746640850300L;
    private Person person = null;
    private InsuranceSubscriber subscriber = null;
    private InsurancePlan insurancePlan = null;
    private Set internalAddresses = null;
    private Set internalPhones = null;
    private InsuranceReportSource reportSource;
    private VAFacility reportSite;
    private InsuranceSiteUploadStatus insuranceSiteUploadStatus;
    private ReasonInsuranceNotUploaded reasonInsuranceNotUploaded;
    private String companyName = null;
    protected String groupName = null;
    protected String groupNumber = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public InsuranceSubscriber getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(InsuranceSubscriber subscriber) {
        this.subscriber = subscriber;
    }

    public InsurancePlan getInsurancePlan() {
        return this.insurancePlan;
    }

    public void setInsurancePlan(InsurancePlan insurancePlan) {
        this.insurancePlan = insurancePlan;
    }

    public Address getAddress() {
        Set addresses = this.getInternalAddresses();
        if (addresses.size() > 0) {
            return (Address)addresses.iterator().next();
        }
        return null;
    }

    public void setAddress(Address address) {
        Set addresses = this.getInternalAddresses();
        addresses.clear();
        if (address != null) {
            this.addAddress(address);
        }
    }

    public Phone getPreCertificationPhone() {
        return Phone.getPhoneOfType(this.getInternalPhones(), PhoneType.CODE_PRE_CERTIFICATION_PHONE.getName());
    }

    public Phone getBusinessPhone() {
        return Phone.getPhoneOfType(this.getInternalPhones(), PhoneType.CODE_BUSINESS.getName());
    }

    public Phone getFax() {
        return Phone.getPhoneOfType(this.getInternalPhones(), PhoneType.CODE_FAX.getName());
    }

    public void setPreCertificationPhone(Phone phone) {
        this.setPhone(this.getInternalPhones(), phone, PhoneType.CODE_PRE_CERTIFICATION_PHONE.getName());
    }

    public void setBusinessPhone(Phone phone) {
        this.setPhone(this.getInternalPhones(), phone, PhoneType.CODE_BUSINESS.getName());
    }

    public void setFax(Phone fax) {
        this.setPhone(this.getInternalPhones(), fax, PhoneType.CODE_FAX.getName());
    }

    private void setPhone(Set phones, Phone phone, String typeCode) {
        if (phone != null && !phone.getType().getCode().equals(typeCode)) {
            throw new IllegalArgumentException("Invalid Phone type: Phone type code must be " + typeCode);
        }
        Phone currentPhone = Phone.getPhoneOfType(phones, typeCode);
        if (currentPhone != null) {
            this.removePhone(currentPhone);
        }
        if (phone != null) {
            this.addPhone(phone);
        }
    }

    public InsuranceReportSource getReportSource() {
        return this.reportSource;
    }

    public void setReportSource(InsuranceReportSource reportSource) {
        this.reportSource = reportSource;
    }

    public VAFacility getReportSite() {
        return this.reportSite;
    }

    public void setReportSite(VAFacility reportSite) {
        this.reportSite = reportSite;
    }

    private void setInternalAddresses(Set addresses) {
        this.internalAddresses = addresses;
    }

    private Set getInternalAddresses() {
        if (this.internalAddresses == null) {
            this.internalAddresses = new HashSet();
        }
        return this.internalAddresses;
    }

    private void addAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        this.getInternalAddresses().add(address);
        address.setInsurancePolicy(this);
    }

    private void removeAddress(Address address) {
        Validate.notNull((Object)address, (String)"Null address specified.");
        this.getInternalAddresses().remove(address);
    }

    private Set getInternalPhones() {
        if (this.internalPhones == null) {
            this.internalPhones = new HashSet();
        }
        return this.internalPhones;
    }

    private void setInternalPhones(Set phones) {
        this.internalPhones = phones;
    }

    private void addPhone(Phone phone) {
        Validate.notNull((Object)((Object)phone), (String)"Null phone specified.");
        this.getInternalPhones().add(phone);
        phone.setInsurancePolicy(this);
    }

    private void removePhone(Phone phone) {
        Validate.notNull((Object)((Object)phone), (String)"Null phone specified.");
        this.getInternalPhones().remove((Object)phone);
    }

    public InsuranceSiteUploadStatus getInsuranceSiteUploadStatus() {
        return this.insuranceSiteUploadStatus;
    }

    public void setInsuranceSiteUploadStatus(InsuranceSiteUploadStatus siteUploadStatus) {
        this.insuranceSiteUploadStatus = siteUploadStatus;
    }

    public ReasonInsuranceNotUploaded getReasonInsuranceNotUploaded() {
        return this.reasonInsuranceNotUploaded;
    }

    public void setReasonInsuranceNotUploaded(ReasonInsuranceNotUploaded reasonInsuranceNotUploaded) {
        this.reasonInsuranceNotUploaded = reasonInsuranceNotUploaded;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupNumber() {
        return this.groupNumber;
    }

    public void setGroupNumber(String groupNumber) {
        this.groupNumber = groupNumber;
    }

    public boolean isSiteRecord() {
        return this.getReportSite() != null && this.getReportSite().getStationNumber().compareTo(VAFacility.CODE_HEC.getName()) != 0;
    }

    public int compareTo(Object policyObject) {
        InsurancePolicy otherPolicy = (InsurancePolicy)policyObject;
        int returnValue = StringUtils.compareTo((String)this.getCompanyName(), (String)otherPolicy.getCompanyName());
        if (returnValue == 0 && (returnValue = StringUtils.compareTo((String)this.getGroupName(), (String)otherPolicy.getGroupName())) == 0) {
            returnValue = StringUtils.compareTo((String)this.getGroupNumber(), (String)otherPolicy.getGroupNumber());
        }
        return returnValue;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("subscriber", (Object)this.subscriber);
        builder.append("companyName", (Object)this.companyName);
        builder.append("groupName", (Object)this.groupName);
        builder.append("groupNumber", (Object)this.groupNumber);
        builder.append("reportSite", (Object)this.reportSite);
        builder.append("reportSource", (Object)this.reportSource);
        builder.append("reasonInsuranceNotUploaded", (Object)this.reasonInsuranceNotUploaded);
        builder.append("insuranceSiteUploadStatus", (Object)this.insuranceSiteUploadStatus);
        builder.append("internalAddresses", (Object)this.internalAddresses);
        builder.append("internalPhones", (Object)this.internalPhones);
        builder.append("insurancePlan", (Object)this.insurancePlan);
    }
}

