/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.hbp;

import gov.va.med.esr.common.model.hbp.HealthBenefitPlanDefinition;
import gov.va.med.esr.common.model.lookup.HealthBenefitPlanCategory;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.model.EntityKey;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class HealthBenefitPlanName
extends AbstractKeyedEntity
implements Comparable<HealthBenefitPlanName> {
    private static final long serialVersionUID = -60195805515658310L;
    private String name = null;
    private HealthBenefitPlanCategory planCategory;
    private Set<HealthBenefitPlanDefinition> internalPlanDefinitions = null;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HealthBenefitPlanCategory getPlanCategory() {
        return this.planCategory;
    }

    public void setPlanCategory(HealthBenefitPlanCategory planCategory) {
        this.planCategory = planCategory;
    }

    private Set<HealthBenefitPlanDefinition> getInternalPlanDefinitions() {
        if (this.internalPlanDefinitions == null) {
            this.internalPlanDefinitions = new HashSet<HealthBenefitPlanDefinition>();
        }
        return this.internalPlanDefinitions;
    }

    private void setInternalPlanDefinitions(Set<HealthBenefitPlanDefinition> internalPlanDefinitions) {
        this.internalPlanDefinitions = internalPlanDefinitions;
    }

    public Set<HealthBenefitPlanDefinition> getPlanDefinitions() {
        return Collections.unmodifiableSet(this.getInternalPlanDefinitions());
    }

    public void addPlanDefinition(HealthBenefitPlanDefinition planDefinition) {
        Validate.notNull((Object)planDefinition, (String)"Null Plan Definition specified.");
        planDefinition.setPlanName(this);
        this.getInternalPlanDefinitions().add(planDefinition);
    }

    public void removePlanDefinition(HealthBenefitPlanDefinition planDefinition) {
        Validate.notNull((Object)planDefinition, (String)"Null Plan Definition specified.");
        planDefinition.setPlanName(null);
        this.getInternalPlanDefinitions().remove(planDefinition);
    }

    public HealthBenefitPlanDefinition getPlanDefinitionByEntityKey(EntityKey identifier) {
        return (HealthBenefitPlanDefinition)HealthBenefitPlanName.getEntityByEntityKey(this.getPlanDefinitions(), (EntityKey)identifier);
    }

    public void removeAllPlanDefinitions() {
        this.getInternalPlanDefinitions().clear();
    }

    @Override
    public int compareTo(HealthBenefitPlanName o) {
        if (o != null) {
            return this.getName().compareTo(o.getName());
        }
        return 1;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("name", (Object)this.name);
        builder.append("planCategory", (Object)this.planCategory);
        builder.append("planDefinitions", this.getPlanDefinitions());
    }
}

