/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.SiteYear;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import gov.va.med.fw.util.DateUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class PatientVisitSummary
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 2712584199371463303L;
    private Person person = null;
    private SiteYear siteYear = null;
    private VAFacility facilityVisited = null;
    private Integer incomeYear = null;
    private Date lastVisitDate = null;
    private Integer inpatientDays = null;
    private Integer outpatientDays = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    private SiteYear getSiteYear() {
        return this.siteYear;
    }

    private void setSiteYear(SiteYear siteYear) {
        this.siteYear = siteYear;
    }

    public VAFacility getFacilityVisited() {
        return this.facilityVisited;
    }

    public void setFacilityVisited(VAFacility facilityVisited) {
        this.facilityVisited = facilityVisited;
    }

    public Integer getIncomeYear() {
        return this.incomeYear;
    }

    public void setIncomeYear(Integer incomeYear) {
        this.incomeYear = incomeYear;
    }

    public Date getLastVisitDate() {
        return this.lastVisitDate;
    }

    public void setLastVisitDate(Date lastVisitDate) {
        this.lastVisitDate = lastVisitDate;
    }

    public Integer getInpatientDays() {
        return this.inpatientDays;
    }

    public void setInpatientDays(Integer inpatientDays) {
        this.inpatientDays = inpatientDays;
    }

    public Integer getOutpatientDays() {
        return this.outpatientDays;
    }

    public void setOutpatientDays(Integer outpatientDays) {
        this.outpatientDays = outpatientDays;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("incomeYear", (Object)this.incomeYear);
        builder.append("lastVisitDate", (Object)this.lastVisitDate);
        builder.append("inpatientDays", (Object)this.inpatientDays);
        builder.append("outpatientDays", (Object)this.outpatientDays);
    }

    public static PatientVisitSummary getLastestVisitedSummary(Collection visitSummaries) {
        Validate.notNull((Object)visitSummaries, (String)"Collection of PatientVisitSummary can not be null");
        PatientVisitSummary latest = null;
        Date latestVisit = null;
        for (PatientVisitSummary vs : visitSummaries) {
            if (!DateUtils.isAfter((Date)vs.getLastVisitDate(), latestVisit)) continue;
            latestVisit = vs.getLastVisitDate();
            latest = vs;
        }
        return latest;
    }

    public static PatientVisitSummary getLastestVisitedSummary(Collection visitSummaries, VAFacility facilityVisited) {
        return PatientVisitSummary.getLastestVisitedSummary(PatientVisitSummary.getPatientVisitSummaries(visitSummaries, facilityVisited));
    }

    public static Set getPatientVisitSummaries(Collection visitSummaries, Integer incomeYear) {
        Validate.notNull((Object)visitSummaries, (String)"Collection of PatientVisitSummary can not be null");
        Validate.notNull((Object)incomeYear, (String)"Income year can not be null");
        HashSet<PatientVisitSummary> s = new HashSet<PatientVisitSummary>();
        for (PatientVisitSummary v : visitSummaries) {
            if (!incomeYear.equals(v.getIncomeYear())) continue;
            s.add(v);
        }
        return Collections.unmodifiableSet(s);
    }

    public static Set getPatientVisitSummaries(Collection visitSummaries, VAFacility facilityVisited) {
        Validate.notNull((Object)visitSummaries, (String)"Collection of PatientVisitSummary can not be null");
        Validate.notNull((Object)((Object)facilityVisited), (String)"VAFacility can not be null");
        HashSet<PatientVisitSummary> s = new HashSet<PatientVisitSummary>();
        for (PatientVisitSummary v : visitSummaries) {
            if (!facilityVisited.equals((Object)v.getFacilityVisited())) continue;
            s.add(v);
        }
        return Collections.unmodifiableSet(s);
    }
}

