/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.financials;

import gov.va.med.esr.common.model.financials.Hardship;
import gov.va.med.esr.common.model.financials.IncomeTestStatus;
import gov.va.med.esr.common.model.lookup.IncomeTestSource;
import gov.va.med.esr.common.model.lookup.IncomeTestType;
import gov.va.med.esr.common.model.lookup.MeansTestStatus;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.lookup.WkfCaseStatusType;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;
import org.apache.commons.lang.builder.ToStringBuilder;

public class IncomeTest
extends AbstractKeyedEntity {
    private static final long serialVersionUID = -7079798377877531292L;
    private Person person = null;
    private Integer incomeYear = null;
    private Boolean pg8RelaxationIndicator = null;
    private Date ivmConversionDate = null;
    private WkfCaseStatusType workflowCaseStatus = null;
    private Boolean discloseFinancialInformation = null;
    private Boolean agreesToPayDeductible = null;
    private Date effectiveDate = null;
    private Integer totalNumberOfDependents = null;
    private Boolean previousYearThresholdApplies = null;
    private Boolean primaryIncomeTest = null;
    private Boolean futureTest = null;
    private IncomeTestSource source = null;
    private IncomeTestType type = null;
    private BigDecimal thresholdA = null;
    private BigDecimal gmtThresholdAmount = null;
    private Address gmtAddress = null;
    private VAFacility siteConductingTest = null;
    private Date adjudicationDate = null;
    private Date ivmTestCompletionDate = null;
    private MeansTestStatus incomeVerificationStatus = null;
    private Date incomeVerificationStatusDate = null;
    private Boolean refusedToSign = null;
    private BigDecimal reasonMTNoLongerRequired = null;
    private Date dateMTNoLongerRequired = null;
    private BigDecimal totalIncome = null;
    private BigDecimal netIncome = null;
    private BigDecimal deductibleExpenses = null;
    private BigDecimal netWorth = null;
    private String comments = null;
    private Hardship hardship = null;
    private Set internalStatuses = null;
    private BigDecimal networthThreshold = null;
    private BigDecimal pensionThreshold = null;
    private BigDecimal childIncomeExclusionThreshold = null;
    private Boolean cadAdjusted = null;
    private Boolean sendForAdjudication = null;
    private Boolean btFinancialInd = null;

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person person) {
        this.validateOwner(this.person, person);
        this.person = person;
    }

    public Integer getIncomeYear() {
        return this.incomeYear;
    }

    public void setIncomeYear(Integer incomeYear) {
        this.incomeYear = incomeYear;
    }

    public Boolean getDiscloseFinancialInformation() {
        return this.discloseFinancialInformation;
    }

    public void setDiscloseFinancialInformation(Boolean discloseFinancialInformation) {
        this.discloseFinancialInformation = discloseFinancialInformation;
    }

    public Boolean getAgreesToPayDeductible() {
        return this.agreesToPayDeductible;
    }

    public void setAgreesToPayDeductible(Boolean agreesToPayDeductible) {
        this.agreesToPayDeductible = agreesToPayDeductible;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public Integer getTotalNumberOfDependents() {
        return this.totalNumberOfDependents;
    }

    public void setTotalNumberOfDependents(Integer totalNumberOfDependents) {
        this.totalNumberOfDependents = totalNumberOfDependents;
    }

    public Boolean getPreviousYearThresholdApplies() {
        return this.previousYearThresholdApplies;
    }

    public void setPreviousYearThresholdApplies(Boolean previousYearThresholdApplies) {
        this.previousYearThresholdApplies = previousYearThresholdApplies;
    }

    public Boolean isPrimaryIncomeTest() {
        return this.primaryIncomeTest;
    }

    public Boolean getPrimaryIncomeTest() {
        return this.isPrimaryIncomeTest();
    }

    public void setPrimaryIncomeTest(Boolean primaryIncomeTest) {
        this.primaryIncomeTest = primaryIncomeTest;
    }

    public Boolean isFutureTest() {
        return this.futureTest;
    }

    public Boolean getFutureTest() {
        return this.futureTest;
    }

    public void setFutureTest(Boolean futureTest) {
        this.futureTest = futureTest;
    }

    public IncomeTestSource getSource() {
        return this.source;
    }

    public void setSource(IncomeTestSource source) {
        this.source = source;
    }

    public IncomeTestType getType() {
        return this.type;
    }

    public void setType(IncomeTestType type) {
        this.type = type;
    }

    public BigDecimal getThresholdA() {
        return this.thresholdA;
    }

    public void setThresholdA(BigDecimal thresholdA) {
        this.thresholdA = thresholdA;
    }

    public BigDecimal getGmtThresholdAmount() {
        return this.gmtThresholdAmount;
    }

    public void setGmtThresholdAmount(BigDecimal gmtThresholdAmount) {
        this.gmtThresholdAmount = gmtThresholdAmount;
    }

    public Address getGmtAddress() {
        return this.gmtAddress;
    }

    public void setGmtAddress(Address gmtAddress) {
        this.gmtAddress = gmtAddress;
    }

    public VAFacility getSiteConductingTest() {
        return this.siteConductingTest;
    }

    public void setSiteConductingTest(VAFacility siteConductingTest) {
        this.siteConductingTest = siteConductingTest;
    }

    public Date getAdjudicationDate() {
        return this.adjudicationDate;
    }

    public void setAdjudicationDate(Date adjudicationDate) {
        this.adjudicationDate = adjudicationDate;
    }

    public Date getIVMTestCompletionDate() {
        return this.ivmTestCompletionDate;
    }

    public void setIVMTestCompletionDate(Date ivmTestCompletionDate) {
        this.ivmTestCompletionDate = ivmTestCompletionDate;
    }

    private Date getIvmTestCompletionDate() {
        return this.ivmTestCompletionDate;
    }

    private void setIvmTestCompletionDate(Date ivmTestCompletionDate) {
        this.ivmTestCompletionDate = ivmTestCompletionDate;
    }

    public MeansTestStatus getIncomeVerificationStatus() {
        return this.incomeVerificationStatus;
    }

    public void setIncomeVerificationStatus(MeansTestStatus incomeVerificationStatus) {
        this.incomeVerificationStatus = incomeVerificationStatus;
    }

    public Date getIncomeVerificationStatusDate() {
        return this.incomeVerificationStatusDate;
    }

    public void setIncomeVerificationStatusDate(Date incomeVerificationStatusDate) {
        this.incomeVerificationStatusDate = incomeVerificationStatusDate;
    }

    public Boolean getRefusedToSign() {
        return this.refusedToSign;
    }

    public void setRefusedToSign(Boolean refusedToSign) {
        this.refusedToSign = refusedToSign;
    }

    public Boolean getCadAdjusted() {
        return this.cadAdjusted;
    }

    public void setCadAdjusted(Boolean cadAdjusted) {
        this.cadAdjusted = cadAdjusted;
    }

    public BigDecimal getReasonMTNoLongerRequired() {
        return this.reasonMTNoLongerRequired;
    }

    public void setReasonMTNoLongerRequired(BigDecimal reasonMTNoLongerRequired) {
        this.reasonMTNoLongerRequired = reasonMTNoLongerRequired;
    }

    public Date getDateMTNoLongerRequired() {
        return this.dateMTNoLongerRequired;
    }

    public void setDateMTNoLongerRequired(Date dateMTNoLongerRequired) {
        this.dateMTNoLongerRequired = dateMTNoLongerRequired;
    }

    public BigDecimal getTotalIncome() {
        return this.totalIncome;
    }

    public void setTotalIncome(BigDecimal totalIncome) {
        this.totalIncome = totalIncome;
    }

    public BigDecimal getNetIncome() {
        return this.netIncome;
    }

    public void setNetIncome(BigDecimal netIncome) {
        this.netIncome = netIncome;
    }

    public BigDecimal getDeductibleExpenses() {
        return this.deductibleExpenses;
    }

    public void setDeductibleExpenses(BigDecimal deductibleExpenses) {
        this.deductibleExpenses = deductibleExpenses;
    }

    public BigDecimal getNetWorth() {
        return this.netWorth;
    }

    public void setNetWorth(BigDecimal netWorth) {
        this.netWorth = netWorth;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public BigDecimal getPensionThreshold() {
        return this.pensionThreshold;
    }

    public void setPensionThreshold(BigDecimal pensionThreshold) {
        this.pensionThreshold = pensionThreshold;
    }

    public BigDecimal getNetworthThreshold() {
        return this.networthThreshold;
    }

    public void setNetworthThreshold(BigDecimal networthThreshold) {
        this.networthThreshold = networthThreshold;
    }

    public BigDecimal getChildIncomeExclusionThreshold() {
        return this.childIncomeExclusionThreshold;
    }

    public void setChildIncomeExclusionThreshold(BigDecimal childIncomeExclusionThreshold) {
        this.childIncomeExclusionThreshold = childIncomeExclusionThreshold;
    }

    public Hardship getHardship() {
        return this.hardship;
    }

    public void setHardship(Hardship hardship) {
        this.hardship = hardship;
    }

    public Boolean getPg8RelaxationIndicator() {
        return this.pg8RelaxationIndicator;
    }

    public void setPg8RelaxationIndicator(Boolean pg8RelaxationIndicator) {
        this.pg8RelaxationIndicator = pg8RelaxationIndicator;
    }

    public Date getIvmConversionDate() {
        return this.ivmConversionDate;
    }

    public void setIvmConversionDate(Date ivmConversionDate) {
        this.ivmConversionDate = ivmConversionDate;
    }

    public WkfCaseStatusType getWorkflowCaseStatus() {
        return this.workflowCaseStatus;
    }

    public void setWorkflowCaseStatus(WkfCaseStatusType workflowCaseStatus) {
        this.workflowCaseStatus = workflowCaseStatus;
    }

    public Boolean getSendForAdjudication() {
        return this.sendForAdjudication;
    }

    public void setSendForAdjudication(Boolean sendForAdjudication) {
        this.sendForAdjudication = sendForAdjudication;
    }

    private Set getInternalStatuses() {
        if (this.internalStatuses == null) {
            this.internalStatuses = new HashSet();
        }
        return this.internalStatuses;
    }

    private void setInternalStatuses(Set internalStatuses) {
        this.internalStatuses = internalStatuses;
    }

    public Set getStatuses() {
        return Collections.unmodifiableSet(this.getInternalStatuses());
    }

    public void addStatus(IncomeTestStatus status) {
        this.addIncomeTestStatus(status);
    }

    public void removeStatus(IncomeTestStatus status) {
        this.removeIncomeTestStatus(status);
    }

    public void addIncomeTestStatus(IncomeTestStatus status) {
        Validate.notNull((Object)((Object)status), (String)"status cannot be null");
        this.getInternalStatuses().add(status);
        status.setIncomeTest(this);
    }

    public void removeIncomeTestStatus(IncomeTestStatus status) {
        Validate.notNull((Object)((Object)status), (String)"Status cannot be null");
        ArrayList<IncomeTestStatus> stList = new ArrayList<IncomeTestStatus>();
        for (IncomeTestStatus st : this.getInternalStatuses()) {
            if ((status.getEntityKey() == null || st.getEntityKey() == null || status.getEntityKey().equals(st.getEntityKey())) && status == st && status.equals((Object)st)) continue;
            stList.add(st);
        }
        this.getInternalStatuses().clear();
        this.getInternalStatuses().addAll(stList);
        status.setIncomeTest(null);
    }

    public void removeAllStatuses() {
        this.getInternalStatuses().clear();
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("incomeYear", (Object)this.incomeYear);
        builder.append("siteConductingTest", (Object)this.siteConductingTest);
        builder.append("discloseFinancialInformation", (Object)this.discloseFinancialInformation);
        builder.append("agreesToPayDeductible", (Object)this.agreesToPayDeductible);
        builder.append("effectiveDate", (Object)this.effectiveDate);
        builder.append("totalNumberOfDependents", (Object)this.totalNumberOfDependents);
        builder.append("previousYearThresholdApplies", (Object)this.previousYearThresholdApplies);
        builder.append("primaryIncomeTest", (Object)this.primaryIncomeTest);
        builder.append("source", (Object)this.source);
        builder.append("type", (Object)this.type);
        builder.append("thresholdA", (Object)this.thresholdA);
        builder.append("gmtThresholdAmount", (Object)this.gmtThresholdAmount);
        builder.append("adjudicationDate", (Object)this.adjudicationDate);
        builder.append("ivmTestCompletionDate", (Object)this.ivmTestCompletionDate);
        builder.append("incomeVerificationStatus", (Object)this.incomeVerificationStatus);
        builder.append("incomeVerificationStatusDate", (Object)this.incomeVerificationStatusDate);
        builder.append("refusedToSign", (Object)this.refusedToSign);
        builder.append("reasonMTNoLongerRequired", (Object)this.reasonMTNoLongerRequired);
        builder.append("dateMTNoLongerRequired", (Object)this.dateMTNoLongerRequired);
        builder.append("totalIncome", (Object)this.totalIncome);
        builder.append("deductibleExpenses", (Object)this.deductibleExpenses);
        builder.append("netWorth", (Object)this.netWorth);
        builder.append("comments", (Object)this.comments);
        builder.append("hardship", (Object)this.hardship);
        builder.append("cadAdjusted", (Object)this.cadAdjusted);
        builder.append("pg8RelaxationIndicator", (Object)this.pg8RelaxationIndicator);
        builder.append("btFinancialInd", (Object)this.btFinancialInd);
    }

    public IncomeTestStatus getIncomeTestStatus() {
        return this.getIncomeTestStatus(this.getType());
    }

    public Date getCompletedDate() {
        IncomeTestStatus status = this.getIncomeTestStatus();
        return status == null ? null : status.getCompletedDate();
    }

    public void setCompletedDate(Date date) {
        for (IncomeTestStatus status : this.getInternalStatuses()) {
            status.setCompletedDate(date);
        }
    }

    public Date getLastEditedDate() {
        IncomeTestStatus status = this.getIncomeTestStatus();
        return status == null ? null : status.getLastEditedDate();
    }

    public void setLastEditedDate(Date date) {
        for (IncomeTestStatus status : this.getInternalStatuses()) {
            status.setLastEditedDate(date);
        }
    }

    public MeansTestStatus getStatus() {
        return this.getIncomeTestStatus() != null ? this.getIncomeTestStatus().getStatus() : null;
    }

    public boolean isPendingAdjudication() {
        MeansTestStatus status = this.getStatus();
        return status == null ? false : MeansTestStatus.MT_STATUS_PENDING_ADJUDICATION.getName().equals(status.getCode());
    }

    public void setMeansTestStatus(MeansTestStatus status) {
        Validate.notNull((Object)((Object)status), (String)"MeansTestStatus can not be null");
        if (this.getType() == null) {
            throw new IllegalArgumentException("IncomeTestType must be set before the MeansTestStatus.");
        }
        IncomeTestStatus itStatus = this.getIncomeTestStatus(this.getType());
        if (itStatus == null) {
            itStatus = new IncomeTestStatus();
            itStatus.setType(this.getType());
            this.addStatus(itStatus);
        }
        itStatus.setStatus(status);
    }

    public void setIncomeTestStatus(IncomeTestType type, MeansTestStatus status) {
        Validate.notNull((Object)((Object)type), (String)"IncomeTestType can not be null");
        IncomeTestStatus itStatus = this.getIncomeTestStatus(type);
        if (itStatus == null) {
            itStatus = new IncomeTestStatus();
            itStatus.setType(type);
            this.addStatus(itStatus);
        }
        itStatus.setStatus(status);
    }

    public void setIncomeTestStatus(IncomeTestType type, MeansTestStatus status, MeansTestStatus determinedStatus) {
        Validate.notNull((Object)((Object)type), (String)"IncomeTestType can not be null");
        IncomeTestStatus itStatus = this.getIncomeTestStatus(type);
        if (itStatus == null) {
            itStatus = new IncomeTestStatus();
            itStatus.setType(type);
            this.addStatus(itStatus);
        }
        itStatus.setStatus(status);
        itStatus.setDeterminedStatus(determinedStatus);
    }

    public MeansTestStatus getDeterminedStatus() {
        return this.getIncomeTestStatus() != null ? this.getIncomeTestStatus().getDeterminedStatus() : null;
    }

    public IncomeTestStatus getPharmacyCoPayStatus() {
        return this.getIncomeTestStatusOfType(IncomeTestType.CODE_CO_PAY_EXEMPTION_TEST);
    }

    public IncomeTestStatus getLongTermCareStatus() {
        return this.getIncomeTestStatusOfType(IncomeTestType.CODE_LTC_CO_PAY_EXEMPTION_TEST);
    }

    public IncomeTestStatus getIncomeTestStatusOfType(IncomeTestType.Code typeCode) {
        IncomeTestStatus match = null;
        if (typeCode != null && this.internalStatuses != null) {
            match = IncomeTest.getIncomeTestStatusOfType(this.internalStatuses, typeCode);
        }
        return match;
    }

    public IncomeTestStatus getIncomeTestStatus(IncomeTestType itType) {
        IncomeTestStatus match = null;
        if (itType != null && itType.getCode() != null && this.internalStatuses != null) {
            match = IncomeTest.getIncomeTestStatusOfType(this.internalStatuses, itType);
        }
        return match;
    }

    public IncomeTestStatus getIncomeTestStatus(IncomeTestType.Code typeCode) {
        IncomeTestStatus match = null;
        if (typeCode != null && this.internalStatuses != null) {
            match = IncomeTest.getIncomeTestStatusOfType(this.internalStatuses, typeCode);
        }
        return match;
    }

    public IncomeTestType getPrimaryTestType() {
        if (Boolean.TRUE.equals(this.getPrimaryIncomeTest())) {
            return this.getType();
        }
        return null;
    }

    public static IncomeTestStatus getIncomeTestStatusOfType(Set statuses, IncomeTestType.Code typeCode) {
        Validate.notNull((Object)statuses, (String)"The set of statuses must not be null");
        Validate.notNull((Object)((Object)typeCode), (String)"IncomeTestStatus type code must not be null");
        for (IncomeTestStatus testStatus : statuses) {
            IncomeTestType incomeTestType = testStatus.getType();
            if (incomeTestType == null || incomeTestType.getCode() == null || !incomeTestType.getCode().equals(typeCode.getName())) continue;
            return testStatus;
        }
        return null;
    }

    public static IncomeTestStatus getIncomeTestStatusOfType(Set statuses, IncomeTestType type) {
        Validate.notNull((Object)statuses, (String)"The set of statuses must not be null");
        Validate.notNull((Object)((Object)type), (String)"IncomeTestType type must not be null");
        for (IncomeTestStatus testStatus : statuses) {
            IncomeTestType testStatusType = testStatus.getType();
            if (testStatusType == null || testStatusType.getCode() == null || type.getCode() == null || !testStatusType.getCode().equals(type.getCode())) continue;
            return testStatus;
        }
        return null;
    }

    public Boolean getBtFinancialInd() {
        return this.btFinancialInd;
    }

    public void setBtFinancialInd(Boolean btFinancialInd) {
        this.btFinancialInd = btFinancialInd;
    }
}

