/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.model.ee;

import gov.va.med.esr.common.model.ee.EGTProcessStatistic;
import gov.va.med.esr.common.model.lookup.EGTSettingType;
import gov.va.med.esr.common.model.lookup.EGTStatus;
import gov.va.med.esr.common.model.lookup.EnrollmentPriorityGroup;
import gov.va.med.esr.common.model.lookup.EnrollmentPrioritySubGroup;
import gov.va.med.fw.model.AbstractKeyedEntity;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;

public class EGTSetting
extends AbstractKeyedEntity {
    private static final long serialVersionUID = 8605732175868336343L;
    private EGTSettingType type = null;
    private EnrollmentPriorityGroup priorityGroup = null;
    private EnrollmentPrioritySubGroup prioritySubGroup = null;
    private Date effectiveDate = null;
    private Date federalRegisterDate = null;
    private String comments = null;
    private Boolean disable = Boolean.FALSE;
    private Boolean current = Boolean.FALSE;
    private Set internalProcessStatistics = null;
    private EGTSetting previousEGT = null;

    public EGTSettingType getType() {
        return this.type;
    }

    public void setType(EGTSettingType type) {
        this.type = type;
    }

    public EnrollmentPriorityGroup getPriorityGroup() {
        return this.priorityGroup;
    }

    public void setPriorityGroup(EnrollmentPriorityGroup priorityGroup) {
        this.priorityGroup = priorityGroup;
    }

    public EnrollmentPrioritySubGroup getPrioritySubGroup() {
        return this.prioritySubGroup;
    }

    public void setPrioritySubGroup(EnrollmentPrioritySubGroup prioritySubGroup) {
        this.prioritySubGroup = prioritySubGroup;
    }

    public Date getEffectiveDate() {
        return this.effectiveDate;
    }

    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Boolean getDisable() {
        return this.disable;
    }

    public void setDisable(Boolean disable) {
        this.disable = disable;
    }

    public Boolean getCurrent() {
        return this.current;
    }

    public Boolean isCurrent() {
        return this.getCurrent();
    }

    public void setCurrent(Boolean current) {
        this.current = current;
    }

    public Date getFederalRegisterDate() {
        return this.federalRegisterDate;
    }

    public void setFederalRegisterDate(Date federalRegisterDate) {
        this.federalRegisterDate = federalRegisterDate;
    }

    private Set getInternalProcessStatistics() {
        if (this.internalProcessStatistics == null) {
            this.internalProcessStatistics = new HashSet();
        }
        return this.internalProcessStatistics;
    }

    private void setInternalProcessStatistics(Set internalProcessStatistics) {
        this.internalProcessStatistics = internalProcessStatistics;
    }

    public EGTProcessStatistic getProcessStatistic() {
        Set processStats = this.getInternalProcessStatistics();
        if (processStats.size() > 0) {
            return (EGTProcessStatistic)((Object)this.internalProcessStatistics.iterator().next());
        }
        return null;
    }

    public void setProcessStatistic(EGTProcessStatistic processStatistic) {
        Set processStats = this.getInternalProcessStatistics();
        processStats.clear();
        if (processStatistic != null) {
            processStats.add(processStatistic);
            processStatistic.setEgtSetting(this);
        }
    }

    public boolean isProcessCurrentlyRunning() {
        EGTStatus egtStatus;
        EGTProcessStatistic processStatistic = this.getProcessStatistic();
        return processStatistic != null && (egtStatus = processStatistic.getEgtProcessStatus()) != null && EGTStatus.CODE_RUNNING.getName().equals(egtStatus.getCode());
    }

    public EGTSetting getPreviousEGT() {
        return this.previousEGT;
    }

    public void setPreviousEGT(EGTSetting previousEGT) {
        this.previousEGT = previousEGT;
    }

    protected void buildToString(ToStringBuilder builder) {
        super.buildToString(builder);
        builder.append("type", (Object)this.type);
        builder.append("priorityGroup", (Object)this.priorityGroup);
        builder.append("prioritySubGroup", (Object)this.prioritySubGroup);
        builder.append("effectiveDate", (Object)this.effectiveDate);
        builder.append("federalRegisterDate", (Object)this.federalRegisterDate);
        builder.append("disable", (Object)this.disable);
        builder.append("current", (Object)this.current);
        builder.append("previousEGT", (Object)this.previousEGT);
    }
}

