/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.clock;

import gov.va.med.esr.common.clock.AbstractClockProcess;
import gov.va.med.esr.common.clock.Clock;
import gov.va.med.esr.common.model.CommonEntityKeyFactory;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.esr.service.PersonService;
import gov.va.med.esr.service.WorkflowService;

public class WorkflowClockProcess
extends AbstractClockProcess {
    private PersonService personService = null;
    private WorkflowService workflowService = null;

    @Override
    protected Clock.Type convertStrToClockType(String type) {
        if (Clock.Type.WF_72_HOUR_CLOCK.getName().equals(type)) {
            return Clock.Type.WF_72_HOUR_CLOCK;
        }
        return null;
    }

    @Override
    protected void processClock(String personId, String clockType, String subject) throws Exception {
        Person person = this.getPersonService().getPerson(CommonEntityKeyFactory.createPersonIdEntityKey(personId));
        Clock.Type firedClockType = this.convertStrToClockType(clockType);
        this.getWorkflowService().processWorkflowEvent(person, firedClockType);
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public WorkflowService getWorkflowService() {
        return this.workflowService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

