/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.CombatEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.CombatServiceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.msds.MilitaryServiceEpisodeMetaDataFromBIRLS;
import gov.va.med.esr.common.builder.msds.MilitaryServiceMetaDataMSDS;
import gov.va.med.esr.common.builder.msds.MilitaryServiceSiteRecordMetaDataFromMSDS;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.jms.vadir.outboundResponse.VadirServiceResponseWrapper;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.BIRLS;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.MilitaryHistory;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.PeriodOfService;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class MilitaryServiceMetaDataFromBIRLS
extends AbstractMetaData
implements MilitaryServiceMetaDataMSDS {
    private MilitaryService militaryService = null;
    private MilitaryServiceSiteRecordMetaData militaryServiceSiteRecordMetaData = null;
    private ActivationMetaData[] activations = null;
    private CombatServiceMetaData[] combatServices = null;
    private CombatEpisodeMetaData[] combatEpisodes = null;
    private BIRLS birls = null;
    private String metaDataError = null;

    public MilitaryServiceMetaDataFromBIRLS(VadirServiceResponseWrapper wrapper) {
        this.processWrapper(wrapper);
    }

    @Override
    public ActivationMetaData[] getActivations() {
        return this.activations;
    }

    @Override
    public CombatServiceMetaData[] getCombatServices() {
        return this.combatServices;
    }

    @Override
    public CombatEpisodeMetaData[] getCombatEpisodes() {
        return this.combatEpisodes;
    }

    @Override
    public String getCombatVeteranEligibilityEndDate() {
        return null;
    }

    @Override
    public String getDisabilityRetirementStatus() {
        return null;
    }

    @Override
    public String getDischargeDueToDisability() {
        return this.birls != null ? this.birls.getDisabilityInd() : null;
    }

    @Override
    public MilitaryService getEntity() {
        return this.militaryService;
    }

    @Override
    public MilitaryServiceSiteRecordMetaData getMilitaryServiceSiteRecord() {
        return this.militaryServiceSiteRecordMetaData;
    }

    @Override
    public void setEntity(MilitaryService entity) {
        this.militaryService = entity;
    }

    @Override
    public String getMetaDataError() {
        return this.metaDataError;
    }

    public void setMetaDataError(String metaDataError) {
        this.metaDataError = metaDataError;
    }

    private void processWrapper(VadirServiceResponseWrapper wrapper) {
        MilitaryHistory history;
        ArrayList militaryPays = new ArrayList();
        ArrayList combatEpisodeList = new ArrayList();
        ArrayList activations = new ArrayList();
        ArrayList<MilitaryServiceEpisodeMetaDataFromBIRLS> servicePeriodsHEC = new ArrayList<MilitaryServiceEpisodeMetaDataFromBIRLS>();
        MilitaryHistory militaryHistory = history = wrapper != null ? (MilitaryHistory)wrapper.getResult() : null;
        if (history != null) {
            List periodOfServices;
            this.birls = history.getBirls();
            List list = periodOfServices = this.birls != null ? this.birls.getPeriodOfService() : new ArrayList();
            if (periodOfServices != null) {
                for (PeriodOfService period : periodOfServices) {
                    if (period.getCharacterOfService() == null || StringUtils.isBlank((String)period.getCharacterOfService()) || "UNK".equals(period.getCharacterOfService()) || "Z".equals(period.getCharacterOfService())) {
                        this.setMetaDataError("06");
                    }
                    MilitaryServiceEpisodeMetaDataFromBIRLS periodMeta = new MilitaryServiceEpisodeMetaDataFromBIRLS(period);
                    servicePeriodsHEC.add(periodMeta);
                }
            }
        }
        this.combatServices = militaryPays.toArray(new CombatServiceMetaData[0]);
        this.combatEpisodes = combatEpisodeList.toArray(new CombatEpisodeMetaData[0]);
        this.militaryServiceSiteRecordMetaData = new MilitaryServiceSiteRecordMetaDataFromMSDS(servicePeriodsHEC.toArray(new MilitaryServiceEpisodeMetaData[0]));
        this.activations = activations.toArray(new ActivationMetaData[0]);
    }
}

