/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.DeploymentMetaData;
import gov.va.med.esr.common.builder.msds.DeploymentMetaDataFromMSDS;
import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.esr.common.infra.ImpreciseDateUtils;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Activation;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.Deployment;
import gov.va.med.esr.jms.vadir.outboundResponse.model.militaryHistory.ServicePeriod;
import gov.va.med.fw.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ActivationMetaDataFromMSDS
implements ActivationMetaData {
    private gov.va.med.esr.common.model.ee.Activation activationEsr = null;
    private DeploymentMetaData[] deployments = null;
    private final String[] invalidTerminationReason = new String[]{"F", "W"};
    private Activation activation = null;

    public ActivationMetaDataFromMSDS(ServicePeriod period, Activation activation) {
        this.processMSDSwrapper(period, activation);
    }

    @Override
    public String getActivationBeginDate() {
        ImpreciseDate date = this.activation != null && this.activation.getStartDate() != null ? ImpreciseDateUtils.createImpreciseDateWithoutTime(this.activation.getStartDate()) : null;
        return date != null ? date.getStandardFormat() : null;
    }

    @Override
    public String getActivationEndDate() {
        ImpreciseDate date = this.activation != null && this.activation.getEndDate() != null ? ImpreciseDateUtils.createImpreciseDateWithoutTime(this.activation.getEndDate()) : null;
        return date != null ? date.getStandardFormat() : null;
    }

    @Override
    public String getDataSource() {
        return MHDataSource.VADIR.getCode();
    }

    @Override
    public DeploymentMetaData[] getDeployments() {
        return this.deployments;
    }

    @Override
    public gov.va.med.esr.common.model.ee.Activation getEntity() {
        return this.activationEsr;
    }

    @Override
    public String getNamedContingency() {
        return null;
    }

    @Override
    public String getSpecialOperation() {
        return null;
    }

    @Override
    public String getTerminationReason() {
        return this.activation != null ? this.activation.getTerminationRsn() : null;
    }

    @Override
    public void setEntity(gov.va.med.esr.common.model.ee.Activation entity) {
        this.activationEsr = entity;
    }

    private void processMSDSwrapper(ServicePeriod period, Activation activation) {
        this.activation = activation;
        if (this.activation == null) {
            return;
        }
        ArrayList<DeploymentMetaDataFromMSDS> deployments = new ArrayList<DeploymentMetaDataFromMSDS>();
        if (activation != null & period != null && period.getDeployments() != null) {
            List deps = period.getDeployments();
            Date actStart = activation.getStartDate();
            Date actEnd = activation.getEndDate();
            for (Deployment deployment : deps) {
                Date end;
                Date start;
                if (StringUtils.contains((String[])this.invalidTerminationReason, (String)deployment.getTerminationRsn()) || !this.isInRange(start = deployment.getStartDate(), end = deployment.getEndDate(), actStart, actEnd)) continue;
                DeploymentMetaDataFromMSDS data = new DeploymentMetaDataFromMSDS(deployment);
                deployments.add(data);
            }
            this.deployments = deployments.toArray(new DeploymentMetaData[0]);
        }
    }

    private boolean isInRange(Date startDate, Date endDate, Date lower_range, Date upper_range) {
        return !(startDate == null || endDate == null || lower_range == null || upper_range == null || !startDate.equals(endDate) && !startDate.before(endDate) || !lower_range.equals(upper_range) && !lower_range.before(upper_range) || !startDate.equals(lower_range) && !startDate.after(lower_range) || !startDate.equals(upper_range) && !startDate.before(upper_range) || !endDate.equals(lower_range) && !endDate.after(lower_range) || !endDate.equals(upper_range) && !endDate.before(upper_range));
    }
}

