/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.msds;

import gov.va.med.esr.common.builder.entity.ActivationMetaData;
import gov.va.med.esr.common.builder.entity.DeploymentMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.ee.Activation;
import gov.va.med.esr.common.model.ee.Deployment;
import gov.va.med.esr.common.model.lookup.MHDataSource;
import gov.va.med.esr.common.model.lookup.NamedContingency;
import gov.va.med.esr.common.model.lookup.SpecialOperation;
import gov.va.med.esr.common.model.lookup.TerminationReason;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class ActivationBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 1661878778634701213L;
    private Builder mhDataSourceBuilder = null;
    private Builder deploymentBuilder = null;
    private Builder terminationReasonBuilder = null;
    private Builder specialOperationBuilder = null;
    private Builder namedContingencyBuilder = null;

    public Activation build(ActivationMetaData metaData) throws BuilderException {
        Activation input = metaData.getEntity();
        Activation output = input == null ? new Activation() : input;
        this.transfer(output, metaData);
        return this.shouldKeep((Object)output) ? output : null;
    }

    private void transfer(Activation input, ActivationMetaData metaData) throws BuilderException {
        input.setActivationBeginDate(super.build(input.getActivationBeginDate(), metaData.getActivationBeginDate()));
        input.setActivationEndDate(super.build(input.getActivationEndDate(), metaData.getActivationEndDate()));
        input.setDataSource((MHDataSource)super.build(this.mhDataSourceBuilder, (AbstractLookup)input.getDataSource(), metaData.getDataSource()));
        input.setNamedContingency((NamedContingency)super.build(this.namedContingencyBuilder, (AbstractLookup)input.getNamedContingency(), metaData.getNamedContingency()));
        input.setSpecialOperation((SpecialOperation)super.build(this.specialOperationBuilder, (AbstractLookup)input.getSpecialOperation(), metaData.getSpecialOperation()));
        input.setTerminationReason((TerminationReason)super.build(this.terminationReasonBuilder, (AbstractLookup)input.getTerminationReason(), metaData.getTerminationReason()));
        this.buildDeployments(input, metaData.getDeployments());
    }

    private void buildDeployments(Activation input, DeploymentMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processDeployment(toAdd, metaData[index]);
        }
        input.removeAllDeployments();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addDeployment((Deployment)((Object)i.next()));
        }
    }

    private void processDeployment(Set toAdd, DeploymentMetaData metaData) throws BuilderException {
        Deployment value = this.buildDeployment(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private Deployment buildDeployment(Deployment input, DeploymentMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Deployment)((Object)this.getDeploymentBuilder().build((Object)metaData));
    }

    public Builder getDeploymentBuilder() {
        return this.deploymentBuilder;
    }

    public void setDeploymentBuilder(Builder deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public Builder getMhDataSourceBuilder() {
        return this.mhDataSourceBuilder;
    }

    public void setMhDataSourceBuilder(Builder mhDataSourceBuilder) {
        this.mhDataSourceBuilder = mhDataSourceBuilder;
    }

    public Builder getTerminationReasonBuilder() {
        return this.terminationReasonBuilder;
    }

    public void setTerminationReasonBuilder(Builder terminationReasonBuilder) {
        this.terminationReasonBuilder = terminationReasonBuilder;
    }

    public Builder getNamedContingencyBuilder() {
        return this.namedContingencyBuilder;
    }

    public void setNamedContingencyBuilder(Builder namedContingencyBuilder) {
        this.namedContingencyBuilder = namedContingencyBuilder;
    }

    public Builder getSpecialOperationBuilder() {
        return this.specialOperationBuilder;
    }

    public void setSpecialOperationBuilder(Builder specialOperationBuilder) {
        this.specialOperationBuilder = specialOperationBuilder;
    }
}

