/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.NameMetaData;
import gov.va.med.esr.common.builder.entity.RelationMetaData;
import gov.va.med.esr.common.builder.entity.SSNMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.NameMetaDataFromIVM;
import gov.va.med.esr.common.builder.entity.metaData.SSNMetaDataFromIVM;
import gov.va.med.esr.service.external.person.RelationInfo;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class RelationMetaDataFromIVM
extends AbstractMetaData
implements RelationMetaData {
    private String impreciseDateFormat = "yyyyMMdd";
    private RelationInfo ivmRelationInfo;

    public RelationMetaDataFromIVM(RelationInfo ivmRelationInfo) {
        this.ivmRelationInfo = ivmRelationInfo;
    }

    @Override
    public String getDOB() {
        return this.ivmRelationInfo == null ? null : this.toStrImpreciseDateFormat(this.toImpreciseDateFormat(this.ivmRelationInfo.getDob()));
    }

    @Override
    public String getGender() {
        return this.ivmRelationInfo == null ? null : this.ivmRelationInfo.getGender();
    }

    @Override
    public NameMetaData getName() {
        return this.ivmRelationInfo == null ? null : new NameMetaDataFromIVM(this.ivmRelationInfo);
    }

    @Override
    public SSNMetaData getSsn() {
        if (this.ivmRelationInfo != null && this.ivmRelationInfo.getSsns() != null) {
            return new SSNMetaDataFromIVM(this.ivmRelationInfo.getSsns().getSsn()[0]);
        }
        return null;
    }

    @Override
    public String getEndDate() {
        return null;
    }

    @Override
    public String getStartDate() {
        return this.ivmRelationInfo == null ? null : this.ivmRelationInfo.getStartDate();
    }

    private String toStrImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.impreciseDateFormat);
            return format.format(date);
        }
        return "";
    }

    private Date toImpreciseDateFormat(String stringDate) {
        if (stringDate != null) {
            try {
                Date date = new SimpleDateFormat(this.impreciseDateFormat).parse(stringDate);
                return date;
            }
            catch (ParseException e) {
                e.printStackTrace();
                return null;
            }
        }
        return null;
    }
}

