/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.ConflictExperienceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.builder.entity.metaData.ConflictExperienceMetaDataFromZMH;
import gov.va.med.esr.common.builder.entity.metaData.MilitaryServiceEpisodeMetaDataFromZMH;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZMH;
import gov.va.med.fw.hl7.segment.ZPD;
import gov.va.med.fw.hl7.segment.ZSP;
import java.util.ArrayList;
import java.util.List;

public class MilitaryServiceSiteRecordMetaDataFromZMH
implements MilitaryServiceSiteRecordMetaData {
    private MilitaryServiceSiteRecord entity;
    private ConflictExperienceMetaData[] conflictExperiences;
    private MilitaryServiceEpisodeMetaData[] militaryServiceEpisodes;
    private MSH msh;
    private ZSP zsp;
    private ZPD zpd;

    public MilitaryServiceSiteRecordMetaDataFromZMH(MSH msh, ZSP zsp, ZPD zpd, List zmhs) {
        this.msh = msh;
        this.zpd = zpd;
        this.zsp = zsp;
        this.processZMHs(zmhs, zpd == null ? null : zpd.getFilipinoVeteranProof());
    }

    @Override
    public MilitaryServiceSiteRecord getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(MilitaryServiceSiteRecord entity) {
        this.entity = entity;
    }

    @Override
    public ConflictExperienceMetaData[] getConflictExperiences() {
        return this.conflictExperiences;
    }

    @Override
    public MilitaryServiceEpisodeMetaData[] getMilitaryServiceEpisodes() {
        return this.militaryServiceEpisodes;
    }

    @Override
    public String getServicePeriod() {
        return this.zsp == null ? null : this.zsp.getServicePeriod();
    }

    @Override
    public String getFilipinoVeteranProof() {
        return this.zpd == null ? null : this.zpd.getFilipinoVeteranProof();
    }

    @Override
    public String getSite() {
        return this.msh == null ? null : this.msh.getSendingFacility();
    }

    private void processZMHs(List zmhs, String filipinoVeteranProof) {
        ArrayList<ConflictExperienceMetaDataFromZMH> conflictExperiences = new ArrayList<ConflictExperienceMetaDataFromZMH>(7);
        ArrayList<MilitaryServiceEpisodeMetaDataFromZMH> militaryServiceEpisodes = new ArrayList<MilitaryServiceEpisodeMetaDataFromZMH>(zmhs.size());
        for (int index = 0; index < (zmhs == null ? 0 : zmhs.size()); ++index) {
            ZMH zmh = (ZMH)zmhs.get(index);
            String type = zmh.getMilitaryHistoryType();
            if (this.isCombatExperience(type)) {
                conflictExperiences.add(new ConflictExperienceMetaDataFromZMH(zmh));
                continue;
            }
            if (this.isMilitaryServiceEpisode(type)) {
                militaryServiceEpisodes.add(new MilitaryServiceEpisodeMetaDataFromZMH(zmh));
                continue;
            }
            if (!this.isConflictExperience(type)) continue;
            conflictExperiences.add(new ConflictExperienceMetaDataFromZMH(zmh));
        }
        this.conflictExperiences = conflictExperiences.toArray(new ConflictExperienceMetaData[0]);
        this.militaryServiceEpisodes = militaryServiceEpisodes.toArray(new MilitaryServiceEpisodeMetaData[0]);
    }

    private boolean isCombatExperience(String type) {
        return "COMB".equals(type);
    }

    private boolean isConflictExperience(String type) {
        return "VIET".equals(type) || "LEBA".equals(type) || "GREN".equals(type) || "PANA".equals(type) || "GULF".equals(type) || "SOMA".equals(type) || "YUGO".equals(type);
    }

    private boolean isMilitaryServiceEpisode(String type) {
        return "SL".equals(type) || "SNL".equals(type) || "SNNL".equals(type) || "MSD".equals(type);
    }
}

