/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.datatype.metadata.TN;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.InsurancePlanMetaData;
import gov.va.med.esr.common.builder.entity.InsurancePolicyMetaData;
import gov.va.med.esr.common.builder.entity.InsuranceSubscriberMetaData;
import gov.va.med.esr.common.builder.entity.PhoneMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AddressMetaDataFromAD;
import gov.va.med.esr.common.builder.entity.metaData.InsurancePlanMetaDataFromIN1;
import gov.va.med.esr.common.builder.entity.metaData.InsuranceSubscriberMetaDataFromIN1;
import gov.va.med.esr.common.builder.entity.metaData.PhoneMetaDataFromTN;
import gov.va.med.esr.common.model.lookup.PhoneType;
import gov.va.med.fw.hl7.segment.IN1;

public abstract class InsurancePolicyMetaDataFromIN1
extends AbstractMetaData
implements InsurancePolicyMetaData {
    private AddressMetaData address;
    private PhoneMetaData phone;
    private InsurancePlanMetaData plan;
    private InsuranceSubscriberMetaData subscriber;
    private String site;

    public InsurancePolicyMetaDataFromIN1(IN1 in1, String site) {
        this.site = site;
        this.address = in1 == null ? null : new AddressMetaDataFromAD(AD.create(in1.getInsuranceCompanyAddress(), in1.getComponentDelimiter()));
        this.phone = in1 == null ? null : new PhoneMetaDataFromTN(TN.create(in1.getInsuranceCompanyPhoneNumber()), PhoneType.CODE_BUSINESS.getName());
        this.plan = in1 == null ? null : new InsurancePlanMetaDataFromIN1(in1);
        this.subscriber = in1 == null ? null : new InsuranceSubscriberMetaDataFromIN1(in1);
    }

    @Override
    public AddressMetaData getAddress() {
        return this.address;
    }

    @Override
    public PhoneMetaData getBusinessPhone() {
        return this.phone;
    }

    @Override
    public InsurancePlanMetaData getPlan() {
        return this.plan;
    }

    @Override
    public InsuranceSubscriberMetaData getSubscriber() {
        return this.subscriber;
    }

    @Override
    public String getReportSite() {
        return this.site;
    }
}

