/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.FT;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.HardshipMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.HardshipMetaDataFromZMT;
import gov.va.med.esr.common.builder.entity.metaData.IncomeTestStatusMetaDataFromZMT;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.fw.hl7.segment.NTE;
import gov.va.med.fw.hl7.segment.ZIC;
import gov.va.med.fw.hl7.segment.ZMT;
import gov.va.med.fw.hl7.segment.ZPD;
import java.util.ArrayList;
import java.util.List;

public class IncomeTestMetaDataFromZMT
extends AbstractMetaData
implements IncomeTestMetaData {
    private IncomeTest entity;
    private ZIC zic;
    private ZMT zmt;
    private ZPD zpd;
    private HardshipMetaData hardship;
    private IncomeTestStatusMetaData[] statuses;
    private String comments;
    private String site;
    private boolean containsDeleteRequest = false;

    public IncomeTestMetaDataFromZMT(ZPD zpd, List zmts, List ntes, ZIC zic, String site) {
        this.processZMTs(zmts);
        this.zic = zic;
        this.hardship = this.zmt == null ? null : new HardshipMetaDataFromZMT(this.zmt);
        this.site = site;
        this.comments = this.processComments(ntes);
        this.zpd = zpd;
    }

    private String processComments(List ntes) {
        String result = null;
        for (int nteIndex = 0; nteIndex < (ntes == null ? 0 : ntes.size()); ++nteIndex) {
            NTE nte = (NTE)ntes.get(nteIndex);
            FT[] fts = FT.create(nte.getComment(), nte.getRepeatDelimiter());
            for (int ftIndex = 0; ftIndex < (fts == null ? 0 : fts.length); ++ftIndex) {
                String comment = fts[ftIndex].getDataString();
                if (comment == null || comment.length() <= 0 || "\"\"".equals(comment)) continue;
                result = (result == null ? "" : result + "\n") + comment;
            }
        }
        return result;
    }

    private boolean isDeleteRequest(ZMT zmt) {
        return zmt.getMeansTestDate() != null && !zmt.getMeansTestDate().equals("") && zmt.getMeansTestStatus().equals("");
    }

    private void processZMTs(List zmts) {
        ArrayList<IncomeTestStatusMetaDataFromZMT> filledZMTs = new ArrayList<IncomeTestStatusMetaDataFromZMT>();
        for (int index = 0; index < (zmts == null ? 0 : zmts.size()); ++index) {
            ZMT zmt = (ZMT)zmts.get(index);
            if (this.isDeleteRequest(zmt)) {
                this.zmt = null;
                filledZMTs.clear();
                this.containsDeleteRequest = true;
                break;
            }
            if (zmt.getMeansTestDate() == null || zmt.getMeansTestDate().equals("")) continue;
            if (this.zmt == null) {
                this.zmt = zmt;
            }
            filledZMTs.add(new IncomeTestStatusMetaDataFromZMT(zmt));
        }
        this.statuses = new IncomeTestStatusMetaData[filledZMTs.size()];
        if (filledZMTs.size() > 0) {
            this.statuses = filledZMTs.toArray(this.statuses);
        }
    }

    @Override
    public IncomeTest getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(IncomeTest entity) {
        this.entity = entity;
    }

    @Override
    public String getAdjudicationDate() {
        return this.zmt == null ? null : this.zmt.getAdjudicationDate();
    }

    @Override
    public String getAgreesToPayDeductible() {
        return this.zmt == null ? null : this.zmt.getAgreedToPayDeductible();
    }

    @Override
    public String getComments() {
        return this.comments;
    }

    @Override
    public String getDateMTNoLongerRequired() {
        return null;
    }

    @Override
    public String getDeductibleExpenses() {
        return this.zmt == null ? null : this.zmt.getDeductibleExpenses();
    }

    @Override
    public String getDiscloseFinancialInformation() {
        if (this.zmt == null) {
            return null;
        }
        if ("0".equals(this.zmt.getDeclinesToGiveIncomeInfo()) || "N".equals(this.zmt.getDeclinesToGiveIncomeInfo())) {
            return "1";
        }
        if ("1".equals(this.zmt.getDeclinesToGiveIncomeInfo()) || "Y".equals(this.zmt.getDeclinesToGiveIncomeInfo())) {
            return "0";
        }
        return "1";
    }

    @Override
    public String getEffectiveDate() {
        return this.zmt == null ? null : this.zmt.getMeansTestDate();
    }

    @Override
    public AddressMetaData getGMTAddress() {
        return null;
    }

    @Override
    public String getGMTThresholdAmount() {
        return this.zmt == null ? null : this.zmt.getGmtThreshold();
    }

    @Override
    public HardshipMetaData getHardship() {
        return this.hardship;
    }

    @Override
    public String getIncomeVerificationStatus() {
        return null;
    }

    @Override
    public String getIncomeVerificationStatusDate() {
        return this.zmt == null ? null : this.zmt.getIvmVerifiedMTCompletedDate();
    }

    @Override
    public String getIncomeYear() {
        return this.zic == null ? null : this.zic.getIncomeYear();
    }

    @Override
    public String getIVMTestCompletionDate() {
        return null;
    }

    @Override
    public String getNetWorth() {
        return this.zmt == null ? null : this.zmt.getNetWorth();
    }

    @Override
    public String getPreviousYearThresholdApplies() {
        return this.zmt == null ? null : this.zmt.getPreviousYearMTThresholdFlag();
    }

    @Override
    public String getPrimaryIncomeTest() {
        return this.zmt == null ? null : this.zmt.getPrimaryTest();
    }

    @Override
    public String getReasonMTNoLongerRequired() {
        return null;
    }

    @Override
    public String getRefusedToSign() {
        return this.zmt == null ? null : this.zmt.getRefusedToSign();
    }

    @Override
    public String getSignatureDate() {
        return this.zmt == null ? null : this.zmt.getVeteranTestSignedDate();
    }

    @Override
    public String getSiteConductingTest() {
        return this.zmt == null ? null : this.zmt.getTestConductingSite();
    }

    @Override
    public String getSource() {
        return this.zmt == null ? null : this.zmt.getTestSource();
    }

    @Override
    public IncomeTestStatusMetaData[] getStatuses() {
        return this.statuses;
    }

    @Override
    public String getThresholdA() {
        return this.zmt == null ? null : this.zmt.getThresholdA();
    }

    @Override
    public String getTotalIncome() {
        return this.zmt == null ? null : this.zmt.getIncome();
    }

    @Override
    public String getTotalNumberOfDependents() {
        return this.zmt == null ? null : this.zmt.getTotalDependents();
    }

    @Override
    public String getType() {
        return this.zmt == null ? null : this.zmt.getTestType();
    }

    @Override
    public String getSite() {
        return this.site;
    }

    @Override
    public String getRxCopayExemptionStatus() {
        return this.zpd == null ? null : this.zpd.getMedicationCopayExemptionStatus();
    }

    @Override
    public boolean isContainsDeleteRequest() {
        return this.containsDeleteRequest;
    }

    @Override
    public String getIVMConversionDate() {
        return null;
    }

    @Override
    public String getPg8RelaxationIndicator() {
        return null;
    }

    @Override
    public String getIvmCaseStatus() {
        return null;
    }

    @Override
    public String getBtFinancialInd() {
        return null;
    }
}

