/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.HardshipMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestMetaData;
import gov.va.med.esr.common.builder.entity.IncomeTestStatusMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.builder.entity.metaData.IncomeTestStatusMetaDataFromIVM;
import gov.va.med.esr.common.model.financials.IncomeTest;
import gov.va.med.esr.service.external.person.IncomeTestInfo;
import gov.va.med.esr.service.external.person.IncomeTestStatusInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class IncomeTestMetaDataFromIVM
extends AbstractMetaData
implements IncomeTestMetaData {
    private IncomeTest entity;
    private IncomeTestInfo ivmIncomeTestInfo;
    private IncomeTestStatusMetaData[] statuses;
    private String site;
    private boolean containsDeleteRequest = false;
    private String impreciseDateFormat = "yyyyMMdd";
    private String incomeYear;

    public IncomeTestMetaDataFromIVM(IncomeTestInfo ivmIncomeTestInfo, String actionCode, Integer incomeYear) {
        this.processIncomeTestInfo(ivmIncomeTestInfo, actionCode);
        this.site = null;
        this.incomeYear = incomeYear == null ? null : incomeYear.toString();
    }

    private boolean isDeleteRequest(String actionCode) {
        return actionCode.equals("R");
    }

    private void processIncomeTestInfo(IncomeTestInfo ivmIncomeTestInfo, String actionCode) {
        ArrayList<IncomeTestStatusMetaDataFromIVM> filledStatus = new ArrayList<IncomeTestStatusMetaDataFromIVM>();
        if (this.isDeleteRequest(actionCode)) {
            ivmIncomeTestInfo = null;
            this.containsDeleteRequest = true;
        } else {
            this.ivmIncomeTestInfo = ivmIncomeTestInfo;
            if (ivmIncomeTestInfo != null && ivmIncomeTestInfo.getStatuses() != null) {
                for (int index = 0; index < (ivmIncomeTestInfo.getStatuses().getStatus() == null ? 0 : ivmIncomeTestInfo.getStatuses().getStatus().length); ++index) {
                    IncomeTestStatusInfo status = ivmIncomeTestInfo.getStatuses().getStatus()[index];
                    filledStatus.add(new IncomeTestStatusMetaDataFromIVM(status));
                }
            }
            this.statuses = new IncomeTestStatusMetaData[filledStatus.size()];
            if (filledStatus.size() > 0) {
                this.statuses = filledStatus.toArray(this.statuses);
            }
        }
        this.statuses = new IncomeTestStatusMetaData[filledStatus.size()];
        if (filledStatus.size() > 0) {
            this.statuses = filledStatus.toArray(this.statuses);
        }
    }

    @Override
    public IncomeTest getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(IncomeTest entity) {
        this.entity = entity;
    }

    @Override
    public String getAdjudicationDate() {
        return null;
    }

    @Override
    public String getAgreesToPayDeductible() {
        return this.ivmIncomeTestInfo == null ? null : (this.ivmIncomeTestInfo.getAgreesToPayDeductible() == null ? null : (this.ivmIncomeTestInfo.getAgreesToPayDeductible() != false ? "Y" : "N"));
    }

    @Override
    public String getComments() {
        return null;
    }

    @Override
    public String getDateMTNoLongerRequired() {
        return null;
    }

    @Override
    public String getDeductibleExpenses() {
        return null;
    }

    @Override
    public String getDiscloseFinancialInformation() {
        return null;
    }

    @Override
    public String getEffectiveDate() {
        return this.ivmIncomeTestInfo == null ? null : this.toImpreciseDateFormat(this.ivmIncomeTestInfo.getEffectiveDate());
    }

    @Override
    public AddressMetaData getGMTAddress() {
        return null;
    }

    @Override
    public String getGMTThresholdAmount() {
        return null;
    }

    @Override
    public HardshipMetaData getHardship() {
        return null;
    }

    @Override
    public String getIncomeVerificationStatus() {
        return null;
    }

    @Override
    public String getIncomeVerificationStatusDate() {
        return null;
    }

    @Override
    public String getIncomeYear() {
        return this.incomeYear;
    }

    @Override
    public String getIVMTestCompletionDate() {
        return this.ivmIncomeTestInfo == null ? null : this.toImpreciseDateFormat(this.ivmIncomeTestInfo.getIvmTestCompletionDate());
    }

    @Override
    public String getNetWorth() {
        return null;
    }

    @Override
    public String getPreviousYearThresholdApplies() {
        return null;
    }

    @Override
    public String getPrimaryIncomeTest() {
        return null;
    }

    @Override
    public String getReasonMTNoLongerRequired() {
        return null;
    }

    @Override
    public String getRefusedToSign() {
        return null;
    }

    @Override
    public String getSignatureDate() {
        return null;
    }

    @Override
    public String getSiteConductingTest() {
        return null;
    }

    @Override
    public String getSource() {
        return this.ivmIncomeTestInfo == null ? null : "2";
    }

    @Override
    public IncomeTestStatusMetaData[] getStatuses() {
        return this.statuses;
    }

    @Override
    public String getThresholdA() {
        return this.ivmIncomeTestInfo == null ? null : (this.ivmIncomeTestInfo.getThresholdA() == null ? null : this.ivmIncomeTestInfo.getThresholdA().toString());
    }

    @Override
    public String getTotalIncome() {
        return null;
    }

    @Override
    public String getTotalNumberOfDependents() {
        return this.ivmIncomeTestInfo == null ? null : (this.ivmIncomeTestInfo.getTotalNumberOfDependents() == null ? null : this.ivmIncomeTestInfo.getTotalNumberOfDependents().toString());
    }

    @Override
    public String getType() {
        return this.ivmIncomeTestInfo == null ? null : this.processIncomingCode(this.ivmIncomeTestInfo.getIncomeTestType());
    }

    @Override
    public String getSite() {
        return null;
    }

    @Override
    public String getRxCopayExemptionStatus() {
        return null;
    }

    @Override
    public boolean isContainsDeleteRequest() {
        return this.containsDeleteRequest;
    }

    @Override
    public String getIVMConversionDate() {
        return this.ivmIncomeTestInfo == null ? null : this.toImpreciseDateFormat(this.ivmIncomeTestInfo.getIvmConversionDate());
    }

    @Override
    public String getPg8RelaxationIndicator() {
        return this.ivmIncomeTestInfo == null ? null : (this.ivmIncomeTestInfo.getPriorityGroup8Relaxation() == null ? null : (this.ivmIncomeTestInfo.getPriorityGroup8Relaxation() != false ? "Y" : "N"));
    }

    @Override
    public String getIvmCaseStatus() {
        return this.ivmIncomeTestInfo == null ? null : (this.ivmIncomeTestInfo.getIvmCaseStatus() == null ? null : this.ivmIncomeTestInfo.getIvmCaseStatus().toString());
    }

    @Override
    public String getBtFinancialInd() {
        return null;
    }

    private String toImpreciseDateFormat(Date date) {
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(this.impreciseDateFormat);
            return format.format(date);
        }
        return "";
    }

    private String processIncomingCode(String incomingCode) {
        if (incomingCode != null) {
            int separatorLoc = incomingCode.indexOf("^");
            if (separatorLoc < 0) {
                return incomingCode.startsWith("0") ? incomingCode.substring(1) : incomingCode;
            }
            return incomingCode.startsWith("0") ? incomingCode.substring(1, separatorLoc) : incomingCode.substring(0, separatorLoc);
        }
        return incomingCode;
    }
}

