/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.entity.DeathRecordMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.person.DeathRecord;
import gov.va.med.fw.hl7.segment.MSH;
import gov.va.med.fw.hl7.segment.ZPD;

public class DeathRecordMetaDataFromZPD
extends AbstractMetaData
implements DeathRecordMetaData {
    private DeathRecord entity;
    private ZPD zpd;
    private MSH msh;
    private boolean lazarus;

    public DeathRecordMetaDataFromZPD(ZPD zpd, MSH msh, boolean lazarus) {
        this.zpd = zpd;
        this.msh = msh;
        this.lazarus = lazarus;
    }

    @Override
    public DeathRecord getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(DeathRecord entity) {
        this.entity = entity;
    }

    @Override
    public String getDataSource() {
        return this.zpd == null ? null : this.zpd.getNotificationSource();
    }

    @Override
    public String getDeathDate() {
        return this.zpd == null || this.lazarus ? null : this.zpd.getDeathDate();
    }

    @Override
    public String getDeathReportDate() {
        return this.zpd == null ? null : this.zpd.getLastModifiedDate();
    }

    @Override
    public String getFacilityReceived() {
        return this.msh == null ? null : this.msh.getSendingFacility();
    }

    @Override
    public String getLazarusDate() {
        return this.zpd == null || !this.lazarus ? null : this.zpd.getDeathDate();
    }
}

