/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.XAD;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.party.Address;

public class AddressMetaDataFromXAD
extends AbstractMetaData
implements AddressMetaData {
    private Address entity;
    private XAD xad;
    private String country;
    private String postalCode;
    private String province;
    private String state;
    private String zipCode;
    private String zipPlus4;
    private String startDate;
    private String endDate;
    private String status;

    public AddressMetaDataFromXAD(XAD xad) {
        this.xad = xad;
        if (xad != null) {
            this.setStartAndEndDates();
            this.country = super.getValue(xad.getCountryCode());
            if (Country.isUSAddress(this.country)) {
                this.postalCode = null;
                this.province = null;
                this.state = super.getValue(xad.getState());
                this.processZipCode(super.getValue(xad.getZipCode()));
            } else {
                this.postalCode = super.getValue(xad.getZipCode());
                this.province = super.getValue(xad.getState());
                this.state = null;
                this.zipCode = null;
                this.zipPlus4 = null;
            }
        }
    }

    private void setStartAndEndDates() {
        String startAndEndDateFromXAD;
        if (this.xad != null && (startAndEndDateFromXAD = super.getValue(this.xad.getAddressValidityRange())) != null) {
            String[] dateComponents = startAndEndDateFromXAD.split("&");
            String string = dateComponents == null ? null : (this.startDate = dateComponents.length > 0 ? dateComponents[0] : null);
            this.endDate = dateComponents == null ? null : (dateComponents.length > 1 ? dateComponents[1] : null);
        }
    }

    private void processZipCode(String value) {
        if (value == null) {
            this.zipCode = null;
            this.zipPlus4 = null;
        } else {
            String[] zipComponents = value.split("\\-");
            if (zipComponents.length == 1) {
                if (zipComponents[0].length() > 5) {
                    this.zipCode = zipComponents[0].substring(0, 5);
                    this.zipPlus4 = zipComponents[0].substring(5);
                } else {
                    this.zipCode = zipComponents[0];
                    this.zipPlus4 = null;
                }
            } else {
                this.zipCode = zipComponents[0];
                this.zipPlus4 = zipComponents[1];
            }
        }
    }

    @Override
    public Address getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Address entity) {
        this.entity = entity;
    }

    @Override
    public String getChangeDate() {
        return this.getStartDate();
    }

    @Override
    public String getChangeSite() {
        return null;
    }

    @Override
    public String getChangeSource() {
        return null;
    }

    @Override
    public String getCity() {
        return super.getValue(this.xad == null ? null : this.xad.getCity());
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getCounty() {
        return super.getValue(this.xad == null ? null : this.xad.getCountyParishCode());
    }

    @Override
    public String getLine1() {
        return super.getValue(this.xad == null ? null : this.xad.getStreetAddress());
    }

    @Override
    public String getLine2() {
        return super.getValue(this.xad == null ? null : this.xad.getOtherDesignation());
    }

    @Override
    public String getLine3() {
        return super.getValue(this.xad == null ? null : this.xad.getOtherGeographicDesignation());
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getProvince() {
        return this.province;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getType() {
        return super.getValue(this.xad == null ? null : this.xad.getTypeCode());
    }

    @Override
    public String getZipCode() {
        return this.zipCode;
    }

    @Override
    public String getZipPlus4() {
        return this.zipPlus4;
    }

    @Override
    public String getEndDate() {
        return this.endDate;
    }

    @Override
    public String getStartDate() {
        return this.startDate;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getTemporaryAddressPhoneNumber() {
        return null;
    }
}

