/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity.metaData;

import gov.va.med.esr.common.builder.datatype.metadata.AD;
import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.metaData.AbstractMetaData;
import gov.va.med.esr.common.model.lookup.Country;
import gov.va.med.esr.common.model.party.Address;

public class AddressMetaDataFromAD
extends AbstractMetaData
implements AddressMetaData {
    private Address entity;
    private AD ad;
    private String country;
    private String postalCode;
    private String province;
    private String state;
    private String zipCode;
    private String zipPlus4;
    private String status;

    public AddressMetaDataFromAD(AD ad) {
        this.ad = ad;
        if (ad != null) {
            this.country = super.getValue(ad.getCountryCode());
            if (Country.isUSAddress(this.country)) {
                this.postalCode = null;
                this.province = null;
                this.state = super.getValue(ad.getState());
                this.processZipCode(super.getValue(ad.getZipCode()));
            } else {
                this.postalCode = super.getValue(ad.getZipCode());
                this.province = super.getValue(ad.getState());
                this.state = null;
                this.zipCode = null;
                this.zipPlus4 = null;
            }
        } else {
            this.country = null;
            this.postalCode = null;
            this.province = null;
            this.state = null;
            this.zipCode = null;
            this.zipPlus4 = null;
        }
    }

    private void processZipCode(String value) {
        if (value == null) {
            this.zipCode = null;
            this.zipPlus4 = null;
        } else {
            String[] zipComponents = value.split("\\-");
            if (zipComponents.length == 1) {
                if (zipComponents[0].length() > 5) {
                    this.zipCode = zipComponents[0].substring(0, 5);
                    this.zipPlus4 = zipComponents[0].substring(5);
                } else {
                    this.zipCode = zipComponents[0];
                    this.zipPlus4 = null;
                }
            } else {
                this.zipCode = zipComponents[0];
                this.zipPlus4 = zipComponents[1];
            }
        }
    }

    @Override
    public Address getEntity() {
        return this.entity;
    }

    @Override
    public void setEntity(Address entity) {
        this.entity = entity;
    }

    @Override
    public String getChangeDate() {
        return null;
    }

    @Override
    public String getChangeSite() {
        return null;
    }

    @Override
    public String getChangeSource() {
        return null;
    }

    @Override
    public String getCity() {
        return super.getValue(this.ad == null ? null : this.ad.getCity());
    }

    @Override
    public String getCountry() {
        return this.country;
    }

    @Override
    public String getCounty() {
        return null;
    }

    @Override
    public String getLine1() {
        return super.getValue(this.ad == null ? null : this.ad.getStreetAddress());
    }

    @Override
    public String getLine2() {
        return super.getValue(this.ad == null ? null : this.ad.getOtherDesignation());
    }

    @Override
    public String getLine3() {
        return super.getValue(this.ad == null ? null : this.ad.getOtherGeographicDesignation());
    }

    @Override
    public String getPostalCode() {
        return this.postalCode;
    }

    @Override
    public String getProvince() {
        return this.province;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getZipCode() {
        return this.zipCode;
    }

    @Override
    public String getZipPlus4() {
        return this.zipPlus4;
    }

    @Override
    public String getEndDate() {
        return null;
    }

    @Override
    public String getStartDate() {
        return null;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public String getTemporaryAddressPhoneNumber() {
        return null;
    }
}

