/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.service.LookupService;
import gov.va.med.fw.service.ServiceException;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;
import org.apache.commons.lang.Validate;

public class VAFacilityBuilder
extends AbstractBuilder {
    private static final long serialVersionUID = 6236921693595290415L;
    private LookupService lookupService;

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Validate.notNull((Object)this.lookupService, (String)"A lookup service must be configured");
    }

    public LookupService getLookupService() {
        return this.lookupService;
    }

    public void setLookupService(LookupService lookupService) {
        this.lookupService = lookupService;
    }

    public VAFacility build(String stationNumber) throws BuilderException {
        try {
            return this.getVAFacilityByStationNumber(stationNumber);
        }
        catch (ServiceException e) {
            throw new BuilderException((Throwable)e);
        }
    }

    private VAFacility getVAFacilityByStationNumber(String stationNumber) throws ServiceException {
        return stationNumber == null ? null : this.lookupService.getVaFacilityByStationNumber(stationNumber);
    }
}

