/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.MonetaryBenefitAwardMetaData;
import gov.va.med.esr.common.builder.entity.MonetaryBenefitMetaData;
import gov.va.med.esr.common.builder.entity.metaData.MonetaryBenefitAwardMetaDataFromZEL;
import gov.va.med.esr.common.model.ee.MonetaryBenefit;
import gov.va.med.esr.common.model.ee.MonetaryBenefitAward;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.hl7.HL7Message;
import gov.va.med.fw.hl7.InvalidMessageException;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MonetaryBenefitAwardBuilder
extends EntityBuilder {
    private static final long serialVersionUID = -7222898023852297548L;
    private Builder monetaryBenefitBuilder;

    public Builder getMonetaryBenefitBuilder() {
        return this.monetaryBenefitBuilder;
    }

    public void setMonetaryBenefitBuilder(Builder monetaryBenefitBuilder) {
        this.monetaryBenefitBuilder = monetaryBenefitBuilder;
    }

    public MonetaryBenefitAward build(Person person, HL7Message message) throws BuilderException, InvalidMessageException {
        MonetaryBenefitAward award = person.getMonetaryBenefitAward();
        MonetaryBenefitAwardMetaDataFromZEL metaData = new MonetaryBenefitAwardMetaDataFromZEL(message.getZELSegment());
        metaData.setEntity(award);
        return this.build(metaData);
    }

    public MonetaryBenefitAward build(MonetaryBenefitAwardMetaData metaData) throws BuilderException {
        MonetaryBenefitAward input = metaData.getEntity();
        MonetaryBenefitAward output = input == null ? new MonetaryBenefitAward() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output.getCheckAmount()) ? output : null;
    }

    private MonetaryBenefit buildMonetaryBenefit(MonetaryBenefit input, MonetaryBenefitMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (MonetaryBenefit)((Object)this.monetaryBenefitBuilder.build((Object)metaData));
    }

    private void buildMonetaryBenefits(MonetaryBenefitAward input, MonetaryBenefitMetaData[] metaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processMonetaryBenefit(toAdd, metaData[index]);
        }
        input.removeAllMonetaryBenefits();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addMonetaryBenefit((MonetaryBenefit)((Object)i.next()));
        }
    }

    private void processMonetaryBenefit(Set toAdd, MonetaryBenefitMetaData metaData) throws BuilderException {
        MonetaryBenefit value = this.buildMonetaryBenefit(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private void transfer(MonetaryBenefitAward input, MonetaryBenefitAwardMetaData metaData) throws BuilderException {
        input.setCheckAmount(super.build(input.getCheckAmount(), metaData.getCheckAmount()));
        this.buildMonetaryBenefits(input, metaData.getMonetaryBenefits());
    }
}

