/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.ConflictExperienceMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.builder.entity.MilitaryServiceEpisodeMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceMetaData;
import gov.va.med.esr.common.builder.entity.MilitaryServiceSiteRecordMetaData;
import gov.va.med.esr.common.model.ee.ConflictExperience;
import gov.va.med.esr.common.model.ee.MilitaryService;
import gov.va.med.esr.common.model.ee.MilitaryServiceEpisode;
import gov.va.med.esr.common.model.ee.MilitaryServiceSiteRecord;
import gov.va.med.esr.common.model.lookup.FilipinoVeteranProof;
import gov.va.med.esr.common.model.lookup.ServicePeriod;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class MilitaryServiceBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 1331488433797205274L;
    private Builder conflictExperienceBuilder;
    private Builder serviceEpisodeBuilder;
    private Builder servicePeriodBuilder;
    private Builder filipinoVeteranProofBuilder;

    public Builder getConflictExperienceBuilder() {
        return this.conflictExperienceBuilder;
    }

    public void setConflictExperienceBuilder(Builder conflictExperienceBuilder) {
        this.conflictExperienceBuilder = conflictExperienceBuilder;
    }

    public Builder getServiceEpisodeBuilder() {
        return this.serviceEpisodeBuilder;
    }

    public void setServiceEpisodeBuilder(Builder serviceEpisodeBuilder) {
        this.serviceEpisodeBuilder = serviceEpisodeBuilder;
    }

    public Builder getServicePeriodBuilder() {
        return this.servicePeriodBuilder;
    }

    public void setServicePeriodBuilder(Builder servicePeriodBuilder) {
        this.servicePeriodBuilder = servicePeriodBuilder;
    }

    public Builder getFilipinoVeteranProofBuilder() {
        return this.filipinoVeteranProofBuilder;
    }

    public void setFilipinoVeteranProofBuilder(Builder filipinoVeteranProofBuilder) {
        this.filipinoVeteranProofBuilder = filipinoVeteranProofBuilder;
    }

    public MilitaryService build(MilitaryServiceMetaData metaData) throws BuilderException {
        MilitaryService input = metaData.getEntity();
        MilitaryService output = input == null ? new MilitaryService() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private ConflictExperience buildConflictExperience(ConflictExperience input, ConflictExperienceMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (ConflictExperience)((Object)this.conflictExperienceBuilder.build((Object)metaData));
    }

    private void buildConflictExperiences(MilitaryServiceSiteRecord input, MilitaryServiceSiteRecordMetaData militaryServiceSiteRecordMetaData) throws BuilderException {
        ConflictExperienceMetaData[] metaData = militaryServiceSiteRecordMetaData.getConflictExperiences();
        HashSet toAdd = new HashSet();
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processConflictExperience(toAdd, metaData[index]);
        }
        input.removeAllConflictExperiences();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addConflictExperience((ConflictExperience)((Object)i.next()));
        }
    }

    private MilitaryServiceEpisode buildServiceEpisode(MilitaryServiceEpisode input, MilitaryServiceEpisodeMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (MilitaryServiceEpisode)((Object)this.serviceEpisodeBuilder.build((Object)metaData));
    }

    private void buildMilitaryServiceEpisodes(MilitaryServiceSiteRecord input, MilitaryServiceSiteRecordMetaData militaryServiceSiteRecordMetaData) throws BuilderException {
        MilitaryServiceEpisodeMetaData[] metaData = militaryServiceSiteRecordMetaData.getMilitaryServiceEpisodes();
        HashSet toAdd = new HashSet();
        HashSet toRemove = new HashSet(input.getMilitaryServiceEpisodes());
        for (int index = 0; index < (metaData == null ? 0 : metaData.length); ++index) {
            this.processServiceEpisode(toAdd, metaData[index]);
        }
        Iterator i = toRemove.iterator();
        while (i.hasNext()) {
            input.removeMilitaryServiceEpisode((MilitaryServiceEpisode)((Object)i.next()));
        }
        i = toAdd.iterator();
        while (i.hasNext()) {
            input.addMilitaryServiceEpisode((MilitaryServiceEpisode)((Object)i.next()));
        }
    }

    private ServicePeriod buildServicePeriod(ServicePeriod input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (ServicePeriod)super.build(this.servicePeriodBuilder, (AbstractLookup)input, code);
    }

    private boolean shouldKeep(MilitaryService obj) {
        return true;
    }

    private void processConflictExperience(Set toAdd, ConflictExperienceMetaData metaData) throws BuilderException {
        Boolean shouldAdd;
        ConflictExperience value = this.buildConflictExperience(null, metaData);
        if (value != null && Boolean.TRUE.equals(shouldAdd = super.build(new Boolean(value != null), metaData.getIndicator()))) {
            toAdd.add(value);
        }
    }

    private void processServiceEpisode(Set toAdd, MilitaryServiceEpisodeMetaData metaData) throws BuilderException {
        MilitaryServiceEpisode value = this.buildServiceEpisode(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private void transfer(MilitaryService input, MilitaryServiceMetaData metaData) throws BuilderException {
        input.setCombatVeteranEligibilityEndDate(super.build(input.getCombatVeteranEligibilityEndDate(), metaData.getCombatVeteranEligibilityEndDate()));
        input.setDisabilityRetirementIndicator(super.build(input.getDisabilityRetirementIndicator(), metaData.getDisabilityRetirementStatus()));
        input.setDischargeDueToDisability(super.build(input.getDischargeDueToDisability(), metaData.getDischargeDueToDisability()));
        this.buildMilitaryServiceSiteRecords(input, metaData.getMilitaryServiceSiteRecord());
    }

    private void buildMilitaryServiceSiteRecords(MilitaryService input, MilitaryServiceSiteRecordMetaData militaryServiceSiteRecordMetaData) throws BuilderException {
        HashSet toAdd = new HashSet();
        this.processMilitaryServiceSiteRecord(toAdd, militaryServiceSiteRecordMetaData);
        input.removeAllMilitaryServiceSiteRecords();
        Iterator i = toAdd.iterator();
        while (i.hasNext()) {
            input.addMilitaryServiceSiteRecord((MilitaryServiceSiteRecord)((Object)i.next()));
        }
    }

    private void processMilitaryServiceSiteRecord(Set toAdd, MilitaryServiceSiteRecordMetaData metaData) throws BuilderException {
        MilitaryServiceSiteRecord value = this.buildMilitaryServiceSiteRecord(null, metaData);
        if (value != null) {
            toAdd.add(value);
        }
    }

    private MilitaryServiceSiteRecord buildMilitaryServiceSiteRecord(MilitaryServiceSiteRecord input, MilitaryServiceSiteRecordMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        if (input == null) {
            input = new MilitaryServiceSiteRecord();
        }
        metaData.setEntity(input);
        input.setSite(this.build(input.getSite(), metaData.getSite()));
        input.setServicePeriod(this.buildServicePeriod(input.getServicePeriod(), metaData.getServicePeriod()));
        input.setFilipinoVeteranProof(this.buildFilipinoVeteranProof(input.getFilipinoVeteranProof(), metaData.getFilipinoVeteranProof()));
        this.buildConflictExperiences(input, metaData);
        this.buildMilitaryServiceEpisodes(input, metaData);
        return input;
    }

    private FilipinoVeteranProof buildFilipinoVeteranProof(FilipinoVeteranProof input, String code) throws BuilderException {
        return super.shouldDelete(code) ? null : (FilipinoVeteranProof)super.build(this.filipinoVeteranProofBuilder, (AbstractLookup)input, code);
    }
}

