/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.infra.ImpreciseDate;
import gov.va.med.fw.util.builder.AbstractBuilder;
import gov.va.med.fw.util.builder.BuilderException;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImpreciseDateBuilder
extends AbstractBuilder {
    private static final long serialVersionUID = -6032144500184433040L;
    private static final String PATTERN = "([0-9]{4})(?:([0-9]{2})(?:([0-9]{2})(?:([0-9]{2})(?:([0-9]{2})(?:([0-9]{2})(?:[.]([0-9]{0,4})?)?)?)?)?)?)?([\\+\\-][0-9]{4})?";
    private static final int GROUP_YEAR = 1;
    private static final int GROUP_MONTH = 2;
    private static final int GROUP_DAY = 3;
    private static final int GROUP_HOUR = 4;
    private static final int GROUP_MINUTE = 5;
    private static final int GROUP_SECOND = 6;
    private static final int GROUP_FRACTIONAL_SECOND = 7;
    private static final int GROUP_TIMEZONE = 8;
    private boolean standardizeDate;

    public boolean isStandardizeDate() {
        return this.standardizeDate;
    }

    public void setStandardizeDate(boolean standardizeDate) {
        this.standardizeDate = standardizeDate;
    }

    public ImpreciseDate build(String value) throws BuilderException {
        return value == null ? null : this.parseString(value);
    }

    private int convertToInt(String string) {
        return new Integer(string);
    }

    protected ImpreciseDate parseString(String string) throws BuilderException {
        Matcher matcher = Pattern.compile(PATTERN).matcher(string);
        if (matcher.matches()) {
            String year = matcher.group(1);
            String month = matcher.group(2);
            String day = matcher.group(3);
            String hour = matcher.group(4);
            String minute = matcher.group(5);
            String second = matcher.group(6);
            String fractionalSecond = matcher.group(7);
            String timeZone = matcher.group(8);
            Calendar calendar = Calendar.getInstance();
            calendar.setLenient(false);
            calendar.clear();
            if (year != null && !"0000".equals(year)) {
                calendar.set(1, this.convertToInt(year));
            }
            if (month != null && !"00".equals(month)) {
                calendar.set(2, this.convertToInt(month) - 1);
            }
            if (day != null && !"00".equals(day)) {
                calendar.set(5, this.convertToInt(day));
            }
            if (hour != null) {
                calendar.set(11, this.convertToInt(hour));
            }
            if (minute != null) {
                calendar.set(12, this.convertToInt(minute));
            }
            if (second != null) {
                calendar.set(13, this.convertToInt(second));
            }
            if (fractionalSecond != null) {
                double factor = fractionalSecond.length() == 1 ? 100.0 : (fractionalSecond.length() == 2 ? 10.0 : (fractionalSecond.length() == 3 ? 1.0 : 0.1));
                calendar.set(14, (int)Math.round((double)this.convertToInt(fractionalSecond) * factor));
            }
            if (this.isStandardizeDate() && timeZone != null) {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT" + timeZone));
            }
            return new ImpreciseDate(calendar);
        }
        throw new BuilderException("the string " + string + " is in an invalid imprecise date format");
    }
}

