/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.AddressMetaData;
import gov.va.med.esr.common.builder.entity.EmploymentMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.lookup.EmploymentStatus;
import gov.va.med.esr.common.model.party.Address;
import gov.va.med.esr.common.model.person.Employment;
import gov.va.med.fw.model.lookup.AbstractLookup;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class EmploymentBuilder
extends EntityBuilder {
    private static final long serialVersionUID = 1996420792810099901L;
    private Builder addressBuilder;
    private Builder employmentStatusBuilder;

    public Builder getAddressBuilder() {
        return this.addressBuilder;
    }

    public void setAddressBuilder(Builder addressBuilder) {
        this.addressBuilder = addressBuilder;
    }

    public Builder getEmploymentStatusBuilder() {
        return this.employmentStatusBuilder;
    }

    public void setEmploymentStatusBuilder(Builder employmentStatusBuilder) {
        this.employmentStatusBuilder = employmentStatusBuilder;
    }

    public Employment build(EmploymentMetaData metaData) throws BuilderException {
        Employment input = metaData.getEntity();
        Employment output = input == null ? new Employment() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private Address buildAddress(Address input, AddressMetaData metaData) throws BuilderException {
        if (metaData == null) {
            return null;
        }
        metaData.setEntity(input);
        return (Address)this.addressBuilder.build((Object)metaData);
    }

    private boolean shouldKeep(Employment obj) {
        return super.shouldKeep((Object)obj) && obj.getEmploymentStatus() != null;
    }

    private void transfer(Employment input, EmploymentMetaData metaData) throws BuilderException {
        input.setEmployerAddress(this.buildAddress(input.getEmployerAddress(), metaData.getAddress()));
        input.setEmployerName(super.build(input.getEmployerName(), metaData.getEmployerName()));
        input.setEmployerPhone(super.build(input.getEmployerPhone(), metaData.getEmployerPhone()));
        input.setEmploymentStatus((EmploymentStatus)super.build(this.employmentStatusBuilder, (AbstractLookup)input.getEmploymentStatus(), metaData.getEmploymentStatus()));
        input.setOccupation(super.build(input.getOccupation(), metaData.getOccupation()));
        input.setRetirementDate(super.build(input.getRetirementDate(), metaData.getRetirementDate()));
    }
}

