/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.entity;

import gov.va.med.esr.common.builder.entity.BeneficiaryMetaData;
import gov.va.med.esr.common.builder.entity.EntityBuilder;
import gov.va.med.esr.common.model.lookup.SensitivityChangeSource;
import gov.va.med.esr.common.model.lookup.VAFacility;
import gov.va.med.esr.common.model.person.Person;
import gov.va.med.fw.util.builder.Builder;
import gov.va.med.fw.util.builder.BuilderException;

public class BeneficiaryBuilder
extends EntityBuilder {
    private Builder sensitivityChangeSourceBuilder;
    private static final long serialVersionUID = -7744115663361444515L;

    public Builder getSensitivityChangeSourceBuilder() {
        return this.sensitivityChangeSourceBuilder;
    }

    public void setSensitivityChangeSourceBuilder(Builder sensitivityChangeSourceBuilder) {
        this.sensitivityChangeSourceBuilder = sensitivityChangeSourceBuilder;
    }

    public Person build(BeneficiaryMetaData metaData) throws BuilderException {
        Person input = metaData.getEntity();
        Person output = input == null ? new Person() : input;
        this.transfer(output, metaData);
        return this.shouldKeep(output) ? output : null;
    }

    private boolean shouldKeep(Person obj) {
        return true;
    }

    private void transfer(Person input, BeneficiaryMetaData metaData) throws BuilderException {
        String claimFolderNumberFromMsg = metaData.getClaimFolderNumber();
        input.setClaimFolderNumber(super.build(input.getClaimFolderNumber(), claimFolderNumberFromMsg));
        String claimFolderLocationFromMsg = metaData.getClaimFolderLocation();
        if (claimFolderNumberFromMsg != null && claimFolderNumberFromMsg.length() > 0 && (claimFolderLocationFromMsg == null || claimFolderLocationFromMsg.length() == 0)) {
            input.setClaimFolderLocation(super.build(input.getClaimFolderLocation(), VAFacility.CODE_DEFAULT_CLAIM_FOLDER_LOCATION.getName()));
        }
        if (claimFolderLocationFromMsg != null) {
            try {
                input.setClaimFolderLocation(super.build(input.getClaimFolderLocation(), metaData.getClaimFolderLocation()));
            }
            catch (BuilderException e) {
                input.setClaimFolderLocation(null);
            }
        }
        input.setSensitiveRecord(super.build(input.isSensitiveRecord(), metaData.getSensitiveRecord()));
        input.setSensitivityChangeDate(super.build(input.getSensitivityChangeDate(), metaData.getSensitivityChangeDate()));
        if (input.getSensitiveRecord() != null) {
            input.setSensitivityChangeSite(super.build(input.getSensitivityChangeSite(), metaData.getSensitivityChangeSite()));
            input.setSensitivityChangeSource((SensitivityChangeSource)((Object)this.sensitivityChangeSourceBuilder.build((Object)SensitivityChangeSource.CODE_VAMC.getCode())));
        }
        input.setUserEnrolleeSite(super.build(input.getUserEnrolleeSite(), metaData.getUserEnrolleeSite()));
        input.setUserEnrolleeValidThrough(super.buildYear(input.getUserEnrolleeValidThrough(), metaData.getUserEnrolleeValidThrough()));
    }
}

