/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.datatype.metadata;

import gov.va.med.esr.common.builder.datatype.metadata.AbstractDataTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ComplexTypeMetaData;
import gov.va.med.esr.common.builder.datatype.metadata.ID;
import gov.va.med.esr.common.builder.datatype.metadata.IS;
import gov.va.med.esr.common.builder.datatype.metadata.ST;

public class XAD
extends ComplexTypeMetaData {
    public static final String START_AND_END_DATE_DELIMITER = "&";
    private static final int POSITION_STREET_ADDRESS = 0;
    private static final int POSITION_OTHER_DESIGNATION = 1;
    private static final int POSITION_CITY = 2;
    private static final int POSITION_STATE = 3;
    private static final int POSITION_ZIP_CODE = 4;
    private static final int POSITION_COUNTRY_CODE = 5;
    private static final int POSITION_TYPE_CODE = 6;
    private static final int POSITION_OTHER_GEOGRAPHIC_DESIGNATION = 7;
    private static final int POSITION_COUNTY_PARISH_CODE = 8;
    private static final int POSITION_CENSUS_TRACT = 9;
    private static final int POSITION_REPRESENTATION_CODE = 10;
    private static final int POSITION_ADDRESS_VALIDITY_RANGE = 11;
    private static final int DATA_SIZE = 12;

    public static XAD[] create(String value, String repeatDelimiter, String delimiter) {
        if (value == null) {
            return null;
        }
        String[] components = AbstractDataTypeMetaData.splitData(value, repeatDelimiter);
        int size = components == null ? 0 : components.length;
        XAD[] elements = new XAD[size];
        for (int index = 0; index < size; ++index) {
            elements[index] = XAD.create(components[index], delimiter);
        }
        return elements;
    }

    public static XAD create() {
        return new XAD(new AbstractDataTypeMetaData[12]);
    }

    public static XAD create(String value, String delimiter) {
        if (AbstractDataTypeMetaData.shouldDelete(value)) {
            return null;
        }
        AbstractDataTypeMetaData[] data = new AbstractDataTypeMetaData[12];
        String[] components = AbstractDataTypeMetaData.splitData(value, delimiter);
        int size = components == null ? 0 : components.length;
        data[0] = size > 0 ? ST.create(components[0]) : null;
        data[1] = size > 1 ? ST.create(components[1]) : null;
        data[2] = size > 2 ? ST.create(components[2]) : null;
        data[3] = size > 3 ? ST.create(components[3]) : null;
        data[4] = size > 4 ? ST.create(components[4]) : null;
        data[5] = size > 5 ? ID.create(components[5]) : null;
        data[6] = size > 6 ? ID.create(components[6]) : null;
        data[7] = size > 7 ? ST.create(components[7]) : null;
        data[8] = size > 8 ? IS.create(components[8]) : null;
        data[9] = size > 9 ? IS.create(components[9]) : null;
        data[10] = size > 10 ? ID.create(components[10]) : null;
        data[11] = size > 11 ? ST.create(components[11]) : null;
        return new XAD(data);
    }

    public static String getDataString(XAD[] data, String repeatDelimiter, String delimiter) {
        return AbstractDataTypeMetaData.formatDataString(data, repeatDelimiter, delimiter, null);
    }

    XAD(AbstractDataTypeMetaData[] data) {
        super(data);
    }

    public ST getStreetAddress() {
        return (ST)super.getData(0);
    }

    public void setStreetAddress(ST streetAddress) {
        super.setData(0, streetAddress);
    }

    public ST getOtherDesignation() {
        return (ST)super.getData(1);
    }

    public void setOtherDesignation(ST otherDesignation) {
        super.setData(1, otherDesignation);
    }

    public ST getCity() {
        return (ST)super.getData(2);
    }

    public void setCity(ST city) {
        super.setData(2, city);
    }

    public ST getState() {
        return (ST)super.getData(3);
    }

    public void setState(ST state) {
        super.setData(3, state);
    }

    public ST getZipCode() {
        return (ST)super.getData(4);
    }

    public void setZipCode(ST zipCode) {
        super.setData(4, zipCode);
    }

    public ID getCountryCode() {
        return (ID)super.getData(5);
    }

    public void setCountryCode(ID countryCode) {
        super.setData(5, countryCode);
    }

    public ID getTypeCode() {
        return (ID)super.getData(6);
    }

    public void setTypeCode(ID typeCode) {
        super.setData(6, typeCode);
    }

    public ST getOtherGeographicDesignation() {
        return (ST)super.getData(7);
    }

    public void setOtherGeographicDesignation(ST otherGeographicDesignation) {
        super.setData(7, otherGeographicDesignation);
    }

    public IS getCountyParishCode() {
        return (IS)super.getData(8);
    }

    public void setCountyParishCode(IS countyParishCode) {
        super.setData(8, countyParishCode);
    }

    public IS getCensusTract() {
        return (IS)super.getData(9);
    }

    public void setCensusTract(IS censusTract) {
        super.setData(9, censusTract);
    }

    public ID getRepresentationCode() {
        return (ID)super.getData(10);
    }

    public void setRepresentationCode(ID representationCode) {
        super.setData(10, representationCode);
    }

    public void setAddressValidityRange(ST addressValidityRange) {
        super.setData(11, addressValidityRange);
    }

    public ST getAddressValidityRange() {
        return (ST)super.getData(11);
    }

    public final String getDataString(String delimiter) {
        return super.getDataString(delimiter, null);
    }
}

