/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.esr.common.builder.comms;

import gov.va.med.esr.common.builder.comms.AbstractLetterFormatter;
import gov.va.med.esr.common.builder.comms.GeneralTransmission;
import gov.va.med.esr.common.builder.comms.GenerateValues;
import gov.va.med.esr.common.builder.comms.IFormatter;
import gov.va.med.esr.common.builder.comms.SsnTransmission;
import gov.va.med.esr.common.model.comms.CommsTemplate;
import gov.va.med.esr.common.model.lookup.AddressType;
import gov.va.med.esr.common.model.lookup.ComLetterTemplateType;
import gov.va.med.esr.common.model.person.Person;

public class SsnRemoteFormatter
extends AbstractLetterFormatter {
    private static final String H16_VALUE_1 = "Vet SSN Invalid";
    private static final String H16_VALUE_2 = "Vet Pseudo";
    private static final String H17_VALUE_1 = "Spouse SSN Invalid";
    private static final String H17_VALUE_2 = "Spouse Pseudo";
    private static final String H18_VALUE_1 = "Depen SSN Invalid";
    private static final String H18_VALUE_2 = "Depen Pseudo";
    private static IFormatter instance = new SsnRemoteFormatter();

    public static IFormatter getInstance() {
        return instance;
    }

    private SsnRemoteFormatter() {
    }

    @Override
    protected void buildDataElementsH(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues) {
        CommsTemplate template = inputValues.getOrigTemplate();
        SsnTransmission ssnTransmission = (SsnTransmission)transmission;
        AddressType addressType = transmission.getVeteranAddressType();
        String H16val = "";
        String H17val = "";
        String H18val = "";
        if (ComLetterTemplateType.FORM_NUMBER_290.getCode().equals(template.getCommsTemplateFormNumber()) || ComLetterTemplateType.FORM_NUMBER_291.getCode().equals(template.getCommsTemplateFormNumber())) {
            if ("V".equals(inputValues.getCategoryType())) {
                H16val = H16_VALUE_1;
            } else if ("S".equals(inputValues.getCategoryType())) {
                H17val = H17_VALUE_1;
            } else if ("D".equals(inputValues.getCategoryType())) {
                H18val = H18_VALUE_1;
            }
        } else if (ComLetterTemplateType.FORM_NUMBER_292.getCode().equals(template.getCommsTemplateFormNumber()) || ComLetterTemplateType.FORM_NUMBER_293.getCode().equals(template.getCommsTemplateFormNumber())) {
            if ("V".equals(inputValues.getCategoryType())) {
                H16val = H16_VALUE_2;
            } else if ("S".equals(inputValues.getCategoryType())) {
                H17val = H17_VALUE_2;
            } else if ("D".equals(inputValues.getCategoryType())) {
                H18val = H18_VALUE_2;
            }
        }
        dataElements.append("* H01=").append(ssnTransmission.getSsnErrorMessage()).append("^\n").append("* H02=").append("").append("^\n").append("* H03=").append("").append("^\n").append("* H04=").append("").append("^\n").append("* H05=").append("").append("^\n").append("* H06=").append("").append("^\n").append("* H07=").append("").append("^\n").append("* H08=").append("").append("^\n").append("* H09=").append("").append("^\n").append("* H10=").append("").append("^\n").append("* H11=").append("").append("^\n").append("* H12=").append("").append("^\n").append("* H13=").append("").append("^\n").append("* H14=").append("").append("^\n").append("* H15=").append("").append("^\n").append("* H16=").append(H16val).append("^\n").append("* H17=").append(H17val).append("^\n").append("* H18=").append(H18val).append("^\n").append("* H19=").append(addressType != null ? addressType.getCode() : "").append("^\n");
    }

    @Override
    protected void buildDataElementsH20(StringBuffer dataElements, GeneralTransmission transmission, GenerateValues inputValues, Person person) {
    }
}

